
#  RC cars timimg though a Yocto-RFID reader

from yocto_api import *
from yocto_rfidreader import *
from YoctoColorV2Display import *


displayName="display64x8.colorLedCluster"
displayIPAddr = "172.17.16.107"
display = None;


# car class, store  handle lap time
class car:
  lastSeen     = 0
  bestLapTime  = -1
  tagid        = "unknown"
  lapcount     = 0
  carsCount    = 0  # static variable
  index =0
  def __init__(self,rfidtag,timestamp):
    self.lastSeen    =  timestamp
    self.tagid       =  rfidtag
    car.carsCount    =  car.carsCount+1
    self.index       =  car.carsCount
    print("(%s) car %d - starting first lap"%(self.tagid,self.index))
    display.clearBuffer();
    display.drawText("Car %d - First lap"%self.index,0,0x080808)

  def lap(self,timestamp):
    if  (timestamp-self.lastSeen)<3 : return
    currentlaptime =  timestamp-self.lastSeen
    self.lastSeen = timestamp
    self.lapcount=self.lapcount +1
    print( "(%s) car %d  lap %d %.2f sec  " % (self.tagid,self.index,self.lapcount, currentlaptime),end="")
    display.clearBuffer()
    display.drawText("%02d"%(self.lapcount), 0, 0x000020,False)
    display.drawText("%.2f" % ( currentlaptime), 12, 0x080808, False)
    if (currentlaptime<=self.bestLapTime) or (self.bestLapTime<0) :
      print("best lap!")
      display.drawText("Best lap" , 34, 0x001000)
      self.bestLapTime = currentlaptime
    else:
      print("+%.2f"%(currentlaptime-self.bestLapTime))
      display.drawText("+%.2f"%(currentlaptime-self.bestLapTime) , 40, 0x200000)

cars = {}

# will be called automatically each time a tag enter or leave the RFID field
def tagEvent(source,  timestamp, event, id):
  global cars
  if event!="+" : return;  # we need Tag arrival only
  if id in cars:
     # if car is known, update its lap time
     cars.get(id).lap(timestamp)
  else:
     # otherwise create new one
     cars[id] =   car(id,timestamp)

print("Hello..");

#use USB device
errmsg = YRefParam()
if YAPI.RegisterHub("usb", errmsg) != YAPI.SUCCESS:
    sys.exit("init error" + errmsg.value)

# the display is controled through network
if YAPI.RegisterHub(displayIPAddr, errmsg) != YAPI.SUCCESS:
  sys.exit("cannot contact display" + errmsg.value)

# find the RDIF reader
reader = YRfidReader.FirstRfidReader()
if reader is None: sys.exit('no RFID reader connected')
# makes sure the reader can detect tag as fast as possible
reader.set_refreshRate(100)

# find the display
LedCluster = YColorLedCluster.FindColorLedCluster(displayName)
if not(LedCluster.isOnline()):
  sys.exit("Display "+displayName+"is offline")

# display init
display= YoctoColorDisplay(LedCluster)
display.drawText( "** Yocto-Race **", 1, 0x001000)

# tagEvent will be automatically called each time
# a tag is detected or lsot
reader.registerEventCallback(tagEvent)

# main loop, doining nothing but calling YAPI.Sleep and
# YAPI.UpdateDeviceList from time to time
n= 0
while True:
  YAPI.Sleep(10,errmsg)
  n=n+1
  if n>20 : n=0
  if (n == 0): YAPI.UpdateDeviceList(errmsg)
