import os, sys, random, socket

from yocto_api import *
from yocto_files import *
from yocto_anbutton import *
from yocto_colorledcluster import *

CONTROLER_ADDR = "192.168.0.1"   #define the YoctoHub-Ethernet address here
SLEEP_AVG = 60
CONFIG_FILE = "config.txt"
GREEN = 0x00FF00
RED = 0xFF0000
ORANGE = 0xFF8000
BLACK = 0x000000
DELAY = 90000
GREENSEQ = 0
REDSEQ = 1
ORANGEBLINKSEQ = 2
ORANGESEQ = 3
BLACKSEQ = 4

ledIndex = -1
ShutDownAlreadySetAtStartUp = True
ShutdownAlreadySent = False
FirstTime = True;
errmsg = YRefParam()
lastCRC = -1;

hostname = socket.gethostname()
myIPAddr = socket.gethostbyname(hostname)

print("Current IP address =" + myIPAddr)
while True:

  if (YAPI.TestHub(CONTROLER_ADDR, 1000, errmsg) != YAPI.SUCCESS):
    print("cannot reach " + CONTROLER_ADDR)
    YAPI.FreeAPI()
  else:
    try:
      if (YAPI.RegisterHub(CONTROLER_ADDR, errmsg) == YAPI.SUCCESS):
      ## parse the config file, and find out the associated LED index
        files = YFiles.FirstFiles()
        if files is None:
          sys.exit("No Files on " + CONTROLER_ADDR)
        fileslist = files.get_list(CONFIG_FILE)
        if len(fileslist) > 0:
          if (fileslist[0].get_name() == CONFIG_FILE and fileslist[0].get_crc() != lastCRC ):
            ledIndex = -1
            lastCRC = fileslist[0].get_crc()
            config = files.download(CONFIG_FILE).decode('utf-8')
            lines = config.split()
            for line in lines:
              tokens = line.split("=")
              if len(tokens) == 2:
                if tokens[1] == myIPAddr:
                  ledIndex = int(tokens[0])
            if (ledIndex < 0):
              print("No Ledindex for " + myIPAddr + " in config.txt on " + CONTROLER_ADDR)
            else:
              print("LED index=" + str(ledIndex))
        else:
          print("No config.txt file on " + CONTROLER_ADDR)


        ## check Shutdown SWITCH
        buttons = YAnButton.FirstAnButton()
        if buttons is None:
          sys.exit("No Anbuttons on " + CONTROLER_ADDR)
        serial = buttons.get_module().get_serialNumber()
        shutdownSwitch = YAnButton.FindAnButton(serial + ".anButton1")
        mustShutDown = shutdownSwitch.get_isPressed();
        if not (mustShutDown): ShutDownAlreadySetAtStartUp = False;

        ## check  LED sequences
        if ledIndex >= 0:
          cluster = YColorLedCluster.FirstColorLedCluster()
          if cluster is None:
            sys.exit("No ColorLedCluster on " + CONTROLER_ADDR)

          if FirstTime:
            signatures = cluster.get_blinkSeqSignatures(0, 5)

            if (signatures[GREENSEQ] == 0):
              cluster.resetBlinkSeq(GREENSEQ)
              cluster.addRgbMoveToBlinkSeq(GREENSEQ, GREEN, 0)
              cluster.addRgbMoveToBlinkSeq(GREENSEQ, GREEN, DELAY)
              cluster.addJumpToBlinkSeq(GREENSEQ, REDSEQ)
              cluster.startBlinkSeq(GREENSEQ)

            if (signatures[ORANGESEQ] == 0):
              cluster.resetBlinkSeq(ORANGESEQ)
              cluster.addRgbMoveToBlinkSeq(ORANGESEQ, ORANGE, 0)
              cluster.addRgbMoveToBlinkSeq(ORANGESEQ, ORANGE, DELAY - 1000)
              cluster.addRgbMoveToBlinkSeq(ORANGESEQ, BLACK, 1000)
              cluster.addJumpToBlinkSeq(ORANGESEQ, BLACKSEQ)
              cluster.startBlinkSeq(ORANGESEQ)

            if (signatures[REDSEQ] == 0):
              cluster.resetBlinkSeq(REDSEQ)
              cluster.addRgbMoveToBlinkSeq(REDSEQ, RED, 0)
              cluster.addRgbMoveToBlinkSeq(REDSEQ, RED, 10000)
              cluster.startBlinkSeq(REDSEQ)

            if (signatures[BLACKSEQ] == 0):
              cluster.resetBlinkSeq(BLACKSEQ)
              cluster.addRgbMoveToBlinkSeq(BLACKSEQ, BLACK, 0)
              cluster.addRgbMoveToBlinkSeq(BLACKSEQ, BLACK, 10000)
              cluster.startBlinkSeq(BLACKSEQ)

            if (signatures[ORANGEBLINKSEQ] == 0):
              cluster.resetBlinkSeq(ORANGEBLINKSEQ)
              cluster.addRgbMoveToBlinkSeq(ORANGEBLINKSEQ, ORANGE, 0)
              cluster.addRgbMoveToBlinkSeq(ORANGEBLINKSEQ, ORANGE, 100)
              cluster.addRgbMoveToBlinkSeq(ORANGEBLINKSEQ, 0, 0)
              cluster.addRgbMoveToBlinkSeq(ORANGEBLINKSEQ, 0, 900)
              cluster.startBlinkSeq(ORANGEBLINKSEQ)

          if cluster.get_rgbColorArrayAtPowerOn(ledIndex, 1)[0] != RED:
            cluster.set_rgbColorAtPowerOn(ledIndex, 1, RED)
            cluster.saveLedsConfigAtPowerOn()

          if (mustShutDown):
            if (ShutDownAlreadySetAtStartUp):
              print("Switch was left in shutdown position")
              cluster.linkLedToBlinkSeq(ledIndex, 1, ORANGEBLINKSEQ, 0)
            else:             
              cluster.linkLedToBlinkSeq(ledIndex, 1, ORANGESEQ, 0)
              if ShutdownAlreadySent:
                print("Shutdown in progress...")
              else:
                print("Initialing shutdown...")
                platformName = platform.system();
                #platformName = "DISABLE SHUTDOWN"
                if platformName == "Windows":
                  os.system('shutdown -s')
                elif platformName == "Linux" :
                  os.system('systemctl poweroff')
                elif platformName == "Darwin":  #Mac
                  os.system("shutdown -h now")  # might not work if not root
                else:
                  print("Unknown platform : " + platformName)
                ShutdownAlreadySent = True

          else:           
            cluster.linkLedToBlinkSeq(ledIndex, 1, GREENSEQ, 0)
            ShutdownAlreadySent = False

      FirstTime = False
      YAPI.FreeAPI()
    except Exception as e:
      print("Error " + str(e))
  t = random.randint(SLEEP_AVG - 10, SLEEP_AVG + 10)
  print("sleeping for " + str(t) + "sec")
  time.sleep(t)







