#!/usr/bin/python
# -*- coding: utf-8 -*-


# This just an example of  YDPS5005 library usage. You will also
# need the Yoctopuce library for python, available on
# www.yoctopuce.com/EN/libraries.php

# For more details about interfacing a DPS5005 with Yoctopuce devices,
# have a look here:
# www.yoctopuce.com/EN/article/DPS5005-adding-a-wired-network-connection

import os, sys , datetime

from yocto_api import *
from yocto_serialport import *
from YDPS5005 import *

DPS5005_ip_address = "127.0.0.1"

errmsg = YRefParam()
if YAPI.RegisterHub(DPS5005_ip_address, errmsg) != YAPI.SUCCESS:
    sys.exit("init error" + errmsg.value)

serialPort = YSerialPort.FirstSerialPort()
if serialPort is None:
        sys.exit('No module Yocto-Serial device connected (check cable)')

DPS5005 = YDPS5005(serialPort)

if not  DPS5005.isSerialPortConfigured():
    if input("The Yocto-Serial doesn't appear to be properly configured, do you want to configure it (y/n) ?")=="y":
        DPS5005.configureSerialPort()
        print("Configuration done.")

DPS5005.set_voltage(1)
DPS5005.set_current(0.5)
print("Voltage setting = " + str(DPS5005.get_voltage())+"V")
print("Current setting = " + str(DPS5005.get_current())+"A")

DPS5005.enableOutput(True)

for i in range(0,30):
    print(datetime.datetime.now().strftime("%H:%M:%S")+": "+str(DPS5005.get_voltageOutput())+"V "+str(DPS5005.get_currentOutput())+"A")
    YAPI.Sleep(1000,errmsg)

DPS5005.enableOutput(False)

YAPI.FreeAPI()
