#!/usr/bin/python
# -*- coding: utf-8 -*-


# This just an example of  YRD6006 library usage. You will also
# need the Yoctopuce library for python, available on
# www.yoctopuce.com/EN/libraries.php

# For more details about interfacing a RD6006 with Yoctopuce devices,
# have a look here:
# www.yoctopuce.com/EN/article/rd6006-adding-a-wired-network-connection

import os, sys , datetime

from yocto_api import *
from yocto_serialport import *
from YRD6006 import *

RD6006_ip_address = "172.17.17.97"

errmsg = YRefParam()
if YAPI.RegisterHub(RD6006_ip_address, errmsg) != YAPI.SUCCESS:
    sys.exit("init error" + errmsg.value)

serialPort = YSerialPort.FirstSerialPort()
if serialPort is None:
        sys.exit('No module Yocto-Serial device connected (check cable)')

RD6006 = YRD6006(serialPort)

if not  RD6006.isSerialPortConfigured():
    if input("The Yocto-Serial doesn't appear to be properly configured, do you want to configure it (y/n) ?")=="y":
        RD6006.configureSerialPort()
        print("Configuration done.")

RD6006.set_voltage(1)
RD6006.set_current(0.5)
print("Voltage setting = " + str(RD6006.get_voltage())+"V")
print("Current setting = " + str(RD6006.get_current())+"A")

RD6006.enableOutput(True)

for i in range(0,30):
    print(datetime.datetime.now().strftime("%H:%M:%S")+": "+str(RD6006.get_voltageOutput())+"V "+str(RD6006.get_currentOutput())+"A")
    YAPI.Sleep(1000,errmsg)

RD6006.enableOutput(False)

YAPI.FreeAPI()
