﻿
//  Windows service used to control a Velux  roof windows 
//  Service Code structure inspired from John Storer's example code
//  http://www.codeproject.com/Articles/14353/Creating-a-Basic-Windows-Service-in-C

using System;
using System.Diagnostics;
using System.ServiceProcess;
using System.Threading;
using HomeAutomation;

namespace WindowsService
{
  class WindowsService : ServiceBase
  {
    /// <summary>
    /// Public Constructor for WindowsService.
    /// - Put all of your Initialization code here.
    /// </summary>
    /// 
    static string serviceDisplayName = "Velux Control";
    static string serviceName        = "VeluxControl";

    // create an email account for your Velux controller
    // and put credentials here
    static string MailServer         = "YourMailServer.com";
    static string MailUser           = "YourEmailAddress";
    static String MailPassword       = "YourEmailPassword";

    Thread PayLoadThread;  // this is the thread containing the "active code"

    public WindowsService()
    {
      this.ServiceName = serviceName;
      this.EventLog.Log = "Application";
      this.EventLog.Source = serviceDisplayName;

      // These Flags set whether or not to handle that specific
      //  type of event. Set to true if you need it, false otherwise.
      this.CanHandlePowerEvent = true;
      this.CanHandleSessionChangeEvent = true;
      this.CanPauseAndContinue = true;
      this.CanShutdown = true;
      this.CanStop = true;
    }

  
    //This is your service entry point
    static void Main(string[] args)
    {
      string execPath = System.Reflection.Assembly.GetEntryAssembly().Location;
      string execFile = System.AppDomain.CurrentDomain.FriendlyName;
    
      if (args.Length > 0)
      {
        switch (args[0].ToUpper())
        {
          case "/INSTALL":
            if (WindowsServiceControl.ServiceIsInstalled(serviceName))
              Console.WriteLine("Service " + serviceName + " is already installed");
            else
            { WindowsServiceControl.InstallAndStart(serviceName, serviceDisplayName, execPath);
              Console.WriteLine(serviceDisplayName + " installed and started");
            } 
            break;

          case "/UNINSTALL":
            if (WindowsServiceControl.ServiceIsInstalled(serviceName))
            {
              WindowsServiceControl.Uninstall(serviceName);
              Console.WriteLine(serviceDisplayName + " uninstalled");
            }
            else Console.WriteLine("Service " + serviceName + " is not installed");
            break;

          case "/START" :
            if (!WindowsServiceControl.ServiceIsInstalled(serviceName))
              Console.WriteLine("Service " + serviceName + " is not installed");
            else
            {
              WindowsServiceControl.StartService(serviceName);
              Console.WriteLine(serviceDisplayName + " started");
            }
            break;

          case "/STOP" :
            if (!WindowsServiceControl.ServiceIsInstalled(serviceName))
              Console.WriteLine("Service " + serviceName + " is not installed");
            else
            {
              WindowsServiceControl.StopService(serviceName);
              Console.WriteLine(serviceDisplayName + " stopped");
            }
            break;

          default:
            Console.WriteLine(execFile+" is a Windows service, you need to install it, then it will");
            Console.WriteLine("start automatically each time your computer starts ");
            Console.WriteLine("Usage:");
            Console.WriteLine(execFile + " [/INSTALL | /START | /STOP | /UNINSTALL ");
            break;
        }

      }
      else ServiceBase.Run(new WindowsService());
    }

    /// <summary>
    /// Dispose of objects that need it here.
    /// </summary>
    /// <param name="disposing">Whether
    ///    or not disposing is going on.</param>
    protected override void Dispose(bool disposing)
    {
      base.Dispose(disposing);
    }

    /// <summary>
    /// OnStart(): Put startup code here
    ///  - Start threads, get inital data, etc.
    /// </summary>
    /// <param name="args"></param>
    protected override void OnStart(string[] args)
    {
      base.OnStart(args);
      PayLoadThread = new Thread(new ThreadStart(Payload));
      PayLoadThread.Start();
    }

    /// <summary>
    /// OnStop(): Put your stop code here
    /// - Stop threads, set final data, etc.
    /// </summary>
    protected override void OnStop()
    {
      base.OnStop();
      if (PayLoadThread.IsAlive)  PayLoadThread.Abort();
      this.EventLog.WriteEntry("Velux Control Thread Stopped");
    }

  
    /// <summary>
    /// OnShutdown(): Called when the System is shutting down
    /// - Put code here when you need special handling
    ///   of code that deals with a system shutdown, such
    ///   as saving special data before shutdown.
    /// </summary>
    protected override void OnShutdown()
    {
      if (PayLoadThread.IsAlive)  PayLoadThread.Abort();
      base.OnShutdown();
    }

    // this is where the "real" stuff is happening
    protected void Payload()
    { string errmsg ="";
       bool fatal = false;
      // create a velux controller instalance
      this.EventLog.WriteEntry("Velux Control Thread Starting");
      VeluxController ctrl = new VeluxController(MailServer, MailUser, MailPassword);
      
      // init it
      if (!ctrl.init(ref errmsg, ref fatal))
        this.EventLog.WriteEntry("InitFailed: " + errmsg, fatal ? EventLogEntryType.Error : EventLogEntryType.Warning); 
      
      //  and make in run from time to time
      if (!fatal)
      while (Thread.CurrentThread.IsAlive)
      {
        try  // this is a network based feature, a lot of bad things can happen
        {
          if (!ctrl.Check4ControlMails(ref errmsg))
            this.EventLog.WriteEntry("failure: " + errmsg, EventLogEntryType.Error);
        }
        catch (Exception e)
        {
          this.EventLog.WriteEntry("Exception: " + e.Message,  EventLogEntryType.Warning);
        }
            Thread.Sleep(60000);  // checks for new command mails every minutes  
       }
		}   
  }
}