﻿//
//  this is the active code of the Velux controller
//  it will check for new email commands and execute it, it will
//  search for 2 relays: one called "openWindow" an another
//  one called "close window"
//  
//  Mail commands must have "open" or "close" in the  subject
//  and "plz" in the body,  an confirmation email will be sent
//  back for recognised command


using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net.Mail;
using System.Net.Mime;
using ActiveUp.Net.Mail;


namespace HomeAutomation
{
  class VeluxController
  {
    protected string mailuser;
    protected string mailpass;
    protected string mailsrv;

    static string OpenFct = "openWindow";
    static string CloseFct = "closeWindow";


    // the constructor, will only store the mail server credentials
    public VeluxController(string mailserver, string mailusername, string mailpassword)
    {
      mailuser = mailusername;
      mailpass = mailpassword;
      mailsrv = mailserver;
    }

    // just a trick to handle error return
    private bool error(ref string msgvar, string message)
    {
      msgvar = message;
      return false;
    }


    // init part : used to init the Yoctopuce API
    public bool init(ref string errmsg, ref bool fatalError)
    {
      fatalError = false;
      YAPI.DisableExceptions();

      // try to register using native control
      if (YAPI.RegisterHub("usb", ref errmsg) != yAPI.SUCCESS)
      {
        fatalError = true;
        return false;
      }

      // check online Yocto-Relays with the correct logical name
      YRelay r = YRelay.FindRelay(OpenFct);
      if (!r.isOnline()) return error(ref errmsg,"No online YRelay function with logical name set to " + OpenFct);

      r = YRelay.FindRelay(CloseFct);
      if (!r.isOnline()) return error(ref errmsg,"No online YRelay function with logical name set to " + CloseFct);

      return true;

    }

  

    // send a mail using .NET Smtp library
    public void sendSmtpMail(string sendto, string subject, string body)
    {
      
      System.Net.Mail.SmtpClient client = new System.Net.Mail.SmtpClient(mailsrv);
      client.EnableSsl = false;
      client.Port = 587;
      client.Credentials = new System.Net.NetworkCredential(mailuser, mailpass);
      MailAddress from = new MailAddress(mailuser);
      MailAddress to = new MailAddress(sendto);
      MailMessage message = new MailMessage(from, to);
      message.Body = body;
      message.Subject = subject;
      client.Send(message);
      message.Dispose();
    }


    // execute a command, you can add some if you want
    public bool ExecuteWindowCommand(string command, ref string errmsg)
    {
      string fctname;
      switch (command)
      {
        case "OPEN": fctname = OpenFct; break;
        case "CLOSE": fctname = CloseFct; break;
        default: errmsg = "unknown command:" + command;return false;
      }

      YRelay r = YRelay.FindRelay(fctname);
      if (r.isOnline())
      {
        r.pulse(500);
        return true;
      }

      errmsg = "Command  " + command + "failed, Relay " + fctname + " is offline";
      return false;
    }

    // process  an email command
    private void ProcessMessage(Message mailmsg)
    {
      string cmd = mailmsg.Subject.Trim().ToUpper();
      string msg = "Command Accepted: " + cmd;
      ExecuteWindowCommand(cmd, ref  msg);
      sendSmtpMail(mailmsg.From.Email.ToString(), msg, DateTime.Now.ToString());
    }

    // send a mail reporting a dropped command
    private void DropMessage(Message msg)
    {
      sendSmtpMail(msg.From.Email.ToString(), "Dropped command :" + msg.Subject, DateTime.Now.ToString());
    }

    // check if a mail command is valid, here we expect the body
    // to be "plz", but a more reasonnable/secure solution would be 
    // a date-based password
    private bool CheckMessage(Message msg)
    { 
      if (msg.BodyText.TextStripped.Trim().ToUpper() != "PLZ") return false;
      return true;
    }

    // 
    // Connect to Imap mail server and retreive command mails
    public bool Check4ControlMails(ref string errmsg)
    {
      errmsg = "";


      Imap4Client imap = new Imap4Client();
      imap.Connect(mailsrv);
      imap.Login(mailuser, mailpass);
      Mailbox inbox = imap.SelectMailbox("inbox");

      // search for "unseen" messages
      MessageCollection mc = new MessageCollection();
      int[] ids = inbox.Search("UNSEEN");

      // retreive unseen messsages (this will tag them as "Seen")
      List<Message> msgList = new List<Message>();
      for (int i = 0; i < ids.Length; i++)
      {
        Message msg = inbox.Fetch.MessageObject(ids[i]);
        if (CheckMessage(msg)) msgList.Add(msg);
      }

      // disconnect form mail server
      imap.Disconnect();

      if (msgList.Count > 0)
      { // search for the most recent mail
        DateTime MostRecent = msgList[0].Date;
        int MostRecentIndex = 0;
        for (int i = 1; i < msgList.Count; i++)
          if (MostRecent < msgList[i].Date)
          {
            MostRecentIndex = i;
            MostRecent = msgList[i].Date;

          }

        // execute the most recent mail command and drop
        //  all others
        for (int i = 0; i < msgList.Count; i++)
        {
          if (i == MostRecentIndex) ProcessMessage(msgList[i]);
          else DropMessage(msgList[i]);
        }
      }

      return true;
    }

  }

}
