program bench;

{$APPTYPE CONSOLE}

{$R *.res}

uses
  SysUtils,Yocto_api,Yocto_anButton,Yocto_relay;

 var
  reftime :int64;
  sum1,sum2,cnt1,cnt2 :integer;
  dump :string;


procedure callback(input : TYfunction; value:string);
  var  val:integer;
 begin
   val := StrToInt(value);
   if (val <10) or (val > 990) then
    begin
      inc(sum2 , yGetTickcount()-reftime);
      inc(cnt2);
      dump := dump +inttostr(yGetTickcount()-reftime) + ':' + value + #13#10;
    end;
 end;

var
 errmsg : string;
 input1 :TYAnButton;
 relay1 :TYrelay;
 i      :integer;
begin
   yDisableExceptions();

   if(yRegisterHub('127.0.0.1', errmsg) <> YAPI_SUCCESS)  then
     begin
        writeln('yInitAPI failed: '+errmsg);
        halt;
     end;

   input1 := yFindAnButton('input1');
   relay1 := yFindRelay('relay1');

   if (not(input1.isOnline()) or not(relay1.isOnline())) then
    begin
       writeln( 'Devices not found, check cable!');
       halt;
    end;

   input1.registerValueCallback(callback);


   sum1 :=0 ;  sum2 := 0; cnt1 := 0; cnt2 := 0;
   dump:='';

   for  i:=0  to 31  do
     begin
        reftime := yGetTickCount();
        if (i  and 1) =0 then relay1.set_state(Y_STATE_A)
                         else relay1.set_state(Y_STATE_B);



     inc(sum1,yGetTickCount()-reftime);
     inc(cnt1);
     ySleep(50, errmsg);
    end;

    writeln(dump);
    writeln('Average command time : '+ FormatFloat('##.##',(sum1+cnt1/2) / cnt1));
    writeln('Average round-trip time : '+ FormatFloat('##.##',(sum2+cnt2/2) / cnt2));


end.
