#include <time.h>
#include <iostream>
#include <iomanip>
#include <sstream>
#include <stdlib.h>

#include "yocto_api.h"
#include "yocto_anbutton.h"
#include "yocto_relay.h"

using namespace std;

u64             reftime;
stringstream    dump;
u64             sum1,sum2,cnt1,cnt2;

static void callback(YAnButton *input, const string &value)
{
    int val = atoi(value.c_str());
    if(val < 10 || val > 990) {
        sum2 += (yGetTickCount()-reftime);
        cnt2++;
        dump << (yGetTickCount()-reftime) << ':' << value << endl;
    }
}

int main(int argc, const char * argv[])
{
    string      errmsg;
    YAnButton   *input1;
    YRelay      *relay1;

    // No exception please
    yDisableExceptions();
    
    if(yRegisterHub("127.0.0.1", errmsg) != YAPI_SUCCESS) {
        cerr << "yInitAPI failed: " << errmsg << endl;
        return -1;
    }
    
    input1 = yFindAnButton("input1");
    relay1 = yFindRelay("relay1");
    if(!input1->isOnline() || !relay1->isOnline()) {
        cerr << "Devices not found, check cable!" << endl;
        return -1;            
    }
    input1->registerValueCallback((YAnButtonUpdateCallback)callback);
    
    sum1 = sum2 = cnt1 = cnt2 = 0;
    for(int i = 0; i < 32; i++) {
        reftime = yGetTickCount();
        relay1->set_state((i & 1 ? Y_STATE_A : Y_STATE_B));
        sum1 += (yGetTickCount()-reftime);
        cnt1++;
        ySleep(50, errmsg);
    }

    cout << dump.str();
    cout << "Average command time:    " << ((double)sum1 / cnt1) << endl;
    cout << "Average round-trip time: " <<sum2<<"/"<<cnt2<<"="<< ((double)sum2 / cnt2) << endl;
    
    return 0;
}

