//
//  main.m
//  yoctobench
//
//  Created by Sébastien Rinsoz on 2/24/12.
//  Copyright (c) 2012 Yoctopuce Sàrl. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "yocto_api.h"
#import "yocto_relay.h"
#import "yocto_anbutton.h"

u64             reftime;
NSMutableArray  *dump;
int             sum1,sum2,cnt1,cnt2;

static void callback(YAnButton *input, NSString *value)
{
    int val = [value intValue];
    if(val < 10 || val > 990) {
        sum2 += [YAPI GetTickCount] - reftime;
        cnt2++;
        [dump addObject:[NSString stringWithFormat:@"%d:%@",(yGetTickCount()-reftime),value] ];
    }
}


int main (int argc, const char * argv[])
{

    @autoreleasepool {
        NSError     *error;
        YAnButton   *input1;
        YRelay      *relay1;
        
        // No exception please
        [YAPI DisableExceptions];
        
        if([YAPI RegisterHub:@"usb": &error ] != YAPI_SUCCESS) {
            NSLog(@"yInitAPI failed: %@", [error localizedDescription]);
            return -1;
        }
        
        input1 = yFindAnButton(@"input1");
        relay1 = yFindRelay(@"relay1");
        if(![input1 isOnline] || ![relay1 isOnline]) {
            NSLog(@"Devices not found, check cable!");
            return -1;            
        }
        [input1 registerValueCallback:callback];
        dump = [[NSMutableArray alloc] init ];
        sum1 = sum2 = cnt1 = cnt2 = 0;
        for(int i = 0; i < 32; i++) {
            reftime = yGetTickCount();
            relay1.state =  ((i & 1 ? Y_STATE_A : Y_STATE_B));
            sum1 += [YAPI GetTickCount ] - reftime;
            cnt1++;
            [YAPI Sleep:50:&error];
        }
        
        NSLog(@"%@",dump);
        NSLog(@"Average command time:    %d",((sum1+cnt1/2) / cnt1));
        NSLog(@"Average round-trip time: %d",((sum2+cnt2/2) / cnt2));
        
    }
    return 0;
}

