﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;


namespace ConsoleApplication1
{
    class Program
    {

        public static long reftime;
        public static StringBuilder dump=new StringBuilder();
        public static long sum1, sum2,cnt1,cnt2;

        static void callback(YAnButton input, string value)
        {
            int val = int.Parse(value);
            if (val < 10 || val > 995)
            {
                sum2 += (YAPI.GetTickCount() - reftime);
                cnt2++;
                dump.AppendLine(YAPI.GetTickCount() - reftime + ":" + value);
            }
        }

        static int Main(string[] args)
        {

            string errmsg = "";
            YAnButton input1;
            YRelay relay1;

            // No exception please
            YAPI.DisableExceptions();


            if (YAPI.RegisterHub("usb", ref errmsg) != YAPI.SUCCESS)
            {
                Console.WriteLine("InitAPI failed: " + errmsg);
                return 1;
            }


            input1 = YAnButton.FindAnButton("input1");
            relay1 = YRelay.FindRelay("relay1");
            if (!input1.isOnline() || !relay1.isOnline())
            {
                Console.WriteLine("Devices not found, check cable!");
                return 1;
            }
            YAPI.Sleep(1000, ref errmsg);
            input1.registerValueCallback(callback);
            sum1 = sum2 = cnt1 = cnt2 = 0;
            for (int i = 0; i < 16; i++)
            {
                reftime = YAPI.GetTickCount();
                relay1.set_state(YRelay.STATE_B);
                sum1 += (YAPI.GetTickCount() - reftime);
                cnt1++;
                YAPI.Sleep(50, ref errmsg);
                reftime = YAPI.GetTickCount();
                relay1.set_state(YRelay.STATE_A);
                sum1 += (YAPI.GetTickCount() - reftime);
                cnt1++;
                YAPI.Sleep(50, ref errmsg);
            }

            Console.WriteLine(dump);
            Console.WriteLine("Average command time:    " + ((double)sum1 / cnt1));
            Console.WriteLine("Average round-trip time: " + sum2 +" / "+ cnt2 +" = " + ((double)sum2 / cnt2));
            return 0;
        }
    }
}

