(*
 *  Yoctopuce Winamp Plug-in, dec 2011
 *  Visit www.yoctopuce.com for more information
 *
 *  This Plug-in allows WinAmp to drive Yocto-color modules which
 *  are USB driven RGB leds
 *
 *  based on Jan Horn's work (www.sulaco.co.za/winamp_tut.htm)
 *
 *)

 unit winamp;

interface

uses windows,forms;

// WinAmp type declarations from vis.h
type
  PWinampVisModule = ^TwinampVisModule;
  TwinampVisModule = record
    description  : PChar;        // description of module
    hwndParent   : HWND;         // parent window (filled in by calling app)
    hDllInstance : HINST;        // instance handle to this DLL (filled in by calling app)
    sRate        : Cardinal;     // sample rate (filled in by calling app)
    nCh          : Cardinal;     // number of channels (filled in...)
    latencyMs    : Cardinal;     // latency from call of RenderFrame to actual drawing\
                                 // (calling app looks at this value when getting data)
    delayMs      : Cardinal;     // delay between calls in ms

    // the data is filled in according to the respective Nch entry
    spectrumNCh  : Cardinal;     // Number of channels
    waveformNCh  : Cardinal;     // Number of channels
    spectrumData : Array [0..1, 0..575] of Byte;     // waveform data   (values from 0-255)
    waveformData : Array [0..1, 0..575] of Byte;     // spectrum data   (values from 0-255)
    Config       : procedure(const PVisModule : PwinampVisModule); cdecl;   // configuration dialog
    Init         : function (const PVisModule : PwinampVisModule) : Integer; cdecl;   // 0 on success, creates window, etc
    Render       : function (const PVisModule : PwinampVisModule) : Integer; cdecl;   // returns 0 if successful, 1 if vis should end
    Quit         : procedure(const PVisModule : PwinampVisModule); cdecl;   // call when done
    userData     : procedure; cdecl;  // user data, optional
  end;

  PwinampVisHeader = ^TwinampVisHeader;
  TwinampVisHeader = record
    version      : Integer;
    description  : PChar;  // description of library
    getModule    : function (Which : Integer) : PwinampVisModule; cdecl;
  end;

implementation

end.
