(*
 *  Yoctopuce Winamp Plug-in, dec 2011
 *  Visit www.yoctopuce.com for more information
 *
 *  This Plug-in allows WinAmp to drive Yocto-color modules which
 *  are USB driven RGB leds
 *
 *  based on Jan Horn's work (www.sulaco.co.za/winamp_tut.htm)
 *
 *)

unit visualizer;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,winamp,
  ExtCtrls, ComCtrls,yocto_api,yocto_colorled;

type
  TVisuWindow = class(TForm)
    Bevel1: TBevel;
    display: TImage;
    StatusBar1: TStatusBar;
    procedure FormCreate(Sender: TObject);

  private
    { Private declarations }
    lastcall : u64;
  public
    { Public declarations }
     procedure render(PVisModule:PWinAMPVisModule;leds:tlist;first:boolean);
  end;

var
  VisuWindow: TVisuWindow;

implementation

 
{$R *.DFM}


// fast HSL  to RGB  convertion (integer calculus)
function hsl2rgb(HSL : integer):integer;
 function hsl2rgbInt(temp1,temp2,temp3 :integer):integer;
 begin
    if (temp3 >= 170) then
      begin
       hsl2rgbInt:=((temp1 + 127) div 255);
       exit;
      end;
     if (temp3 > 42) then
       begin
        if (temp3 <= 127)  then
          begin
            hsl2rgbInt:= ((temp2 + 127) div 255);
          end;
        temp3 := 170 - temp3;
      end;
    hsl2rgbInt :=((temp1*255 + (temp2-temp1) * (6 * temp3) + 32512) div 65025);

end;
 var
   H,S,L,R,G,B,temp1,temp2,temp3 : integer;

 begin
    H := (HSL shr 16)  and $ff;
    S := (HSL shr 8)  and $ff ;
    L :=  HSL  and $ff;

    if (S=0) then
      begin
       hsl2rgb := (L shl 16) or (L shl 8) or L;
       exit;
      end;

    if (L<=127) then temp2 := L * (255 + S)
      else temp2 := (L+S) * 255 - L*S;

    temp1 := 510 * L - temp2;

    // R
    temp3 := (H + 85);
    if (temp3 > 255) then temp3 := temp3-255;
    R := hsl2rgbInt(temp1, temp2, temp3);

    // G
    temp3 := H;
    if (temp3 > 255) then  temp3 := temp3-255;
    G := hsl2rgbInt(temp1, temp2, temp3);

    // B
    if (H >= 85) then temp3 := H - 85 else temp3 := H + 170;
    B := hsl2rgbInt(temp1, temp2, temp3);

    if (R>255) then R:=255;  // just in case
    if (G>255) then G:=255;
    if (B>255) then B:=255;

    hsl2rgb := (B shl 16) or (G shl 8) or  R;  // delphi format
end;

procedure   TVisuWindow.render(PVisModule:PWinAMPVisModule;leds:tlist;first:boolean);

 const
   MAXCOLOR     = 6;
   clustersize    : array[0..MAXCOLOR-1] of integer=(4,5,5,8,8,10);

 var
  color           : array[0..MAXCOLOR-1] of integer;
  canvas          : tcanvas;
  HSL,H,S,L,space : integer;
  i,j             : integer;
  power,x1,x2     : integer;
  ColorsCount     : integer;
  baseindex       : integer;
  startset,endset : u64;
  sincelastCall   : u64;
  perfmsg         : string;

 begin
  display.Picture.bitmap.width:=display.width;
  display.Picture.bitmap.height:=display.height;


  // color count depend of many colorLed we found
  ColorsCount := MAXCOLOR;
  if (leds.count>0)  then ColorsCount := leds.count;
  if (ColorsCount>MAXCOLOR) then ColorsCount:=MAXCOLOR;
   space :=  display.width  div (ColorsCount);


  // first refresh, lets draw the background as well
  canvas :=  display.Picture.bitmap.canvas;
  canvas.pen.style:=psClear;
  if (first) then
   begin
    canvas.brush.color := clBlack	;
    canvas.rectangle(0,0,display.width,display.height);
    if (leds.count=0) then  statusbar1.panels[0].text:=  'No ColorLed found, connect a Yocto-Color module...'
     else if (leds.count=1) then  statusbar1.panels[0].text:=  'Only one ColorLed found'
     else if (leds.count=2) then  statusbar1.panels[0].text:=  'Only two ColorLeds found, you should buy som more :-)'
     else statusbar1.panels[0].text:=  inttostr(leds.count)+' ColorLeds found';
   end;


  // Winamp gives spectum data in PVisModule^.spectrumData array
  // we groups these values in clusters and color intensity is computed
  // according to the max value found in each cluster

  baseindex:=0;
  for i:=0 to ColorsCount-1 do
   begin
    power := 0;
    for j:=0 to clustersize[i]-1 do
     begin
       if power< (PVisModule^.spectrumData[0][baseindex+j] + PVisModule^.spectrumData[1][baseindex+j]) then
          power  := (PVisModule^.spectrumData[0][baseindex+j] + PVisModule^.spectrumData[1][baseindex+j]);
     end;

    inc(baseindex,clustersize[i]);
    power:=power div 4;

    // luminosity not hight than 128 or led will turn to white
    if (power>$80) then power:=$80;

    // compute HSL clor
    H := (512-60-(I*$FF div ColorsCount)) and 255;
    S := $FF;
    L := power ;
    HSL :=  (H shl 16) OR  (S shl 8) OR L;
    color[i] := HSL;

    // draws the UI
    canvas.brush.color :=  hsl2rgb(hsl);
    x1:= (space div 4) +i*space;
    x2:= x1+space div 2;
    canvas.rectangle(X1,display.height, X2,display.height-l );
    canvas.brush.color :=   clBlack;
    canvas.rectangle(X1,display.height-l, X2,0 );
   end;


   // we update leds color in 2 passes: first even ones then
   // odd ones:  that's because there are 2 leds per modules,
   // and a module stays busy for a few ms after a request.
   // settings led sequentially would work, but it would  be slower.

   startset:= yGetTickCount();
   for j:=0 to 1 do
     begin
       i:=j;   // first even indexes then odd ones
       while (i<leds.count)  do
         begin
           TYcolorLed(leds[i]).set_HslColor( color [i mod ColorsCount] );
           inc(i,2);
         end;
     end;
   endset:= yGetTickCount();

   // some performance start, we display how may time it took to set all leds
   // and how times per seconds we are called by winAmp

   perfmsg:=  intToStr(endset-startset)+'ms ' ;
   sincelastCall := GetTickCount()-lastcall;
   if  (sincelastCall>0)  then perfmsg:=perfmsg+' / '+intToStr(1000 div sincelastCall)+'Hz';
   statusbar1.panels[1].text:= perfmsg;
   lastcall :=yGetTickCount();


 end;



procedure TVisuWindow.FormCreate(Sender: TObject);
begin
  lastcall :=yGetTickCount();
end;

end.
