(*
 *  Yoctopuce Winamp Plug-in, dec 2011
 *  Visit www.yoctopuce.com for more information
 *
 *  This Plug-in allows WinAmp to drive Yocto-color modules which
 *  are USB driven RGB leds
 *
 *  based on Jan Horn's work (www.sulaco.co.za/winamp_tut.htm)
 *
 *)
unit YoctoPlugin;

interface

uses  classes,sysutils, Windows, Messages,   winamp,setup, visualizer, yocto_api, yocto_colorLed;



  // forward declaration of the procedures
function  GetModule(Which :integer) :PWinAMPVisModule; cdecl;
procedure Config(const PVisModule : PWinAMPVisModule); cdecl;
function  Init(const   PVisModule : PWinAMPVisModule) : integer; cdecl;
function  Render(const PVisModule : PWinAMPVisModule) :integer; cdecl;
procedure Quit(const   PVisModule : PWinAMPVisModule); cdecl;


// Winamp TWinAMPVisHeader
const
  HDR : TWinAMPVisHeader =
           (Version      : $101;  // WinAMP checks this for compatibility
            Description  : 'Yoctopuce WinAMP Plugin for Yocto-Color devices';
            GetModule    : GetModule);
  VisModule : TWinAMPVisModule =
           (Description  :'Yoctopuce Spectrum Analyzer';
            hWNDParent   :0;
            hDLLInstance :0;
            sRate        :0;
            nCh          :0;
            LatencyMs    :10;
            DelayMS      :33;
            SpectrumNch  :2;
            WaveformNch  :0;
            Config       :Config;    // config function
            Init         :Init;      // Plug-in initialization function. Returns 0 if success
            Render       :Render;    // render function. 0 if successful, 1 if vis should end
            Quit         :Quit;      // quit function
            UserData     :nil);


function winampVisGetHeader : PwinampVisHeader; cdecl; export;

implementation



var

  setupWin   : TsetupWin;
  VisuWindow : TVisuWindow;
  leds       : tlist;



function InitYoctoLeds()   :boolean;
  var errmsg:string;
      led:TyColorLed;
begin

  // init yocotpuce API
  if (yRegisterHub('usb', errmsg)<>YAPI_SUCCESS)  then
    begin
       MessageBox(0,pchar(errmsg), 'Error', MB_OK or MB_ICONERROR);
       InitYoctoLeds :=false;
       exit;
    end;

  yDisableExceptions(); // no exception, thank you

  // enumerate all leds, we store all leds objects in a list
  leds:=tlist.create();
  led :=  yFirstColorLed();
  while (led<>nil) do
   begin
     led.set_rgbcolor($FF0000);  // rapid red flash
     led.module().set_luminosity(2); // set blue beacon led to low luminosity
     leds.add(led);
     led.set_rgbcolor($000000);
     led:=led.nextColorLed();
   end;

   InitYoctoLeds :=true;
end;

{------------------------------------------------------------------}
{  WINAMP function - Get plugin handle                             }
{------------------------------------------------------------------}
function WinAMPVisGetHeader :PWinAMPVisHeader;
begin
  Result := @HDR;    //  Return the main header
end;


{------------------------------------------------------------------}
{  WINAMP function - Get module handle                             }
{------------------------------------------------------------------}
function GetModule(Which : integer) : PwinampVisModule;
begin
  if which = 0 then
    Result := @VisModule
  else
    Result := nil;
end;


{------------------------------------------------------------------}
{  WINAMP function - Config setting for the vis module             }
{------------------------------------------------------------------}
procedure Config(const PVisModule : PWinAMPVisModule);
begin
  setupWin :=TsetupWin.Create(nil);
  try
    setupWin.ShowModal;
  finally
    setupWin.Free;
  end;
end;

{------------------------------------------------------------------}
{  WINAMP function - Config setting for the vis module             }
{------------------------------------------------------------------}
procedure Quit(const PVisModule : PWinAMPVisModule);
begin
  VisuWindow.close;
  VisuWindow.free;
  yfreeapi();
end;

{--------------------------------------------------------------------}
{  Creates the window and attaches a OpenGL rendering context to it  }
{--------------------------------------------------------------------}
procedure CreateWindow(const PVisModule : PWinAMPVisModule);
begin
  VisuWindow :=TVisuWindow.Create(nil);
  VisuWindow.Show();
  VisuWindow.render(PVisModule,leds,true);
end;


{--------------------------------------------------------------------}
{  Plugin Init section. Gets the plugin saved details from the       }
{  plugin.ini file in winamp\plugins and creates the GL window       }
{--------------------------------------------------------------------}
function Init(const PVisModule :PWinAMPVisModule) :integer;

begin
  if not(InitYoctoLeds()) then
   begin
    Result := 1;
    exit;
   end;

  CreateWindow(PVisModule);
  Result := 0;

end;


{--------------------------------------------------------------------}
{  Main message loop for the application                             }
{--------------------------------------------------------------------}
function Render(const PVisModule : PWinAMPVisModule) : Integer;
var LastTime : DWord;
begin
  if assigned(VisuWindow) then
  begin
    VisuWindow.render(PVisModule,leds,false);
  end;
  Result :=0;
end;


initialization
  VisuWindow:=nil;
  leds :=nil;
end.
