<?php
include("yocto_api.php");
include("yocto_serialport.php");
include("yocto_poweroutput.php");
include("yocto_wakeupmonitor.php");
include("yocto_epaper.php");

function getURL($url)  // alternative to url fopen
{  $curl = curl_init();
   curl_setopt_array($curl, array(CURLOPT_RETURNTRANSFER=>1,CURLOPT_URL=>$url,CURLOPT_USERAGENT=>'CURL Request'));
   $res = curl_exec($curl);
   curl_close($curl);
   return $res;
}

if (yRegisterHub("callback", $errmsg) != YAPI_SUCCESS)
    die("init error" + errmsg);
  
$serialPort = yFirstSerialPort();
if (is_null($serialPort)) die ('no serial port available');

$module=$serialPort->get_module();
$serial=$module->get_serialNumber();
$power=yFindPowerOutput($serial.".powerOutput"); 
$monitor=yFirstWakeUpMonitor(); 
if (!$power->isOnline()) die ('power output not found');
if (is_null($monitor)) printf ("no WakeUpMonitorFound\n");
$power->set_voltage(Y_VOLTAGE_OUT5V);
$serialPort->set_voltageLevel(Y_VOLTAGELEVEL_TTL5V);

 $json =  getURL('http://api.icndb.com/jokes/random/');
 $maxCharPerLine = 31;
 if (!($json===false))
   { $data =  json_decode($json);
     $joke = html_entity_decode($data->value->joke);
     // embedded font spaces are too narrow
     $joke=str_replace(' ','  ',$joke);
     $serialPort->reset();    
     set64PtFont($serialPort); 
     clearWithBgColor($serialPort);
     $y=10;
     // no automatic justification in the waveshare display
     while (strlen($joke)>0)
     { $n = $maxCharPerLine;
       if ($n<(strlen($joke)-1))
       { while (($joke[$n]!=' ') && ($joke[$n]!='-') &&($n>0)) $n-=1; 
         if ($n==0) $maxCharPerLine=$n; else $n++;
       }
       drawText($serialPort,0,$y,substr($joke,0,$n));
       $joke=substr($joke,$n);
       $y+=72;
     }
    refreshAndUpdate($serialPort);
   }
   $monitor->sleep(6);
?>