/*********************************************************************
 *
 *  $Id: app.ts 32624 2018-10-10 13:23:29Z seb $
 *
 *  Yoctopuce Plugin to ELGATO  StreamDeck
 *
 *
 *********************************************************************/

import {YFunction} from 'yoctolib-esm/yocto_api.js'
import { YWakeUpMonitor } from 'yoctolib-esm/yocto_wakeupmonitor.js'
import { ControllerEnum, StreamDeckAction,YoctopuceDeviceHandler} from '../common_code/yoctopuce_plugin.js'
import { genericSVGIcon } from '../common_code/icons.js'
import { wakeUpMonitorSettings } from './wakeUpMonitor_settings.js'
import {buzzerIcon} from "../buzzer/buzzer_plugin";




export class  StreamDeck_YWakeUpMonitorAction extends StreamDeckAction
 {
   public static readonly  ManagedFunctionType = "wakeUpMonitor";
   static  get actionUUID() : string {return "com.yoctopuce."+StreamDeck_YWakeUpMonitorAction.ManagedFunctionType+ ".action"; }
   public  get ManagedFunctionType() { return  StreamDeck_YWakeUpMonitorAction.ManagedFunctionType }
   private  currentSettings : wakeUpMonitorSettings = new wakeUpMonitorSettings();
   public  icon  : wakeupIcon = null as any;
   public  monitor: YWakeUpMonitor | null =null;
   private lastImage : HTMLImageElement =null as any;



   /*******************************
    * notify the system which Yoctopuce function type is handled by the plugin
    *  must be called at at application start
    *******************************/

   public  static registerFunctionType()
   {
     YoctopuceDeviceHandler.registerFunctionType(StreamDeck_YWakeUpMonitorAction.ManagedFunctionType);
   }

   /*******************************
    * constructor, auttomatically called when a new action is created
    *******************************/

    constructor(uuid:string)
    {   super(uuid);
        YoctopuceDeviceHandler.registerAction(StreamDeck_YWakeUpMonitorAction.ManagedFunctionType,this);
    }

   /*******************************
    * local init
    *******************************/

    public async init()
    {
      this.lastImage = await StreamDeckAction.newImage("wakeUpMonitor_action.svg")
    }

   /*******************************
    * return actions settings
    *******************************/

    protected get settings(): wakeUpMonitorSettings{return this.currentSettings; }

   /*******************************
    * called when the device linked to the action is appearing
    *******************************/

   protected  async functionArrival(hwdname:string)
   { this.redrawIcon(); }

   /*******************************
    * called when the device linked to the action is disappearing
    *******************************/

   protected  async functionRemoval(hwdname:string)
   { this.redrawIcon(); }

   /*******************************
    * called when the key or rotary button is pressed down
    *******************************/

   public  async onKeyDown(context: any, settings: any, coordinates: any, userDesiredState: any)
     {

     }


   /*******************************
    * called when the key or rotary button is pressed ip
    *******************************/

   public  async onKeyUp(context: any, settings: any, coordinates: any, userDesiredState: any)
      {
        if (this.monitor!=null)
           if (await this.monitor.isOnline())
               switch  (this.currentSettings.action)
               {   case "SLEEP"     : await this.monitor.sleep(1); break;
                   case "SLEEPFOR"  : await this.monitor.sleepFor(this.currentSettings.sleepDuration,1 ); break;

               }
     };

   /*******************************
    * called the device current value has changed
    *******************************/

     public valueChanged(source:YWakeUpMonitor , value:String )
     {
     }

   /*******************************
    * redraw the action icon
    *******************************/

   protected async redrawIcon()
     {
       if (this.monitor!=null)
       {
         let online :boolean = await this.monitor.isOnline();
         this.icon.offline = !online;
         this.lastImage = new Image();
         this.lastImage.onload = () =>
         {
           this.setBgImage(this.UUID, this.lastImage)
         }
         let url:string = this.icon.asURL
         this.lastImage.src =url ;
       } else this.setBgImage(this.UUID, this.lastImage)

     }

   /*******************************
    * called with local settings
    *******************************/

   public async didReceiveSettings(context: any, settings: any, coordinates: any)
       {
          super.didReceiveSettings(context, settings, coordinates)
          if  (this.currentSettings.hwdName!="")
           {  this.monitor = await YWakeUpMonitor.FindWakeUpMonitor(this.currentSettings.hwdName);
              await this.monitor.registerValueCallback((source:YFunction,value:string)=>{this.broadcastValueChange(source,value);})
              await this.redrawIcon();
           } else  console.log("monitor name not set");
       }

   /*******************************
    * called with global settings
    *******************************/

   public async didReceiveGlobalSettings(context: any,  settings: any) {  }

   /*******************************
    * called when the action is about to be shown
    *******************************/

   public async onWillAppear(context: any,  controller: ControllerEnum,  settings: any, coordinates: any)
      { super.onWillAppear(context, controller, settings, coordinates)
        this.icon=new wakeupIcon(72,72);
        await this.didReceiveSettings(context, settings,  coordinates)
       // this.getGlobalSettings(context);
      }
 }


export class wakeupIcon extends genericSVGIcon
{
  private setCommonStyle(e: SVGElement )
  {
    e.setAttribute("stroke-width", "2");
    e.setAttribute("stroke-linecap", "round");
    e.setAttribute("stroke-linejoin", "round");
    e.setAttribute("stroke-miterlimit", "22.9256");  // ?

  }

  constructor(imgXsize:number,imgYsize:number)
  {  super(imgXsize,imgYsize)

    let c : SVGCircleElement  = document.createElementNS("http://www.w3.org/2000/svg", "circle") as SVGCircleElement;
    c.setAttribute("cx","19.87")
    c.setAttribute("cy","20.99")
    c.setAttribute("r","9.39")
    c.setAttribute("stroke", "red");
    c.setAttribute("fill","white");
    this.setCommonStyle(c);
    this.svg.appendChild(c);

    let p : SVGPolylineElement  = document.createElementNS("http://www.w3.org/2000/svg", "polyline") as SVGPolylineElement;
    p.setAttribute("points","15.5,17.25 19.87,20.99 27.34,17.25")
    p.setAttribute("stroke", "black");
    p.setAttribute("fill","none");
    this.setCommonStyle(p);
    this.svg.appendChild(p);

    let ph : SVGPathElement  = document.createElementNS("http://www.w3.org/2000/svg", "path") as SVGPathElement;
    ph.setAttribute("d","M9.82 9.1c2.04,-1.57 4.98,-1.19 6.55,0.85l-7.4 5.71c-1.57,-2.05 -1.19,-4.98 0.85,-6.56z")
    ph.setAttribute("stroke", "orange");
    ph.setAttribute("fill","yellow");
    this.setCommonStyle(ph);
    this.svg.appendChild(ph);

    ph   = document.createElementNS("http://www.w3.org/2000/svg", "path") as SVGPathElement;
    ph.setAttribute("d","M30.13 9.1c-2.04,-1.57 -4.98,-1.19 -6.55,0.85l7.4 5.71c1.57,-2.05 1.19,-4.98 -0.85,-6.56z")
    ph.setAttribute("stroke", "orange");
    ph.setAttribute("fill","yellow");
    this.setCommonStyle(ph);
    this.svg.appendChild(ph);

    let l : SVGLineElement  = document.createElementNS("http://www.w3.org/2000/svg", "line") as SVGLineElement;
    l.setAttribute("x1","26.6")
    l.setAttribute("y1","28.1")
    l.setAttribute("x2","28.36")
    l.setAttribute("y2","31")
    l.setAttribute("stroke","red");
    this.setCommonStyle(l);
    this.svg.appendChild(l);

    l = document.createElementNS("http://www.w3.org/2000/svg", "line") as SVGLineElement;
    l.setAttribute("x1","13.13")
    l.setAttribute("y1","28.1")
    l.setAttribute("x2","11.37")
    l.setAttribute("y2","31")
    l.setAttribute("stroke","red");
    this.setCommonStyle(l);
    this.svg.appendChild(l);

    ph = document.createElementNS("http://www.w3.org/2000/svg", "path") as SVGPathElement;
    ph.setAttribute("d","M49.15 4.43c9.83,3.41 16.85,12.45 16.85,23.06 0,13.54 -11.42,24.51 -25.53,24.51 -6.53,0 -12.49,-2.36 -17.01,-6.23 15.82,-1.27 28.25,-14 28.25,-29.51 0,-4.21 -0.92,-8.21 -2.56,-11.83z")
    ph.setAttribute("stroke", "orange");
    ph.setAttribute("fill","yellow");
    this.setCommonStyle(ph);
    this.svg.appendChild(ph);

    this.AddOfflineIndicator();
  }


}



/*******************************
 * important!
 *******************************/

StreamDeck_YWakeUpMonitorAction.registerFunctionType();


// @ts-ignore
