
import { commonSettings } from '../common_code/commonSettings.js'


export class servoSettings extends commonSettings
{
    public action    : string = "TOGGLE";
    public targetmin : number = 0;
    public targetmax : number = 20;
    public delay     : number = 0;
    public increment : number = 1;



  public set(unknownSettings : any) :boolean
    { if (!super.set(unknownSettings)) return false;
      if ("action" in unknownSettings)      this.action    =  unknownSettings["action"].toString();
      if ("targetmin" in unknownSettings)   this.targetmin =  parseFloat(unknownSettings["targetmin"]);
      if ("targetmax" in unknownSettings)   this.targetmax =  parseFloat(unknownSettings["targetmax"]);
      if ("delay" in unknownSettings)       this.delay     =  parseFloat(unknownSettings["delay"]);
      if ("increment" in unknownSettings)   this.increment =  Math.max(0.1,parseFloat(unknownSettings["increment"]));

      return true;
   }
}