
import { PI_handler } from '../common_code/yoctopuce_pi.js'
import { currentLoopOutputSettings } from './currentLoopOutput_settings.js'
export {currentLoopOutputSettings}

export class YCurrentLoopOutput_PI_handler extends PI_handler
{

    private _settings: currentLoopOutputSettings;
    protected  get settings():currentLoopOutputSettings {return this._settings}
    private targetMax   :HTMLInputElement |null =null;

    /*******************************
     * Constructor , load action's settings
     *******************************/

    constructor (inPort: string, inUUID: string, inRegisterEvent: any, inInfo:any,inActionInfo:string)
    {   super(inPort,inUUID,inRegisterEvent,inInfo,inActionInfo, new currentLoopOutputSettings()  )
        this._settings = this.deviceSettings as currentLoopOutputSettings;
        this.DisableUI(true);

    }

    /*******************************
     * called with action settings
     *******************************/
    protected didReceiveSettings(context: any,unknownSettings: any) :boolean
    {   if (!super.didReceiveSettings(context,unknownSettings )) return false;
        let action :HTMLSelectElement     |null = document.getElementById("action") as HTMLSelectElement;
        let targetMin :HTMLInputElement   |null = document.getElementById("targetMin") as HTMLInputElement;
        this.targetMax = document.getElementById("targetMax") as HTMLInputElement;
        let moveDelay :HTMLInputElement   |null = document.getElementById("moveDelay") as HTMLInputElement;
        action.value = this.settings.action;
        targetMin.value = this.settings.targetmin.toString();
        this.targetMax.value = this.settings.targetmax.toString();
        moveDelay.value = this.settings.delay.toString();
        let it :HTMLElement | null = document.getElementById("targetMaxField");
        if (it) it.style.display = this.dualLimits(action.value) ?"":"none";
        this.DisableUI(this.settings.hwdName=="");
        return true;
    }


    private DisableUI(state :boolean)
    {
        let action : HTMLSelectElement | null = document.getElementById("action") as HTMLSelectElement ;
        if  (action!=null)  action.disabled =  state;
        let targetMin : HTMLInputElement | null = document.getElementById("targetMin") as HTMLInputElement ;
        if  (targetMin!=null)  targetMin.disabled =  state;
        let targetMax : HTMLInputElement | null = document.getElementById("targetMax") as HTMLInputElement ;
        if  (targetMax!=null)  targetMax.disabled =  state;
        let moveDelay : HTMLInputElement | null = document.getElementById("moveDelay") as HTMLInputElement ;
        if  (moveDelay!=null)  moveDelay.disabled =  state;
    }

    /*******************************
     * called when a Properties inpector field has changed
     *******************************/

    protected inspectorValueHasChanged(source: HTMLInputElement | HTMLSelectElement)
    {   super.inspectorValueHasChanged(source);
        switch (source.id)
        {
            case "deviceList":
                this.DisableUI(source.value=="") ;
                break;

            case "action" :
                this.settings.action = source.value;
                let it :HTMLElement | null = document.getElementById("targetMaxField");
                if (it) it.style.display = this.dualLimits(source.value)?"":"none";
                this.saveSettings(this.settings);
                break;
            case "targetMin" :
                this.settings.targetmin = parseFloat(source.value);
                this.saveSettings(this.settings);
                break;
            case "targetMax" :
                this.settings.targetmax = parseFloat(source.value);
                this.saveSettings(this.settings);
                break;
            case "moveDelay" :
                this.settings.delay = parseInt( source.value);
                this.saveSettings(this.settings);
                break;

        }

    }

    /*******************************
     * extra stuff
     *******************************/

    private dualLimits(action:string)
    {  return (action=="TOGGLE") || (action=="MOMENTARY");

    }


}