export class genericSVGIcon
{   protected svg :SVGSVGElement;
  protected  width :number   = 0;
  protected height:number  = 0;
  private _offline =true;
  private offline_bgr  : SVGRectElement  = null as any;
  private offline_l1   : SVGLineElement  = null as any;
  private offline_l2   : SVGLineElement  = null as any;
  private offline_r    : SVGRectElement  = null as any;
  private offline_text : SVGTextElement  = null as any;

  constructor(imgXsize:number,imgYsize:number)
  {  this.width  = imgXsize;
    this.height = imgYsize
    this.svg    = document.createElementNS("http://www.w3.org/2000/svg", "svg") as SVGSVGElement ;
    this.svg.setAttribute("viewBox", "0 0 "+imgXsize.toString()+" "+imgYsize.toString());
    this.svg.setAttribute("version", "1.1");
    this.svg.setAttribute("width", imgXsize.toString());
    this.svg.setAttribute("height",imgYsize.toString());
  }

  public  set offline(value:boolean )
  {   this._offline = value;
    let attrvalue : string = this._offline?"visible":"hidden";
    this.offline_bgr.setAttribute("visibility",attrvalue)
    this.offline_l1.setAttribute("visibility",attrvalue)
    this.offline_l2.setAttribute("visibility",attrvalue)
    this.offline_r.setAttribute("visibility",attrvalue)
    this.offline_text.setAttribute("visibility",attrvalue)
  }

  protected AddOfflineIndicator()
  {
    this.offline_bgr = document.createElementNS("http://www.w3.org/2000/svg", "rect") as SVGRectElement;
    this.offline_bgr.setAttribute("x","0")
    this.offline_bgr.setAttribute("y","0")
    this.offline_bgr.setAttribute("width",this.width.toString())
    this.offline_bgr.setAttribute("height",this.height.toString())
    this.offline_bgr.setAttribute("fill","black");
    this.offline_bgr.setAttribute("fill-opacity","0.6");
    this.svg.appendChild(this.offline_bgr);

    this.offline_l1  = document.createElementNS("http://www.w3.org/2000/svg", "line") as SVGLineElement;
    this.offline_l1.setAttribute("x1","0")
    this.offline_l1.setAttribute("y1","0")
    this.offline_l1.setAttribute("x2",this.width.toString())
    this.offline_l1.setAttribute("y2",this.height.toString())
    this.offline_l1.setAttribute("stroke","red");
    this.svg.appendChild(this.offline_l1);

    this.offline_l2  = document.createElementNS("http://www.w3.org/2000/svg", "line") as SVGLineElement;
    this.offline_l2.setAttribute("x1",this.width.toString())
    this.offline_l2.setAttribute("y1","0")
    this.offline_l2.setAttribute("x2","0")
    this.offline_l2.setAttribute("y2",this.height.toString())
    this.offline_l2.setAttribute("stroke","red");
    this.svg.appendChild(this.offline_l2);

    let textHeight = Math.round(this.height/5);
    let h :number = textHeight*1.4;
    let w :number = textHeight*5;
    this.offline_r   = document.createElementNS("http://www.w3.org/2000/svg", "rect") as SVGRectElement;
    this.offline_r.setAttribute("x",((this.width -w) /2).toString())
    this.offline_r.setAttribute("y",((this.height -h)  /2 -1).toString())
    this.offline_r.setAttribute("width",w.toString())
    this.offline_r.setAttribute("height",h.toString())
    this.offline_r.setAttribute("stroke","red");
    this.offline_r.setAttribute("fill","black");
    this.svg.appendChild(this.offline_r);

    this.offline_text  =  document.createElementNS("http://www.w3.org/2000/svg","text") as SVGTextElement;
    this.offline_text.setAttribute("dominant-baseline", "Middle")
    this.offline_text.setAttribute("text-anchor","middle")
    this.offline_text.setAttribute("font-family","Arial, Helvetica, sans-serif")
    this.offline_text.setAttribute("font-size",textHeight.toString())
    this.offline_text.setAttribute("x",(this.width/2).toString());
    this.offline_text.setAttribute("y",(this.height/2).toString())
    this.offline_text.setAttribute("fill","red");
    this.offline_text.innerHTML="OFFLINE";
    this.svg.appendChild(this.offline_text);
  }

  public get asURL() : string
  {
    let contents = this.svg.outerHTML.replace("<svg ","<svg xmlns=\"http://www.w3.org/2000/svg\" ");
    return  URL.createObjectURL(new Blob([contents], { type: 'image/svg+xml' }));
  }
}


export class CircularGauge extends genericSVGIcon
{ private centerX :number;
  private centerY :number;
  private innerRadius :number;
  private outterRadius:number ;
  private angleStart:number ;
  private angleEnd :number;
  private angleValue :number;
  private unit
  private valuePath :SVGPathElement;
  private valueLabel :SVGTextElement;
  private valueUnit :SVGTextElement;
  private value:number =0;

  private computePathDescription(centerX:number,centerY:number, innerRadius :number, outterRadius :number, angleStart:number, angleEnd:number):string
  {let flag1 :string ="0 1 ";
    let flag2 :string="0 0 ";
    if (angleStart>angleEnd) angleStart+=360;
    if (angleEnd-angleStart >180)  {flag1= "1 1 " ; flag2="1 0 ";}
    angleStart = angleStart*Math.PI/180.0;
    angleEnd = angleEnd*Math.PI/180.0;

    let P1x :number= centerX+outterRadius*Math.cos(angleStart);
    let P1y :number= centerY+outterRadius*Math.sin(angleStart);
    let P2x :number= centerX+outterRadius*Math.cos(angleEnd);
    let P2y :number= centerY+outterRadius*Math.sin(angleEnd);
    let P3x :number= centerX+innerRadius*Math.cos(angleEnd);
    let P3y :number= centerY+innerRadius*Math.sin(angleEnd);
    let P4x :number= centerX+innerRadius*Math.cos(angleStart);
    let P4y :number= centerY+innerRadius*Math.sin(angleStart);
    return  "M "+P1x.toFixed(2)+" "+P1y.toFixed(2)
      +" A "+outterRadius.toFixed(2)+" "+outterRadius.toFixed(2)+" 0 "+flag1 +P2x.toFixed(2)+" "+P2y.toFixed(2)
      +" L "+P3x.toFixed(2)+" "+P3y.toFixed(2)
      +" A "+innerRadius.toFixed(2)+" "+innerRadius.toFixed(2)+" 0 "+flag2 +P4x.toFixed(2)+" "+P4y.toFixed(2)
      +" Z"
  }

  public setValue(percentValue :number,textValue:string)
  {  let end :number =  this.angleStart>this.angleEnd ?  this.angleEnd+360 : this.angleEnd;
    if (percentValue<0) percentValue =0;
    if (percentValue>100) percentValue =100;
    this.angleValue =  (this.angleStart+ percentValue*(end-this.angleStart)/100.0);
    if (this.angleValue>360) this.angleValue-=360;
    this.valuePath.setAttribute("d",this.computePathDescription(this.centerX,this.centerY, this.innerRadius , this.outterRadius , this.angleStart, this.angleValue));
    this.valueLabel.innerHTML = textValue;
  }

  constructor(imgXsize:number,imgYsize:number, centerX:number,centerY:number, innerRadius :number, outterRadius :number, angleStart:number, angleEnd:number,value:number,unit:string)
  {   super(imgXsize,imgYsize)
    this.centerX = centerX;
    this.centerY = centerY;
    this.innerRadius = innerRadius;
    this.outterRadius = outterRadius;
    this.angleStart = angleStart;
    this.angleValue = angleStart;
    this.angleEnd = angleEnd;
    this.unit=unit;
    this.valueLabel =  document.createElementNS("http://www.w3.org/2000/svg","text") as SVGTextElement;

    this.valueUnit =  document.createElementNS("http://www.w3.org/2000/svg","text") as SVGTextElement;
    this.valueUnit.setAttribute("font-family","Arial, Helvetica, sans-serif")
    this.valueUnit.setAttribute("font-size",(outterRadius-innerRadius).toString())
    let rectangularDisplay :boolean =  this.width>this.height;
    this.valueUnit.setAttribute("dominant-baseline",rectangularDisplay ? "auto" : "hanging")
    this.valueUnit.setAttribute("text-anchor",rectangularDisplay?"start":"end")
    this.valueUnit.setAttribute("x", rectangularDisplay ? (centerX+outterRadius+5).toString(): (imgXsize-5).toString())
    this.valueUnit.setAttribute("y",rectangularDisplay ? (centerY+outterRadius).toString():"5")
    this.valueUnit.setAttribute("fill","White");
    this.valueUnit.innerHTML=unit;
    this.svg.appendChild( this.valueUnit);

    let pathDescriptionStatic = this.computePathDescription(this.centerX,this.centerY, this.innerRadius , this.outterRadius , this.angleStart, this.angleEnd)

    let p :SVGPathElement = document.createElementNS("http://www.w3.org/2000/svg", "path") as SVGPathElement;
    p.setAttribute("style","fill:#404040; stroke:none;")
    p.setAttribute("d",pathDescriptionStatic);
    this.svg.appendChild( p);

    this.valuePath = document.createElementNS("http://www.w3.org/2000/svg", "path") as SVGPathElement;
    this.valuePath.setAttribute("style","fill:lime; stroke:none;")
    this.setValue(value,"--")
    this.svg.appendChild( this.valuePath);

    p = document.createElementNS("http://www.w3.org/2000/svg", "path") as SVGPathElement;
    p.setAttribute("style","fill:none; stroke:#808080; stroke-width:2")
    p.setAttribute("d",pathDescriptionStatic);
    this.svg.appendChild( p);

    this.valueLabel.setAttribute("text-anchor","end")
    this.valueLabel.setAttribute("font-family","Arial, Helvetica, sans-serif")
    this.valueLabel.setAttribute("font-size",(outterRadius-innerRadius).toString())
    this.valueLabel.setAttribute("x",(centerX+outterRadius).toString())
    this.valueLabel.setAttribute("y",(centerY+outterRadius).toString())
    this.valueLabel.setAttribute("fill","white");
    this.valueLabel.innerHTML="--.-";
    this.svg.appendChild( this.valueLabel);

    this.AddOfflineIndicator();
  }
}

export class rectangularGauge extends genericSVGIcon
{ private centerX :number;
  private centerY :number;
  private rectWidth :number;
  private rectHeight:number ;
  private unit
  private valueRect :SVGRectElement;
  private valueLabel :SVGTextElement;
  private value:number =0;


  public setValue(percentValue :number,textValue:string)
  {
    let w :number = Math.abs(percentValue) * (this.rectWidth/2) /100;
    if (percentValue>0) this.valueRect.setAttribute("x",(this.centerX).toString());
                   else this.valueRect.setAttribute("x",(this.centerX-w).toString());
    this.valueRect.setAttribute("width",( w ).toString());
    this.valueLabel.innerHTML = textValue;
  }

  constructor(imgXsize:number,imgYsize:number, centerX:number,centerY:number, width :number, height :number ,value:number,unit:string)
  {   super(imgXsize,imgYsize)
    this.centerX = centerX;
    this.centerY = centerY;
    this.rectWidth = width;
    this.rectHeight = height;
    this.unit=unit;
    let protude : number =4;

    let l : SVGLineElement =  document.createElementNS("http://www.w3.org/2000/svg", "line") as SVGLineElement;
   /* l.setAttribute("style","fill:none; stroke:#808080; stroke-width:2")
    l.setAttribute("x1",(this.centerX- this.rectWidth/2).toString());
    l.setAttribute("x2",(this.centerX- this.rectWidth/2).toString());
    l.setAttribute("y1",(this.centerY).toString());
    l.setAttribute("y2",(this.centerY- this.rectHeight/2-protude).toString());
    this.svg.appendChild(l);

    l  =  document.createElementNS("http://www.w3.org/2000/svg", "line") as SVGLineElement;
    l.setAttribute("style","fill:none; stroke:#808080; stroke-width:2")
    l.setAttribute("x1",(this.centerX+ this.rectWidth/2).toString());
    l.setAttribute("x2",(this.centerX+ this.rectWidth/2).toString());
    l.setAttribute("y1",(this.centerY).toString());
    l.setAttribute("y2",(this.centerY- this.rectHeight/2-protude).toString());
    this.svg.appendChild(l);

    */


    let r :SVGRectElement = document.createElementNS("http://www.w3.org/2000/svg", "rect") as SVGRectElement;
    r.setAttribute("style","fill:#404040; stroke:none;")
    r.setAttribute("x",(this.centerX- this.rectWidth/2).toString());
    r.setAttribute("y",(this.centerY- this.rectHeight/2).toString());
    r.setAttribute("rx","2");
    r.setAttribute("ry","2");
    r.setAttribute("width",(this.rectWidth).toString());
    r.setAttribute("height",(this.rectHeight).toString());
    this.svg.appendChild(r);

    this.valueRect =  document.createElementNS("http://www.w3.org/2000/svg", "rect") as SVGRectElement;
    this.valueRect.setAttribute("style","fill:lime; stroke-width:2;")
    this.valueRect.setAttribute("x",(this.centerX- this.rectWidth/2).toString());
    this.valueRect.setAttribute("y",(this.centerY- this.rectHeight/2).toString());
    this.valueRect.setAttribute("width",(0).toString());
    this.valueRect.setAttribute("height",(this.rectHeight).toString());
    this.svg.appendChild(this.valueRect);

    r  = document.createElementNS("http://www.w3.org/2000/svg", "rect") as SVGRectElement;
    r.setAttribute("style","fill:none; stroke:#808080; stroke-width:2")
    r.setAttribute("x",(this.centerX- this.rectWidth/2).toString());
    r.setAttribute("y",(this.centerY- this.rectHeight/2).toString());
    r.setAttribute("rx","2");
    r.setAttribute("ry","2");
    r.setAttribute("width",(this.rectWidth).toString());
    r.setAttribute("height",(this.rectHeight).toString());
    this.svg.appendChild(r);

    l  =  document.createElementNS("http://www.w3.org/2000/svg", "line") as SVGLineElement;
    l.setAttribute("style","fill:none; stroke:#808080; stroke-width:2")
    l.setAttribute("x1",(this.centerX).toString());
    l.setAttribute("x2",(this.centerX).toString());
    l.setAttribute("y1",(this.centerY+ this.rectHeight/2+protude).toString());
    l.setAttribute("y2",(this.centerY- this.rectHeight/2-protude).toString());
    this.svg.appendChild(l);

    this.valueLabel =  document.createElementNS("http://www.w3.org/2000/svg","text") as SVGTextElement;
    this.valueLabel.setAttribute("dominant-baseline", "hanging")
    this.valueLabel.setAttribute("text-anchor","end")

    this.valueLabel.setAttribute("font-family","Arial, Helvetica, sans-serif")
    this.valueLabel.setAttribute("font-size",(this.rectHeight).toString())
    this.valueLabel.setAttribute("x",(centerX+this.rectWidth/2).toString())
    this.valueLabel.setAttribute("y",(centerY+this.rectHeight/2+5).toString())
    this.valueLabel.setAttribute("fill","white");
    this.valueLabel.innerHTML="---.- %";
    this.svg.appendChild( this.valueLabel);

    this.AddOfflineIndicator();
  }
}


