
import { commonSettings } from '../common_code/commonSettings.js'
import {ControllerEnum} from '../common_code/yoctopuce_plugin.js'

export class colorLedClusterSettings extends commonSettings
{
    public action     : string = "TOGGLE";
    public firstLed   : number = 0;
    public ledCount   : number = 8;
    public color1     : string = "#00FF00";
    public color2     : string = "#0000FF";
    public colorSpace : string = "RGB";
    public transitionDelay : number = 500;
    public encoderAction : string = "R";
    public targetmax : number = 20;
    public delay     : number = 0;

    
    public set(unknownSettings : any) :boolean
    { if (!super.set(unknownSettings)) return false;
      if ("action" in unknownSettings)            this.action          = unknownSettings["action"].toString();
      if ("firstLed" in unknownSettings)          this.firstLed        = parseInt(unknownSettings["firstLed"]);
      if ("ledCount" in unknownSettings)          this.ledCount        = parseInt(unknownSettings["ledCount"]);
      if ("color1" in unknownSettings)            this.color1          = unknownSettings["color1"].toString();
      if ("color2" in unknownSettings)            this.color2          = unknownSettings["color2"].toString();
      if ("colorSpace" in unknownSettings)        this.colorSpace      = unknownSettings["colorSpace"].toString();
      if ("transitionDelay" in unknownSettings)   this.transitionDelay = parseInt(unknownSettings["transitionDelay"]);
      if ("encoderAction" in unknownSettings)     this.encoderAction   = unknownSettings["encoderAction"].toString();

      return true;
   }
}