
import { PI_handler } from '../common_code/yoctopuce_pi.js'
import {colorLedClusterSettings } from './colorLedCluster_settings.js'
import {ControllerEnum} from "../common_code/yoctopuce_plugin";
export {colorLedClusterSettings}

export class YColorLedCluster_PI_handler extends PI_handler
{

    private _settings: colorLedClusterSettings;
    protected  get settings():colorLedClusterSettings {return this._settings}
    private targetMax   :HTMLInputElement |null =null;

    /*******************************
     * Constructor , load action's settings
     *******************************/

    constructor (inPort: string, inUUID: string, inRegisterEvent: any, inInfo:any,inActionInfo:string)
    {   super(inPort,inUUID,inRegisterEvent,inInfo,inActionInfo, new colorLedClusterSettings()  )
        this._settings = this.deviceSettings as colorLedClusterSettings;

        let div : HTMLDivElement =  document.getElementById("EncoderActionField") as HTMLDivElement;
        if ((this.controller == ControllerEnum.ENCODER) && div) div.style.display ="";

        this.DisableUI(true);
    }


    private DisableUI(state :boolean)
    {   let action : HTMLSelectElement | null = document.getElementById("action") as HTMLSelectElement ;
        if  (action!=null)  action.disabled =  state;
        let firstLed : HTMLInputElement | null = document.getElementById("firstLed") as HTMLInputElement ;
        if  (firstLed!=null)  firstLed.disabled =  state;
        let ledCount : HTMLInputElement | null = document.getElementById("ledCount") as HTMLInputElement ;
        if  (ledCount!=null)  ledCount.disabled =  state;
        let color1 :  HTMLInputElement | null = document.getElementById("color1") as HTMLInputElement ;
        if  (color1 !=null)  color1.disabled =  state;
        let color2 :  HTMLInputElement | null = document.getElementById("color2") as HTMLInputElement ;
        if  (color2 !=null)  color2.disabled =  state;
        let colorSpace : HTMLSelectElement | null = document.getElementById("colorSpace") as HTMLSelectElement ;
        if  (colorSpace!=null)  colorSpace.disabled =  state;
        let transitionDelay :  HTMLInputElement | null = document.getElementById("transitionDelay") as HTMLInputElement ;
        if  (transitionDelay !=null)  transitionDelay.disabled =  state;
        let encoderAction : HTMLSelectElement | null = document.getElementById("encoderAction") as HTMLSelectElement ;
        if  (encoderAction!=null)  encoderAction.disabled =  state;
    }


    /*******************************
     * called with action settings
     *******************************/
    protected didReceiveSettings(context: any,unknownSettings: any) :boolean
    {   if (!super.didReceiveSettings(context,unknownSettings )) return false;

        let action :HTMLSelectElement     |null = document.getElementById("action") as HTMLSelectElement;
        let firstLed :HTMLInputElement   |null = document.getElementById("firstLed") as HTMLInputElement;
        let ledCount :HTMLInputElement   |null = document.getElementById("ledCount") as HTMLInputElement;
        let color1 :HTMLInputElement   |null = document.getElementById("color1") as HTMLInputElement;
        let color2 :HTMLInputElement   |null = document.getElementById("color2") as HTMLInputElement;
        let colorSpace :HTMLSelectElement     |null = document.getElementById("colorSpace") as HTMLSelectElement;
        let transitionDelay :HTMLInputElement   |null = document.getElementById("transitionDelay") as HTMLInputElement;
        let encoderAction :HTMLSelectElement   |null = document.getElementById("encoderAction") as HTMLSelectElement;


        action.value = this.settings.action;
        firstLed.value = this.settings.firstLed.toString();
        ledCount.value = this.settings.ledCount.toString();
        color1.value = this.settings.color1.toString();
        color2.value = this.settings.color2.toString();
        colorSpace.value = this.settings.colorSpace.toString();
        transitionDelay.value = this.settings.transitionDelay.toString();
        encoderAction.value =  this.settings.encoderAction;

        let it :HTMLElement | null = document.getElementById("color2Field");
        if (it) it.style.display = this.settings.action =="ONOFF" ?"none":"";



        this.DisableUI(this.settings.hwdName=="");

        return true;
    }


    /*******************************
     * called when a Properties inpector field has changed
     *******************************/

    protected inspectorValueHasChanged(source: HTMLInputElement | HTMLSelectElement)
    {   super.inspectorValueHasChanged(source);
        switch (source.id)
        {    case "deviceList":
                this.DisableUI(source.value=="") ;
                break;
            case "action" :
                this.settings.action = source.value;
                let it :HTMLElement | null = document.getElementById("color2Field");
                if (it) it.style.display = this.settings.action =="ONOFF" ?"none":"";
                this.saveSettings(this.settings);
                break;
            case "firstLed" :
                this.settings.firstLed = parseInt(source.value);
                this.saveSettings(this.settings);
                break;
            case "ledCount" :
                this.settings.ledCount = parseInt(source.value);
                this.saveSettings(this.settings);
                break;
            case "color1" :
                this.settings.color1 = source.value;
                this.saveSettings(this.settings);
                break;
            case "color2" :
                this.settings.color2 = source.value;
                this.saveSettings(this.settings);
                break;
            case "colorSpace" :
                this.settings.colorSpace = source.value;
                this.saveSettings(this.settings);
                break;
            case "transitionDelay" :
                this.settings.transitionDelay = parseInt(source.value);
                this.saveSettings(this.settings);
                break;
            case "encoderAction" :
                this.settings.encoderAction = source.value;
                this.saveSettings(this.settings);
                break;

        }

    }




}