
import { commonSettings } from '../common_code/commonSettings.js'

export class buzzerSettings extends commonSettings
{
    public action : string ="TUNE";
    public melody :string ="150% 'G8 F# E E F#2_ F#2 ,A8 'G F# E E4 F#4 D. E8 ,A2 A8 'E4 F#8 G4. E4 C# D8 E4. ,A4 'F#2.";
    public pulseduration : number =1000;
    public frequency     : number  =100;
    public volume        : number  =50;


   public set(unknownSettings : any) :boolean
    { if (!super.set(unknownSettings)) return false;
     if ("action" in unknownSettings)     this.action =  unknownSettings["action"].toString();
     if ("pulseduration" in unknownSettings) this.pulseduration =  parseInt(unknownSettings["pulseduration"]);
     if ("frequency" in unknownSettings)  this.frequency =  parseInt(unknownSettings["frequency"]);
     if ("volume" in unknownSettings)     this.volume =  parseInt(unknownSettings["volume"]);
     if ("melody" in unknownSettings)     this.melody =  unknownSettings["melody"].toString();
     return true;
   }
}