/*********************************************************************
 *
 *  $Id: app.ts 32624 2018-10-10 13:23:29Z seb $
 *
 *  Yoctopuce Plugin to ELGATO  StreamDeck
 *
 *
 *********************************************************************/

import {YFunction} from 'yoctolib-esm/yocto_api.js'
import { YBuzzer } from 'yoctolib-esm/yocto_buzzer.js'
import { ControllerEnum, StreamDeckAction,YoctopuceDeviceHandler} from '../common_code/yoctopuce_plugin.js'
import { genericSVGIcon } from '../common_code/icons.js'
import { buzzerSettings } from './buzzer_settings.js'
import {YRelay} from "yoctolib-esm/yocto_relay";


export class  StreamDeck_YBuzzerAction extends StreamDeckAction
 {
   public static readonly  ManagedFunctionType = "buzzer";
   static  get actionUUID() : string {return "com.yoctopuce."+StreamDeck_YBuzzerAction.ManagedFunctionType+ ".action"; }
   public  get ManagedFunctionType() { return  StreamDeck_YBuzzerAction.ManagedFunctionType }
   private  currentSettings : buzzerSettings = new buzzerSettings();
   public  icon  : buzzerIcon = null as any;
   public  buzzer: YBuzzer | null =null;
   private lastImage : HTMLImageElement =null as any;

   /*******************************
    * notify the system which Yoctopuce function type is handled by the plugin
    *  must be called at at application start
    *******************************/

   public  static registerFunctionType()
   {
     YoctopuceDeviceHandler.registerFunctionType(StreamDeck_YBuzzerAction.ManagedFunctionType);
   }

   /*******************************
    * constructor, auttomatically called when a new action is created
    *******************************/

    constructor(uuid:string)
    {   super(uuid);

        YoctopuceDeviceHandler.registerAction(StreamDeck_YBuzzerAction.ManagedFunctionType,this);
    }

   /*******************************
    * local init
    *******************************/

    public async init()
    {
      this.lastImage = await StreamDeckAction.newImage("buzzer_action.svg")
    }

   /*******************************
    * return actions settings
    *******************************/

    protected get settings(): buzzerSettings{return this.currentSettings; }

   /*******************************
    * called when the device linked to the action is appearing
    *******************************/

   protected  async functionArrival(hwdname:string)
   { console.log("**** arrival "+hwdname);
     this.redrawIcon();
   }

   /*******************************
    * called when the device linked to the action is disappearing
    *******************************/

   protected  async functionRemoval(hwdname:string)
   { console.log("**** removal "+hwdname);
     this.redrawIcon();
   }

   /*******************************
    * called when the key or rotary button is pressed down
    *******************************/

   public  async onKeyDown(context: any, settings: any, coordinates: any, userDesiredState: any)
     {   if (this.buzzer!=null)
         if (await this.buzzer.isOnline())
             switch  (this.currentSettings.action)
             {   case "MOMENTARY": await this.buzzer.set_volume(this.currentSettings.volume);
                                   await  this.buzzer.set_frequency(this.currentSettings.frequency);
                                   break;
             }
     }


   /*******************************
    * called when the key or rotary button is pressed ip
    *******************************/

   public  async onKeyUp(context: any, settings: any, coordinates: any, userDesiredState: any)
      { if (this.buzzer!=null)
           if (await this.buzzer.isOnline())
               switch  (this.currentSettings.action)
               {    case "PULSE":      await this.buzzer.set_volume(this.currentSettings.volume);
                                       await this.buzzer.pulse(this.currentSettings.frequency,this.currentSettings.pulseduration);
                                       break;
                    case "TUNE":       await this.buzzer.set_volume(this.currentSettings.volume);
                                       await this.buzzer.playNotes(this.currentSettings.melody);
                                       break;
                    case "MOMENTARY":  await  this.buzzer.set_frequency(0);
                                       break;
               }
     };

   /*******************************
    * called the device current value has changed
    *******************************/

     public valueChanged(source:YBuzzer , value:String )
     {
     }

   /*******************************
    * redraw the action icon
    *******************************/

   protected async redrawIcon()
     {
       if (this.buzzer!=null)
       {
         let online :boolean = await this.buzzer.isOnline();
         this.icon.offline = !online;
         this.lastImage = new Image();
         this.lastImage.onload = () =>
         {
           this.setBgImage(this.UUID, this.lastImage)
         }
         let url:string = this.icon.asURL
         this.lastImage.src =url ;
       } else this.setBgImage(this.UUID, this.lastImage)

     }

   /*******************************
    * called with local settings
    *******************************/

   public async didReceiveSettings(context: any, settings: any, coordinates: any)
       {
          super.didReceiveSettings(context, settings, coordinates)
          if  (this.currentSettings.hwdName!="")
           {  this.buzzer = await YBuzzer.FindBuzzer(this.currentSettings.hwdName);
              await this.buzzer.registerValueCallback((source:YFunction,value:string)=>{this.broadcastValueChange(source,value);})
              await this.redrawIcon();
           } else  console.log("buzzer name not set");
       }

   /*******************************
    * called with global settings
    *******************************/

   public async didReceiveGlobalSettings(context: any,  settings: any) {  }

   /*******************************
    * called when the action is about to be shown
    *******************************/

   public async onWillAppear(context: any,  controller: ControllerEnum,  settings: any, coordinates: any)
      { super.onWillAppear(context, controller, settings, coordinates)
        this.icon=new buzzerIcon(72,72);
        await this.didReceiveSettings(context, settings,  coordinates)
       // this.getGlobalSettings(context);
      }
 }


export class buzzerIcon extends genericSVGIcon
{
  private setCommonStyle(e: SVGElement )
  {
    e.setAttribute("stroke-width", "2");
    e.setAttribute("stroke-linecap", "round");
    e.setAttribute("stroke-linejoin", "round");
    e.setAttribute("stroke-miterlimit", "22.9256");  // ?

  }

  constructor(imgXsize:number,imgYsize:number)
  {  super(imgXsize,imgYsize)

    let p : SVGPolygonElement  = document.createElementNS("http://www.w3.org/2000/svg", "polygon") as SVGPolygonElement;
    p.setAttribute("points","37.33,7.81 27.33,22.42 17.33,22.42 17.33,32.16 17.33,37.02 27.33,37.02 37.33,51.63 ")
    p.setAttribute("stroke","#7F7353");
    p.setAttribute("fill","#B9AE93");

    this.setCommonStyle(p);
    this.svg.appendChild(p);

    let l : SVGLineElement  = document.createElementNS("http://www.w3.org/2000/svg", "line") as SVGLineElement;
    l.setAttribute("x1","22.33")
    l.setAttribute("y1","19.9")
    l.setAttribute("x2","22.33")
    l.setAttribute("y2","39.79")
    l.setAttribute("stroke","#635941");
    this.setCommonStyle(l);
    this.svg.appendChild(l);

    l  = document.createElementNS("http://www.w3.org/2000/svg", "line") as SVGLineElement;
    l.setAttribute("x1","27.33")
    l.setAttribute("y1","22.42")
    l.setAttribute("x2","27.33")
    l.setAttribute("y2","37.02")
    l.setAttribute("stroke","#7F7353");
    this.setCommonStyle(l);
    this.svg.appendChild(l);

    let h : SVGPathElement  = document.createElementNS("http://www.w3.org/2000/svg", "path") as SVGPathElement;
    h.setAttribute("d","M40 15.57c2.48,4.35 3.78,9.23 3.78,14.2 0,4.97 -1.3,9.86 -3.78,14.2")
    h.setAttribute("stroke","#B0B0B0");
    h.setAttribute("fill","none");

    this.setCommonStyle(h);
    this.svg.appendChild(h);

    h  = document.createElementNS("http://www.w3.org/2000/svg", "path") as SVGPathElement;
    h.setAttribute("d","M46.99 11.78c3.14,5.51 4.79,11.7 4.79,17.99 0,6.3 -1.65,12.5 -4.79,18")
    h.setAttribute("stroke","#B0B0B0");
    h.setAttribute("fill","none");
    this.setCommonStyle(h);
    this.svg.appendChild(h);

    h  = document.createElementNS("http://www.w3.org/2000/svg", "path") as SVGPathElement;
    h.setAttribute("d","M53.8 7.68c3.92,6.74 5.98,14.35 5.98,22.09 0,7.62 -1.99,15.12 -5.8,21.78")
    h.setAttribute("stroke","#B0B0B0");
    h.setAttribute("fill","none");
    this.setCommonStyle(h);
    this.svg.appendChild(h);
    this.AddOfflineIndicator();
  }





}


/*******************************
 * important!
 *******************************/

StreamDeck_YBuzzerAction.registerFunctionType();


// @ts-ignore
