
import { PI_handler } from '../common_code/yoctopuce_pi.js'
import { buzzerSettings } from './buzzer_settings.js'


export {buzzerSettings}

export class YBuzzer_PI_handler extends PI_handler
{
    private _settings: buzzerSettings;
    protected  get settings():buzzerSettings {return this._settings}

    /*******************************
     * Constructor , load action's settings
     *******************************/

    constructor (inPort: string, inUUID: string, inRegisterEvent: any, inInfo:any,inActionInfo:string)
    {   super(inPort,inUUID,inRegisterEvent,inInfo,inActionInfo, new  buzzerSettings()  )
        this._settings = this.deviceSettings as  buzzerSettings;
        this.updateUI();
        this.DisableUI(true);
    }

    /*******************************
     * called with action settings
     *******************************/

    protected didReceiveSettings(context: any,unknownSettings: any) :boolean
    {   if (!super.didReceiveSettings(context,unknownSettings )) return false;
        this.updateUI();
        this.DisableUI(this.settings.hwdName=="");
        return true
    }

    private DisableUI(state :boolean)
    {
        let action : HTMLSelectElement | null = document.getElementById("action") as HTMLSelectElement ;
        if  (action!=null)  action.disabled =  state;
        let duration : HTMLInputElement | null = document.getElementById("duration") as HTMLInputElement ;
        if  (duration!=null)  duration.disabled =  state;
        let frequency : HTMLInputElement | null = document.getElementById("frequency") as HTMLInputElement ;
        if  (frequency!=null)  frequency.disabled =  state;
        let volume : HTMLInputElement | null = document.getElementById("volume") as HTMLInputElement ;
        if  (volume!=null)  volume.disabled =  state;
        let melody : HTMLInputElement | null = document.getElementById("melody") as HTMLInputElement ;
        if  (melody!=null)  melody.disabled =  state;
    }



    private updateUI()
    {   let action :HTMLSelectElement |null = document.getElementById("action") as HTMLSelectElement;
        let duration :HTMLInputElement |null = document.getElementById("duration") as HTMLInputElement;
        let frequency :HTMLInputElement |null = document.getElementById("frequency") as HTMLInputElement;
        let volume :HTMLInputElement |null = document.getElementById("volume") as HTMLInputElement;
        let melody :HTMLInputElement |null = document.getElementById("melody") as HTMLInputElement;
        action.value        = this.settings.action;
        duration.value      = this.settings.pulseduration.toString();
        frequency.value     = this.settings.frequency.toString();
        volume.value        = this.settings.volume.toString();
        melody.value        = this.settings.melody.toString();


        let durationField : HTMLDivElement | null = document.getElementById("durationField") as HTMLDivElement;
        let frequencyField : HTMLDivElement | null = document.getElementById("frequencyField") as HTMLDivElement;
        let melodyField : HTMLDivElement | null = document.getElementById("melodyField") as HTMLDivElement;
        if (durationField) durationField.style.display = this.settings.action=="PULSE"?"":"none";
        if (melodyField) melodyField.style.display = this.settings.action=="TUNE"?"":"none";
        if (frequencyField) frequencyField.style.display = this.settings.action=="PULSE" ||  this.settings.action=="MOMENTARY" ?"":"none";


    }

    /*******************************
     * called when a Properties inpector field has changed
     *******************************/

    protected inspectorValueHasChanged(source: HTMLInputElement | HTMLSelectElement)
    {
        super.inspectorValueHasChanged(source);
        switch (source.id)
        {   case "deviceList":
                this.DisableUI(source.value=="") ;
                break;
            case "action" :
                this.settings.action = source.value;
                this.updateUI();
                this.saveSettings(this.settings);
                break;
            case "pulseduration" :
                this.settings.pulseduration = parseInt(source.value);
                this.saveSettings(this.settings);
                break;
            case "volume" :
                this.settings.volume = parseInt(source.value);
                this.saveSettings(this.settings);
                break;
            case "melody" :
                this.settings.melody = source.value;
                this.saveSettings(this.settings);
                break;
            case "frequency" :
                this.settings.frequency = parseInt(source.value);
                this.saveSettings(this.settings);
                break;
        }
    }
}