# -*- coding: utf-8 -*-
# ********************************************************************
#
#  $Id: svn_id $
#
#  Implements yFindOrientation(), the high-level API for Orientation functions
#
#  - - - - - - - - - License information: - - - - - - - - -
#
#  Copyright (C) 2011 and beyond by Yoctopuce Sarl, Switzerland.
#
#  Yoctopuce Sarl (hereafter Licensor) grants to you a perpetual
#  non-exclusive license to use, modify, copy and integrate this
#  file into your software for the sole purpose of interfacing
#  with Yoctopuce products.
#
#  You may reproduce and distribute copies of this file in
#  source or object form, as long as the sole purpose of this
#  code is to interface with Yoctopuce products. You must retain
#  this notice in the distributed source file.
#
#  You should refer to Yoctopuce General Terms and Conditions
#  for additional information regarding your rights and
#  obligations.
#
#  THE SOFTWARE AND DOCUMENTATION ARE PROVIDED 'AS IS' WITHOUT
#  WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING
#  WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY, FITNESS
#  FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO
#  EVENT SHALL LICENSOR BE LIABLE FOR ANY INCIDENTAL, SPECIAL,
#  INDIRECT OR CONSEQUENTIAL DAMAGES, LOST PROFITS OR LOST DATA,
#  COST OF PROCUREMENT OF SUBSTITUTE GOODS, TECHNOLOGY OR
#  SERVICES, ANY CLAIMS BY THIRD PARTIES (INCLUDING BUT NOT
#  LIMITED TO ANY DEFENSE THEREOF), ANY CLAIMS FOR INDEMNITY OR
#  CONTRIBUTION, OR OTHER SIMILAR COSTS, WHETHER ASSERTED ON THE
#  BASIS OF CONTRACT, TORT (INCLUDING NEGLIGENCE), BREACH OF
#  WARRANTY, OR OTHERWISE.
#
# *********************************************************************


__docformat__ = 'restructuredtext en'
from yocto_api import *


#--- (YOrientation class start)
#noinspection PyProtectedMember
class YOrientation(YSensor):
    """
    The YOrientation class allows you to read and configure Yoctopuce orientation sensors.
    It inherits from YSensor class the core functions to read measurements,
    to register callback functions, and to access the autonomous datalogger.

    """
    #--- (end of YOrientation class start)
    #--- (YOrientation return codes)
    #--- (end of YOrientation return codes)
    #--- (YOrientation dlldef)
    #--- (end of YOrientation dlldef)
    #--- (YOrientation yapiwrapper)
    #--- (end of YOrientation yapiwrapper)
    #--- (YOrientation definitions)
    #--- (end of YOrientation definitions)

    def __init__(self, func):
        super(YOrientation, self).__init__(func)
        self._className = 'Orientation'
        #--- (YOrientation attributes)
        self._callback = None
        #--- (end of YOrientation attributes)

    #--- (YOrientation implementation)
    def _parseAttr(self, json_val):
        super(YOrientation, self)._parseAttr(json_val)

    @staticmethod
    def FindOrientation(func):
        """
        Retrieves an orientation sensor for a given identifier.
        The identifier can be specified using several formats:

        - FunctionLogicalName
        - ModuleSerialNumber.FunctionIdentifier
        - ModuleSerialNumber.FunctionLogicalName
        - ModuleLogicalName.FunctionIdentifier
        - ModuleLogicalName.FunctionLogicalName


        This function does not require that the orientation sensor is online at the time
        it is invoked. The returned object is nevertheless valid.
        Use the method YOrientation.isOnline() to test if the orientation sensor is
        indeed online at a given time. In case of ambiguity when looking for
        an orientation sensor by logical name, no error is notified: the first instance
        found is returned. The search is performed first by hardware name,
        then by logical name.

        If a call to this object's is_online() method returns FALSE although
        you are certain that the matching device is plugged, make sure that you did
        call registerHub() at application initialization time.

        @param func : a string that uniquely characterizes the orientation sensor, for instance
                MyDevice.orientation.

        @return a YOrientation object allowing you to drive the orientation sensor.
        """
        # obj
        obj = YFunction._FindFromCache("Orientation", func)
        if obj is None:
            obj = YOrientation(func)
            YFunction._AddToCache("Orientation", func, obj)
        return obj

    def nextOrientation(self):
        """
        Continues the enumeration of orientation sensors started using yFirstOrientation().
        Caution: You can't make any assumption about the returned orientation sensors order.
        If you want to find a specific an orientation sensor, use Orientation.findOrientation()
        and a hardwareID or a logical name.

        @return a pointer to a YOrientation object, corresponding to
                an orientation sensor currently online, or a None pointer
                if there are no more orientation sensors to enumerate.
        """
        hwidRef = YRefParam()
        if YAPI.YISERR(self._nextFunction(hwidRef)):
            return None
        if hwidRef.value == "":
            return None
        return YOrientation.FindOrientation(hwidRef.value)

#--- (end of YOrientation implementation)

#--- (YOrientation functions)

    @staticmethod
    def FirstOrientation():
        """
        Starts the enumeration of orientation sensors currently accessible.
        Use the method YOrientation.nextOrientation() to iterate on
        next orientation sensors.

        @return a pointer to a YOrientation object, corresponding to
                the first orientation sensor currently online, or a None pointer
                if there are none.
        """
        devRef = YRefParam()
        neededsizeRef = YRefParam()
        serialRef = YRefParam()
        funcIdRef = YRefParam()
        funcNameRef = YRefParam()
        funcValRef = YRefParam()
        errmsgRef = YRefParam()
        size = YAPI.C_INTSIZE
        #noinspection PyTypeChecker,PyCallingNonCallable
        p = (ctypes.c_int * 1)()
        err = YAPI.apiGetFunctionsByClass("Orientation", 0, p, size, neededsizeRef, errmsgRef)

        if YAPI.YISERR(err) or not neededsizeRef.value:
            return None

        if YAPI.YISERR(
                YAPI.yapiGetFunctionInfo(p[0], devRef, serialRef, funcIdRef, funcNameRef, funcValRef, errmsgRef)):
            return None

        return YOrientation.FindOrientation(serialRef.value + "." + funcIdRef.value)

#--- (end of YOrientation functions)
