/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDataSet;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YSensor;
import java.util.ArrayList;

public class YConsolidatedDataSet {
    protected double _start = 0.0;
    protected double _end = 0.0;
    protected int _nsensors = 0;
    protected ArrayList<YSensor> _sensors = new ArrayList();
    protected ArrayList<YDataSet> _datasets = new ArrayList();
    protected ArrayList<Integer> _progresss = new ArrayList();
    protected ArrayList<Integer> _nextidx = new ArrayList();
    protected ArrayList<Double> _nexttim = new ArrayList();

    public YConsolidatedDataSet(double startTime, double endTime, ArrayList<YSensor> sensorList) {
        this.imm_init(startTime, endTime, sensorList);
    }

    public int imm_init(double startt, double endt, ArrayList<YSensor> sensorList) {
        this._start = startt;
        this._end = endt;
        this._sensors = sensorList;
        this._nsensors = -1;
        return 0;
    }

    public static YConsolidatedDataSet Init(ArrayList<String> sensorNames, double startTime, double endTime) throws YAPI_Exception {
        ArrayList<YSensor> sensorList = new ArrayList<YSensor>();
        int nSensors = sensorNames.size();
        sensorList.clear();
        for (int idx = 0; idx < nSensors; ++idx) {
            String sensorName = sensorNames.get(idx);
            YSensor s = YSensor.FindSensor(sensorName);
            sensorList.add(s);
        }
        YConsolidatedDataSet obj = new YConsolidatedDataSet(startTime, endTime, sensorList);
        return obj;
    }

    public int nextRecord(ArrayList<Double> datarec) throws YAPI_Exception {
        int currprogress;
        int idx;
        int s;
        ArrayList<Object> measures = new ArrayList();
        if (this._nsensors == -1) {
            this._nsensors = this._sensors.size();
            this._datasets.clear();
            this._progresss.clear();
            this._nextidx.clear();
            this._nexttim.clear();
            for (s = 0; s < this._nsensors; ++s) {
                YSensor sensor = this._sensors.get(s);
                YDataSet newdataset = sensor.get_recordedData(this._start, this._end);
                this._datasets.add(newdataset);
                this._progresss.add(0);
                this._nextidx.add(0);
                this._nexttim.add(0.0);
            }
        }
        datarec.clear();
        double nexttime = 0.0;
        for (s = 0; s < this._nsensors; ++s) {
            double currnexttim = this._nexttim.get(s);
            if (currnexttim == 0.0) {
                idx = this._nextidx.get(s);
                measures = this._datasets.get(s).get_measures();
                currprogress = this._progresss.get(s);
                while (idx >= measures.size() && currprogress < 100) {
                    currprogress = this._datasets.get(s).loadMore();
                    if (currprogress < 0) {
                        currprogress = 100;
                    }
                    this._progresss.set(s, currprogress);
                    measures = this._datasets.get(s).get_measures();
                }
                if (idx < measures.size()) {
                    currnexttim = ((YMeasure)measures.get(idx)).get_endTimeUTC();
                    this._nexttim.set(s, currnexttim);
                }
            }
            if (!(currnexttim > 0.0) || nexttime != 0.0 && !(nexttime > currnexttim)) continue;
            nexttime = currnexttim;
        }
        if (nexttime == 0.0) {
            return 100;
        }
        datarec.clear();
        datarec.add(nexttime);
        int globprogress = 0;
        for (s = 0; s < this._nsensors; ++s) {
            if (this._nexttim.get(s) == nexttime) {
                idx = this._nextidx.get(s);
                measures = this._datasets.get(s).get_measures();
                double newvalue = ((YMeasure)measures.get(idx)).get_averageValue();
                datarec.add(newvalue);
                this._nexttim.set(s, 0.0);
                this._nextidx.set(s, idx + 1);
            } else {
                datarec.add(Double.NaN);
            }
            currprogress = this._progresss.get(s);
            globprogress += currprogress;
        }
        if (globprogress > 0 && (globprogress /= this._nsensors) > 99) {
            globprogress = 99;
        }
        return globprogress;
    }
}

