/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YSensor;
import java.util.ArrayList;
import java.util.Locale;

public class YWeighScale
extends YSensor {
    public static final int EXCITATION_OFF = 0;
    public static final int EXCITATION_DC = 1;
    public static final int EXCITATION_AC = 2;
    public static final int EXCITATION_INVALID = -1;
    public static final double TEMPAVGADAPTRATIO_INVALID = -1.79769313486231E308;
    public static final double TEMPCHGADAPTRATIO_INVALID = -1.79769313486231E308;
    public static final double COMPTEMPAVG_INVALID = -1.79769313486231E308;
    public static final double COMPTEMPCHG_INVALID = -1.79769313486231E308;
    public static final double COMPENSATION_INVALID = -1.79769313486231E308;
    public static final double ZEROTRACKING_INVALID = -1.79769313486231E308;
    public static final String COMMAND_INVALID = "!INVALID!";
    protected int _excitation = -1;
    protected double _tempAvgAdaptRatio = -1.79769313486231E308;
    protected double _tempChgAdaptRatio = -1.79769313486231E308;
    protected double _compTempAvg = -1.79769313486231E308;
    protected double _compTempChg = -1.79769313486231E308;
    protected double _compensation = -1.79769313486231E308;
    protected double _zeroTracking = -1.79769313486231E308;
    protected String _command = "!INVALID!";
    protected UpdateCallback _valueCallbackWeighScale = null;
    protected TimedReportCallback _timedReportCallbackWeighScale = null;

    protected YWeighScale(YAPIContext ctx, String func) {
        super(ctx, func);
        this._className = "WeighScale";
    }

    protected YWeighScale(String func) {
        this(YAPI.GetYCtx(true), func);
    }

    @Override
    protected void _parseAttr(YJSONObject json_val) throws Exception {
        if (json_val.has("excitation")) {
            this._excitation = json_val.getInt("excitation");
        }
        if (json_val.has("tempAvgAdaptRatio")) {
            this._tempAvgAdaptRatio = (double)Math.round(json_val.getDouble("tempAvgAdaptRatio") / 65.536) / 1000.0;
        }
        if (json_val.has("tempChgAdaptRatio")) {
            this._tempChgAdaptRatio = (double)Math.round(json_val.getDouble("tempChgAdaptRatio") / 65.536) / 1000.0;
        }
        if (json_val.has("compTempAvg")) {
            this._compTempAvg = (double)Math.round(json_val.getDouble("compTempAvg") / 65.536) / 1000.0;
        }
        if (json_val.has("compTempChg")) {
            this._compTempChg = (double)Math.round(json_val.getDouble("compTempChg") / 65.536) / 1000.0;
        }
        if (json_val.has("compensation")) {
            this._compensation = (double)Math.round(json_val.getDouble("compensation") / 65.536) / 1000.0;
        }
        if (json_val.has("zeroTracking")) {
            this._zeroTracking = (double)Math.round(json_val.getDouble("zeroTracking") / 65.536) / 1000.0;
        }
        if (json_val.has("command")) {
            this._command = json_val.getString("command");
        }
        super._parseAttr(json_val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_unit(String newval) throws YAPI_Exception {
        YWeighScale yWeighScale = this;
        synchronized (yWeighScale) {
            String rest_val = newval;
            this._setAttr("unit", rest_val);
        }
        return 0;
    }

    public int setUnit(String newval) throws YAPI_Exception {
        return this.set_unit(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_excitation() throws YAPI_Exception {
        int res;
        YWeighScale yWeighScale = this;
        synchronized (yWeighScale) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._excitation;
        }
        return res;
    }

    public int getExcitation() throws YAPI_Exception {
        return this.get_excitation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_excitation(int newval) throws YAPI_Exception {
        YWeighScale yWeighScale = this;
        synchronized (yWeighScale) {
            String rest_val = Integer.toString(newval);
            this._setAttr("excitation", rest_val);
        }
        return 0;
    }

    public int setExcitation(int newval) throws YAPI_Exception {
        return this.set_excitation(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_tempAvgAdaptRatio(double newval) throws YAPI_Exception {
        YWeighScale yWeighScale = this;
        synchronized (yWeighScale) {
            String rest_val = Long.toString(Math.round(newval * 65536.0));
            this._setAttr("tempAvgAdaptRatio", rest_val);
        }
        return 0;
    }

    public int setTempAvgAdaptRatio(double newval) throws YAPI_Exception {
        return this.set_tempAvgAdaptRatio(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_tempAvgAdaptRatio() throws YAPI_Exception {
        double res;
        YWeighScale yWeighScale = this;
        synchronized (yWeighScale) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = this._tempAvgAdaptRatio;
        }
        return res;
    }

    public double getTempAvgAdaptRatio() throws YAPI_Exception {
        return this.get_tempAvgAdaptRatio();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_tempChgAdaptRatio(double newval) throws YAPI_Exception {
        YWeighScale yWeighScale = this;
        synchronized (yWeighScale) {
            String rest_val = Long.toString(Math.round(newval * 65536.0));
            this._setAttr("tempChgAdaptRatio", rest_val);
        }
        return 0;
    }

    public int setTempChgAdaptRatio(double newval) throws YAPI_Exception {
        return this.set_tempChgAdaptRatio(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_tempChgAdaptRatio() throws YAPI_Exception {
        double res;
        YWeighScale yWeighScale = this;
        synchronized (yWeighScale) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = this._tempChgAdaptRatio;
        }
        return res;
    }

    public double getTempChgAdaptRatio() throws YAPI_Exception {
        return this.get_tempChgAdaptRatio();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_compTempAvg() throws YAPI_Exception {
        double res;
        YWeighScale yWeighScale = this;
        synchronized (yWeighScale) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = this._compTempAvg;
        }
        return res;
    }

    public double getCompTempAvg() throws YAPI_Exception {
        return this.get_compTempAvg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_compTempChg() throws YAPI_Exception {
        double res;
        YWeighScale yWeighScale = this;
        synchronized (yWeighScale) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = this._compTempChg;
        }
        return res;
    }

    public double getCompTempChg() throws YAPI_Exception {
        return this.get_compTempChg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_compensation() throws YAPI_Exception {
        double res;
        YWeighScale yWeighScale = this;
        synchronized (yWeighScale) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = this._compensation;
        }
        return res;
    }

    public double getCompensation() throws YAPI_Exception {
        return this.get_compensation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_zeroTracking(double newval) throws YAPI_Exception {
        YWeighScale yWeighScale = this;
        synchronized (yWeighScale) {
            String rest_val = Long.toString(Math.round(newval * 65536.0));
            this._setAttr("zeroTracking", rest_val);
        }
        return 0;
    }

    public int setZeroTracking(double newval) throws YAPI_Exception {
        return this.set_zeroTracking(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_zeroTracking() throws YAPI_Exception {
        double res;
        YWeighScale yWeighScale = this;
        synchronized (yWeighScale) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = this._zeroTracking;
        }
        return res;
    }

    public double getZeroTracking() throws YAPI_Exception {
        return this.get_zeroTracking();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_command() throws YAPI_Exception {
        String res;
        YWeighScale yWeighScale = this;
        synchronized (yWeighScale) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return COMMAND_INVALID;
            }
            res = this._command;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_command(String newval) throws YAPI_Exception {
        YWeighScale yWeighScale = this;
        synchronized (yWeighScale) {
            String rest_val = newval;
            this._setAttr("command", rest_val);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YWeighScale FindWeighScale(String func) {
        YWeighScale obj;
        YAPIContext ctx = YAPI.GetYCtx(true);
        Object object = ctx._functionCacheLock;
        synchronized (object) {
            obj = (YWeighScale)YFunction._FindFromCache("WeighScale", func);
            if (obj == null) {
                obj = new YWeighScale(func);
                YFunction._AddToCache("WeighScale", func, obj);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YWeighScale FindWeighScaleInContext(YAPIContext yctx, String func) {
        YWeighScale obj;
        Object object = yctx._functionCacheLock;
        synchronized (object) {
            obj = (YWeighScale)YFunction._FindFromCacheInContext(yctx, "WeighScale", func);
            if (obj == null) {
                obj = new YWeighScale(yctx, func);
                YFunction._AddToCache("WeighScale", func, obj);
            }
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackWeighScale = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackWeighScale != null) {
            this._valueCallbackWeighScale.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int registerTimedReportCallback(TimedReportCallback callback) {
        YWeighScale sensor = this;
        if (callback != null) {
            YFunction._UpdateTimedReportCallbackList(sensor, true);
        } else {
            YFunction._UpdateTimedReportCallbackList(sensor, false);
        }
        this._timedReportCallbackWeighScale = callback;
        return 0;
    }

    @Override
    public int _invokeTimedReportCallback(YMeasure value) {
        if (this._timedReportCallbackWeighScale != null) {
            this._timedReportCallbackWeighScale.timedReportCallback(this, value);
        } else {
            super._invokeTimedReportCallback(value);
        }
        return 0;
    }

    public int tare() throws YAPI_Exception {
        return this.set_command("T");
    }

    public int setupSpan(double currWeight, double maxWeight) throws YAPI_Exception {
        return this.set_command(String.format(Locale.US, "S%d:%d", (int)Math.round(1000.0 * currWeight), (int)Math.round(1000.0 * maxWeight)));
    }

    public int setCompensationTable(int tableIndex, ArrayList<Double> tempValues, ArrayList<Double> compValues) throws YAPI_Exception {
        int siz = tempValues.size();
        if (siz == 1) {
            throw new YAPI_Exception(-2, "thermal compensation table must have at least two points");
        }
        if (siz != compValues.size()) {
            throw new YAPI_Exception(-2, "table sizes mismatch");
        }
        int res = this.set_command(String.format(Locale.US, "%dZ", tableIndex));
        if (res != 0) {
            throw new YAPI_Exception(-8, "unable to reset thermal compensation table");
        }
        int found = 1;
        double prev = -999999.0;
        while (found > 0) {
            found = 0;
            double curr = 9.9999999E7;
            double currComp = -999999.0;
            for (int idx = 0; idx < siz; ++idx) {
                double idxTemp = tempValues.get(idx);
                if (!(idxTemp > prev) || !(idxTemp < curr)) continue;
                curr = idxTemp;
                currComp = compValues.get(idx);
                found = 1;
            }
            if (found <= 0) continue;
            res = this.set_command(String.format(Locale.US, "%dm%d:%d", tableIndex, (int)Math.round(1000.0 * curr), (int)Math.round(1000.0 * currComp)));
            if (res != 0) {
                throw new YAPI_Exception(-8, "unable to set thermal compensation table");
            }
            prev = curr;
        }
        return 0;
    }

    public int loadCompensationTable(int tableIndex, ArrayList<Double> tempValues, ArrayList<Double> compValues) throws YAPI_Exception {
        ArrayList<Object> paramlist = new ArrayList();
        String id = this.get_functionId();
        id = id.substring(10, 10 + id.length() - 10);
        byte[] bin_json = this._download(String.format(Locale.US, "extra.json?page=%d", 4 * YAPIContext._atoi(id) + tableIndex));
        paramlist = this._json_get_array(bin_json);
        int siz = paramlist.size() >> 1;
        tempValues.clear();
        compValues.clear();
        for (int idx = 0; idx < siz; ++idx) {
            double temp = YAPI.ystr2float(new String((byte[])paramlist.get(2 * idx), this._yapi._deviceCharset)) / 1000.0;
            double comp = YAPI.ystr2float(new String((byte[])paramlist.get(2 * idx + 1), this._yapi._deviceCharset)) / 1000.0;
            tempValues.add(temp);
            compValues.add(comp);
        }
        return 0;
    }

    public int set_offsetAvgCompensationTable(ArrayList<Double> tempValues, ArrayList<Double> compValues) throws YAPI_Exception {
        return this.setCompensationTable(0, tempValues, compValues);
    }

    public int loadOffsetAvgCompensationTable(ArrayList<Double> tempValues, ArrayList<Double> compValues) throws YAPI_Exception {
        return this.loadCompensationTable(0, tempValues, compValues);
    }

    public int set_offsetChgCompensationTable(ArrayList<Double> tempValues, ArrayList<Double> compValues) throws YAPI_Exception {
        return this.setCompensationTable(1, tempValues, compValues);
    }

    public int loadOffsetChgCompensationTable(ArrayList<Double> tempValues, ArrayList<Double> compValues) throws YAPI_Exception {
        return this.loadCompensationTable(1, tempValues, compValues);
    }

    public int set_spanAvgCompensationTable(ArrayList<Double> tempValues, ArrayList<Double> compValues) throws YAPI_Exception {
        return this.setCompensationTable(2, tempValues, compValues);
    }

    public int loadSpanAvgCompensationTable(ArrayList<Double> tempValues, ArrayList<Double> compValues) throws YAPI_Exception {
        return this.loadCompensationTable(2, tempValues, compValues);
    }

    public int set_spanChgCompensationTable(ArrayList<Double> tempValues, ArrayList<Double> compValues) throws YAPI_Exception {
        return this.setCompensationTable(3, tempValues, compValues);
    }

    public int loadSpanChgCompensationTable(ArrayList<Double> tempValues, ArrayList<Double> compValues) throws YAPI_Exception {
        return this.loadCompensationTable(3, tempValues, compValues);
    }

    public YWeighScale nextWeighScale() {
        String next_hwid;
        try {
            String hwid = this._yapi._yHash.resolveHwID(this._className, this._func);
            next_hwid = this._yapi._yHash.getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YWeighScale.FindWeighScaleInContext(this._yapi, next_hwid);
    }

    public static YWeighScale FirstWeighScale() {
        YAPIContext yctx = YAPI.GetYCtx(false);
        if (yctx == null) {
            return null;
        }
        String next_hwid = yctx._yHash.getFirstHardwareId("WeighScale");
        if (next_hwid == null) {
            return null;
        }
        return YWeighScale.FindWeighScaleInContext(yctx, next_hwid);
    }

    public static YWeighScale FirstWeighScaleInContext(YAPIContext yctx) {
        String next_hwid = yctx._yHash.getFirstHardwareId("WeighScale");
        if (next_hwid == null) {
            return null;
        }
        return YWeighScale.FindWeighScaleInContext(yctx, next_hwid);
    }

    public static interface UpdateCallback {
        public void yNewValue(YWeighScale var1, String var2);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YWeighScale var1, YMeasure var2);
    }
}

