/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import java.io.ByteArrayInputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

class YTrustManager
implements X509TrustManager {
    private final ArrayList<X509TrustManager> _defaultTM;
    private X509TrustManager _yoctoTM;
    private final int _flags;
    private static final Pattern CERT_PATTERN = Pattern.compile("-+BEGIN\\s+.*CERTIFICATE[^-]*-+(?:\\s|\\r|\\n)+([a-z0-9+/=\\r\\n]+)-+END\\s+.*CERTIFICATE[^-]*-+", 2);

    YTrustManager(KeyStore keyStore, int flags) throws Exception {
        TrustManagerFactory tmf = null;
        tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init((KeyStore)null);
        this._defaultTM = new ArrayList();
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            this._defaultTM.add((X509TrustManager)tm);
        }
        this._yoctoTM = keyStore.size() > 0 ? this.trustManagerFor(keyStore) : null;
        this._flags = flags;
    }

    private X509TrustManager trustManagerFor(KeyStore keyStore) throws YAPI_Exception {
        TrustManagerFactory tmf = null;
        try {
            tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new YAPI_Exception(-15, e.getLocalizedMessage(), e);
        }
        try {
            tmf.init(keyStore);
        }
        catch (KeyStoreException e) {
            throw new YAPI_Exception(-15, e.getLocalizedMessage(), e);
        }
        TrustManager[] trustManagers = tmf.getTrustManagers();
        if (trustManagers.length != 1) {
            throw new YAPI_Exception(-15, "Unexpected number of trust managers");
        }
        TrustManager trustManager = trustManagers[0];
        if (trustManager instanceof X509TrustManager) {
            return (X509TrustManager)trustManager;
        }
        throw new YAPI_Exception(-15, "not a X509TrustManager");
    }

    static ArrayList<X509Certificate> parsePemCert(String pem_str) throws CertificateException {
        Matcher matcher = CERT_PATTERN.matcher(pem_str);
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        int start = 0;
        while (matcher.find(start)) {
            byte[] buffer = YAPI.Base64Decode(matcher.group(1));
            certificates.add((X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(buffer)));
            start = matcher.end();
        }
        return certificates;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        block6: {
            for (X509TrustManager tm : this._defaultTM) {
                try {
                    tm.checkClientTrusted(chain, authType);
                    return;
                }
                catch (CertificateException certificateException) {
                }
            }
            try {
                if (this._yoctoTM == null) {
                    throw new CertificateException("None of the TrustManagers trust this certificate chain");
                }
                this._yoctoTM.checkClientTrusted(chain, authType);
            }
            catch (CertificateException ex) {
                if ((this._flags & 1) != 0) break block6;
                throw ex;
            }
        }
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        block6: {
            for (X509TrustManager tm : this._defaultTM) {
                try {
                    tm.checkServerTrusted(chain, authType);
                    return;
                }
                catch (CertificateException certificateException) {
                }
            }
            try {
                if (this._yoctoTM == null) {
                    throw new CertificateException("None of the TrustManagers trust this certificate chain");
                }
                this._yoctoTM.checkServerTrusted(chain, authType);
            }
            catch (CertificateException ex) {
                if ((this._flags & 1) != 0) break block6;
                throw ex;
            }
        }
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        ArrayList<X509Certificate> allCerts = new ArrayList<X509Certificate>(this._defaultTM.size() + 1);
        for (X509TrustManager tm : this._defaultTM) {
            allCerts.addAll(Arrays.asList(tm.getAcceptedIssuers()));
        }
        if (this._yoctoTM != null) {
            allCerts.addAll(Arrays.asList(this._yoctoTM.getAcceptedIssuers()));
        }
        X509Certificate[] res = new X509Certificate[allCerts.size()];
        res = allCerts.toArray(res);
        return res;
    }
}

