/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YCalibCtx;
import com.yoctopuce.YoctoAPI.YDataLogger;
import com.yoctopuce.YoctoAPI.YDataSet;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YModule;
import java.util.ArrayList;
import java.util.Locale;

public class YSensor
extends YFunction {
    protected YCalibCtx _cal = null;
    public static final String UNIT_INVALID = "!INVALID!";
    public static final double CURRENTVALUE_INVALID = -1.79769313486231E308;
    public static final double LOWESTVALUE_INVALID = -1.79769313486231E308;
    public static final double HIGHESTVALUE_INVALID = -1.79769313486231E308;
    public static final double CURRENTRAWVALUE_INVALID = -1.79769313486231E308;
    public static final String LOGFREQUENCY_INVALID = "!INVALID!";
    public static final String REPORTFREQUENCY_INVALID = "!INVALID!";
    public static final int ADVMODE_IMMEDIATE = 0;
    public static final int ADVMODE_PERIOD_AVG = 1;
    public static final int ADVMODE_PERIOD_MIN = 2;
    public static final int ADVMODE_PERIOD_MAX = 3;
    public static final int ADVMODE_INVALID = -1;
    public static final String CALIBRATIONPARAM_INVALID = "!INVALID!";
    public static final double RESOLUTION_INVALID = -1.79769313486231E308;
    public static final int SENSORSTATE_INVALID = Integer.MIN_VALUE;
    protected String _unit = "!INVALID!";
    protected double _currentValue = -1.79769313486231E308;
    protected double _lowestValue = -1.79769313486231E308;
    protected double _highestValue = -1.79769313486231E308;
    protected double _currentRawValue = -1.79769313486231E308;
    protected String _logFrequency = "!INVALID!";
    protected String _reportFrequency = "!INVALID!";
    protected int _advMode = -1;
    protected String _calibrationParam = "!INVALID!";
    protected double _resolution = -1.79769313486231E308;
    protected int _sensorState = Integer.MIN_VALUE;
    protected UpdateCallback _valueCallbackSensor = null;
    protected TimedReportCallback _timedReportCallbackSensor = null;
    protected double _prevTR = 0.0;
    protected double _iresol = 0.0;

    String _encodeCalibrationPoints(ArrayList<Double> rawValues, ArrayList<Double> refValues, String actualCparams) throws YAPI_Exception {
        int npt = rawValues.size() < refValues.size() ? rawValues.size() : refValues.size();
        int minRaw = 0;
        if (npt == 0) {
            return "0";
        }
        int pos = actualCparams.indexOf(44);
        if (actualCparams.equals("") || actualCparams.equals("0") || pos >= 0) {
            this._throw(-3, "Device does not support new calibration parameters. Please upgrade your firmware");
            return "0";
        }
        ArrayList<Integer> iCalib = YAPIContext._decodeWords(actualCparams);
        int calibrationOffset = iCalib.get(0);
        int divisor = iCalib.get(1);
        int calibType = divisor > 0 ? npt : 10 + npt;
        Object res = Integer.toString(calibType);
        if (calibType <= 10) {
            for (int i = 0; i < npt; ++i) {
                int refVal;
                int rawVal = (int)(rawValues.get(i) * (double)divisor - (double)calibrationOffset + 0.5);
                if (rawVal < minRaw || rawVal >= 65536 || (refVal = (int)(refValues.get(i) * (double)divisor - (double)calibrationOffset + 0.5)) < 0 || refVal >= 65536) continue;
                res = (String)res + String.format(Locale.US, ",%d,%d", rawVal, refVal);
                minRaw = rawVal + 1;
            }
        } else {
            for (int i = 0; i < npt; ++i) {
                int rawVal = (int)YAPIContext._doubleToDecimal(rawValues.get(i));
                int refVal = (int)YAPIContext._doubleToDecimal(refValues.get(i));
                res = (String)res + String.format(Locale.US, ",%d,%d", rawVal, refVal);
            }
        }
        return res;
    }

    static int _decodeCalibrationPoints(String calibParams, ArrayList<Integer> intPt, ArrayList<Double> rawPt, ArrayList<Double> calPt) {
        int calibType;
        intPt.clear();
        rawPt.clear();
        calPt.clear();
        if (calibParams.equals("") || calibParams.equals("0")) {
            return 0;
        }
        if (calibParams.indexOf(44) != -1) {
            return -1;
        }
        ArrayList<Integer> iCalib = YAPIContext._decodeWords(calibParams);
        if (iCalib.size() < 2) {
            return -1;
        }
        if (iCalib.size() == 2) {
            return 0;
        }
        int pos = 0;
        double calibrationOffset = iCalib.get(pos++).intValue();
        double divisor = iCalib.get(pos++).intValue();
        if ((calibType = iCalib.get(pos++).intValue()) == 0) {
            return 0;
        }
        while (pos < iCalib.size()) {
            int ival = iCalib.get(pos++);
            double fval = calibType <= 10 ? ((double)ival + calibrationOffset) / divisor : YAPIContext._decimalToDouble(ival);
            intPt.add(ival);
            if ((intPt.size() & 1) == 1) {
                rawPt.add(fval);
                continue;
            }
            calPt.add(fval);
        }
        if (intPt.size() < 10) {
            return -1;
        }
        return calibType;
    }

    protected YSensor(YAPIContext yctx, String func) {
        super(yctx, func);
        this._className = "Sensor";
    }

    protected YSensor(String func) {
        this(YAPI.GetYCtx(false), func);
    }

    @Override
    protected void _parseAttr(YJSONObject json_val) throws Exception {
        if (json_val.has("unit")) {
            this._unit = json_val.getString("unit");
        }
        if (json_val.has("currentValue")) {
            this._currentValue = (double)Math.round(json_val.getDouble("currentValue") / 65.536) / 1000.0;
        }
        if (json_val.has("lowestValue")) {
            this._lowestValue = (double)Math.round(json_val.getDouble("lowestValue") / 65.536) / 1000.0;
        }
        if (json_val.has("highestValue")) {
            this._highestValue = (double)Math.round(json_val.getDouble("highestValue") / 65.536) / 1000.0;
        }
        if (json_val.has("currentRawValue")) {
            this._currentRawValue = (double)Math.round(json_val.getDouble("currentRawValue") / 65.536) / 1000.0;
        }
        if (json_val.has("logFrequency")) {
            this._logFrequency = json_val.getString("logFrequency");
        }
        if (json_val.has("reportFrequency")) {
            this._reportFrequency = json_val.getString("reportFrequency");
        }
        if (json_val.has("advMode")) {
            this._advMode = json_val.getInt("advMode");
        }
        if (json_val.has("calibrationParam")) {
            this._calibrationParam = json_val.getString("calibrationParam");
        }
        if (json_val.has("resolution")) {
            this._resolution = (double)Math.round(json_val.getDouble("resolution") / 65.536) / 1000.0;
        }
        if (json_val.has("sensorState")) {
            this._sensorState = json_val.getInt("sensorState");
        }
        super._parseAttr(json_val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_unit() throws YAPI_Exception {
        String res;
        YSensor ySensor = this;
        synchronized (ySensor) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._unit;
        }
        return res;
    }

    public String getUnit() throws YAPI_Exception {
        return this.get_unit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_currentValue() throws YAPI_Exception {
        double res;
        YSensor ySensor = this;
        synchronized (ySensor) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = this._cal == null ? this._currentValue : this._applyCalibration(this._currentRawValue);
            if (res == -1.79769313486231E308) {
                return res;
            }
            res = (double)Math.round(res * this._iresol) / this._iresol;
        }
        return res;
    }

    public double getCurrentValue() throws YAPI_Exception {
        return this.get_currentValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_lowestValue(double newval) throws YAPI_Exception {
        YSensor ySensor = this;
        synchronized (ySensor) {
            String rest_val = Long.toString(Math.round(newval * 65536.0));
            this._setAttr("lowestValue", rest_val);
        }
        return 0;
    }

    public int setLowestValue(double newval) throws YAPI_Exception {
        return this.set_lowestValue(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_lowestValue() throws YAPI_Exception {
        double res;
        YSensor ySensor = this;
        synchronized (ySensor) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = (double)Math.round(this._lowestValue * this._iresol) / this._iresol;
        }
        return res;
    }

    public double getLowestValue() throws YAPI_Exception {
        return this.get_lowestValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_highestValue(double newval) throws YAPI_Exception {
        YSensor ySensor = this;
        synchronized (ySensor) {
            String rest_val = Long.toString(Math.round(newval * 65536.0));
            this._setAttr("highestValue", rest_val);
        }
        return 0;
    }

    public int setHighestValue(double newval) throws YAPI_Exception {
        return this.set_highestValue(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_highestValue() throws YAPI_Exception {
        double res;
        YSensor ySensor = this;
        synchronized (ySensor) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = (double)Math.round(this._highestValue * this._iresol) / this._iresol;
        }
        return res;
    }

    public double getHighestValue() throws YAPI_Exception {
        return this.get_highestValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_currentRawValue() throws YAPI_Exception {
        double res;
        YSensor ySensor = this;
        synchronized (ySensor) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = this._currentRawValue;
        }
        return res;
    }

    public double getCurrentRawValue() throws YAPI_Exception {
        return this.get_currentRawValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_logFrequency() throws YAPI_Exception {
        String res;
        YSensor ySensor = this;
        synchronized (ySensor) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._logFrequency;
        }
        return res;
    }

    public String getLogFrequency() throws YAPI_Exception {
        return this.get_logFrequency();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_logFrequency(String newval) throws YAPI_Exception {
        YSensor ySensor = this;
        synchronized (ySensor) {
            String rest_val = newval;
            this._setAttr("logFrequency", rest_val);
        }
        return 0;
    }

    public int setLogFrequency(String newval) throws YAPI_Exception {
        return this.set_logFrequency(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_reportFrequency() throws YAPI_Exception {
        String res;
        YSensor ySensor = this;
        synchronized (ySensor) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._reportFrequency;
        }
        return res;
    }

    public String getReportFrequency() throws YAPI_Exception {
        return this.get_reportFrequency();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_reportFrequency(String newval) throws YAPI_Exception {
        YSensor ySensor = this;
        synchronized (ySensor) {
            String rest_val = newval;
            this._setAttr("reportFrequency", rest_val);
        }
        return 0;
    }

    public int setReportFrequency(String newval) throws YAPI_Exception {
        return this.set_reportFrequency(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_advMode() throws YAPI_Exception {
        int res;
        YSensor ySensor = this;
        synchronized (ySensor) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._advMode;
        }
        return res;
    }

    public int getAdvMode() throws YAPI_Exception {
        return this.get_advMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_advMode(int newval) throws YAPI_Exception {
        YSensor ySensor = this;
        synchronized (ySensor) {
            String rest_val = Integer.toString(newval);
            this._setAttr("advMode", rest_val);
        }
        return 0;
    }

    public int setAdvMode(int newval) throws YAPI_Exception {
        return this.set_advMode(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_calibrationParam() throws YAPI_Exception {
        String res;
        YSensor ySensor = this;
        synchronized (ySensor) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._calibrationParam;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_calibrationParam(String newval) throws YAPI_Exception {
        YSensor ySensor = this;
        synchronized (ySensor) {
            String rest_val = newval;
            this._setAttr("calibrationParam", rest_val);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_resolution(double newval) throws YAPI_Exception {
        YSensor ySensor = this;
        synchronized (ySensor) {
            String rest_val = Long.toString(Math.round(newval * 65536.0));
            this._setAttr("resolution", rest_val);
        }
        return 0;
    }

    public int setResolution(double newval) throws YAPI_Exception {
        return this.set_resolution(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_resolution() throws YAPI_Exception {
        double res;
        YSensor ySensor = this;
        synchronized (ySensor) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = this._resolution;
        }
        return res;
    }

    public double getResolution() throws YAPI_Exception {
        return this.get_resolution();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_sensorState() throws YAPI_Exception {
        int res;
        YSensor ySensor = this;
        synchronized (ySensor) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return Integer.MIN_VALUE;
            }
            res = this._sensorState;
        }
        return res;
    }

    public int getSensorState() throws YAPI_Exception {
        return this.get_sensorState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YSensor FindSensor(String func) {
        YSensor obj;
        YAPIContext ctx = YAPI.GetYCtx(true);
        Object object = ctx._functionCacheLock;
        synchronized (object) {
            obj = (YSensor)YFunction._FindFromCache("Sensor", func);
            if (obj == null) {
                obj = new YSensor(func);
                YFunction._AddToCache("Sensor", func, obj);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YSensor FindSensorInContext(YAPIContext yctx, String func) {
        YSensor obj;
        Object object = yctx._functionCacheLock;
        synchronized (object) {
            obj = (YSensor)YFunction._FindFromCacheInContext(yctx, "Sensor", func);
            if (obj == null) {
                obj = new YSensor(yctx, func);
                YFunction._AddToCache("Sensor", func, obj);
            }
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackSensor = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackSensor != null) {
            this._valueCallbackSensor.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    @Override
    public int _parserHelper() {
        this._iresol = this._resolution > 0.0 ? (double)Math.round(1.0 / this._resolution) : 10000.0;
        String calibStr = this._calibrationParam;
        if (calibStr.equals("0,") || calibStr.equals("") || calibStr.equals("0")) {
            this._cal = null;
            return 0;
        }
        if (this._cal == null || !this._cal.src.equals(calibStr)) {
            this._parseCalibStr(calibStr);
        }
        return 0;
    }

    public boolean isSensorReady() {
        try {
            if (this.get_sensorState() != 0) {
                return false;
            }
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    public YDataLogger get_dataLogger() throws YAPI_Exception {
        YModule modu = this.get_module();
        String serial = modu.get_serialNumber();
        if (serial.equals("!INVALID!")) {
            return null;
        }
        String hwid = serial + ".dataLogger";
        YDataLogger logger = YDataLogger.FindDataLogger(hwid);
        return logger;
    }

    public int _parseCalibStr(String calibStr) {
        YAPI.CalibrationHandlerCallback calhdl;
        int caltyp;
        ArrayList<Integer> calpar = new ArrayList<Integer>();
        ArrayList<Double> calraw = new ArrayList<Double>();
        ArrayList<Double> calref = new ArrayList<Double>();
        if (calibStr.indexOf(",") >= 0) {
            int position;
            ArrayList<Integer> iCalib = YAPIContext._decodeFloats(calibStr);
            caltyp = iCalib.get(0) / 1000;
            if (caltyp < 30) {
                this._cal = null;
                return 0;
            }
            calhdl = this._yapi._getCalibrationHandler(caltyp);
            if (calhdl == null) {
                this._cal = null;
                return 0;
            }
            int maxpos = iCalib.size();
            calpar.clear();
            for (position = 1; position < maxpos; ++position) {
                calpar.add(iCalib.get(position));
            }
            calraw.clear();
            calref.clear();
            position = 1;
            while (position + 1 < maxpos) {
                double fRaw = iCalib.get(position).doubleValue();
                double fRef = iCalib.get(position + 1).doubleValue();
                calraw.add(fRaw /= 1000.0);
                calref.add(fRef /= 1000.0);
                position += 2;
            }
        } else {
            ArrayList<Integer> iCalib = YAPIContext._decodeWords(calibStr);
            if (iCalib.size() <= 2) {
                this._cal = null;
                return 0;
            }
            caltyp = iCalib.get(2);
            calhdl = this._yapi._getCalibrationHandler(caltyp);
            if (calhdl == null) {
                this._cal = null;
                return 0;
            }
            int maxpos = caltyp <= 10 ? caltyp : (caltyp <= 20 ? caltyp - 10 : 5);
            if ((maxpos = 3 + 2 * maxpos) > iCalib.size()) {
                maxpos = iCalib.size();
            }
            calpar.clear();
            calraw.clear();
            calref.clear();
            int position = 3;
            while (position + 1 < maxpos) {
                int iRaw = iCalib.get(position);
                int iRef = iCalib.get(position + 1);
                calpar.add(iRaw);
                calpar.add(iRef);
                calraw.add(YAPIContext._decimalToDouble(iRaw));
                calref.add(YAPIContext._decimalToDouble(iRef));
                position += 2;
            }
        }
        this._cal = new YCalibCtx(calibStr, calhdl, caltyp, calpar, calraw, calref);
        return 0;
    }

    public int startDataLogger() throws YAPI_Exception {
        byte[] res = this._download("api/dataLogger/recording?recording=1");
        if (res.length <= 0) {
            throw new YAPI_Exception(-8, "unable to start datalogger");
        }
        return 0;
    }

    public int stopDataLogger() throws YAPI_Exception {
        byte[] res = this._download("api/dataLogger/recording?recording=0");
        if (res.length <= 0) {
            throw new YAPI_Exception(-8, "unable to stop datalogger");
        }
        return 0;
    }

    public YDataSet get_recordedData(double startTime, double endTime) throws YAPI_Exception {
        String funcid = this.get_functionId();
        String funit = this.get_unit();
        return new YDataSet(this, funcid, funit, startTime, endTime);
    }

    public int registerTimedReportCallback(TimedReportCallback callback) {
        YSensor sensor = this;
        if (callback != null) {
            YFunction._UpdateTimedReportCallbackList(sensor, true);
        } else {
            YFunction._UpdateTimedReportCallbackList(sensor, false);
        }
        this._timedReportCallbackSensor = callback;
        return 0;
    }

    public int _invokeTimedReportCallback(YMeasure value) {
        if (this._timedReportCallbackSensor != null) {
            this._timedReportCallbackSensor.timedReportCallback(this, value);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int calibrateFromPoints(ArrayList<Double> rawValues, ArrayList<Double> refValues) throws YAPI_Exception {
        int res;
        YSensor ySensor = this;
        synchronized (ySensor) {
            String rest_val = this._encodeCalibrationPoints(rawValues, refValues);
            res = this._setAttr("calibrationParam", rest_val);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadCalibrationPoints(ArrayList<Double> rawValues, ArrayList<Double> refValues) throws YAPI_Exception {
        rawValues.clear();
        refValues.clear();
        YSensor ySensor = this;
        synchronized (ySensor) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -4;
            }
            if (this._cal == null) {
                return 0;
            }
            rawValues.clear();
            refValues.clear();
            for (double ii_0 : this._cal.raw) {
                rawValues.add(ii_0);
            }
            for (double ii_1 : this._cal.cal) {
                refValues.add(ii_1);
            }
        }
        return 0;
    }

    public String _encodeCalibrationPoints(ArrayList<Double> rawValues, ArrayList<Double> refValues) throws YAPI_Exception {
        int npt = rawValues.size();
        if (npt != refValues.size()) {
            this._throw(-2, "Invalid calibration parameters (size mismatch)");
            return "!INVALID!";
        }
        if (npt == 0) {
            return "0";
        }
        String res = String.format(Locale.US, "%d", 30);
        for (int idx = 0; idx < npt; ++idx) {
            res = String.format(Locale.US, "%s,%f,%f", res, (double)rawValues.get(idx), (double)refValues.get(idx));
        }
        return res;
    }

    public double _applyCalibration(double rawValue) {
        if (this._cal == null) {
            return rawValue;
        }
        if (rawValue == -1.79769313486231E308) {
            return -1.79769313486231E308;
        }
        return this._cal.hdl.yCalibrationHandler(rawValue, this._cal.typ, this._cal.par, this._cal.raw, this._cal.cal);
    }

    public YMeasure _decodeTimedReport(double timestamp, double duration, ArrayList<Integer> report) {
        double maxVal;
        double minVal;
        double avgVal;
        double endTime;
        double startTime = duration > 0.0 ? timestamp - duration : this._prevTR;
        this._prevTR = endTime = timestamp;
        if (startTime == 0.0) {
            startTime = endTime;
        }
        if (report.size() <= 5) {
            double poww = 1.0;
            double avgRaw = 0.0;
            int byteVal = 0;
            for (int i = 1; i < report.size(); ++i) {
                byteVal = report.get(i);
                avgRaw += poww * (double)byteVal;
                poww *= 256.0;
            }
            if ((byteVal & 0x80) != 0) {
                avgRaw -= poww;
            }
            avgVal = avgRaw / 1000.0;
            if (this._cal != null) {
                avgVal = this._cal.hdl.yCalibrationHandler(avgVal, this._cal.typ, this._cal.par, this._cal.raw, this._cal.cal);
            }
            minVal = avgVal;
            maxVal = avgVal;
        } else {
            int i;
            int sublen = 1 + (report.get(1) & 3);
            double poww = 1.0;
            double avgRaw = 0.0;
            int byteVal = 0;
            for (i = 2; sublen > 0 && i < report.size(); ++i, --sublen) {
                byteVal = report.get(i);
                avgRaw += poww * (double)byteVal;
                poww *= 256.0;
            }
            if ((byteVal & 0x80) != 0) {
                avgRaw -= poww;
            }
            poww = 1.0;
            double difRaw = 0.0;
            for (sublen = 1 + (report.get(1) >> 2 & 3); sublen > 0 && i < report.size(); ++i, --sublen) {
                byteVal = report.get(i);
                difRaw += poww * (double)byteVal;
                poww *= 256.0;
            }
            double minRaw = avgRaw - difRaw;
            poww = 1.0;
            difRaw = 0.0;
            for (sublen = 1 + (report.get(1) >> 4 & 3); sublen > 0 && i < report.size(); ++i, --sublen) {
                byteVal = report.get(i);
                difRaw += poww * (double)byteVal;
                poww *= 256.0;
            }
            double maxRaw = avgRaw + difRaw;
            avgVal = avgRaw / 1000.0;
            minVal = minRaw / 1000.0;
            maxVal = maxRaw / 1000.0;
            if (this._cal != null) {
                avgVal = this._cal.hdl.yCalibrationHandler(avgVal, this._cal.typ, this._cal.par, this._cal.raw, this._cal.cal);
                minVal = this._cal.hdl.yCalibrationHandler(minVal, this._cal.typ, this._cal.par, this._cal.raw, this._cal.cal);
                maxVal = this._cal.hdl.yCalibrationHandler(maxVal, this._cal.typ, this._cal.par, this._cal.raw, this._cal.cal);
            }
        }
        return new YMeasure(startTime, endTime, minVal, avgVal, maxVal);
    }

    public double _decodeVal(int w) {
        double val = w;
        if (this._cal != null) {
            val = this._cal.hdl.yCalibrationHandler(val, this._cal.typ, this._cal.par, this._cal.raw, this._cal.cal);
        }
        return val;
    }

    public double _decodeAvg(int dw) {
        double val = dw;
        if (this._cal != null) {
            val = this._cal.hdl.yCalibrationHandler(val, this._cal.typ, this._cal.par, this._cal.raw, this._cal.cal);
        }
        return val;
    }

    public YSensor nextSensor() {
        String next_hwid;
        try {
            String hwid = this._yapi._yHash.resolveHwID(this._className, this._func);
            next_hwid = this._yapi._yHash.getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YSensor.FindSensorInContext(this._yapi, next_hwid);
    }

    public static YSensor FirstSensor() {
        YAPIContext yctx = YAPI.GetYCtx(false);
        if (yctx == null) {
            return null;
        }
        String next_hwid = yctx._yHash.getFirstHardwareId("Sensor");
        if (next_hwid == null) {
            return null;
        }
        return YSensor.FindSensorInContext(yctx, next_hwid);
    }

    public static YSensor FirstSensorInContext(YAPIContext yctx) {
        String next_hwid = yctx._yHash.getFirstHardwareId("Sensor");
        if (next_hwid == null) {
            return null;
        }
        return YSensor.FindSensorInContext(yctx, next_hwid);
    }

    public static interface UpdateCallback {
        public void yNewValue(YSensor var1, String var2);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YSensor var1, YMeasure var2);
    }
}

