/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.WPEntry;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YFirmwareFile;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YModule;
import com.yoctopuce.YoctoAPI.YPEntry;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingDeque;

abstract class YGenericHub {
    static final int NOTIFY_V2_LEGACY = 0;
    static final int NOTIFY_V2_6RAWBYTES = 1;
    static final int NOTIFY_V2_TYPEDDATA = 2;
    static final int NOTIFY_V2_FLUSHGROUP = 3;
    static final int YSTREAM_EMPTY = 0;
    static final int YSTREAM_TCP = 1;
    static final int YSTREAM_TCP_CLOSE = 2;
    static final int YSTREAM_NOTICE = 3;
    static final int YSTREAM_REPORT = 4;
    static final int YSTREAM_META = 5;
    static final int YSTREAM_REPORT_V2 = 6;
    static final int YSTREAM_NOTICE_V2 = 7;
    static final int YSTREAM_TCP_NOTIF = 8;
    static final int YSTREAM_TCP_ASYNCCLOSE = 9;
    static final int USB_META_UTCTIME = 1;
    static final int USB_META_DLFLUSH = 2;
    static final int USB_META_ACK_D2H_PACKET = 3;
    static final int USB_META_WS_ANNOUNCE = 4;
    static final int USB_META_WS_AUTHENTICATION = 5;
    static final int USB_META_WS_ERROR = 6;
    static final int USB_META_ACK_UPLOAD = 7;
    static final int USB_META_UTCTIME_SIZE = 6;
    static final int USB_META_DLFLUSH_SIZE = 1;
    static final int USB_META_ACK_D2H_PACKET_SIZE = 2;
    static final int USB_META_WS_ANNOUNCE_SIZE = 28;
    static final int USB_META_WS_AUTHENTICATION_SIZE = 28;
    static final int USB_META_WS_ERROR_SIZE = 6;
    static final int USB_META_ACK_UPLOAD_SIZE = 6;
    static final int USB_META_WS_PROTO_V1 = 1;
    static final int USB_META_WS_PROTO_V2 = 2;
    static final int VERSION_SUPPORT_ASYNC_CLOSE = 1;
    static final int USB_META_WS_VALID_SHA1 = 1;
    static final int USB_META_WS_AUTH_FLAGS_RW = 2;
    private static final int PUBVAL_LEGACY = 0;
    private static final int PUBVAL_1RAWBYTE = 1;
    private static final int PUBVAL_2RAWBYTES = 2;
    private static final int PUBVAL_3RAWBYTES = 3;
    private static final int PUBVAL_4RAWBYTES = 4;
    private static final int PUBVAL_5RAWBYTES = 5;
    private static final int PUBVAL_6RAWBYTES = 6;
    private static final int PUBVAL_C_LONG = 7;
    private static final int PUBVAL_C_FLOAT = 8;
    private static final int PUBVAL_YOCTO_FLOAT_E3 = 9;
    private static final int PUBVAL_YOCTO_FLOAT_E6 = 10;
    static final long YPROG_BOOTLOADER_TIMEOUT = 20000L;
    final YAPIContext _yctx;
    final HTTPParams _URL_params;
    protected long _notifyTrigger = 0L;
    protected Object _notifyHandle = null;
    volatile boolean _isNotifWorking = false;
    long _devListExpires = 0L;
    final ConcurrentHashMap<Integer, String> _serialByYdx = new ConcurrentHashMap();
    private HashMap<String, YDevice> _devices = new HashMap();
    boolean _reportConnnectionLost;
    protected String _hubSerialNumber = null;
    private HashMap<String, Integer> _beaconss = new HashMap();
    protected ArrayList<String> _knownUrls = new ArrayList();
    private volatile int _lastErrorType = 0;
    private volatile String _lastErrorMessage = "";
    private volatile Exception _lastExecption = null;
    protected volatile int _networkTimeoutMs;
    private boolean _enabled = true;
    private final long _creation_time;
    private static int _global_hub_id = 0;
    private final int _hubid;
    private final BlockingQueue<YDevice> _logPullList = new LinkedBlockingDeque<YDevice>();

    YGenericHub(YAPIContext yctx, HTTPParams httpParams, boolean reportConnnectionLost) {
        this._yctx = yctx;
        this._networkTimeoutMs = this._yctx._networkTimeoutMs;
        this._reportConnnectionLost = reportConnnectionLost;
        this._URL_params = httpParams;
        this._knownUrls.add(httpParams._originalURL);
        this._creation_time = System.currentTimeMillis();
        this._hubid = _global_hub_id++;
    }

    abstract void release();

    abstract String getRootUrl();

    protected void dbglog(int level, String msg) {
        if (this._yctx._dbglog_level >= level) {
            this._yctx.dbglog(level, String.format("hub_%d(%s): %s", this._hubid, this._URL_params._originalURL, msg));
        }
    }

    boolean isSameHub(String url, Object request, Object response, Object session) {
        for (String ku : this._knownUrls) {
            if (!url.equals(ku)) continue;
            return true;
        }
        HTTPParams params = new HTTPParams(url);
        String paramsUrl = params.getUrl(false, false, false);
        return paramsUrl.equals(this._URL_params.getUrl(false, false, false));
    }

    abstract void startNotifications() throws YAPI_Exception;

    abstract void stopNotifications();

    synchronized boolean updateHubSerial(String serial) throws YAPI_Exception {
        if (this._hubSerialNumber == null) {
            this.dbglog(3, "serial is " + serial);
            this._hubSerialNumber = serial;
            return this._yctx._checkForDuplicateHub(this);
        }
        return false;
    }

    static String decodePubVal(int typeV2, byte[] funcval, int ofs, int funcvallen) {
        int len;
        Object buffer = "";
        if (typeV2 == 1 || typeV2 == 2) {
            int funcValType = typeV2 == 1 ? 6 : funcval[ofs++] & 0xFF;
            switch (funcValType) {
                case 0: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    for (int i = 0; i < funcValType; ++i) {
                        int c;
                        int b;
                        buffer = (String)buffer + ((b = (c = funcval[ofs++] & 0xFF) >> 4) > 9 ? b + 97 - 10 : b + 48);
                        b = c & 0xF;
                        buffer = (String)buffer + (b > 9 ? b + 97 - 10 : b + 48);
                    }
                    return buffer;
                }
                case 7: 
                case 9: {
                    int endp;
                    int numVal = funcval[ofs++] & 0xFF;
                    numVal += (funcval[ofs++] & 0xFF) << 8;
                    numVal += (funcval[ofs++] & 0xFF) << 16;
                    numVal += (funcval[ofs++] & 0xFF) << 24;
                    if (funcValType == 7) {
                        return String.format(Locale.US, "%d", numVal);
                    }
                    buffer = String.format(Locale.US, "%.3f", (double)numVal / 1000.0);
                    for (endp = ((String)buffer).length(); endp > 0 && ((String)buffer).charAt(endp - 1) == '0'; --endp) {
                    }
                    if (endp > 0 && ((String)buffer).charAt(endp - 1) == '.') {
                        buffer = ((String)buffer).substring(0, --endp);
                    }
                    return buffer;
                }
                case 8: {
                    int endp;
                    float floatVal = ByteBuffer.wrap(funcval).order(ByteOrder.LITTLE_ENDIAN).getFloat();
                    buffer = String.format(Locale.US, "%.6f", Float.valueOf(floatVal));
                    for (endp = ((String)buffer).length(); endp > 0 && ((String)buffer).charAt(endp - 1) == '0'; --endp) {
                    }
                    if (endp > 0 && ((String)buffer).charAt(endp - 1) == '.') {
                        buffer = ((String)buffer).substring(0, --endp);
                    }
                    return buffer;
                }
                default: {
                    return "?";
                }
            }
        }
        for (len = 0; len < 6 && len < funcvallen && funcval[len + ofs] != 0; ++len) {
        }
        return new String(funcval, ofs, len);
    }

    void removeAllDevices() {
        HashMap<String, ArrayList<YPEntry>> yellowPages = new HashMap<String, ArrayList<YPEntry>>();
        ArrayList<WPEntry> whitePages = new ArrayList<WPEntry>();
        try {
            this.updateFromWpAndYp(whitePages, yellowPages);
        }
        catch (YAPI_Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateFromWpAndYp(ArrayList<WPEntry> whitePages, HashMap<String, ArrayList<YPEntry>> yellowPages) throws YAPI_Exception {
        String serial;
        ArrayList<YDevice> toRemove = new ArrayList<YDevice>(this._devices.values());
        for (WPEntry wp : whitePages) {
            serial = wp.getSerialNumber();
            if (this._devices.containsKey(serial)) {
                YDevice currdev = this._devices.get(serial);
                if (!currdev.getLogicalName().equals(wp.getLogicalName())) {
                    currdev.refresh();
                    this._yctx._pushChangeEvent(serial);
                } else if (currdev.getBeacon() > 0 != wp.getBeacon() > 0) {
                    currdev.refresh();
                }
                toRemove.remove(currdev);
                continue;
            }
            YDevice dev = new YDevice(this, wp, yellowPages);
            this._yctx._yHash.reindexDevice(dev);
            this._devices.put(serial, dev);
            this._yctx._pushPlugEvent(serial, wp.getProductName(), wp.getProductId());
            this._yctx._Log("HUB: device " + serial + " has been plugged\n");
        }
        for (YDevice dev : toRemove) {
            serial = dev.getSerialNumber();
            this._yctx._Log("HUB: device " + serial + " has been unplugged\n");
            this.UnplugDevice(serial);
        }
        YGenericHub yGenericHub = this;
        synchronized (yGenericHub) {
            if (this._hubSerialNumber == null) {
                for (WPEntry wp : whitePages) {
                    if (!wp.getNetworkUrl().equals("")) continue;
                    this.updateHubSerial(wp.getSerialNumber());
                }
            }
        }
        this._yctx._yHash.reindexYellowPages(yellowPages);
    }

    void UnplugDevice(String serial) {
        this._yctx._pushUnPlugEvent(serial);
        this._devices.remove(serial);
        this._yctx._yHash.forgetDevice(serial);
    }

    String getSerialNumber() {
        if (this._hubSerialNumber == null) {
            return "";
        }
        return this._hubSerialNumber;
    }

    public String get_urlOf(String serialNumber) {
        for (YDevice dev : this._devices.values()) {
            String devSerialNumber = dev.getSerialNumber();
            if (!devSerialNumber.equals(serialNumber)) continue;
            return this._URL_params.getUrl(true, false, false) + dev.getNetworkUrl() + "/";
        }
        return this._URL_params.getUrl(true, false, true);
    }

    public ArrayList<String> get_subDeviceOf(String serialNumber) {
        ArrayList<String> res = new ArrayList<String>();
        for (YDevice dev : this._devices.values()) {
            String devSerialNumber = dev.getSerialNumber();
            if (devSerialNumber.equals(serialNumber)) {
                if (dev.getNetworkUrl().equals("")) continue;
                res.clear();
                return res;
            }
            res.add(devSerialNumber);
        }
        return res;
    }

    void handleValueNotification(String serial, String funcid, String value) {
        String hwid = serial + "." + funcid;
        this._yctx._yHash.setFunctionValue(hwid, value);
        YFunction conn_fn = this._yctx._GetValueCallback(hwid);
        if (conn_fn != null) {
            this._yctx._PushDataEvent(new YAPIContext.DataEvent(conn_fn, value));
        }
    }

    void handleConfigChangeNotification(String serial) {
        YModule module = this._yctx._GetModuleCallack(serial);
        if (module != null) {
            this._yctx._PushDataEvent(new YAPIContext.DataEvent(module));
        }
    }

    void handleBeaconNotification(String serial, String logicalName, int beacon) {
        if (!this._beaconss.containsKey(serial) || this._beaconss.get(serial) != beacon) {
            this._beaconss.put(serial, beacon);
            YModule module = this._yctx._GetModuleCallack(serial);
            if (module != null) {
                this._yctx._PushDataEvent(new YAPIContext.DataEvent(module, beacon));
            }
        }
    }

    protected void handleTimedNotification(String serial, String funcid, double time, double duration, byte[] report) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(report.length);
        for (byte b : report) {
            int i = b & 0xFF;
            arrayList.add(i);
        }
        this.handleTimedNotification(serial, funcid, time, duration, arrayList);
    }

    void handleTimedNotification(String serial, String funcid, double time, double duration, ArrayList<Integer> report) {
        String hwid = serial + "." + funcid;
        YFunction func = this._yctx._GetTimedReportCallback(hwid);
        if (func != null) {
            this._yctx._PushDataEvent(new YAPIContext.DataEvent(func, time, duration, report));
        }
    }

    abstract void updateDeviceList(boolean var1) throws YAPI_Exception, InterruptedException;

    public abstract ArrayList<String> getBootloaders() throws YAPI_Exception, InterruptedException;

    abstract int ping(int var1) throws YAPI_Exception;

    public static String getAPIVersion() {
        return "";
    }

    abstract boolean isCallbackMode();

    abstract boolean isReadOnly();

    public void set_networkTimeout(int networkMsTimeout) {
        this._networkTimeoutMs = networkMsTimeout;
    }

    public int get_networkTimeout() {
        return this._networkTimeoutMs;
    }

    public String getLastErrorMessage() {
        return this._lastErrorMessage;
    }

    public int getLastErrorType() {
        return this._lastErrorType;
    }

    void saveLastError(int type, String message, Exception ex) {
        this.dbglog(4, String.format("saveLastError %d:%s (%s)", type, message, ex));
        this._lastErrorType = type;
        this._lastErrorMessage = message;
        this._lastExecption = ex;
    }

    public abstract boolean isOnline();

    public synchronized void merge(YGenericHub newhub) {
        this._yctx.dbglog(2, String.format("merge hub %s(%d) ->%s(%d)", newhub._URL_params._originalURL, newhub.get_hubid(), this._URL_params._originalURL, this.get_hubid()));
        this.addKnownURL(newhub._URL_params._originalURL);
        if (this._creation_time < newhub._creation_time) {
            this._reportConnnectionLost = newhub._reportConnnectionLost;
        }
    }

    public void disable() {
        this._enabled = false;
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public synchronized void addKnownURL(String url) {
        if (!this._knownUrls.contains(url)) {
            this._knownUrls.add(url);
        }
    }

    public void requestStop() {
    }

    public abstract String getConnectionUrl();

    public int get_hubid() {
        return this._hubid;
    }

    public abstract int get_connectionState();

    public int waitIsOnline(int msTimeout) throws YAPI_Exception {
        long expiration = System.currentTimeMillis() + (long)msTimeout;
        this.dbglog(3, String.format("waitIsOnline: wait %dms", msTimeout));
        while (!this.isOnline() && this._lastErrorType == 0 && expiration >= System.currentTimeMillis()) {
            this._yctx.Sleep(100L);
        }
        if (this.isOnline()) {
            this.dbglog(3, "waitIsOnline: hub is online");
            return 0;
        }
        this.dbglog(3, String.format("waitIsOnline: hub  is offline (%d:%s)", this._lastErrorType, this._lastErrorMessage));
        if (this._lastErrorType != 0) {
            throw new YAPI_Exception(this._lastErrorType, this._lastErrorMessage, this._lastExecption);
        }
        throw new YAPI_Exception(-7, String.format("Unable to connect to hub %s:%s", this._URL_params.getHost(), this._URL_params.getPort()));
    }

    abstract ArrayList<String> firmwareUpdate(String var1, YFirmwareFile var2, byte[] var3, UpdateProgress var4) throws YAPI_Exception, InterruptedException;

    abstract void devRequestAsync(YDevice var1, String var2, byte[] var3, RequestAsyncResult var4, Object var5) throws YAPI_Exception, InterruptedException;

    abstract byte[] devRequestSync(YDevice var1, String var2, byte[] var3, RequestProgress var4, Object var5) throws YAPI_Exception, InterruptedException;

    void addDevForLogPull(YDevice yDevice) {
        this._logPullList.offer(yDevice);
    }

    void testLogPull() throws InterruptedException {
        YDevice device = (YDevice)this._logPullList.poll();
        if (device == null) {
            return;
        }
        try {
            String logRequest = device.getLogRequest();
            if (logRequest == null) {
                return;
            }
            RequestAsyncResult logCallbackHandler = device.getLogCallbackHandler();
            this.devRequestAsync(device, logRequest, null, logCallbackHandler, null);
        }
        catch (YAPI_Exception e) {
            e.printStackTrace();
        }
    }

    static class HTTPParams {
        private String _host;
        private int _port;
        private String _user;
        private String _pass;
        private String _proto;
        private final String _subDomain;
        private final String _originalURL;

        public String getOriginalURL() {
            return this._originalURL;
        }

        public HTTPParams(HTTPParams org) {
            this._host = org._host;
            this._port = org._port;
            this._user = org._user;
            this._pass = org._pass;
            this._proto = org._proto;
            this._subDomain = org._subDomain;
            this._originalURL = org._originalURL;
        }

        public HTTPParams(String url) {
            int end_host;
            int end_auth;
            int defaultPort = 4444;
            this._originalURL = url;
            int pos = 0;
            if (url.startsWith("auto://")) {
                pos = 7;
                this._proto = "auto";
            } else if (url.startsWith("secure://")) {
                pos = 9;
                this._proto = "secure";
                defaultPort = 4443;
            } else if (url.startsWith("http://")) {
                pos = 7;
                this._proto = "http";
            } else if (url.startsWith("https://")) {
                pos = 8;
                this._proto = "https";
                defaultPort = 4443;
            } else if (url.startsWith("wss://")) {
                pos = 6;
                this._proto = "wss";
                defaultPort = 4443;
            } else {
                if (url.equals("usb")) {
                    this._proto = "usb";
                    this._user = "";
                    this._pass = "";
                    this._subDomain = "";
                    this._host = "";
                    this._port = -1;
                    return;
                }
                if (url.startsWith("ws://")) {
                    pos = 5;
                    this._proto = "ws";
                } else {
                    this._proto = "auto";
                }
            }
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            if ((end_auth = url.indexOf(64, pos)) > 0) {
                int end_user = url.indexOf(58, pos);
                if (end_user >= 0 && end_user < end_auth) {
                    this._user = url.substring(pos, end_user);
                    this._pass = url.substring(end_user + 1, end_auth);
                } else {
                    this._user = url.substring(pos, end_auth);
                    this._pass = "";
                }
                pos = end_auth + 1;
            } else {
                this._user = "";
                this._pass = "";
            }
            if (url.length() > pos && url.charAt(pos) == '@') {
                ++pos;
            }
            if ((end_host = url.indexOf(47, pos)) < 0) {
                end_host = url.length();
                this._subDomain = "";
            } else {
                this._subDomain = url.substring(end_host);
            }
            int endv6 = url.indexOf(93, pos);
            int portpos = url.indexOf(58, pos);
            if (portpos > 0 && endv6 < end_host && portpos < endv6) {
                portpos = url.indexOf(58, endv6);
            }
            if (portpos > 0) {
                if (portpos + 1 < end_host) {
                    this._host = url.substring(pos, portpos);
                    this._port = Integer.parseInt(url.substring(portpos + 1, end_host));
                } else {
                    this._host = url.substring(pos, portpos);
                    this._port = defaultPort;
                }
            } else {
                this._host = url.substring(pos, end_host);
                if (this._subDomain.length() > 0) {
                    if (this._proto.equals("http")) {
                        defaultPort = 80;
                    } else if (this._proto.equals("https")) {
                        defaultPort = 443;
                    }
                }
                this._port = defaultPort;
            }
        }

        public HTTPParams(HTTPParams http_params_org, String proto, int port) {
            this._originalURL = http_params_org._originalURL;
            this._host = http_params_org._host;
            this._port = port;
            this._user = http_params_org._user;
            this._pass = http_params_org._pass;
            this._proto = !http_params_org.getProto().equals("http") && !http_params_org.getProto().equals("https") ? proto : http_params_org.getProto();
            this._subDomain = http_params_org._subDomain;
        }

        String getHost() {
            return this._host;
        }

        String getPass() {
            return this._pass;
        }

        int getPort() {
            return this._port;
        }

        String getUser() {
            return this._user;
        }

        String getUrl() {
            return this.getUrl(false, true, false);
        }

        String getUrl(boolean withProto, boolean withUserPass, boolean withEndSlash) {
            if (this._proto.equals("usb")) {
                return "usb";
            }
            StringBuilder url = new StringBuilder();
            if (withProto) {
                url.append(this._proto).append("://");
            }
            if (withUserPass && !this._user.equals("")) {
                url.append(this._user);
                if (!this._pass.equals("")) {
                    url.append(":");
                    url.append(this._pass);
                }
                url.append("@");
            }
            url.append(this._host);
            url.append(":");
            url.append(this._port);
            url.append(this._subDomain);
            if (withEndSlash) {
                url.append('/');
            }
            return url.toString();
        }

        public String getProto() {
            return this._proto;
        }

        boolean useWebSocket() {
            return this._proto.startsWith("ws");
        }

        String getSubDomain() {
            return this._subDomain;
        }

        boolean hasAuthParam() {
            return !this._user.equals("");
        }

        boolean useSecureSocket() {
            return "wss".equals(this._proto) || "https".equals(this._proto) || "secure".equals(this._proto);
        }

        public String toString() {
            return this._proto + "://" + this._host + ":" + this._port + this._subDomain;
        }

        public boolean testInfoJson() {
            return this._proto.equals("auto") || this._proto.equals("secure") || this._proto.equals("http") || this._proto.equals("https");
        }

        public void updateForRedirect(String host, int port, boolean is_secure) {
            this._host = host;
            this._port = port;
            this._proto = this.useWebSocket() ? (is_secure ? "wss" : "ws") : (is_secure ? "https" : "http");
        }

        public void updateAuth(String user, String pass) {
            this._user = user;
            this._pass = pass;
        }
    }

    static interface RequestAsyncResult {
        public void RequestAsyncDone(Object var1, byte[] var2, int var3, String var4);
    }

    static interface RequestProgress {
        public void requestProgressUpdate(Object var1, int var2, int var3);
    }

    static interface UpdateProgress {
        public void firmware_progress(int var1, String var2);
    }
}

