/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YFirmwareFile;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YModule;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class YFirmwareUpdate {
    protected String _serial = "";
    protected byte[] _settings = new byte[0];
    protected String _firmwarepath = "";
    protected String _progress_msg = "";
    protected int _progress_c = 0;
    protected int _progress = 0;
    protected int _restore_step = 0;
    protected boolean _force;
    private final YAPIContext _yapi;
    private Thread _thread = null;

    byte[] _downloadfile(String url) throws YAPI_Exception {
        return this._yapi.BasicHTTPRequest(url, this._yapi._networkTimeoutMs, 0);
    }

    static YFirmwareFile checkFirmware_r(File folder, String serial_base) throws YAPI_Exception {
        YFirmwareFile bestFirmware = null;
        if (folder.isFile()) {
            bestFirmware = YFirmwareUpdate._loadFirmwareFile(folder);
        } else {
            File[] listOfFiles = folder.listFiles();
            if (listOfFiles != null) {
                for (File subfile : listOfFiles) {
                    YFirmwareFile firmware;
                    block8: {
                        if (!subfile.getName().startsWith(serial_base)) continue;
                        firmware = null;
                        if (subfile.isFile()) {
                            try {
                                firmware = YFirmwareUpdate._loadFirmwareFile(subfile);
                                break block8;
                            }
                            catch (YAPI_Exception ex) {
                                continue;
                            }
                        }
                        if (subfile.isDirectory()) {
                            firmware = YFirmwareUpdate.checkFirmware_r(subfile, serial_base);
                        }
                    }
                    if (firmware == null || !firmware.getSerial().startsWith(serial_base) || bestFirmware != null && bestFirmware.getFirmwareReleaseAsInt() >= firmware.getFirmwareReleaseAsInt()) continue;
                    bestFirmware = firmware;
                }
            }
        }
        return bestFirmware;
    }

    private static YFirmwareFile _loadFirmwareFile(File file) throws YAPI_Exception {
        FileInputStream in;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new YAPI_Exception(-14, "File not found");
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream(1024);
        try {
            byte[] buffer = new byte[1024];
            int readed = 0;
            while (readed >= 0) {
                readed = in.read(buffer, 0, buffer.length);
                if (readed < 0) {
                    break;
                }
                result.write(buffer, 0, readed);
            }
        }
        catch (IOException e) {
            throw new YAPI_Exception(-8, "unable to load file :" + e.getLocalizedMessage());
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        return YFirmwareFile.Parse(file.getPath(), result.toByteArray());
    }

    public YFirmwareUpdate(YAPIContext yctx, String serial, String path, byte[] settings, boolean force) {
        this._serial = serial;
        this._firmwarepath = path;
        this._settings = settings;
        this._yapi = yctx;
        this._force = force;
    }

    public YFirmwareUpdate(YAPIContext yctx, String serial, String path, byte[] settings) {
        this(yctx, serial, path, settings, false);
    }

    public YFirmwareUpdate(String serial, String path, byte[] settings) {
        this(YAPI.GetYCtx(false), serial, path, settings, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _progress(int progress, String msg) {
        YFirmwareUpdate yFirmwareUpdate = this;
        synchronized (yFirmwareUpdate) {
            this._progress = progress;
            this._progress_msg = msg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _processMore_internal(int start) {
        YFirmwareUpdate yFirmwareUpdate = this;
        synchronized (yFirmwareUpdate) {
            if (!(start <= 0 || this._thread != null && this._thread.isAlive())) {
                this._progress(0, "Firmware update started");
                this._thread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            YFirmwareFile firmware;
                            YFirmwareUpdate.this._progress(1, "Loading firmware");
                            if (YFirmwareUpdate.this._firmwarepath.startsWith("www.yoctopuce.com") || YFirmwareUpdate.this._firmwarepath.startsWith("http://www.yoctopuce.com")) {
                                byte[] bytes = YFirmwareUpdate.this._yapi.BasicHTTPRequest(YFirmwareUpdate.this._firmwarepath, YFirmwareUpdate.this._yapi._networkTimeoutMs, 0);
                                firmware = YFirmwareFile.Parse(YFirmwareUpdate.this._firmwarepath, bytes);
                            } else {
                                firmware = YFirmwareUpdate._loadFirmwareFile(new File(YFirmwareUpdate.this._firmwarepath));
                            }
                            YFirmwareUpdate.this._progress(5, "check if module is already in bootloader");
                            YGenericHub hub = null;
                            YModule module = YModule.FindModuleInContext(YFirmwareUpdate.this._yapi, YFirmwareUpdate.this._serial + ".module");
                            if (module.isOnline()) {
                                YDevice yDevice = module.getYDevice();
                                hub = yDevice.getHub();
                            } else {
                                hub = YFirmwareUpdate.this._yapi.getHubWithBootloader(YFirmwareUpdate.this._serial);
                            }
                            if (hub == null) {
                                throw new YAPI_Exception(-4, "device " + YFirmwareUpdate.this._serial + " is not detected");
                            }
                            hub.firmwareUpdate(YFirmwareUpdate.this._serial, firmware, YFirmwareUpdate.this._settings, new YGenericHub.UpdateProgress(){

                                @Override
                                public void firmware_progress(int percent, String message) {
                                    YFirmwareUpdate.this._progress(5 + percent * 80 / 100, message);
                                }
                            });
                            if (hub.isCallbackMode() && hub.getSerialNumber().equals(YFirmwareUpdate.this._serial)) {
                                YFirmwareUpdate.this._progress(100, "Success (WebSocket Callback)");
                                return;
                            }
                            YFirmwareUpdate.this._progress(80, "wait to the device restart");
                            long timeout = YAPI.GetTickCount() + 60000L;
                            module.clearCache();
                            while (!module.isOnline() && timeout > YAPI.GetTickCount()) {
                                Thread.sleep(500L);
                                try {
                                    YFirmwareUpdate.this._yapi.UpdateDeviceList();
                                }
                                catch (YAPI_Exception yAPI_Exception) {}
                            }
                            if (module.isOnline()) {
                                String realFw;
                                if (YFirmwareUpdate.this._settings != null) {
                                    module.set_allSettingsAndFiles(YFirmwareUpdate.this._settings);
                                    module.saveToFlash();
                                }
                                if ((realFw = module.get_firmwareRelease()).equals(firmware.getFirmwareRelease())) {
                                    YFirmwareUpdate.this._progress(100, "Success");
                                } else {
                                    YFirmwareUpdate.this._progress(-8, "Unable to update firmware");
                                }
                            } else {
                                YFirmwareUpdate.this._progress(-4, "Device did not reboot correctly");
                            }
                        }
                        catch (YAPI_Exception e) {
                            YFirmwareUpdate.this._progress(e.errorType, e.getLocalizedMessage());
                            e.printStackTrace();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }, "Update" + this._serial);
                this._thread.start();
            }
        }
        return 0;
    }

    private static String CheckFirmware_internal(String serial, String path, int minrelease) {
        String link = "";
        Integer best_rev = 0;
        try {
            if (path.startsWith("www.yoctopuce.com") || path.startsWith("http://www.yoctopuce.com")) {
                YJSONObject obj;
                byte[] json = YAPI.GetYCtx(true).BasicHTTPRequest("http://www.yoctopuce.com/FR/common/getLastFirmwareLink.php?serial=" + serial, 20000, 0);
                try {
                    obj = new YJSONObject(new String(json, Charset.forName("ISO_8859_1")));
                    obj.parse();
                }
                catch (Exception ex) {
                    throw new YAPI_Exception(-8, ex.getLocalizedMessage());
                }
                try {
                    link = obj.getString("link");
                    best_rev = obj.getInt("version");
                }
                catch (Exception e) {
                    throw new YAPI_Exception(-8, "invalid respond form www.yoctopuce.com : " + e.getLocalizedMessage());
                }
            }
            File folder = new File(path);
            YFirmwareFile firmware = YFirmwareUpdate.checkFirmware_r(folder, serial.substring(0, 8));
            if (firmware != null) {
                best_rev = firmware.getFirmwareReleaseAsInt();
                link = firmware.getPath();
            }
            if (minrelease != 0) {
                if (minrelease < best_rev) {
                    return link;
                }
                return "";
            }
            return link;
        }
        catch (Exception ex) {
            return "error:" + ex.getLocalizedMessage();
        }
    }

    private static ArrayList<String> GetAllBootLoadersInContext_internal(YAPIContext yctx) {
        return yctx.getAllBootLoaders();
    }

    private static ArrayList<String> GetAllBootLoaders_internal() {
        return YFirmwareUpdate.GetAllBootLoadersInContext(YAPI.GetYCtx(false));
    }

    public int _processMore(int newupdate) {
        return this._processMore_internal(newupdate);
    }

    public static ArrayList<String> GetAllBootLoaders() {
        return YFirmwareUpdate.GetAllBootLoaders_internal();
    }

    public static ArrayList<String> GetAllBootLoadersInContext(YAPIContext yctx) {
        return YFirmwareUpdate.GetAllBootLoadersInContext_internal(yctx);
    }

    public static String CheckFirmware(String serial, String path, int minrelease) {
        return YFirmwareUpdate.CheckFirmware_internal(serial, path, minrelease);
    }

    public int get_progress() {
        if (this._progress >= 0) {
            this._processMore(0);
        }
        return this._progress;
    }

    public String get_progressMessage() {
        return this._progress_msg;
    }

    public int startUpdate() {
        String err = new String(this._settings, this._yapi._deviceCharset);
        int leng = err.length();
        if (leng >= 6 && "error:".equals(err.substring(0, 6))) {
            this._progress = -1;
            this._progress_msg = err.substring(6, 6 + leng - 6);
        } else {
            this._progress = 0;
            this._progress_c = 0;
            this._processMore(1);
        }
        return this._progress;
    }
}

