/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YSensor;

public class YMagnetometer
extends YSensor {
    public static final int BANDWIDTH_INVALID = -1;
    public static final double XVALUE_INVALID = -1.79769313486231E308;
    public static final double YVALUE_INVALID = -1.79769313486231E308;
    public static final double ZVALUE_INVALID = -1.79769313486231E308;
    protected int _bandwidth = -1;
    protected double _xValue = -1.79769313486231E308;
    protected double _yValue = -1.79769313486231E308;
    protected double _zValue = -1.79769313486231E308;
    protected UpdateCallback _valueCallbackMagnetometer = null;
    protected TimedReportCallback _timedReportCallbackMagnetometer = null;

    protected YMagnetometer(YAPIContext ctx, String func) {
        super(ctx, func);
        this._className = "Magnetometer";
    }

    protected YMagnetometer(String func) {
        this(YAPI.GetYCtx(true), func);
    }

    @Override
    protected void _parseAttr(YJSONObject json_val) throws Exception {
        if (json_val.has("bandwidth")) {
            this._bandwidth = json_val.getInt("bandwidth");
        }
        if (json_val.has("xValue")) {
            this._xValue = (double)Math.round(json_val.getDouble("xValue") / 65.536) / 1000.0;
        }
        if (json_val.has("yValue")) {
            this._yValue = (double)Math.round(json_val.getDouble("yValue") / 65.536) / 1000.0;
        }
        if (json_val.has("zValue")) {
            this._zValue = (double)Math.round(json_val.getDouble("zValue") / 65.536) / 1000.0;
        }
        super._parseAttr(json_val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_bandwidth() throws YAPI_Exception {
        int res;
        YMagnetometer yMagnetometer = this;
        synchronized (yMagnetometer) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._bandwidth;
        }
        return res;
    }

    public int getBandwidth() throws YAPI_Exception {
        return this.get_bandwidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_bandwidth(int newval) throws YAPI_Exception {
        YMagnetometer yMagnetometer = this;
        synchronized (yMagnetometer) {
            String rest_val = Integer.toString(newval);
            this._setAttr("bandwidth", rest_val);
        }
        return 0;
    }

    public int setBandwidth(int newval) throws YAPI_Exception {
        return this.set_bandwidth(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_xValue() throws YAPI_Exception {
        double res;
        YMagnetometer yMagnetometer = this;
        synchronized (yMagnetometer) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = this._xValue;
        }
        return res;
    }

    public double getXValue() throws YAPI_Exception {
        return this.get_xValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_yValue() throws YAPI_Exception {
        double res;
        YMagnetometer yMagnetometer = this;
        synchronized (yMagnetometer) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = this._yValue;
        }
        return res;
    }

    public double getYValue() throws YAPI_Exception {
        return this.get_yValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_zValue() throws YAPI_Exception {
        double res;
        YMagnetometer yMagnetometer = this;
        synchronized (yMagnetometer) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = this._zValue;
        }
        return res;
    }

    public double getZValue() throws YAPI_Exception {
        return this.get_zValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YMagnetometer FindMagnetometer(String func) {
        YMagnetometer obj;
        YAPIContext ctx = YAPI.GetYCtx(true);
        Object object = ctx._functionCacheLock;
        synchronized (object) {
            obj = (YMagnetometer)YFunction._FindFromCache("Magnetometer", func);
            if (obj == null) {
                obj = new YMagnetometer(func);
                YFunction._AddToCache("Magnetometer", func, obj);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YMagnetometer FindMagnetometerInContext(YAPIContext yctx, String func) {
        YMagnetometer obj;
        Object object = yctx._functionCacheLock;
        synchronized (object) {
            obj = (YMagnetometer)YFunction._FindFromCacheInContext(yctx, "Magnetometer", func);
            if (obj == null) {
                obj = new YMagnetometer(yctx, func);
                YFunction._AddToCache("Magnetometer", func, obj);
            }
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackMagnetometer = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackMagnetometer != null) {
            this._valueCallbackMagnetometer.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int registerTimedReportCallback(TimedReportCallback callback) {
        YMagnetometer sensor = this;
        if (callback != null) {
            YFunction._UpdateTimedReportCallbackList(sensor, true);
        } else {
            YFunction._UpdateTimedReportCallbackList(sensor, false);
        }
        this._timedReportCallbackMagnetometer = callback;
        return 0;
    }

    @Override
    public int _invokeTimedReportCallback(YMeasure value) {
        if (this._timedReportCallbackMagnetometer != null) {
            this._timedReportCallbackMagnetometer.timedReportCallback(this, value);
        } else {
            super._invokeTimedReportCallback(value);
        }
        return 0;
    }

    public YMagnetometer nextMagnetometer() {
        String next_hwid;
        try {
            String hwid = this._yapi._yHash.resolveHwID(this._className, this._func);
            next_hwid = this._yapi._yHash.getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YMagnetometer.FindMagnetometerInContext(this._yapi, next_hwid);
    }

    public static YMagnetometer FirstMagnetometer() {
        YAPIContext yctx = YAPI.GetYCtx(false);
        if (yctx == null) {
            return null;
        }
        String next_hwid = yctx._yHash.getFirstHardwareId("Magnetometer");
        if (next_hwid == null) {
            return null;
        }
        return YMagnetometer.FindMagnetometerInContext(yctx, next_hwid);
    }

    public static YMagnetometer FirstMagnetometerInContext(YAPIContext yctx) {
        String next_hwid = yctx._yHash.getFirstHardwareId("Magnetometer");
        if (next_hwid == null) {
            return null;
        }
        return YMagnetometer.FindMagnetometerInContext(yctx, next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YMagnetometer var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YMagnetometer var1, String var2);
    }
}

