/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YJSONArray;
import com.yoctopuce.YoctoAPI.YJSONContent;
import com.yoctopuce.YoctoAPI.YJSONNumber;
import com.yoctopuce.YoctoAPI.YJSONString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

class YJSONObject
extends YJSONContent {
    private HashMap<String, YJSONContent> _parsed = new HashMap();
    private ArrayList<String> _keys = new ArrayList(16);

    YJSONObject(String data) {
        super(data, 0, data.length(), YJSONContent.YJSONType.OBJECT);
    }

    YJSONObject(String data, int start, int len) {
        super(data, start, len, YJSONContent.YJSONType.OBJECT);
    }

    @Override
    int parse() throws Exception {
        String current_name = "";
        int name_start = this._data_start;
        int cur_pos = YJSONObject.SkipGarbage(this._data, this._data_start, this._data_boundary);
        if (this._data.length() <= cur_pos || cur_pos >= this._data_boundary || this._data.charAt(cur_pos) != '{') {
            throw new Exception(this.formatError("Opening braces was expected", cur_pos));
        }
        ++cur_pos;
        YJSONContent.Tjstate state = YJSONContent.Tjstate.JWAITFORNAME;
        block8: while (cur_pos < this._data_boundary) {
            char sti = this._data.charAt(cur_pos);
            switch (state) {
                case JWAITFORNAME: {
                    if (sti == '\"') {
                        state = YJSONContent.Tjstate.JWAITFORENDOFNAME;
                        name_start = cur_pos + 1;
                        break;
                    }
                    if (sti == '}') {
                        this._data_len = cur_pos + 1 - this._data_start;
                        return this._data_len;
                    }
                    if (sti == ' ' || sti == '\n' || sti == '\r') break;
                    throw new Exception(this.formatError("invalid char: was expecting \"", cur_pos));
                }
                case JWAITFORENDOFNAME: {
                    if (sti == '\"') {
                        current_name = this._data.substring(name_start, cur_pos);
                        state = YJSONContent.Tjstate.JWAITFORCOLON;
                        break;
                    }
                    if (sti >= ' ') break;
                    throw new Exception(this.formatError("invalid char: was expecting an identifier compliant char", cur_pos));
                }
                case JWAITFORCOLON: {
                    if (sti == ':') {
                        state = YJSONContent.Tjstate.JWAITFORDATA;
                        break;
                    }
                    if (sti == ' ' || sti == '\n' || sti == '\r') break;
                    throw new Exception(this.formatError("invalid char: was expecting \"", cur_pos));
                }
                case JWAITFORDATA: {
                    int len;
                    YJSONContent jobj;
                    if (sti == '{') {
                        jobj = new YJSONObject(this._data, cur_pos, this._data_boundary);
                        len = ((YJSONObject)jobj).parse();
                        cur_pos += len;
                        this._parsed.put(current_name, jobj);
                        this._keys.add(current_name);
                        state = YJSONContent.Tjstate.JWAITFORNEXTSTRUCTMEMBER;
                        continue block8;
                    }
                    if (sti == '[') {
                        jobj = new YJSONArray(this._data, cur_pos, this._data_boundary);
                        len = ((YJSONArray)jobj).parse();
                        cur_pos += len;
                        this._parsed.put(current_name, jobj);
                        this._keys.add(current_name);
                        state = YJSONContent.Tjstate.JWAITFORNEXTSTRUCTMEMBER;
                        continue block8;
                    }
                    if (sti == '\"') {
                        jobj = new YJSONString(this._data, cur_pos, this._data_boundary);
                        len = ((YJSONString)jobj).parse();
                        cur_pos += len;
                        this._parsed.put(current_name, jobj);
                        this._keys.add(current_name);
                        state = YJSONContent.Tjstate.JWAITFORNEXTSTRUCTMEMBER;
                        continue block8;
                    }
                    if (sti == '-' || sti >= '0' && sti <= '9') {
                        jobj = new YJSONNumber(this._data, cur_pos, this._data_boundary);
                        len = ((YJSONNumber)jobj).parse();
                        cur_pos += len;
                        this._parsed.put(current_name, jobj);
                        this._keys.add(current_name);
                        state = YJSONContent.Tjstate.JWAITFORNEXTSTRUCTMEMBER;
                        continue block8;
                    }
                    if (sti == ' ' || sti == '\n' || sti == '\r') break;
                    throw new Exception(this.formatError("invalid char: was expecting  \",0..9,t or f", cur_pos));
                }
                case JWAITFORNEXTSTRUCTMEMBER: {
                    if (sti == ',') {
                        state = YJSONContent.Tjstate.JWAITFORNAME;
                        name_start = cur_pos + 1;
                        break;
                    }
                    if (sti == '}') {
                        this._data_len = cur_pos + 1 - this._data_start;
                        return this._data_len;
                    }
                    if (sti == ' ' || sti == '\n' || sti == '\r') break;
                    throw new Exception(this.formatError("invalid char: was expecting ,", cur_pos));
                }
                case JWAITFORNEXTARRAYITEM: 
                case JWAITFORSTRINGVALUE: 
                case JWAITFORINTVALUE: 
                case JWAITFORBOOLVALUE: {
                    throw new Exception(this.formatError("invalid state for YJSONObject", cur_pos));
                }
            }
            ++cur_pos;
        }
        throw new Exception(this.formatError("unexpected end of data", cur_pos));
    }

    boolean has(String key) {
        return this._parsed.containsKey(key);
    }

    YJSONObject getYJSONObject(String key) {
        return (YJSONObject)this._parsed.get(key);
    }

    YJSONString getYJSONString(String key) {
        return (YJSONString)this._parsed.get(key);
    }

    YJSONArray getYJSONArray(String key) {
        return (YJSONArray)this._parsed.get(key);
    }

    Set<String> getKeys() {
        return this._parsed.keySet();
    }

    YJSONNumber getYJSONNumber(String key) {
        return (YJSONNumber)this._parsed.get(key);
    }

    void remove(String key) {
        this._parsed.remove(key);
    }

    String getString(String key) {
        if (this._parsed.get(key).getJSONType() == YJSONContent.YJSONType.STRING) {
            YJSONString ystr = (YJSONString)this._parsed.get(key);
            return ystr.getString();
        }
        if (this._parsed.get(key).getJSONType() == YJSONContent.YJSONType.NUMBER) {
            YJSONNumber yint = (YJSONNumber)this._parsed.get(key);
            return String.valueOf(yint.getInt());
        }
        return "<JSON_getString_error>";
    }

    int getInt(String key) {
        YJSONNumber yint = (YJSONNumber)this._parsed.get(key);
        return yint.getInt();
    }

    YJSONContent get(String key) {
        return this._parsed.get(key);
    }

    long getLong(String key) {
        YJSONNumber yint = (YJSONNumber)this._parsed.get(key);
        return yint.getLong();
    }

    double getDouble(String key) {
        YJSONNumber yint = (YJSONNumber)this._parsed.get(key);
        return yint.getDouble();
    }

    @Override
    byte[] toJSON() {
        ByteArrayOutputStream res = new ByteArrayOutputStream();
        try {
            res.write(123);
            String sep = "";
            for (String key : this._parsed.keySet()) {
                YJSONContent subContent = this._parsed.get(key);
                byte[] subres = subContent.toJSON();
                res.write(sep.getBytes("ISO-8859-1"));
                res.write(34);
                res.write(key.getBytes("ISO-8859-1"));
                res.write("\":".getBytes("ISO-8859-1"));
                res.write(subres);
                sep = ",";
            }
            res.write(125);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res.toByteArray();
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append('{');
        String sep = "";
        for (String key : this._parsed.keySet()) {
            YJSONContent subContent = this._parsed.get(key);
            String subres = subContent.toString();
            res.append(sep);
            res.append(key);
            res.append("=>");
            res.append(subres);
            sep = ",";
        }
        res.append('}');
        return res.toString();
    }

    String getKeyFromIdx(int i) {
        return this._keys.get(i);
    }

    @Override
    YJSONContent updateFroJZon(YJSONContent newItem) throws Exception {
        YJSONContent.YJSONType newItemJSONType = newItem.getJSONType();
        if (newItemJSONType != YJSONContent.YJSONType.ARRAY && newItemJSONType != YJSONContent.YJSONType.OBJECT) {
            throw new Exception(String.format("Unable to convert %s to %s", newItem.getJSONType().toString(), this.getJSONType().toString()));
        }
        YJSONObject result = new YJSONObject(newItem._data, newItem._data_start, newItem._data_boundary);
        if (newItemJSONType == YJSONContent.YJSONType.ARRAY) {
            YJSONArray jzonArr = (YJSONArray)newItem;
            for (int i = 0; i < jzonArr.length(); ++i) {
                String key = this.getKeyFromIdx(i);
                YJSONContent jzonContent = jzonArr.get(i);
                YJSONContent updatedContent = this._parsed.get(key).updateFroJZon(jzonContent);
                result._keys.add(key);
                result._parsed.put(key, updatedContent);
            }
        } else {
            YJSONObject newObj = (YJSONObject)newItem;
            if (this._keys.size() == 0) {
                throw new Exception(String.format("Unable to convert %s to %s (empty object)", newItem.getJSONType().toString(), this.getJSONType().toString()));
            }
            YJSONContent first_reference = this._parsed.get(this._keys.get(0));
            for (String key : newObj._keys) {
                YJSONContent jsonContent;
                YJSONContent jzonContent = newObj.get(key);
                YJSONContent updatedContent = this._keys.contains(key) ? ((jsonContent = this._parsed.get(key)).getJSONType() == YJSONContent.YJSONType.ARRAY && ((YJSONArray)jsonContent).length() == 0 ? first_reference.updateFroJZon(jzonContent) : jsonContent.updateFroJZon(jzonContent)) : first_reference.updateFroJZon(jzonContent);
                result._keys.add(key);
                result._parsed.put(key, updatedContent);
            }
        }
        return result;
    }
}

