/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDisplayLayer;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YMeasure;
import java.util.ArrayList;
import java.util.Locale;

public class YDisplay
extends YFunction {
    public static final int ENABLED_FALSE = 0;
    public static final int ENABLED_TRUE = 1;
    public static final int ENABLED_INVALID = -1;
    public static final String STARTUPSEQ_INVALID = "!INVALID!";
    public static final int BRIGHTNESS_INVALID = -1;
    public static final int AUTOINVERTDELAY_INVALID = -1;
    public static final int ORIENTATION_LEFT = 0;
    public static final int ORIENTATION_UP = 1;
    public static final int ORIENTATION_RIGHT = 2;
    public static final int ORIENTATION_DOWN = 3;
    public static final int ORIENTATION_INVALID = -1;
    public static final String DISPLAYPANEL_INVALID = "!INVALID!";
    public static final int DISPLAYWIDTH_INVALID = -1;
    public static final int DISPLAYHEIGHT_INVALID = -1;
    public static final int DISPLAYTYPE_MONO = 0;
    public static final int DISPLAYTYPE_GRAY = 1;
    public static final int DISPLAYTYPE_RGB = 2;
    public static final int DISPLAYTYPE_EPAPER = 3;
    public static final int DISPLAYTYPE_INVALID = -1;
    public static final int LAYERWIDTH_INVALID = -1;
    public static final int LAYERHEIGHT_INVALID = -1;
    public static final int LAYERCOUNT_INVALID = -1;
    public static final String COMMAND_INVALID = "!INVALID!";
    protected int _enabled = -1;
    protected String _startupSeq = "!INVALID!";
    protected int _brightness = -1;
    protected int _autoInvertDelay = -1;
    protected int _orientation = -1;
    protected String _displayPanel = "!INVALID!";
    protected int _displayWidth = -1;
    protected int _displayHeight = -1;
    protected int _displayType = -1;
    protected int _layerWidth = -1;
    protected int _layerHeight = -1;
    protected int _layerCount = -1;
    protected String _command = "!INVALID!";
    protected UpdateCallback _valueCallbackDisplay = null;
    protected ArrayList<YDisplayLayer> _allDisplayLayers = new ArrayList();
    private Boolean _recording = false;
    private String _sequence;

    protected YDisplay(YAPIContext yctx, String func) {
        super(yctx, func);
        this._className = "Display";
    }

    protected YDisplay(String func) {
        this(YAPI.GetYCtx(true), func);
    }

    @Override
    protected void _parseAttr(YJSONObject json_val) throws Exception {
        if (json_val.has("enabled")) {
            int n = this._enabled = json_val.getInt("enabled") > 0 ? 1 : 0;
        }
        if (json_val.has("startupSeq")) {
            this._startupSeq = json_val.getString("startupSeq");
        }
        if (json_val.has("brightness")) {
            this._brightness = json_val.getInt("brightness");
        }
        if (json_val.has("autoInvertDelay")) {
            this._autoInvertDelay = json_val.getInt("autoInvertDelay");
        }
        if (json_val.has("orientation")) {
            this._orientation = json_val.getInt("orientation");
        }
        if (json_val.has("displayPanel")) {
            this._displayPanel = json_val.getString("displayPanel");
        }
        if (json_val.has("displayWidth")) {
            this._displayWidth = json_val.getInt("displayWidth");
        }
        if (json_val.has("displayHeight")) {
            this._displayHeight = json_val.getInt("displayHeight");
        }
        if (json_val.has("displayType")) {
            this._displayType = json_val.getInt("displayType");
        }
        if (json_val.has("layerWidth")) {
            this._layerWidth = json_val.getInt("layerWidth");
        }
        if (json_val.has("layerHeight")) {
            this._layerHeight = json_val.getInt("layerHeight");
        }
        if (json_val.has("layerCount")) {
            this._layerCount = json_val.getInt("layerCount");
        }
        if (json_val.has("command")) {
            this._command = json_val.getString("command");
        }
        super._parseAttr(json_val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_enabled() throws YAPI_Exception {
        int res;
        YDisplay yDisplay = this;
        synchronized (yDisplay) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._enabled;
        }
        return res;
    }

    public int getEnabled() throws YAPI_Exception {
        return this.get_enabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_enabled(int newval) throws YAPI_Exception {
        YDisplay yDisplay = this;
        synchronized (yDisplay) {
            String rest_val = newval > 0 ? "1" : "0";
            this._setAttr("enabled", rest_val);
        }
        return 0;
    }

    public int setEnabled(int newval) throws YAPI_Exception {
        return this.set_enabled(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_startupSeq() throws YAPI_Exception {
        String res;
        YDisplay yDisplay = this;
        synchronized (yDisplay) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._startupSeq;
        }
        return res;
    }

    public String getStartupSeq() throws YAPI_Exception {
        return this.get_startupSeq();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_startupSeq(String newval) throws YAPI_Exception {
        YDisplay yDisplay = this;
        synchronized (yDisplay) {
            String rest_val = newval;
            this._setAttr("startupSeq", rest_val);
        }
        return 0;
    }

    public int setStartupSeq(String newval) throws YAPI_Exception {
        return this.set_startupSeq(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_brightness() throws YAPI_Exception {
        int res;
        YDisplay yDisplay = this;
        synchronized (yDisplay) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._brightness;
        }
        return res;
    }

    public int getBrightness() throws YAPI_Exception {
        return this.get_brightness();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_brightness(int newval) throws YAPI_Exception {
        YDisplay yDisplay = this;
        synchronized (yDisplay) {
            String rest_val = Integer.toString(newval);
            this._setAttr("brightness", rest_val);
        }
        return 0;
    }

    public int setBrightness(int newval) throws YAPI_Exception {
        return this.set_brightness(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_autoInvertDelay() throws YAPI_Exception {
        int res;
        YDisplay yDisplay = this;
        synchronized (yDisplay) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._autoInvertDelay;
        }
        return res;
    }

    public int getAutoInvertDelay() throws YAPI_Exception {
        return this.get_autoInvertDelay();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_autoInvertDelay(int newval) throws YAPI_Exception {
        YDisplay yDisplay = this;
        synchronized (yDisplay) {
            String rest_val = Integer.toString(newval);
            this._setAttr("autoInvertDelay", rest_val);
        }
        return 0;
    }

    public int setAutoInvertDelay(int newval) throws YAPI_Exception {
        return this.set_autoInvertDelay(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_orientation() throws YAPI_Exception {
        int res;
        YDisplay yDisplay = this;
        synchronized (yDisplay) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._orientation;
        }
        return res;
    }

    public int getOrientation() throws YAPI_Exception {
        return this.get_orientation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_orientation(int newval) throws YAPI_Exception {
        YDisplay yDisplay = this;
        synchronized (yDisplay) {
            String rest_val = Integer.toString(newval);
            this._setAttr("orientation", rest_val);
        }
        return 0;
    }

    public int setOrientation(int newval) throws YAPI_Exception {
        return this.set_orientation(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_displayPanel() throws YAPI_Exception {
        String res;
        YDisplay yDisplay = this;
        synchronized (yDisplay) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._displayPanel;
        }
        return res;
    }

    public String getDisplayPanel() throws YAPI_Exception {
        return this.get_displayPanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_displayPanel(String newval) throws YAPI_Exception {
        YDisplay yDisplay = this;
        synchronized (yDisplay) {
            String rest_val = newval;
            this._setAttr("displayPanel", rest_val);
        }
        return 0;
    }

    public int setDisplayPanel(String newval) throws YAPI_Exception {
        return this.set_displayPanel(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_displayWidth() throws YAPI_Exception {
        int res;
        YDisplay yDisplay = this;
        synchronized (yDisplay) {
            if (this._cacheExpiration == 0L && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._displayWidth;
        }
        return res;
    }

    public int getDisplayWidth() throws YAPI_Exception {
        return this.get_displayWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_displayHeight() throws YAPI_Exception {
        int res;
        YDisplay yDisplay = this;
        synchronized (yDisplay) {
            if (this._cacheExpiration == 0L && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._displayHeight;
        }
        return res;
    }

    public int getDisplayHeight() throws YAPI_Exception {
        return this.get_displayHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_displayType() throws YAPI_Exception {
        int res;
        YDisplay yDisplay = this;
        synchronized (yDisplay) {
            if (this._cacheExpiration == 0L && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._displayType;
        }
        return res;
    }

    public int getDisplayType() throws YAPI_Exception {
        return this.get_displayType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_layerWidth() throws YAPI_Exception {
        int res;
        YDisplay yDisplay = this;
        synchronized (yDisplay) {
            if (this._cacheExpiration == 0L && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._layerWidth;
        }
        return res;
    }

    public int getLayerWidth() throws YAPI_Exception {
        return this.get_layerWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_layerHeight() throws YAPI_Exception {
        int res;
        YDisplay yDisplay = this;
        synchronized (yDisplay) {
            if (this._cacheExpiration == 0L && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._layerHeight;
        }
        return res;
    }

    public int getLayerHeight() throws YAPI_Exception {
        return this.get_layerHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_layerCount() throws YAPI_Exception {
        int res;
        YDisplay yDisplay = this;
        synchronized (yDisplay) {
            if (this._cacheExpiration == 0L && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._layerCount;
        }
        return res;
    }

    public int getLayerCount() throws YAPI_Exception {
        return this.get_layerCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_command() throws YAPI_Exception {
        String res;
        YDisplay yDisplay = this;
        synchronized (yDisplay) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._command;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_command(String newval) throws YAPI_Exception {
        YDisplay yDisplay = this;
        synchronized (yDisplay) {
            String rest_val = newval;
            this._setAttr("command", rest_val);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YDisplay FindDisplay(String func) {
        YDisplay obj;
        YAPIContext ctx = YAPI.GetYCtx(true);
        Object object = ctx._functionCacheLock;
        synchronized (object) {
            obj = (YDisplay)YFunction._FindFromCache("Display", func);
            if (obj == null) {
                obj = new YDisplay(func);
                YFunction._AddToCache("Display", func, obj);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YDisplay FindDisplayInContext(YAPIContext yctx, String func) {
        YDisplay obj;
        Object object = yctx._functionCacheLock;
        synchronized (object) {
            obj = (YDisplay)YFunction._FindFromCacheInContext(yctx, "Display", func);
            if (obj == null) {
                obj = new YDisplay(yctx, func);
                YFunction._AddToCache("Display", func, obj);
            }
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackDisplay = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackDisplay != null) {
            this._valueCallbackDisplay.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int resetAll() throws YAPI_Exception {
        this.flushLayers();
        this.resetHiddenLayerFlags();
        return this.sendCommand("Z");
    }

    public int regenerateDisplay() throws YAPI_Exception {
        return this.sendCommand("z");
    }

    public int postponeRefresh(int duration) throws YAPI_Exception {
        return this.sendCommand(String.format(Locale.US, "H%d", duration));
    }

    public int triggerRefresh() throws YAPI_Exception {
        return this.sendCommand("H0");
    }

    public int fade(int brightness, int duration) throws YAPI_Exception {
        this.flushLayers();
        return this.sendCommand(String.format(Locale.US, "+%d,%d", brightness, duration));
    }

    public int newSequence() throws YAPI_Exception {
        this.flushLayers();
        this._sequence = "";
        this._recording = true;
        return 0;
    }

    public int saveSequence(String sequenceName) throws YAPI_Exception {
        this.flushLayers();
        this._recording = false;
        this._upload(sequenceName, this._sequence.getBytes(this._yapi._deviceCharset));
        this._sequence = "";
        return 0;
    }

    public int playSequence(String sequenceName) throws YAPI_Exception {
        this.flushLayers();
        return this.sendCommand(String.format(Locale.US, "S%s", sequenceName));
    }

    public int pauseSequence(int delay_ms) throws YAPI_Exception {
        this.flushLayers();
        return this.sendCommand(String.format(Locale.US, "W%d", delay_ms));
    }

    public int stopSequence() throws YAPI_Exception {
        this.flushLayers();
        return this.sendCommand("S");
    }

    public int upload(String pathname, byte[] content) throws YAPI_Exception {
        return this._upload(pathname, content);
    }

    public int copyLayerContent(int srcLayerId, int dstLayerId) throws YAPI_Exception {
        this.flushLayers();
        return this.sendCommand(String.format(Locale.US, "o%d,%d", srcLayerId, dstLayerId));
    }

    public int swapLayerContent(int layerIdA, int layerIdB) throws YAPI_Exception {
        this.flushLayers();
        return this.sendCommand(String.format(Locale.US, "E%d,%d", layerIdA, layerIdB));
    }

    public YDisplayLayer get_displayLayer(int layerId) throws YAPI_Exception {
        int layercount = this.get_layerCount();
        if (layerId < 0 || layerId >= layercount) {
            throw new YAPI_Exception(-2, "invalid DisplayLayer index");
        }
        if (this._allDisplayLayers.size() == 0) {
            for (int idx = 0; idx < layercount; ++idx) {
                this._allDisplayLayers.add(new YDisplayLayer(this, idx));
            }
        }
        return this._allDisplayLayers.get(layerId);
    }

    public byte[] readDisplay(ArrayList<Integer> palette) throws YAPI_Exception {
        int pixval;
        int pixpos;
        int srci;
        byte[] pixmap = new byte[]{};
        if (this.get_autoInvertDelay() < 0) {
            byte[] zipmap = this._download("display.gif");
            int zipsize = zipmap.length;
            if (zipsize == 0) {
                return pixmap;
            }
            if (zipsize < 32) {
                throw new YAPI_Exception(-8, "not a GIF image");
            }
            if ((zipmap[0] & 0xFF) != 71 || (zipmap[2] & 0xFF) != 70) {
                throw new YAPI_Exception(-2, "not a GIF image");
            }
            int zipwidth = (zipmap[6] & 0xFF) + 256 * (zipmap[7] & 0xFF);
            int zipheight = (zipmap[8] & 0xFF) + 256 * (zipmap[9] & 0xFF);
            palette.clear();
            int zipcol = (zipmap[13] & 0xFF) * 65536 + (zipmap[14] & 0xFF) * 256 + (zipmap[15] & 0xFF);
            palette.add(zipcol);
            zipcol = (zipmap[16] & 0xFF) * 65536 + (zipmap[17] & 0xFF) * 256 + (zipmap[18] & 0xFF);
            palette.add(zipcol);
            int pixcount = zipwidth * zipheight;
            pixmap = new byte[pixcount];
            int pixpos2 = 0;
            int srcpos = 30;
            zipsize -= 2;
            while (srcpos < zipsize) {
                int endrun = srcpos + 1 + (zipmap[srcpos] & 0xFF);
                ++srcpos;
                while (srcpos < endrun) {
                    int srcval = zipmap[srcpos] & 0xFF;
                    ++srcpos;
                    for (int srcbit = 8; srcbit != 0; srcbit -= 3) {
                        if (srcbit < 3) {
                            srcval += (zipmap[srcpos] & 0xFF) << srcbit;
                            ++srcpos;
                        }
                        int pixval2 = srcval & 7;
                        srcval >>= 3;
                        if (pixval2 <= 1 || pixval2 == 4) {
                            throw new YAPI_Exception(-2, "unexpected encoding");
                        }
                        pixmap[pixpos2] = (byte)(pixval2 & 0xFF);
                        ++pixpos2;
                    }
                }
            }
            return pixmap;
        }
        byte[] zipmap = this._download("pixels.bin");
        int zipsize = zipmap.length;
        if (zipsize == 0) {
            return pixmap;
        }
        if (zipsize < 16) {
            throw new YAPI_Exception(-8, "not a pixmap");
        }
        if ((zipmap[0] & 0xFF) != 80 || (zipmap[2] & 0xFF) != 88) {
            throw new YAPI_Exception(-2, "not a pixmap");
        }
        int zipwidth = (zipmap[4] & 0xFF) + 256 * (zipmap[5] & 0xFF);
        int zipheight = (zipmap[6] & 0xFF) + 256 * (zipmap[7] & 0xFF);
        int ziprotate = zipmap[8] & 0xFF;
        int zipcolors = zipmap[9] & 0xFF;
        palette.clear();
        int srcpos = 10;
        for (srci = 0; srci < zipcolors; ++srci) {
            int zipcol = (zipmap[srcpos] & 0xFF) * 65536 + (zipmap[srcpos + 1] & 0xFF) * 256 + (zipmap[srcpos + 2] & 0xFF);
            palette.add(zipcol);
            srcpos += 3;
        }
        int zipbits = 1;
        while (1 << zipbits < zipcolors) {
            ++zipbits;
        }
        int zipmask = (1 << zipbits) - 1;
        int pixcount = zipwidth * zipheight;
        pixmap = new byte[pixcount];
        int srcx = 0;
        int srcy = 0;
        int incx = 8 / zipbits;
        int srcval = 0;
        while (srcpos < zipsize) {
            int srcpat = zipmap[srcpos] & 0xFF;
            ++srcpos;
            for (int srcbit = 7; srcbit >= 0; --srcbit) {
                if ((srcpat & 0x80) != 0) {
                    srcval = zipmap[srcpos] & 0xFF;
                    ++srcpos;
                }
                srcpat <<= 1;
                pixpos = srcy * zipwidth + srcx;
                for (srci = 8 - zipbits; srci >= 0; srci -= zipbits) {
                    pixval = srcval >> srci & zipmask;
                    pixmap[pixpos] = (byte)(pixval & 0xFF);
                    ++pixpos;
                }
                if (++srcy < zipheight) continue;
                srcy = 0;
                if ((srcx += incx) < zipwidth) continue;
                srcbit = 0;
            }
        }
        if (ziprotate == 0) {
            return pixmap;
        }
        if ((ziprotate & 2) != 0) {
            srcpos = 0;
            for (pixpos = pixcount - 1; srcpos < pixpos; ++srcpos, --pixpos) {
                pixval = pixmap[srcpos] & 0xFF;
                pixmap[srcpos] = (byte)(pixmap[pixpos] & 0xFF & 0xFF);
                pixmap[pixpos] = (byte)(pixval & 0xFF);
            }
        }
        if ((ziprotate & 1) == 0) {
            return pixmap;
        }
        byte[] rotmap = new byte[pixcount];
        srcx = 0;
        srcy = zipwidth - 1;
        for (srcpos = 0; srcpos < pixcount; ++srcpos) {
            pixval = pixmap[srcpos] & 0xFF;
            pixpos = srcy * zipheight + srcx;
            rotmap[pixpos] = (byte)(pixval & 0xFF);
            if (--srcy >= 0) continue;
            ++srcx;
            srcy = zipwidth - 1;
        }
        return rotmap;
    }

    public YDisplay nextDisplay() {
        String next_hwid;
        try {
            String hwid = this._yapi._yHash.resolveHwID(this._className, this._func);
            next_hwid = this._yapi._yHash.getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YDisplay.FindDisplayInContext(this._yapi, next_hwid);
    }

    public static YDisplay FirstDisplay() {
        YAPIContext yctx = YAPI.GetYCtx(false);
        if (yctx == null) {
            return null;
        }
        String next_hwid = yctx._yHash.getFirstHardwareId("Display");
        if (next_hwid == null) {
            return null;
        }
        return YDisplay.FindDisplayInContext(yctx, next_hwid);
    }

    public static YDisplay FirstDisplayInContext(YAPIContext yctx) {
        String next_hwid = yctx._yHash.getFirstHardwareId("Display");
        if (next_hwid == null) {
            return null;
        }
        return YDisplay.FindDisplayInContext(yctx, next_hwid);
    }

    public synchronized int flushLayers() throws YAPI_Exception {
        if (this._allDisplayLayers.size() > 0) {
            for (YDisplayLayer _allDisplayLayer : this._allDisplayLayers) {
                _allDisplayLayer.flush_now();
            }
        }
        return 0;
    }

    public synchronized void resetHiddenLayerFlags() {
        if (this._allDisplayLayers.size() > 0) {
            for (YDisplayLayer _allDisplayLayer : this._allDisplayLayers) {
                _allDisplayLayer.resetHiddenFlag();
            }
        }
    }

    public synchronized int sendCommand(String cmd) throws YAPI_Exception {
        if (!this._recording.booleanValue()) {
            return this.set_command(cmd);
        }
        this._sequence = this._sequence + cmd + "\n";
        return 0;
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YDisplay var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YDisplay var1, String var2);
    }
}

