/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YCallbackHub;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YHTTPHub;
import com.yoctopuce.YoctoAPI.YHash;
import com.yoctopuce.YoctoAPI.YHub;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YModule;
import com.yoctopuce.YoctoAPI.YSSDP;
import com.yoctopuce.YoctoAPI.YSensor;
import com.yoctopuce.YoctoAPI.YTrustManager;
import com.yoctopuce.YoctoAPI.YUSBHub;
import com.yoctopuce.YoctoAPI.yHTTPRequest;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class YAPIContext {
    private static final double[] decExp = new double[]{1.0E-6, 1.0E-5, 1.0E-4, 0.001, 0.01, 0.1, 1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9};
    private static final char[] _hexArray = "0123456789ABCDEF".toCharArray();
    String _defaultEncoding = "ISO-8859-1";
    final Charset _deviceCharset;
    private int _apiMode;
    private final ArrayList<YGenericHub> _hubs = new ArrayList(1);
    private final Queue<PlugEvent> _pendingCallbacks = new LinkedList<PlugEvent>();
    private final Queue<DataEvent> _data_events = new LinkedList<DataEvent>();
    private final Object _regCbLock = new Object();
    private YAPI.DeviceArrivalCallback _arrivalCallback;
    private YAPI.DeviceChangeCallback _namechgCallback;
    private YAPI.DeviceRemovalCallback _removalCallback;
    private final Object _logCallbackLock = new Object();
    private YAPI.LogCallback _logCallback;
    private final Object _newHubCallbackLock = new Object();
    private YAPI.HubDiscoveryCallback _HubDiscoveryCallback;
    private final HashMap<Integer, YAPI.CalibrationHandlerCallback> _calibHandlers = new HashMap();
    private final YSSDP _ssdp;
    final YHash _yHash;
    private final ArrayList<YFunction> _ValueCallbackList = new ArrayList();
    private final ArrayList<YFunction> _TimedReportCallbackList = new ArrayList();
    private final Map<YModule, Integer> _moduleCallbackList = new HashMap<YModule, Integer>();
    private final KeyStore _keyStore;
    private int _sslFlags = 0;
    private int _pktAckDelay = 0;
    long _deviceListValidityMs = 10000L;
    int _networkTimeoutMs = 20000;
    final Object _functionCacheLock;
    private final Map<Integer, YHub> _yhub_cache = new HashMap<Integer, YHub>();
    int _dbglog_level = 0;
    protected long _defaultCacheValidity = 5L;
    private final YSSDP.YSSDPReportInterface _ssdpCallback = new YSSDP.YSSDPReportInterface(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void HubDiscoveryCallback(String serial, String urlToRegister, String urlToUnregister) {
            if (urlToRegister != null) {
                Object object = YAPIContext.this._newHubCallbackLock;
                synchronized (object) {
                    if (YAPIContext.this._HubDiscoveryCallback != null) {
                        YAPIContext.this._HubDiscoveryCallback.yHubDiscoveryCallback(serial, urlToRegister);
                    }
                }
            }
            if ((YAPIContext.this._apiMode & 2) != 0 && urlToRegister != null) {
                if (urlToUnregister != null) {
                    YAPIContext.this.UnregisterHub(urlToUnregister);
                }
                try {
                    YAPIContext.this.PreregisterHub(urlToRegister);
                }
                catch (YAPI_Exception ex) {
                    YAPIContext.this._Log("Unable to register hub " + urlToRegister + " detected by SSDP:" + ex.toString());
                }
            }
        }
    };
    private static final YAPI.CalibrationHandlerCallback linearCalibrationHandler = new YAPI.CalibrationHandlerCallback(){

        @Override
        public double yCalibrationHandler(double rawValue, int calibType, ArrayList<Integer> params, ArrayList<Double> rawValues, ArrayList<Double> refValues) {
            int npt;
            double x = rawValues.get(0);
            double adj = refValues.get(0) - x;
            int i = 0;
            if (calibType < 30) {
                npt = calibType % 10;
                if (npt > rawValues.size()) {
                    npt = rawValues.size();
                }
                if (npt > refValues.size()) {
                    npt = refValues.size();
                }
            } else {
                npt = refValues.size();
            }
            while (rawValue > rawValues.get(i) && ++i < npt) {
                double x2 = x;
                double adj2 = adj;
                x = rawValues.get(i);
                adj = refValues.get(i) - x;
                if (!(rawValue < x) || !(x > x2)) continue;
                adj = adj2 + (adj - adj2) * (rawValue - x2) / (x - x2);
            }
            return rawValue + adj;
        }
    };

    static double _decimalToDouble(int val) {
        boolean negate = false;
        int mantis = val & 0x7FF;
        if (mantis == 0) {
            return 0.0;
        }
        if (val > Short.MAX_VALUE) {
            negate = true;
            val = 65536 - val;
        } else if (val < 0) {
            negate = true;
            val = -val;
        }
        int exp = val >> 11;
        double res = (double)mantis * decExp[exp];
        return negate ? -res : res;
    }

    static long _doubleToDecimal(double val) {
        int decpow;
        boolean negate = false;
        if (val == 0.0) {
            return 0L;
        }
        if (val < 0.0) {
            negate = true;
            val = -val;
        }
        double comp = val / 1999.0;
        for (decpow = 0; comp > decExp[decpow] && decpow < 15; ++decpow) {
        }
        double mant = val / decExp[decpow];
        long res = decpow == 15 && mant > 2047.0 ? 32767L : (long)(decpow << 11) + Math.round(mant);
        return negate ? -res : res;
    }

    static ArrayList<Integer> _decodeWords(String data) {
        ArrayList<Integer> udata = new ArrayList<Integer>();
        int datalen = data.length();
        int p = 0;
        while (p < datalen) {
            int val;
            int c;
            if ((c = data.charAt(p++)) == 42) {
                val = 0;
            } else if (c == 88) {
                val = 65535;
            } else if (c == 89) {
                val = Short.MAX_VALUE;
            } else if (c >= 97) {
                int srcpos = udata.size() - 1 - (c - 97);
                val = srcpos < 0 ? 0 : udata.get(srcpos);
            } else {
                if (p + 2 > datalen) {
                    return udata;
                }
                val = c - 48;
                c = data.charAt(p++);
                val += c - 48 << 5;
                if ((c = data.charAt(p++)) == 122) {
                    c = 92;
                }
                val += c - 48 << 10;
            }
            udata.add(val);
        }
        return udata;
    }

    static ArrayList<Integer> _decodeFloats(String data) {
        ArrayList<Integer> idata = new ArrayList<Integer>();
        int datalen = data.length();
        int p = 0;
        while (p < datalen) {
            int val = 0;
            int sign = 1;
            int dec = 0;
            int decInc = 0;
            char c = data.charAt(p++);
            while (c != '-' && (c < '0' || c > '9')) {
                if (p >= datalen) {
                    return idata;
                }
                c = data.charAt(p++);
            }
            if (c == '-') {
                if (p >= datalen) {
                    return idata;
                }
                sign = -sign;
                c = data.charAt(p++);
            }
            while (c >= '0' && c <= '9' || c == '.') {
                if (c == '.') {
                    decInc = 1;
                } else if (dec < 3) {
                    val = val * 10 + (c - 48);
                    dec += decInc;
                }
                if (p < datalen) {
                    c = data.charAt(p++);
                    continue;
                }
                c = '\u0000';
            }
            if (dec < 3) {
                val = dec == 0 ? (val *= 1000) : (dec == 1 ? (val *= 100) : (val *= 10));
            }
            idata.add(sign * val);
        }
        return idata;
    }

    static int _find_in_bytes(byte[] source, byte[] match) {
        if (source == null || match == null) {
            return -1;
        }
        if (source.length == 0 || match.length == 0) {
            return -1;
        }
        int ret = -1;
        int mpos = 0;
        byte m = match[mpos];
        for (int spos = 0; spos < source.length; ++spos) {
            if (m == source[spos]) {
                if (mpos == 0) {
                    ret = spos;
                } else if (mpos == match.length - 1) {
                    return ret;
                }
                m = match[++mpos];
                continue;
            }
            ret = -1;
            mpos = 0;
            m = match[mpos];
        }
        return ret;
    }

    public static int _atoi(String str) {
        int i;
        if ((str = str.trim()).length() == 0) {
            return 0;
        }
        int s = 0;
        if (str.charAt(s) == '+') {
            ++s;
        }
        if (str.charAt(i = s) == '-') {
            ++i;
        }
        while (i < str.length() && Character.isDigit(str.charAt(i))) {
            ++i;
        }
        if (i == 0) {
            return 0;
        }
        str = str.substring(s, i);
        return Integer.parseInt(str);
    }

    static String _bytesToHexStr(byte[] bytes, int offset, int len) {
        char[] hexChars = new char[len * 2];
        for (int j = 0; j < len; ++j) {
            int v = bytes[offset + j] & 0xFF;
            hexChars[j * 2] = _hexArray[v >>> 4];
            hexChars[j * 2 + 1] = _hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] _hexStrToBin(String hex_str) {
        int len = hex_str.length() / 2;
        byte[] res = new byte[len];
        for (int i = 0; i < len; ++i) {
            res[i] = (byte)((Character.digit(hex_str.charAt(i * 2), 16) << 4) + Character.digit(hex_str.charAt(i * 2 + 1), 16));
        }
        return res;
    }

    public static byte[] _bytesMerge(byte[] array_a, byte[] array_b) {
        byte[] res = new byte[array_a.length + array_b.length];
        System.arraycopy(array_a, 0, res, 0, array_a.length);
        System.arraycopy(array_b, 0, res, array_a.length, array_b.length);
        return res;
    }

    static String functionClass(String funcid) {
        int dotpos = funcid.indexOf(46);
        if (dotpos >= 0) {
            funcid = funcid.substring(dotpos + 1);
        }
        int classlen = funcid.length();
        while (funcid.charAt(classlen - 1) <= '9') {
            --classlen;
        }
        return funcid.substring(0, 1).toUpperCase(Locale.US) + funcid.substring(1, classlen);
    }

    void dbglog(int level, String msg) {
        if (this._dbglog_level >= level) {
            // empty if block
        }
    }

    void dbglogExc(int level, Exception ex) {
        if (this._dbglog_level >= level) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean _checkForDuplicateHub(YGenericHub newhub) {
        String serial = newhub.getSerialNumber();
        YGenericHub previous = null;
        ArrayList<YGenericHub> arrayList = this._hubs;
        synchronized (arrayList) {
            this.dbglog(3, String.format("Check if we already have a hub with serial %s (hubid=%d)", serial, newhub.get_hubid()));
            for (YGenericHub hub : this._hubs) {
                this.dbglog(5, String.format("test hub %d (%s) against %d (%s)", hub.get_hubid(), hub._URL_params.getOriginalURL(), newhub.get_hubid(), newhub._URL_params.getOriginalURL()));
                if (!hub.isEnabled()) {
                    this.dbglog(3, String.format("Skip hub %d (%s) because it's disabled", hub.get_hubid(), hub._URL_params.getOriginalURL()));
                    continue;
                }
                String current = hub.getSerialNumber();
                if (!serial.equals(current) || hub == newhub) continue;
                previous = hub;
                break;
            }
            if (previous != null) {
                previous.merge(newhub);
                newhub.disable();
            }
        }
        if (previous != null) {
            newhub.requestStop();
            return true;
        }
        return false;
    }

    public YAPIContext() {
        KeyStore keyStore;
        Charset charset;
        try {
            charset = Charset.forName("ISO-8859-1");
        }
        catch (Exception dummy) {
            charset = Charset.defaultCharset();
        }
        this._deviceCharset = charset;
        this._yHash = new YHash(this);
        this._ssdp = new YSSDP(this);
        this._functionCacheLock = new Object();
        this.resetContext();
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            keyStore.load(null, null);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            keyStore = null;
        }
        this._keyStore = keyStore;
    }

    Socket CreateSSLSocket(int sslFlags) throws IOException {
        return this.getSocketFactory(sslFlags).createSocket();
    }

    private void resetContext() {
        this._apiMode = 0;
        this._pendingCallbacks.clear();
        this._data_events.clear();
        this._arrivalCallback = null;
        this._namechgCallback = null;
        this._removalCallback = null;
        this._logCallback = null;
        this._HubDiscoveryCallback = null;
        this._hubs.clear();
        this._yhub_cache.clear();
        this._calibHandlers.clear();
        this._ssdp.reset();
        this._yHash.reset();
        this._ValueCallbackList.clear();
        this._TimedReportCallbackList.clear();
        this._moduleCallbackList.clear();
        for (int i = 1; i <= 20; ++i) {
            this._calibHandlers.put(i, linearCalibrationHandler);
        }
        this._calibHandlers.put(30, linearCalibrationHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _pushPlugEvent(String serial, String productName, int productId) {
        if (this._arrivalCallback != null) {
            Queue<PlugEvent> queue = this._pendingCallbacks;
            synchronized (queue) {
                this._pendingCallbacks.add(new PlugEvent(this, PlugEvent.Event.PLUG, serial));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _pushChangeEvent(String serial) {
        if (this._namechgCallback != null) {
            Queue<PlugEvent> queue = this._pendingCallbacks;
            synchronized (queue) {
                this._pendingCallbacks.add(new PlugEvent(this, PlugEvent.Event.CHANGE, serial));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _pushUnPlugEvent(String serial) {
        if (this._removalCallback != null) {
            Queue<PlugEvent> queue = this._pendingCallbacks;
            synchronized (queue) {
                this._pendingCallbacks.add(new PlugEvent(this, PlugEvent.Event.UNPLUG, serial));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _PushDataEvent(DataEvent ev) {
        Queue<DataEvent> queue = this._data_events;
        synchronized (queue) {
            this._data_events.add(ev);
        }
    }

    YAPI.CalibrationHandlerCallback _getCalibrationHandler(int calibType) {
        if (!this._calibHandlers.containsKey(calibType)) {
            return null;
        }
        return this._calibHandlers.get(calibType);
    }

    YDevice funcGetDevice(String className, String func) throws YAPI_Exception {
        String resolved;
        try {
            resolved = this._yHash.resolveSerial(className, func);
        }
        catch (YAPI_Exception ex) {
            if (ex.errorType == -4 && this._hubs.isEmpty()) {
                throw new YAPI_Exception(ex.errorType, "Impossible to contact any device because no hub has been registered");
            }
            this._updateDeviceList_internal(true, false);
            resolved = this._yHash.resolveSerial(className, func);
        }
        YDevice dev = this._yHash.getDevice(resolved);
        if (dev == null) {
            this._updateDeviceList_internal(true, false);
            dev = this._yHash.getDevice(resolved);
            if (dev == null) {
                throw new YAPI_Exception(-4, "Device [" + resolved + "] not online");
            }
        }
        return dev;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _UpdateValueCallbackList(YFunction func, boolean add) {
        if (add) {
            func.isOnline();
            ArrayList<YFunction> arrayList = this._ValueCallbackList;
            synchronized (arrayList) {
                if (!this._ValueCallbackList.contains(func)) {
                    this._ValueCallbackList.add(func);
                }
            }
        }
        ArrayList<YFunction> arrayList = this._ValueCallbackList;
        synchronized (arrayList) {
            this._ValueCallbackList.remove(func);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    YFunction _GetValueCallback(String hwid) {
        ArrayList<YFunction> arrayList = this._ValueCallbackList;
        synchronized (arrayList) {
            for (YFunction func : this._ValueCallbackList) {
                try {
                    if (!func.getHardwareId().equals(hwid)) continue;
                    return func;
                }
                catch (YAPI_Exception yAPI_Exception) {
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _UpdateTimedReportCallbackList(YFunction func, boolean add) {
        if (add) {
            func.isOnline();
            ArrayList<YFunction> arrayList = this._TimedReportCallbackList;
            synchronized (arrayList) {
                if (!this._TimedReportCallbackList.contains(func)) {
                    this._TimedReportCallbackList.add(func);
                }
            }
        }
        ArrayList<YFunction> arrayList = this._TimedReportCallbackList;
        synchronized (arrayList) {
            this._TimedReportCallbackList.remove(func);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _UpdateModuleCallbackList(YModule module, boolean add) {
        if (add) {
            module.isOnline();
            Map<YModule, Integer> map = this._moduleCallbackList;
            synchronized (map) {
                if (!this._moduleCallbackList.containsKey(module)) {
                    this._moduleCallbackList.put(module, 1);
                } else {
                    this._moduleCallbackList.put(module, this._moduleCallbackList.get(module) + 1);
                }
            }
        }
        Map<YModule, Integer> map = this._moduleCallbackList;
        synchronized (map) {
            if (this._moduleCallbackList.containsKey(module) && this._moduleCallbackList.get(module) > 1) {
                this._moduleCallbackList.put(module, this._moduleCallbackList.get(module) - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    YModule _GetModuleCallack(String serial) {
        YModule module = YModule.FindModuleInContext(this, serial + ".module");
        Map<YModule, Integer> map = this._moduleCallbackList;
        synchronized (map) {
            if (this._moduleCallbackList.containsKey(module) && this._moduleCallbackList.get(module) > 0) {
                return module;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    YFunction _GetTimedReportCallback(String hwid) {
        ArrayList<YFunction> arrayList = this._TimedReportCallbackList;
        synchronized (arrayList) {
            for (YFunction func : this._TimedReportCallbackList) {
                try {
                    if (!func.getHardwareId().equals(hwid)) continue;
                    return func;
                }
                catch (YAPI_Exception yAPI_Exception) {
                }
            }
        }
        return null;
    }

    private String GetYAPISharedLibraryPath_internal() {
        return YUSBHub.getYAPISharedLibraryPath();
    }

    public String AddUdevRule_internal(boolean force) {
        return YUSBHub.addUdevRule(force);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized YGenericHub _AddNewHub(String url, boolean reportConnnectionLost, InputStream request, OutputStream response, Object session) throws YAPI_Exception {
        YGenericHub newhub;
        ArrayList<YGenericHub> arrayList = this._hubs;
        synchronized (arrayList) {
            for (YGenericHub h : this._hubs) {
                if (!h.isEnabled() || !h.isSameHub(url, request, response, session)) continue;
                h.addKnownURL(url);
                return h;
            }
        }
        YGenericHub.HTTPParams parsedurl = new YGenericHub.HTTPParams(url);
        if (url.equals("usb")) {
            YUSBHub.CheckUSBAcces();
            newhub = new YUSBHub(this, true, this._pktAckDelay);
        } else if (url.equals("usb_silent")) {
            YUSBHub.CheckUSBAcces();
            newhub = new YUSBHub(this, false, this._pktAckDelay);
        } else {
            if (url.equals("net")) {
                if ((this._apiMode & 2) == 0) {
                    this._apiMode |= 2;
                    this._ssdp.addCallback(this._ssdpCallback);
                }
                return null;
            }
            newhub = parsedurl.getHost().equals("callback") ? (session != null ? new YHTTPHub(this, parsedurl, reportConnnectionLost, session) : new YCallbackHub(this, parsedurl, request, response)) : new YHTTPHub(this, parsedurl, reportConnnectionLost, null);
        }
        newhub.startNotifications();
        if (reportConnnectionLost) {
            try {
                newhub.waitIsOnline(YAPI.GetNetworkTimeout());
                this.dbglog(3, "new hub= " + newhub.toString() + " Should be online : " + Boolean.toString(newhub.isOnline()));
            }
            catch (YAPI_Exception ex) {
                if (ex.errorType == -11) {
                    String serialNumber = newhub.getSerialNumber();
                    this.dbglog(3, "duplicate= " + newhub.get_hubid());
                    newhub.stopNotifications();
                    ArrayList<YGenericHub> arrayList2 = this._hubs;
                    synchronized (arrayList2) {
                        for (YGenericHub h : this._hubs) {
                            if (!h.getSerialNumber().equals(serialNumber)) continue;
                            return h;
                        }
                    }
                } else {
                    newhub.stopNotifications();
                }
                ex.printStackTrace();
                throw ex;
            }
        }
        ArrayList<YGenericHub> arrayList3 = this._hubs;
        synchronized (arrayList3) {
            if (!this._checkForDuplicateHub(newhub)) {
                this.dbglog(3, "new hub= " + newhub.get_hubid() + " online=" + Boolean.toString(newhub.isOnline()));
                this._hubs.add(newhub);
            } else {
                this.dbglog(3, "drop duplicate hub " + newhub.get_hubid());
                newhub.stopNotifications();
            }
        }
        return newhub;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _updateDeviceList_internal(boolean forceupdate, boolean invokecallbacks) throws YAPI_Exception {
        YAPIContext yAPIContext = this;
        synchronized (yAPIContext) {
            for (YGenericHub h : this._hubs) {
                if (!h.isEnabled()) continue;
                try {
                    h.updateDeviceList(forceupdate);
                }
                catch (InterruptedException e) {
                    throw new YAPI_Exception(-8, "Thread has been interrupted");
                }
            }
        }
        if (invokecallbacks) {
            while (true) {
                PlugEvent evt;
                Object object = this._pendingCallbacks;
                synchronized (object) {
                    if (this._pendingCallbacks.isEmpty()) {
                        break;
                    }
                    evt = this._pendingCallbacks.poll();
                }
                object = this._regCbLock;
                synchronized (object) {
                    if (evt != null) {
                        switch (evt.ev) {
                            case PLUG: {
                                if (this._arrivalCallback == null) break;
                                evt.module.isOnline();
                                this._arrivalCallback.yDeviceArrival(evt.module);
                                break;
                            }
                            case CHANGE: {
                                if (this._namechgCallback == null) break;
                                this._namechgCallback.yDeviceChange(evt.module);
                                break;
                            }
                            case UNPLUG: {
                                if (this._removalCallback == null) break;
                                this._removalCallback.yDeviceRemoval(evt.module);
                            }
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _Log(String message) {
        Object object = this._logCallbackLock;
        synchronized (object) {
            if (this._logCallback != null) {
                this._logCallback.yLog(message);
            }
        }
    }

    byte[] BasicHTTPRequest(String url, int mstimout, int ssl_flags) throws YAPI_Exception {
        URL u;
        ByteArrayOutputStream result = new ByteArrayOutputStream(1024);
        try {
            u = new URL(url);
        }
        catch (MalformedURLException e) {
            throw new YAPI_Exception(-8, e.getLocalizedMessage());
        }
        if (url.startsWith("http://")) {
            String path;
            String host = u.getHost();
            int port = u.getPort();
            if (port < 0) {
                port = 80;
            }
            if ((path = u.getFile()).isEmpty()) {
                path = "/";
            }
            return yHTTPRequest.yTcpDownload(this, host, port, path, mstimout);
        }
        BufferedInputStream in = null;
        try {
            URLConnection connection = u.openConnection();
            HttpsURLConnection httpsUrlConnection = (HttpsURLConnection)connection;
            httpsUrlConnection.setConnectTimeout(mstimout);
            int flags = ssl_flags | this._sslFlags;
            httpsUrlConnection.setSSLSocketFactory(this.getSocketFactory(flags));
            if ((flags & 4) != 0) {
                httpsUrlConnection.setHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession sslSession) {
                        return true;
                    }
                });
            }
            in = new BufferedInputStream(connection.getInputStream());
            byte[] buffer = new byte[1024];
            int readed = 0;
            while ((readed = in.read(buffer, 0, buffer.length)) >= 0) {
                result.write(buffer, 0, readed);
            }
        }
        catch (SSLHandshakeException e) {
            throw new YAPI_Exception(-20, "unable to contact " + url + " :" + e.getLocalizedMessage(), e);
        }
        catch (SSLException e) {
            throw new YAPI_Exception(-15, "unable to contact " + url + " :" + e.getLocalizedMessage(), e);
        }
        catch (IOException e) {
            throw new YAPI_Exception(-8, "unable to contact " + url + " :" + e.getLocalizedMessage(), e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result.toByteArray();
    }

    private SSLSocketFactory getSocketFactory(int sslFlags) {
        SSLContext sslContext = null;
        Object yTrustManager = null;
        try {
            TrustManager[] trustManagers = new TrustManager[]{new YTrustManager(this._keyStore, sslFlags | this._sslFlags)};
            sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, trustManagers, new SecureRandom());
            return sslContext.getSocketFactory();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void SetNetworkTimeout_internal(int networkMsTimeout) {
        this._networkTimeoutMs = networkMsTimeout;
    }

    public int GetNetworkTimeout_internal() {
        return this._networkTimeoutMs;
    }

    public String DownloadHostCertificate_internal(String url, long mstimeout) {
        StringBuilder res = new StringBuilder();
        YGenericHub.HTTPParams parsedurl = new YGenericHub.HTTPParams(url);
        try {
            boolean https_req = parsedurl.useSecureSocket();
            if (parsedurl.getPort() == 4443) {
                https_req = true;
            }
            String clean_url = String.format("%s://%s:%d%s/info.json", parsedurl.useSecureSocket() ? "https" : "http", parsedurl.getHost(), parsedurl.getPort(), parsedurl.getSubDomain());
            URL destinationURL = new URL(clean_url);
            HttpsURLConnection conn = (HttpsURLConnection)destinationURL.openConnection();
            conn.setSSLSocketFactory(this.getSocketFactory(7));
            conn.connect();
            Certificate[] certs = conn.getServerCertificates();
            boolean i = true;
            for (Certificate cert : certs) {
                if (!(cert instanceof X509Certificate)) continue;
                res.append("-----BEGIN CERTIFICATE-----\n");
                byte[] encoded = cert.getEncoded();
                res.append(YAPI.Base64Encode(encoded, 0, encoded.length));
                res.append("-----END CERTIFICATE-----\n");
            }
        }
        catch (IOException | CertificateEncodingException e) {
            return "error:" + e.getLocalizedMessage();
        }
        return res.toString();
    }

    public String AddTrustedCertificates_internal(String certificate) {
        if (this._keyStore != null) {
            ArrayList<X509Certificate> certs;
            try {
                certs = YTrustManager.parsePemCert(certificate);
            }
            catch (CertificateException e) {
                return "error:" + e.getLocalizedMessage();
            }
            for (X509Certificate c : certs) {
                try {
                    this._keyStore.setCertificateEntry("cert" + c.toString(), c);
                }
                catch (KeyStoreException e) {
                    return "error:" + e.getLocalizedMessage();
                }
            }
            return "";
        }
        return "Error: Not supported";
    }

    public String SetNetworkSecurityOptions_internal(int options) {
        this._sslFlags = options;
        return "";
    }

    private String SetTrustedCertificatesList_internal(String certificatePath) {
        return "error: Not supported in Java";
    }

    public void SetDeviceListValidity(int deviceListValidity) {
        this.SetDeviceListValidity_internal(deviceListValidity);
    }

    public int GetDeviceListValidity() {
        return this.GetDeviceListValidity_internal();
    }

    public String GetYAPISharedLibraryPath() {
        return this.GetYAPISharedLibraryPath_internal();
    }

    public String AddUdevRule(boolean force) {
        return this.AddUdevRule_internal(force);
    }

    public String DownloadHostCertificate(String url, long mstimeout) {
        return this.DownloadHostCertificate_internal(url, mstimeout);
    }

    public String AddTrustedCertificates(String certificate) {
        return this.AddTrustedCertificates_internal(certificate);
    }

    public String SetTrustedCertificatesList(String certificatePath) {
        return this.SetTrustedCertificatesList_internal(certificatePath);
    }

    public String SetNetworkSecurityOptions(int opts) {
        return this.SetNetworkSecurityOptions_internal(opts);
    }

    public void SetNetworkTimeout(int networkMsTimeout) {
        this.SetNetworkTimeout_internal(networkMsTimeout);
    }

    public int GetNetworkTimeout() {
        return this.GetNetworkTimeout_internal();
    }

    public void SetCacheValidity(long cacheValidityMs) {
        this._defaultCacheValidity = cacheValidityMs;
    }

    public long GetCacheValidity() {
        return this._defaultCacheValidity;
    }

    public YHub nextHubInUseInternal(int hubref) {
        return this.nextHubInUseInternal_internal(hubref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public YHub getYHubObj(int hubref) {
        YHub obj;
        YAPIContext ctx = YAPI.GetYCtx(true);
        Object object = ctx._functionCacheLock;
        synchronized (object) {
            obj = this._findYHubFromCache(hubref);
            if (obj == null) {
                obj = new YHub(this, hubref);
                this._addYHubToCache(hubref, obj);
            }
        }
        return obj;
    }

    public YHub findYHubFromID(String id) {
        YHub rhub;
        for (rhub = this.nextHubInUseInternal(-1); rhub != null; rhub = rhub.nextHubInUse()) {
            if (rhub.get_serialNumber().equals(id)) {
                return rhub;
            }
            if (!rhub.get_registeredUrl().equals(id)) continue;
            return rhub;
        }
        return rhub;
    }

    public YGenericHub getGenHub(int hubref) {
        for (YGenericHub h : this._hubs) {
            if (h.get_hubid() != hubref) continue;
            return h;
        }
        return null;
    }

    private void _addYHubToCache(int hubref, YHub obj) {
        this._yhub_cache.put(hubref, obj);
    }

    private YHub _findYHubFromCache(int hubref) {
        return this._yhub_cache.get(hubref);
    }

    private synchronized YHub nextHubInUseInternal_internal(int hubref) {
        int nextref = hubref < 0 ? 0 : hubref + 1;
        int next_avail_ref = Integer.MAX_VALUE;
        for (YGenericHub h : this._hubs) {
            if (!h.isEnabled()) continue;
            int hubid = h.get_hubid();
            if (hubid == nextref) {
                return this.getYHubObj(nextref);
            }
            if (hubid <= nextref || hubid >= next_avail_ref) continue;
            next_avail_ref = hubid;
        }
        if (next_avail_ref != Integer.MAX_VALUE) {
            return this.getYHubObj(next_avail_ref);
        }
        return null;
    }

    public void SetHTTPCallbackCacheDir(String directory) throws YAPI_Exception {
        throw new YAPI_Exception(-3, "SetHTTPCallbackCacheDir is not supported by Java lib");
    }

    public void ClearHTTPCallbackCacheDir(boolean removeFiles) {
    }

    private void SetDeviceListValidity_internal(long deviceListValidity) {
        this._deviceListValidityMs = deviceListValidity * 1000L;
    }

    private int GetDeviceListValidity_internal() {
        return (int)(this._deviceListValidityMs / 1000L);
    }

    public void SetUSBPacketAckMs(int pktAckDelay) {
        this._pktAckDelay = pktAckDelay;
    }

    public static String GetAPIVersion() {
        return YAPI.GetAPIVersion();
    }

    public int InitAPI(int mode) throws YAPI_Exception {
        if ((mode & 2) != 0) {
            this.RegisterHub("net");
        }
        if ((mode & 4) != 0) {
            this._pktAckDelay = 50;
        }
        if ((mode & 1) != 0) {
            this.RegisterHub("usb");
        }
        return 0;
    }

    public synchronized void FreeAPI() {
        if ((this._apiMode & 2) != 0) {
            this._ssdp.Stop();
        }
        for (YGenericHub h : this._hubs) {
            h.stopNotifications();
            h.release();
        }
        this.resetContext();
    }

    public int RegisterHub(String url) throws YAPI_Exception {
        YGenericHub hub = this._AddNewHub(url, true, null, null, null);
        if (hub != null) {
            try {
                hub.updateDeviceList(true);
            }
            catch (YAPI_Exception ex) {
                this.unregisterHubEx(url, null, null, null);
                throw ex;
            }
            catch (InterruptedException e) {
                this.unregisterHubEx(url, null, null, null);
                throw new YAPI_Exception(-8, "Thread has been interrupted");
            }
        }
        return 0;
    }

    public int RegisterHub(String url, InputStream request, OutputStream response) throws YAPI_Exception {
        YGenericHub hub = this._AddNewHub(url, true, request, response, null);
        if (hub != null) {
            try {
                hub.updateDeviceList(true);
            }
            catch (YAPI_Exception ex) {
                this.unregisterHubEx(url, request, response, null);
                throw ex;
            }
            catch (InterruptedException e) {
                this.unregisterHubEx(url, request, response, null);
                throw new YAPI_Exception(-8, "Thread has been interrupted");
            }
        }
        return 0;
    }

    public int RegisterHubHTTPCallback(InputStream request, OutputStream response) throws YAPI_Exception {
        YGenericHub hub = this._AddNewHub("http://callback", true, request, response, null);
        if (hub != null) {
            try {
                hub.updateDeviceList(true);
            }
            catch (InterruptedException e) {
                throw new YAPI_Exception(-8, "Thread has been interrupted");
            }
        }
        return 0;
    }

    public int PreregisterHubWebSocketCallback(Object session) throws YAPI_Exception {
        return this.PreregisterHubWebSocketCallback(session, null, null);
    }

    public int PreregisterHubWebSocketCallback(Object session, String user, String pass) throws YAPI_Exception {
        if (user == null) {
            user = "";
        }
        if (pass != null) {
            user = user + ":" + pass;
        }
        String url = "ws://" + user + "@callback";
        this._AddNewHub(url, true, null, null, session);
        return 0;
    }

    public void UnregisterHubWebSocketCallback(Object session) {
        this.unregisterHubEx("ws://callback", null, null, session);
    }

    public void EnableUSBHost(Object osContext) throws YAPI_Exception {
        YUSBHub.SetContextType(osContext);
    }

    public int PreregisterHub(String url) throws YAPI_Exception {
        this._AddNewHub(url, false, null, null, null);
        return 0;
    }

    public void UnregisterHub(String url) {
        if (url.equals("net")) {
            this._apiMode &= 0xFFFFFFFD;
            return;
        }
        this.unregisterHubEx(url, null, null, null);
    }

    private void unregisterHubEx(String url, InputStream request, OutputStream response, Object session) {
        Iterator<YGenericHub> it = this._hubs.iterator();
        while (it.hasNext()) {
            YGenericHub h = it.next();
            if (!h.isSameHub(url, request, response, session)) continue;
            h.addKnownURL(url);
            h.stopNotifications();
            h.release();
            it.remove();
        }
    }

    public int TestHub(String url, int mstimeout) throws YAPI_Exception {
        YGenericHub newhub;
        if (url.equals("net")) {
            throw new YAPI_Exception(-2, "Invalid URL");
        }
        YGenericHub.HTTPParams parsedurl = new YGenericHub.HTTPParams(url);
        if (url.equals("usb")) {
            YUSBHub.CheckUSBAcces();
            newhub = new YUSBHub(this, true, this._pktAckDelay);
        } else {
            newhub = parsedurl.getHost().equals("callback") ? new YCallbackHub(this, parsedurl, null, null) : new YHTTPHub(this, parsedurl, true, null);
        }
        newhub.set_networkTimeout(mstimeout);
        return newhub.ping(mstimeout);
    }

    public int UpdateDeviceList() throws YAPI_Exception {
        this._updateDeviceList_internal(true, true);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int HandleEvents() throws YAPI_Exception {
        while (true) {
            DataEvent pv;
            Queue<DataEvent> queue = this._data_events;
            synchronized (queue) {
                if (this._data_events.isEmpty()) {
                    break;
                }
                pv = this._data_events.poll();
            }
            if (pv == null) continue;
            pv.invoke();
        }
        return 0;
    }

    public int Sleep(long ms_duration) throws YAPI_Exception {
        long end = YAPIContext.GetTickCount() + ms_duration;
        boolean first = true;
        do {
            if (first || end - YAPIContext.GetTickCount() > 10L) {
                this.HandleEvents();
                first = false;
            }
            if (end <= YAPIContext.GetTickCount()) continue;
            try {
                Thread.sleep(2L);
            }
            catch (InterruptedException ex) {
                throw new YAPI_Exception(-8, "Thread has been interrupted");
            }
        } while (end > YAPIContext.GetTickCount());
        return 0;
    }

    public int TriggerHubDiscovery() throws YAPI_Exception {
        this._ssdp.addCallback(this._ssdpCallback);
        return 0;
    }

    public static long GetTickCount() {
        return System.currentTimeMillis();
    }

    public boolean CheckLogicalName(String name) {
        return YAPI.CheckLogicalName(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RegisterDeviceArrivalCallback(YAPI.DeviceArrivalCallback arrivalCallback) {
        Object object = this._regCbLock;
        synchronized (object) {
            this._arrivalCallback = arrivalCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RegisterDeviceChangeCallback(YAPI.DeviceChangeCallback changeCallback) {
        Object object = this._regCbLock;
        synchronized (object) {
            this._namechgCallback = changeCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RegisterDeviceRemovalCallback(YAPI.DeviceRemovalCallback removalCallback) {
        Object object = this._regCbLock;
        synchronized (object) {
            this._removalCallback = removalCallback;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RegisterHubDiscoveryCallback(YAPI.HubDiscoveryCallback hubDiscoveryCallback) {
        Object object = this._newHubCallbackLock;
        synchronized (object) {
            this._HubDiscoveryCallback = hubDiscoveryCallback;
        }
        try {
            this.TriggerHubDiscovery();
        }
        catch (YAPI_Exception yAPI_Exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RegisterLogFunction(YAPI.LogCallback logfun) {
        Object object = this._logCallbackLock;
        synchronized (object) {
            this._logCallback = logfun;
        }
    }

    ArrayList<String> getAllBootLoaders() {
        ArrayList<String> res = new ArrayList<String>();
        for (YGenericHub h : this._hubs) {
            try {
                ArrayList<String> bootloaders;
                try {
                    bootloaders = h.getBootloaders();
                }
                catch (InterruptedException e) {
                    throw new YAPI_Exception(-8, "Thread has been interrupted");
                }
                if (bootloaders == null) continue;
                res.addAll(bootloaders);
            }
            catch (YAPI_Exception e) {
                this._Log(e.getLocalizedMessage());
            }
        }
        return res;
    }

    public YGenericHub getHubWithBootloader(String serial) throws YAPI_Exception, InterruptedException {
        for (YGenericHub h : this._hubs) {
            ArrayList<String> bootloaders = h.getBootloaders();
            if (!bootloaders.contains(serial)) continue;
            return h;
        }
        return null;
    }

    static class PlugEvent {
        Event ev;
        public YModule module;

        PlugEvent(YAPIContext yctx, Event ev, String serial) {
            this.ev = ev;
            this.module = YModule.FindModuleInContext(yctx, serial + ".module");
        }

        public static enum Event {
            PLUG,
            UNPLUG,
            CHANGE;

        }
    }

    static class DataEvent {
        private final YFunction _fun;
        private final String _value;
        private final ArrayList<Integer> _report;
        private final double _timestamp;
        private final double _duration;
        private final YModule _module;
        private final int _beacon;

        DataEvent(YFunction fun, String value) {
            this._module = null;
            this._fun = fun;
            this._value = value;
            this._report = null;
            this._timestamp = 0.0;
            this._duration = 0.0;
            this._beacon = -1;
        }

        DataEvent(YModule module) {
            this._module = module;
            this._fun = null;
            this._value = null;
            this._report = null;
            this._timestamp = 0.0;
            this._duration = 0.0;
            this._beacon = -1;
        }

        DataEvent(YModule module, int beacon) {
            this._module = module;
            this._fun = null;
            this._value = null;
            this._report = null;
            this._timestamp = 0.0;
            this._duration = 0.0;
            this._beacon = beacon;
        }

        DataEvent(YFunction fun, double timestamp, double duration, ArrayList<Integer> report) {
            this._module = null;
            this._fun = fun;
            this._value = null;
            this._timestamp = timestamp;
            this._duration = duration;
            this._report = report;
            this._beacon = -1;
        }

        public void invoke() {
            if (this._module != null) {
                if (this._beacon < 0) {
                    this._module._invokeConfigChangeCallback();
                } else {
                    this._module._invokeBeaconCallback(this._beacon);
                }
            } else if (this._value == null) {
                YSensor sensor = (YSensor)this._fun;
                assert (sensor != null);
                YMeasure mesure = sensor._decodeTimedReport(this._timestamp, this._duration, this._report);
                sensor._invokeTimedReportCallback(mesure);
            } else {
                assert (this._fun != null);
                this._fun._invokeValueCallback(this._value);
            }
        }
    }
}

