/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import java.util.Locale;

public class YRfidStatus {
    public static final int SUCCESS = 0;
    public static final int COMMAND_NOT_SUPPORTED = 1;
    public static final int COMMAND_NOT_RECOGNIZED = 2;
    public static final int COMMAND_OPTION_NOT_RECOGNIZED = 3;
    public static final int COMMAND_CANNOT_BE_PROCESSED_IN_TIME = 4;
    public static final int UNDOCUMENTED_ERROR = 15;
    public static final int BLOCK_NOT_AVAILABLE = 16;
    public static final int BLOCK_ALREADY_LOCKED = 17;
    public static final int BLOCK_LOCKED = 18;
    public static final int BLOCK_NOT_SUCESSFULLY_PROGRAMMED = 19;
    public static final int BLOCK_NOT_SUCESSFULLY_LOCKED = 20;
    public static final int BLOCK_IS_PROTECTED = 21;
    public static final int CRYPTOGRAPHIC_ERROR = 64;
    public static final int READER_BUSY = 1000;
    public static final int TAG_NOTFOUND = 1001;
    public static final int TAG_LEFT = 1002;
    public static final int TAG_JUSTLEFT = 1003;
    public static final int TAG_COMMUNICATION_ERROR = 1004;
    public static final int TAG_NOT_RESPONDING = 1005;
    public static final int TIMEOUT_ERROR = 1006;
    public static final int COLLISION_DETECTED = 1007;
    public static final int INVALID_CMD_ARGUMENTS = -66;
    public static final int UNKNOWN_CAPABILITIES = -67;
    public static final int MEMORY_NOT_SUPPORTED = -68;
    public static final int INVALID_BLOCK_INDEX = -69;
    public static final int MEM_SPACE_UNVERRUN_ATTEMPT = -70;
    public static final int BROWNOUT_DETECTED = -71;
    public static final int BUFFER_OVERFLOW = -72;
    public static final int CRC_ERROR = -73;
    public static final int COMMAND_RECEIVE_TIMEOUT = -75;
    public static final int DID_NOT_SLEEP = -76;
    public static final int ERROR_DECIMAL_EXPECTED = -77;
    public static final int HARDWARE_FAILURE = -78;
    public static final int ERROR_HEX_EXPECTED = -79;
    public static final int FIFO_LENGTH_ERROR = -80;
    public static final int FRAMING_ERROR = -81;
    public static final int NOT_IN_CNR_MODE = -82;
    public static final int NUMBER_OU_OF_RANGE = -83;
    public static final int NOT_SUPPORTED = -84;
    public static final int NO_RF_FIELD_ACTIVE = -85;
    public static final int READ_DATA_LENGTH_ERROR = -86;
    public static final int WATCHDOG_RESET = -87;
    public static final int UNKNOW_COMMAND = -91;
    public static final int UNKNOW_ERROR = -92;
    public static final int UNKNOW_PARAMETER = -93;
    public static final int UART_RECEIVE_ERROR = -94;
    public static final int WRONG_DATA_LENGTH = -95;
    public static final int WRONG_MODE = -96;
    public static final int UNKNOWN_DWARFxx_ERROR_CODE = -97;
    public static final int RESPONSE_SHORT = -98;
    public static final int UNEXPECTED_TAG_ID_IN_RESPONSE = -99;
    public static final int UNEXPECTED_TAG_INDEX = -100;
    public static final int READ_EOF = -101;
    public static final int READ_OK_SOFAR = -102;
    public static final int WRITE_DATA_MISSING = -103;
    public static final int WRITE_TOO_MUCH_DATA = -104;
    public static final int TRANSFER_CLOSED = -105;
    public static final int COULD_NOT_BUILD_REQUEST = -106;
    public static final int INVALID_OPTIONS = -107;
    public static final int UNEXPECTED_RESPONSE = -108;
    public static final int AFI_NOT_AVAILABLE = -109;
    public static final int DSFID_NOT_AVAILABLE = -110;
    public static final int TAG_RESPONSE_TOO_SHORT = -111;
    public static final int DEC_EXPECTED = -112;
    public static final int HEX_EXPECTED = -113;
    public static final int NOT_SAME_SECOR = -114;
    public static final int MIFARE_AUTHENTICATED = -115;
    public static final int NO_DATABLOCK = -116;
    public static final int KEYB_IS_READABLE = -117;
    public static final int OPERATION_NOT_EXECUTED = -118;
    public static final int BLOK_MODE_ERROR = -119;
    public static final int BLOCK_NOT_WRITABLE = -120;
    public static final int BLOCK_ACCESS_ERROR = -121;
    public static final int BLOCK_NOT_AUTHENTICATED = -122;
    public static final int ACCESS_KEY_BIT_NOT_WRITABLE = -123;
    public static final int USE_KEYA_FOR_AUTH = -124;
    public static final int USE_KEYB_FOR_AUTH = -125;
    public static final int KEY_NOT_CHANGEABLE = -126;
    public static final int BLOCK_TOO_HIGH = -127;
    public static final int AUTH_ERR = -128;
    public static final int NOKEY_SELECT = -129;
    public static final int CARD_NOT_SELECTED = -130;
    public static final int BLOCK_TO_READ_NONE = -131;
    public static final int NO_TAG = -132;
    public static final int TOO_MUCH_DATA = -133;
    public static final int CON_NOT_SATISFIED = -134;
    public static final int BLOCK_IS_SPECIAL = -135;
    public static final int READ_BEYOND_ANNOUNCED_SIZE = -136;
    public static final int BLOCK_ZERO_IS_RESERVED = -137;
    public static final int VALUE_BLOCK_BAD_FORMAT = -138;
    public static final int ISO15693_ONLY_FEATURE = -139;
    public static final int ISO14443_ONLY_FEATURE = -140;
    public static final int MIFARE_CLASSIC_ONLY_FEATURE = -141;
    public static final int BLOCK_MIGHT_BE_PROTECTED = -142;
    public static final int NO_SUCH_BLOCK = -143;
    public static final int COUNT_TOO_BIG = -144;
    public static final int UNKNOWN_MEM_SIZE = -145;
    public static final int MORE_THAN_2BLOCKS_MIGHT_NOT_WORK = -146;
    public static final int READWRITE_NOT_SUPPORTED = -147;
    public static final int UNEXPECTED_VICC_ID_IN_RESPONSE = -148;
    public static final int LOCKBLOCK_NOT_SUPPORTED = -150;
    public static final int INTERNAL_ERROR_SHOULD_NEVER_HAPPEN = -151;
    public static final int INVLD_BLOCK_MODE_COMBINATION = -152;
    public static final int INVLD_ACCESS_MODE_COMBINATION = -153;
    public static final int INVALID_SIZE = -154;
    public static final int BAD_PASSWORD_FORMAT = -155;
    public static final int RADIO_IS_OFF = -156;
    protected String _tagId = "";
    protected int _errCode = 0;
    protected int _errBlk = 0;
    protected String _errMsg = "";
    protected int _yapierr = 0;
    protected int _fab = 0;
    protected int _lab = 0;

    public String get_tagId() {
        return this._tagId;
    }

    public int get_errorCode() {
        return this._errCode;
    }

    public int get_errorBlock() {
        return this._errBlk;
    }

    public String get_errorMessage() {
        return this._errMsg;
    }

    public int get_yapiError() {
        return this._yapierr;
    }

    public int get_firstAffectedBlock() {
        return this._fab;
    }

    public int get_lastAffectedBlock() {
        return this._lab;
    }

    public void imm_init(String tagId, int errCode, int errBlk, int fab, int lab) {
        String errMsg;
        if (errCode == 0) {
            this._yapierr = 0;
            errMsg = "Success (no error)";
        } else {
            if (errCode < 0) {
                if (errCode > -50) {
                    this._yapierr = errCode;
                    errMsg = String.format(Locale.US, "YoctoLib error %d", errCode);
                } else {
                    this._yapierr = -17;
                    errMsg = String.format(Locale.US, "Non-recoverable RFID error %d", errCode);
                }
            } else if (errCode > 1000) {
                this._yapierr = -16;
                errMsg = String.format(Locale.US, "Recoverable RFID error %d", errCode);
            } else {
                this._yapierr = -17;
                errMsg = String.format(Locale.US, "Non-recoverable RFID error %d", errCode);
            }
            if (errCode == 1001) {
                errMsg = "Tag not found";
            }
            if (errCode == 1003) {
                errMsg = "Tag left during operation";
            }
            if (errCode == 1002) {
                errMsg = "Tag not here anymore";
            }
            if (errCode == 1000) {
                errMsg = "Reader is busy";
            }
            if (errCode == -66) {
                errMsg = "Invalid command arguments";
            }
            if (errCode == -67) {
                errMsg = "Unknown capabilities";
            }
            if (errCode == -68) {
                errMsg = "Memory no present";
            }
            if (errCode == -69) {
                errMsg = "Invalid block index";
            }
            if (errCode == -70) {
                errMsg = "Tag memory space overrun attempt";
            }
            if (errCode == 1) {
                errMsg = "The command is not supported";
            }
            if (errCode == 2) {
                errMsg = "The command is not recognized";
            }
            if (errCode == 3) {
                errMsg = "The command option is not supported.";
            }
            if (errCode == 4) {
                errMsg = "The command cannot be processed in time";
            }
            if (errCode == 15) {
                errMsg = "Error with no information given";
            }
            if (errCode == 16) {
                errMsg = "Block is not available";
            }
            if (errCode == 17) {
                errMsg = "Block / byte is already locked and thus cannot be locked again.";
            }
            if (errCode == 18) {
                errMsg = "Block / byte is locked and its content cannot be changed";
            }
            if (errCode == 19) {
                errMsg = "Block was not successfully programmed";
            }
            if (errCode == 20) {
                errMsg = "Block was not successfully locked";
            }
            if (errCode == 21) {
                errMsg = "Block is protected";
            }
            if (errCode == 64) {
                errMsg = "Generic cryptographic error";
            }
            if (errCode == -71) {
                errMsg = "BrownOut detected (BOD)";
            }
            if (errCode == -72) {
                errMsg = "Buffer Overflow (BOF)";
            }
            if (errCode == -73) {
                errMsg = "Communication CRC Error (CCE)";
            }
            if (errCode == 1007) {
                errMsg = "Collision Detected (CLD/CDT)";
            }
            if (errCode == -75) {
                errMsg = "Command Receive Timeout (CRT)";
            }
            if (errCode == -76) {
                errMsg = "Did Not Sleep (DNS)";
            }
            if (errCode == -77) {
                errMsg = "Error Decimal Expected (EDX)";
            }
            if (errCode == -78) {
                errMsg = "Error Hardware Failure (EHF)";
            }
            if (errCode == -79) {
                errMsg = "Error Hex Expected (EHX)";
            }
            if (errCode == -80) {
                errMsg = "FIFO length error (FLE)";
            }
            if (errCode == -81) {
                errMsg = "Framing error (FER)";
            }
            if (errCode == -82) {
                errMsg = "Not in CNR Mode (NCM)";
            }
            if (errCode == -83) {
                errMsg = "Number Out of Range (NOR)";
            }
            if (errCode == -84) {
                errMsg = "Not Supported (NOS)";
            }
            if (errCode == -85) {
                errMsg = "No RF field active (NRF)";
            }
            if (errCode == -86) {
                errMsg = "Read data length error (RDL)";
            }
            if (errCode == -87) {
                errMsg = "Watchdog reset (SRT)";
            }
            if (errCode == 1004) {
                errMsg = "Tag Communication Error (TCE)";
            }
            if (errCode == 1005) {
                errMsg = "Tag Not Responding (TNR)";
            }
            if (errCode == 1006) {
                errMsg = "TimeOut Error (TOE)";
            }
            if (errCode == -91) {
                errMsg = "Unknown Command (UCO)";
            }
            if (errCode == -92) {
                errMsg = "Unknown error (UER)";
            }
            if (errCode == -93) {
                errMsg = "Unknown Parameter (UPA)";
            }
            if (errCode == -94) {
                errMsg = "UART Receive Error (URE)";
            }
            if (errCode == -95) {
                errMsg = "Wrong Data Length (WDL)";
            }
            if (errCode == -96) {
                errMsg = "Wrong Mode (WMO)";
            }
            if (errCode == -97) {
                errMsg = "Unknown DWARF15 error code";
            }
            if (errCode == -99) {
                errMsg = "Unexpected Tag id in response";
            }
            if (errCode == -100) {
                errMsg = "internal error : unexpected TAG index";
            }
            if (errCode == -105) {
                errMsg = "transfer closed";
            }
            if (errCode == -103) {
                errMsg = "Missing write data";
            }
            if (errCode == -104) {
                errMsg = "Attempt to write too much data";
            }
            if (errCode == -106) {
                errMsg = "Could not not request";
            }
            if (errCode == -107) {
                errMsg = "Invalid transfer options";
            }
            if (errCode == -108) {
                errMsg = "Unexpected Tag response";
            }
            if (errCode == -109) {
                errMsg = "AFI not available";
            }
            if (errCode == -110) {
                errMsg = "DSFID not available";
            }
            if (errCode == -111) {
                errMsg = "Tag's response too short";
            }
            if (errCode == -112) {
                errMsg = "Error Decimal value Expected, or is missing";
            }
            if (errCode == -113) {
                errMsg = "Error Hexadecimal value Expected, or is missing";
            }
            if (errCode == -114) {
                errMsg = "Input and Output block are not in the same Sector";
            }
            if (errCode == -115) {
                errMsg = "No chip with MIFARE Classic technology Authenticated";
            }
            if (errCode == -116) {
                errMsg = "No Data Block";
            }
            if (errCode == -117) {
                errMsg = "Key B is Readable";
            }
            if (errCode == -118) {
                errMsg = "Operation Not Executed, would have caused an overflow";
            }
            if (errCode == -119) {
                errMsg = "Block has not been initialized as a 'value block'";
            }
            if (errCode == -120) {
                errMsg = "Block Not Writable";
            }
            if (errCode == -121) {
                errMsg = "Block Access Error";
            }
            if (errCode == -122) {
                errMsg = "Block Not Authenticated";
            }
            if (errCode == -123) {
                errMsg = "Access bits or Keys not Writable";
            }
            if (errCode == -124) {
                errMsg = "Use Key B for authentication";
            }
            if (errCode == -125) {
                errMsg = "Use Key A for authentication";
            }
            if (errCode == -126) {
                errMsg = "Key(s) not changeable";
            }
            if (errCode == -127) {
                errMsg = "Block index is too high";
            }
            if (errCode == -128) {
                errMsg = "Authentication Error (i.e. wrong key)";
            }
            if (errCode == -129) {
                errMsg = "No Key Select, select a temporary or a static key";
            }
            if (errCode == -130) {
                errMsg = " Card is Not Selected";
            }
            if (errCode == -131) {
                errMsg = "Number of Blocks to Read is 0";
            }
            if (errCode == -132) {
                errMsg = "No Tag detected";
            }
            if (errCode == -133) {
                errMsg = "Too Much Data (i.e. Uart input buffer overflow)";
            }
            if (errCode == -134) {
                errMsg = "Conditions Not Satisfied";
            }
            if (errCode == -135) {
                errMsg = "Bad parameter: block is a special block";
            }
            if (errCode == -136) {
                errMsg = "Attempt to read more than announced size.";
            }
            if (errCode == -137) {
                errMsg = "Block 0 is reserved and cannot be used";
            }
            if (errCode == -138) {
                errMsg = "One value block is not properly initialized";
            }
            if (errCode == -139) {
                errMsg = "Feature available on ISO 15693 only";
            }
            if (errCode == -140) {
                errMsg = "Feature available on ISO 14443 only";
            }
            if (errCode == -141) {
                errMsg = "Feature available on ISO 14443 MIFARE Classic only";
            }
            if (errCode == -142) {
                errMsg = "Block might be protected";
            }
            if (errCode == -143) {
                errMsg = "No such block";
            }
            if (errCode == -144) {
                errMsg = "Count parameter is too large";
            }
            if (errCode == -145) {
                errMsg = "Tag memory size is unknown";
            }
            if (errCode == -146) {
                errMsg = "Writing more than two blocks at once might not be supported by this tag";
            }
            if (errCode == -147) {
                errMsg = "Read/write operation not supported for this tag";
            }
            if (errCode == -148) {
                errMsg = "Unexpected VICC ID in response";
            }
            if (errCode == -150) {
                errMsg = "This tag does not support the Lock block function";
            }
            if (errCode == -151) {
                errMsg = "Yoctopuce RFID code ran into an unexpected state, please contact support";
            }
            if (errCode == -152) {
                errMsg = "Invalid combination of block mode options";
            }
            if (errCode == -153) {
                errMsg = "Invalid combination of access mode options";
            }
            if (errCode == -154) {
                errMsg = "Invalid data size parameter";
            }
            if (errCode == -155) {
                errMsg = "Bad password format or type";
            }
            if (errCode == -156) {
                errMsg = "Radio is OFF (refreshRate=0).";
            }
            if (errBlk >= 0) {
                errMsg = String.format(Locale.US, "%s (block %d)", errMsg, errBlk);
            }
        }
        this._tagId = tagId;
        this._errCode = errCode;
        this._errBlk = errBlk;
        this._errMsg = errMsg;
        this._fab = fab;
        this._lab = lab;
    }
}

