/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.WPEntry;
import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YFirmwareFile;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YJSONArray;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YPEntry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;

class YCallbackHub
extends YGenericHub {
    private final YGenericHub.HTTPParams _http_params;
    private final OutputStream _out;
    private YJSONObject _callbackCache;

    YCallbackHub(YAPIContext yctx, YGenericHub.HTTPParams httpParams, InputStream request, OutputStream response) throws YAPI_Exception {
        super(yctx, httpParams, true);
        this._http_params = httpParams;
        this._out = response;
        if (request == null || this._out == null) {
            throw new YAPI_Exception(-2, "Use RegisterHub(String url, BufferedReader request, PrintWriter response) to start api in callback");
        }
        try {
            this.loadCallbackCache(request);
        }
        catch (IOException ex) {
            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
        }
    }

    @Override
    public int get_connectionState() {
        return 2;
    }

    @Override
    void release() {
    }

    @Override
    String getRootUrl() {
        return this._http_params.getUrl();
    }

    @Override
    synchronized boolean isSameHub(String url, Object request, Object response, Object session) {
        boolean sameHub = super.isSameHub(url, request, response, session);
        OutputStream tmp = (OutputStream)response;
        return sameHub && tmp == this._out;
    }

    @Override
    void startNotifications() throws YAPI_Exception {
    }

    @Override
    void stopNotifications() {
    }

    private void _output(String msg) throws IOException {
        this._out.write(msg.getBytes(this._yctx._deviceCharset));
    }

    private void loadCallbackCache(InputStream in) throws YAPI_Exception, IOException {
        int nRead;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = in.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        String data_str = buffer.toString(this._yctx._defaultEncoding);
        if (data_str.length() == 0) {
            String errmsg = "RegisterHub(callback) used without posting YoctoAPI data";
            this._output("\n!YoctoAPI:" + errmsg + "\n");
            this._callbackCache = null;
            throw new YAPI_Exception(-8, errmsg);
        }
        try {
            this._callbackCache = new YJSONObject(data_str);
            this._callbackCache.parse();
        }
        catch (Exception ex) {
            String errmsg = "invalid data:[\n" + ex.toString() + data_str + "\n]";
            this._output("\n!YoctoAPI:" + errmsg + "\n");
            this._callbackCache = null;
            throw new YAPI_Exception(-8, errmsg);
        }
        if (!this._http_params.getPass().equals("")) {
            String salt;
            MessageDigest mdigest;
            try {
                mdigest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException ex) {
                throw new YAPI_Exception(-3, "No MD5 provider");
            }
            if (!this._callbackCache.has("sign")) {
                String errmsg = "missing signature from incoming YoctoHub (callback password required)";
                this._output("\n!YoctoAPI:" + errmsg + "\n");
                this._callbackCache = null;
                throw new YAPI_Exception(-12, errmsg);
            }
            String sign = this._callbackCache.getString("sign");
            String pass = this._http_params.getPass();
            if (pass.length() == 32) {
                salt = pass.toLowerCase();
            } else {
                mdigest.reset();
                mdigest.update(pass.getBytes(this._yctx._deviceCharset));
                byte[] md5pass = mdigest.digest();
                salt = YAPIContext._bytesToHexStr(md5pass, 0, md5pass.length).toLowerCase();
            }
            data_str = data_str.replace(sign, salt);
            mdigest.reset();
            mdigest.update(data_str.getBytes(this._yctx._deviceCharset));
            byte[] md5 = mdigest.digest();
            String check = YAPIContext._bytesToHexStr(md5, 0, md5.length).toLowerCase();
            if (!check.equals(sign)) {
                String errmsg = "invalid signature from incoming YoctoHub (invalid callback password)";
                this._output("\n!YoctoAPI:" + errmsg + "\n");
                this._callbackCache = null;
                throw new YAPI_Exception(-12, errmsg);
            }
        }
    }

    private byte[] cachedRequest(String query, byte[] header_and_body) throws YAPI_Exception, IOException {
        int endline = query.indexOf("\r");
        if (endline >= 0) {
            query = query.substring(0, endline);
        }
        if (query.startsWith("POST ")) {
            int body_start;
            int endb;
            String boundary = "???";
            for (endb = body_start = YAPIContext._find_in_bytes(header_and_body, "\r\n\r\n".getBytes(this._yctx._deviceCharset)) + 4; endb < header_and_body.length && header_and_body[endb] != 13; ++endb) {
            }
            String tmp = new String(header_and_body, body_start, 2);
            if (tmp.equals("--") && endb > body_start + 2 && endb < body_start + 20) {
                boundary = new String(header_and_body, body_start + 2, endb - body_start - 2);
            }
            int bodylen = header_and_body.length - body_start;
            this._output("\n@YoctoAPI:" + query + " " + Integer.toString(bodylen) + ":" + boundary + "\n");
            this._out.write(header_and_body, body_start, bodylen);
            return "".getBytes(this._yctx._deviceCharset);
        }
        if (!query.startsWith("GET ")) {
            return null;
        }
        int jzon = query.indexOf("?fw=");
        if (jzon >= 0 && query.indexOf(38, jzon) < 0) {
            query = query.substring(0, jzon);
        }
        if (!query.contains("?") || query.contains("/logs.txt") || query.contains("/logger.json") || query.contains("/ping.txt") || query.contains("/files.json?a=dir")) {
            try {
                String[] parts = query.split(" ");
                String url = parts[1];
                boolean getmodule = url.contains("api/module.json");
                if (getmodule) {
                    url = url.replace("api/module.json", "api.json");
                }
                if (!this._callbackCache.has(url)) {
                    this._output("\n!YoctoAPI:" + url + " is not preloaded, adding to list");
                    this._output("\n@YoctoAPI:+" + url + "\n");
                    return null;
                }
                YJSONObject jsonres = this._callbackCache.getYJSONObject(url);
                if (getmodule) {
                    jsonres = jsonres.getYJSONObject("module");
                }
                return jsonres.toJSON();
            }
            catch (Exception ex) {
                return "".getBytes();
            }
        }
        this._output("\n@YoctoAPI:" + query + "\n");
        return "".getBytes(this._yctx._deviceCharset);
    }

    @Override
    synchronized void updateDeviceList(boolean forceupdate) throws YAPI_Exception {
        String yreq;
        long now = YAPI.GetTickCount();
        if (forceupdate) {
            this._devListExpires = 0L;
        }
        if (this._devListExpires > now) {
            return;
        }
        try {
            byte[] data = this.cachedRequest("GET /api.json\r\n", null);
            if (data == null) {
                throw new YAPI_Exception(-8, "no cached request for GET /api.json");
            }
            yreq = new String(data);
        }
        catch (IOException ex) {
            this.saveLastError(-8, ex.getLocalizedMessage(), ex);
            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
        }
        HashMap<String, ArrayList<YPEntry>> yellowPages = new HashMap<String, ArrayList<YPEntry>>();
        ArrayList<WPEntry> whitePages = new ArrayList<WPEntry>();
        try {
            YJSONObject loadval = new YJSONObject(yreq);
            loadval.parse();
            if (!loadval.has("services") || !loadval.getYJSONObject("services").has("whitePages")) {
                String message = "Device " + this._http_params.getHost() + " is not a hub";
                this.saveLastError(-2, message, null);
                throw new YAPI_Exception(-2, message);
            }
            YJSONArray whitePages_json = loadval.getYJSONObject("services").getYJSONArray("whitePages");
            YJSONObject yellowPages_json = loadval.getYJSONObject("services").getYJSONObject("yellowPages");
            Set<String> keys = yellowPages_json.getKeys();
            for (String classname : keys) {
                YJSONArray yprecs_json = yellowPages_json.getYJSONArray(classname);
                ArrayList<YPEntry> yprecs_arr = new ArrayList<YPEntry>(yprecs_json.length());
                for (int i = 0; i < yprecs_json.length(); ++i) {
                    YPEntry yprec = new YPEntry(yprecs_json.getYJSONObject(i));
                    yprecs_arr.add(yprec);
                }
                yellowPages.put(classname, yprecs_arr);
            }
            for (int i = 0; i < whitePages_json.length(); ++i) {
                YJSONObject jsonObject = whitePages_json.getYJSONObject(i);
                WPEntry devinfo = new WPEntry(jsonObject);
                int index = jsonObject.getInt("index");
                this._serialByYdx.put(index, devinfo.getSerialNumber());
                whitePages.add(devinfo);
            }
        }
        catch (Exception e) {
            String message = "Request failed, could not parse API result for " + this._http_params.getHost();
            this.saveLastError(-8, message, e);
            throw new YAPI_Exception(-8, message, e);
        }
        this.updateFromWpAndYp(whitePages, yellowPages);
        this.saveLastError(0, "", null);
        now = YAPI.GetTickCount();
        this._devListExpires = now + 500L;
    }

    @Override
    public ArrayList<String> getBootloaders() throws YAPI_Exception {
        throw new YAPI_Exception(-3, "Firmware update is not supported in HTTP callback");
    }

    @Override
    public int ping(int mstimeout) throws YAPI_Exception {
        throw new YAPI_Exception(-3, "Not yet implemented");
    }

    @Override
    boolean isCallbackMode() {
        return true;
    }

    @Override
    boolean isReadOnly() {
        return false;
    }

    @Override
    public boolean isOnline() {
        return true;
    }

    @Override
    public String getConnectionUrl() {
        return this._URL_params.getUrl(true, false, true);
    }

    @Override
    ArrayList<String> firmwareUpdate(String serial, YFirmwareFile firmware, byte[] settings, YGenericHub.UpdateProgress progress) throws YAPI_Exception, InterruptedException {
        throw new YAPI_Exception(-3, "Firmware update is not supported in HTTP callback");
    }

    @Override
    void devRequestAsync(YDevice device, String req_first_line, byte[] req_head_and_body, YGenericHub.RequestAsyncResult asyncResult, Object asyncContext) throws YAPI_Exception {
        try {
            this.cachedRequest(req_first_line, req_head_and_body);
        }
        catch (IOException ex) {
            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
        }
    }

    @Override
    byte[] devRequestSync(YDevice device, String req_first_line, byte[] req_head_and_body, YGenericHub.RequestProgress progress, Object context) throws YAPI_Exception {
        try {
            return this.cachedRequest(req_first_line, req_head_and_body);
        }
        catch (IOException ex) {
            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
        }
    }
}

