/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.NotificationHandler;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDevice;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YHTTPHub;
import com.yoctopuce.YoctoAPI.yHTTPRequest;
import java.util.HashMap;
import java.util.Locale;

class TCPNotificationHandler
extends NotificationHandler {
    private HashMap<YDevice, yHTTPRequest> _httpReqByDev = new HashMap();

    TCPNotificationHandler(YHTTPHub hub) {
        super(hub);
    }

    @Override
    String getThreadLabel() {
        return "TCPNotHandler_" + this._hub._runtime_http_params.toString();
    }

    @Override
    public void run(long expiration) {
        int firt_try = 1;
        yHTTPRequest yreq = new yHTTPRequest(this._hub, "Notification of " + this._hub.getRootUrl());
        while (this._hub.workerThreadMustContinue()) {
            if (this._error_delay > 0) {
                try {
                    Thread.sleep(this._error_delay);
                }
                catch (InterruptedException ex) {
                    this._hub.set_connectionState(4);
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            try {
                String notUrl;
                if (firt_try > 0) {
                    if (System.currentTimeMillis() > expiration) {
                        throw new YAPI_Exception(-7, "Unable to start the request in time");
                    }
                    this._hub.set_connectionState(1);
                    firt_try = 0;
                } else {
                    this._hub.set_connectionState(3);
                }
                yreq._requestReserve();
                if (this._notifyPos < 0L) {
                    notUrl = "GET /not.byn";
                    this._hub.dbglog(4, "request /not.byn");
                } else {
                    notUrl = String.format(Locale.US, "GET /not.byn?abs=%d", this._notifyPos);
                    this._hub.dbglog(4, String.format("request /not.byn?abs=%d", this._notifyPos));
                }
                yreq._requestStart(notUrl, null, 0L, null, null);
                this._hub.set_connectionState(2);
                String fifo = "";
                do {
                    int pos;
                    try {
                        this._hub.testLogPull();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        Thread.currentThread().interrupt();
                        throw new YAPI_Exception(e.getLocalizedMessage());
                    }
                    yreq._requestProcesss();
                    byte[] partial = yreq.getPartialResult();
                    if (partial != null) {
                        fifo = fifo + new String(partial);
                    }
                    while ((pos = fifo.indexOf("\n")) >= 0) {
                        String line = fifo.substring(0, pos + 1);
                        if (line.indexOf(27) == -1) {
                            this.handleNetNotification(line);
                        }
                        fifo = fifo.substring(pos + 1);
                        if (pos >= 0) continue;
                    }
                    this._error_delay = 0;
                } while (this._hub.workerThreadMustContinue());
                yreq._requestStop();
                yreq._requestRelease();
            }
            catch (YAPI_Exception ex) {
                if (ex.errorType == -12 || ex.errorType == -20) break;
                this._hub.set_connectionState(3);
                ++this._notifRetryCount;
                this._hub._isNotifWorking = false;
                this._error_delay = 100 << (this._notifRetryCount > 4 ? 4 : this._notifRetryCount);
            }
        }
        this._hub.set_connectionState(4);
        yreq._requestStop();
        yreq._requestRelease();
    }

    @Override
    byte[] hubRequestSync(String req_first_line, byte[] req_head_and_body, int mstimeout) throws YAPI_Exception {
        yHTTPRequest req = new yHTTPRequest(this._hub, "request to " + this._hub.getHost());
        return req.RequestSync(req_first_line, req_head_and_body, mstimeout);
    }

    @Override
    byte[] devRequestSync(YDevice device, String req_first_line, byte[] req_head_and_body, int mstimeout, YGenericHub.RequestProgress progress, Object context) throws YAPI_Exception {
        if (!this._httpReqByDev.containsKey(device)) {
            this._httpReqByDev.put(device, new yHTTPRequest(this._hub, "Device " + device.getSerialNumber()));
        }
        yHTTPRequest req = this._httpReqByDev.get(device);
        return req.RequestSync(req_first_line, req_head_and_body, mstimeout);
    }

    @Override
    void devRequestAsync(YDevice device, String req_first_line, byte[] req_head_and_body, YGenericHub.RequestAsyncResult asyncResult, Object asyncContext) throws YAPI_Exception {
        if (!this._httpReqByDev.containsKey(device)) {
            this._httpReqByDev.put(device, new yHTTPRequest(this._hub, "Device " + device.getSerialNumber()));
        }
        yHTTPRequest req = this._httpReqByDev.get(device);
        req.RequestAsync(req_first_line, req_head_and_body, asyncResult, asyncContext);
    }

    @Override
    boolean waitAndFreeAsyncTasks(long timeout) throws InterruptedException {
        for (yHTTPRequest req : this._httpReqByDev.values()) {
            req.WaitRequestEnd(timeout);
        }
        return false;
    }

    @Override
    void stopSocketsOfThread() {
    }

    @Override
    public boolean hasRwAccess() {
        return this._hub._runtime_http_params.getUser().equals("admin");
    }
}

