/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YRfidOptions;
import com.yoctopuce.YoctoAPI.YRfidStatus;
import com.yoctopuce.YoctoAPI.YRfidTagInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class YRfidReader
extends YFunction {
    public static final int NTAGS_INVALID = -1;
    public static final int REFRESHRATE_INVALID = -1;
    protected int _nTags = -1;
    protected int _refreshRate = -1;
    protected UpdateCallback _valueCallbackRfidReader = null;
    protected YEventCallback _eventCallback;
    protected boolean _isFirstCb;
    protected int _prevCbPos = 0;
    protected int _eventPos = 0;
    protected int _eventStamp = 0;
    private UpdateCallback yInternalEventCallback = new UpdateCallback(){

        @Override
        public void yNewValue(YRfidReader obj, String value) {
            try {
                obj._internalEventHandler(value);
            }
            catch (YAPI_Exception e) {
                e.printStackTrace();
            }
        }
    };

    protected YRfidReader(YAPIContext ctx, String func) {
        super(ctx, func);
        this._className = "RfidReader";
    }

    protected YRfidReader(String func) {
        this(YAPI.GetYCtx(true), func);
    }

    @Override
    protected void _parseAttr(YJSONObject json_val) throws Exception {
        if (json_val.has("nTags")) {
            this._nTags = json_val.getInt("nTags");
        }
        if (json_val.has("refreshRate")) {
            this._refreshRate = json_val.getInt("refreshRate");
        }
        super._parseAttr(json_val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_nTags() throws YAPI_Exception {
        int res;
        YRfidReader yRfidReader = this;
        synchronized (yRfidReader) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._nTags;
        }
        return res;
    }

    public int getNTags() throws YAPI_Exception {
        return this.get_nTags();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_refreshRate() throws YAPI_Exception {
        int res;
        YRfidReader yRfidReader = this;
        synchronized (yRfidReader) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._refreshRate;
        }
        return res;
    }

    public int getRefreshRate() throws YAPI_Exception {
        return this.get_refreshRate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_refreshRate(int newval) throws YAPI_Exception {
        YRfidReader yRfidReader = this;
        synchronized (yRfidReader) {
            String rest_val = Integer.toString(newval);
            this._setAttr("refreshRate", rest_val);
        }
        return 0;
    }

    public int setRefreshRate(int newval) throws YAPI_Exception {
        return this.set_refreshRate(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YRfidReader FindRfidReader(String func) {
        YRfidReader obj;
        YAPIContext ctx = YAPI.GetYCtx(true);
        Object object = ctx._functionCacheLock;
        synchronized (object) {
            obj = (YRfidReader)YFunction._FindFromCache("RfidReader", func);
            if (obj == null) {
                obj = new YRfidReader(func);
                YFunction._AddToCache("RfidReader", func, obj);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YRfidReader FindRfidReaderInContext(YAPIContext yctx, String func) {
        YRfidReader obj;
        Object object = yctx._functionCacheLock;
        synchronized (object) {
            obj = (YRfidReader)YFunction._FindFromCacheInContext(yctx, "RfidReader", func);
            if (obj == null) {
                obj = new YRfidReader(yctx, func);
                YFunction._AddToCache("RfidReader", func, obj);
            }
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackRfidReader = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackRfidReader != null) {
            this._valueCallbackRfidReader.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int _chkerror(String tagId, byte[] json, YRfidStatus status) throws YAPI_Exception {
        int lab;
        int fab;
        int errBlk;
        int errCode;
        if (json.length == 0) {
            errCode = this.get_errorType();
            errBlk = -1;
            fab = -1;
            lab = -1;
        } else {
            String jsonStr = new String(json, this._yapi._deviceCharset);
            errCode = YAPIContext._atoi(this._json_get_key(json, "err"));
            errBlk = YAPIContext._atoi(this._json_get_key(json, "errBlk")) - 1;
            if (jsonStr.indexOf("\"fab\":") >= 0) {
                fab = YAPIContext._atoi(this._json_get_key(json, "fab")) - 1;
                lab = YAPIContext._atoi(this._json_get_key(json, "lab")) - 1;
            } else {
                fab = -1;
                lab = -1;
            }
        }
        status.imm_init(tagId, errCode, errBlk, fab, lab);
        int retcode = status.get_yapiError();
        if (retcode != 0) {
            throw new YAPI_Exception(retcode, status.get_errorMessage());
        }
        return 0;
    }

    public int reset() throws YAPI_Exception {
        YRfidStatus status = new YRfidStatus();
        byte[] json = this._download("rfid.json?a=reset");
        return this._chkerror("", json, status);
    }

    public ArrayList<String> get_tagIdList() throws YAPI_Exception {
        ArrayList<Object> jsonList = new ArrayList();
        ArrayList<String> taglist = new ArrayList<String>();
        byte[] json = this._download("rfid.json?a=list");
        taglist.clear();
        if (json.length > 3) {
            jsonList = this._json_get_array(json);
            for (byte[] byArray : jsonList) {
                taglist.add(this._json_get_string(byArray));
            }
        }
        return taglist;
    }

    public YRfidTagInfo get_tagInfo(String tagId, YRfidStatus status) throws YAPI_Exception {
        String url = String.format(Locale.US, "rfid.json?a=info&t=%s", tagId);
        byte[] json = this._download(url);
        this._chkerror(tagId, json, status);
        int tagType = YAPIContext._atoi(this._json_get_key(json, "type"));
        int size = YAPIContext._atoi(this._json_get_key(json, "size"));
        int usable = YAPIContext._atoi(this._json_get_key(json, "usable"));
        int blksize = YAPIContext._atoi(this._json_get_key(json, "blksize"));
        int fblk = YAPIContext._atoi(this._json_get_key(json, "fblk"));
        int lblk = YAPIContext._atoi(this._json_get_key(json, "lblk"));
        YRfidTagInfo res = new YRfidTagInfo();
        res.imm_init(tagId, tagType, size, usable, blksize, fblk, lblk);
        return res;
    }

    public int tagLockBlocks(String tagId, int firstBlock, int nBlocks, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        String optstr = options.imm_getParams();
        String url = String.format(Locale.US, "rfid.json?a=lock&t=%s&b=%d&n=%d%s", tagId, firstBlock, nBlocks, optstr);
        byte[] json = this._download(url);
        return this._chkerror(tagId, json, status);
    }

    public ArrayList<Boolean> get_tagLockState(String tagId, int firstBlock, int nBlocks, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        ArrayList<Boolean> res = new ArrayList<Boolean>();
        String optstr = options.imm_getParams();
        String url = String.format(Locale.US, "rfid.json?a=chkl&t=%s&b=%d&n=%d%s", tagId, firstBlock, nBlocks, optstr);
        byte[] json = this._download(url);
        this._chkerror(tagId, json, status);
        if (status.get_yapiError() != 0) {
            return res;
        }
        byte[] binRes = YAPIContext._hexStrToBin(this._json_get_key(json, "bitmap"));
        for (int idx = 0; idx < nBlocks; ++idx) {
            int val = binRes[idx >> 3] & 0xFF;
            boolean isLocked = (val & 1 << (idx & 7)) != 0;
            res.add(isLocked);
        }
        return res;
    }

    public ArrayList<Boolean> get_tagSpecialBlocks(String tagId, int firstBlock, int nBlocks, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        ArrayList<Boolean> res = new ArrayList<Boolean>();
        String optstr = options.imm_getParams();
        String url = String.format(Locale.US, "rfid.json?a=chks&t=%s&b=%d&n=%d%s", tagId, firstBlock, nBlocks, optstr);
        byte[] json = this._download(url);
        this._chkerror(tagId, json, status);
        if (status.get_yapiError() != 0) {
            return res;
        }
        byte[] binRes = YAPIContext._hexStrToBin(this._json_get_key(json, "bitmap"));
        for (int idx = 0; idx < nBlocks; ++idx) {
            int val = binRes[idx >> 3] & 0xFF;
            boolean isLocked = (val & 1 << (idx & 7)) != 0;
            res.add(isLocked);
        }
        return res;
    }

    public String tagReadHex(String tagId, int firstBlock, int nBytes, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        String optstr = options.imm_getParams();
        String url = String.format(Locale.US, "rfid.json?a=read&t=%s&b=%d&n=%d%s", tagId, firstBlock, nBytes, optstr);
        byte[] json = this._download(url);
        this._chkerror(tagId, json, status);
        String hexbuf = status.get_yapiError() == 0 ? this._json_get_key(json, "res") : "";
        return hexbuf;
    }

    public byte[] tagReadBin(String tagId, int firstBlock, int nBytes, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        return YAPIContext._hexStrToBin(this.tagReadHex(tagId, firstBlock, nBytes, options, status));
    }

    public ArrayList<Integer> tagReadArray(String tagId, int firstBlock, int nBytes, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        ArrayList<Integer> res = new ArrayList<Integer>();
        byte[] blk = this.tagReadBin(tagId, firstBlock, nBytes, options, status);
        int endidx = blk.length;
        for (int idx = 0; idx < endidx; ++idx) {
            res.add(blk[idx] & 0xFF);
        }
        return res;
    }

    public String tagReadStr(String tagId, int firstBlock, int nChars, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        return new String(this.tagReadBin(tagId, firstBlock, nChars, options, status), this._yapi._deviceCharset);
    }

    public int tagWriteBin(String tagId, int firstBlock, byte[] buff, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        int buflen = buff.length;
        if (buflen <= 16) {
            String hexstr = YAPIContext._bytesToHexStr(buff, 0, buff.length);
            return this.tagWriteHex(tagId, firstBlock, hexstr, options, status);
        }
        String optstr = options.imm_getParams();
        String fname = String.format(Locale.US, "Rfid:t=%s&b=%d&n=%d%s", tagId, firstBlock, buflen, optstr);
        byte[] json = this._uploadEx(fname, buff);
        return this._chkerror(tagId, json, status);
    }

    public int tagWriteArray(String tagId, int firstBlock, ArrayList<Integer> byteList, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        int bufflen = byteList.size();
        byte[] buff = new byte[bufflen];
        for (int idx = 0; idx < bufflen; ++idx) {
            int hexb = byteList.get(idx);
            buff[idx] = (byte)(hexb & 0xFF);
        }
        return this.tagWriteBin(tagId, firstBlock, buff, options, status);
    }

    public int tagWriteHex(String tagId, int firstBlock, String hexString, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        int bufflen = hexString.length();
        if ((bufflen >>= 1) <= 16) {
            String optstr = options.imm_getParams();
            String url = String.format(Locale.US, "rfid.json?a=writ&t=%s&b=%d&w=%s%s", tagId, firstBlock, hexString, optstr);
            byte[] json = this._download(url);
            return this._chkerror(tagId, json, status);
        }
        byte[] buff = new byte[bufflen];
        for (int idx = 0; idx < bufflen; ++idx) {
            int hexb = Integer.valueOf(hexString.substring(2 * idx, 2 * idx + 2), 16);
            buff[idx] = (byte)(hexb & 0xFF);
        }
        return this.tagWriteBin(tagId, firstBlock, buff, options, status);
    }

    public int tagWriteStr(String tagId, int firstBlock, String text, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        byte[] buff = text.getBytes(this._yapi._deviceCharset);
        return this.tagWriteBin(tagId, firstBlock, buff, options, status);
    }

    public int tagGetAFI(String tagId, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        String optstr = options.imm_getParams();
        String url = String.format(Locale.US, "rfid.json?a=rdsf&t=%s&b=0%s", tagId, optstr);
        byte[] json = this._download(url);
        this._chkerror(tagId, json, status);
        int res = status.get_yapiError() == 0 ? YAPIContext._atoi(this._json_get_key(json, "res")) : status.get_yapiError();
        return res;
    }

    public int tagSetAFI(String tagId, int afi, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        String optstr = options.imm_getParams();
        String url = String.format(Locale.US, "rfid.json?a=wrsf&t=%s&b=0&v=%d%s", tagId, afi, optstr);
        byte[] json = this._download(url);
        return this._chkerror(tagId, json, status);
    }

    public int tagLockAFI(String tagId, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        String optstr = options.imm_getParams();
        String url = String.format(Locale.US, "rfid.json?a=lksf&t=%s&b=0%s", tagId, optstr);
        byte[] json = this._download(url);
        return this._chkerror(tagId, json, status);
    }

    public int tagGetDSFID(String tagId, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        String optstr = options.imm_getParams();
        String url = String.format(Locale.US, "rfid.json?a=rdsf&t=%s&b=1%s", tagId, optstr);
        byte[] json = this._download(url);
        this._chkerror(tagId, json, status);
        int res = status.get_yapiError() == 0 ? YAPIContext._atoi(this._json_get_key(json, "res")) : status.get_yapiError();
        return res;
    }

    public int tagSetDSFID(String tagId, int dsfid, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        String optstr = options.imm_getParams();
        String url = String.format(Locale.US, "rfid.json?a=wrsf&t=%s&b=1&v=%d%s", tagId, dsfid, optstr);
        byte[] json = this._download(url);
        return this._chkerror(tagId, json, status);
    }

    public int tagLockDSFID(String tagId, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        String optstr = options.imm_getParams();
        String url = String.format(Locale.US, "rfid.json?a=lksf&t=%s&b=1%s", tagId, optstr);
        byte[] json = this._download(url);
        return this._chkerror(tagId, json, status);
    }

    public String get_lastEvents() throws YAPI_Exception {
        byte[] content = this._download("events.txt?pos=0");
        return new String(content, this._yapi._deviceCharset);
    }

    public int registerEventCallback(YEventCallback callback) throws YAPI_Exception {
        this._eventCallback = callback;
        this._isFirstCb = true;
        if (callback != null) {
            this.registerValueCallback(this.yInternalEventCallback);
        } else {
            this.registerValueCallback((UpdateCallback)null);
        }
        return 0;
    }

    public int _internalEventHandler(String cbVal) throws YAPI_Exception {
        int arrPos;
        int arrLen;
        ArrayList<Object> eventArr = new ArrayList();
        int cbPos = YAPIContext._atoi(cbVal);
        int cbDPos = (cbPos /= 1000) - this._prevCbPos & 0x7FFFF;
        this._prevCbPos = cbPos;
        if (cbDPos > 16384) {
            this._eventPos = 0;
        }
        if (this._eventCallback == null) {
            return 0;
        }
        if (this._isFirstCb) {
            this._isFirstCb = false;
            this._eventStamp = 0;
            content = this._download("events.txt");
            contentStr = new String(content, this._yapi._deviceCharset);
            eventArr = new ArrayList<String>(Arrays.asList(contentStr.split("\n")));
            arrLen = eventArr.size();
            if (arrLen <= 0) {
                throw new YAPI_Exception(-8, "fail to download events");
            }
            arrPos = 1;
            lenStr = (String)eventArr.get(0);
            lenStr = lenStr.substring(1, 1 + lenStr.length() - 1);
            this._eventPos = YAPIContext._atoi(lenStr);
        } else {
            String url = String.format(Locale.US, "events.txt?pos=%d", this._eventPos);
            content = this._download(url);
            contentStr = new String(content, this._yapi._deviceCharset);
            eventArr = new ArrayList<String>(Arrays.asList(contentStr.split("\n")));
            arrLen = eventArr.size();
            if (arrLen <= 0) {
                throw new YAPI_Exception(-8, "fail to download events");
            }
            arrPos = 0;
            lenStr = (String)eventArr.get(--arrLen);
            lenStr = lenStr.substring(1, 1 + lenStr.length() - 1);
            this._eventPos = YAPIContext._atoi(lenStr);
        }
        while (arrPos < arrLen) {
            String hexStamp;
            int intStamp;
            String eventStr = (String)eventArr.get(arrPos);
            int eventLen = eventStr.length();
            int typePos = eventStr.indexOf(":") + 1;
            if (eventLen >= 14 && typePos > 10 && (intStamp = Integer.valueOf(hexStamp = eventStr.substring(0, 8), 16).intValue()) >= this._eventStamp) {
                this._eventStamp = intStamp;
                byte[] binMStamp = eventStr.substring(8, 10).getBytes(this._yapi._deviceCharset);
                int msStamp = ((binMStamp[0] & 0xFF) - 64) * 32 + (binMStamp[1] & 0xFF);
                double evtStamp = (double)intStamp + 0.001 * (double)msStamp;
                int dataPos = eventStr.indexOf("=") + 1;
                String evtType = eventStr.substring(typePos, typePos + 1);
                String evtData = "";
                if (dataPos > 10) {
                    evtData = eventStr.substring(dataPos, dataPos + eventLen - dataPos);
                }
                if (this._eventCallback != null) {
                    this._eventCallback.eventCallback(this, evtStamp, evtType, evtData);
                }
            }
            ++arrPos;
        }
        return 0;
    }

    public YRfidReader nextRfidReader() {
        String next_hwid;
        try {
            String hwid = this._yapi._yHash.resolveHwID(this._className, this._func);
            next_hwid = this._yapi._yHash.getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YRfidReader.FindRfidReaderInContext(this._yapi, next_hwid);
    }

    public static YRfidReader FirstRfidReader() {
        YAPIContext yctx = YAPI.GetYCtx(false);
        if (yctx == null) {
            return null;
        }
        String next_hwid = yctx._yHash.getFirstHardwareId("RfidReader");
        if (next_hwid == null) {
            return null;
        }
        return YRfidReader.FindRfidReaderInContext(yctx, next_hwid);
    }

    public static YRfidReader FirstRfidReaderInContext(YAPIContext yctx) {
        String next_hwid = yctx._yHash.getFirstHardwareId("RfidReader");
        if (next_hwid == null) {
            return null;
        }
        return YRfidReader.FindRfidReaderInContext(yctx, next_hwid);
    }

    public static interface UpdateCallback {
        public void yNewValue(YRfidReader var1, String var2);
    }

    public static interface YEventCallback {
        public void eventCallback(YRfidReader var1, double var2, String var4, String var5);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YRfidReader var1, YMeasure var2);
    }
}

