/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YMeasure;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class YMicroPython
extends YFunction {
    public static final String LASTMSG_INVALID = "!INVALID!";
    public static final int HEAPUSAGE_INVALID = -1;
    public static final int XHEAPUSAGE_INVALID = -1;
    public static final String CURRENTSCRIPT_INVALID = "!INVALID!";
    public static final String STARTUPSCRIPT_INVALID = "!INVALID!";
    public static final int DEBUGMODE_OFF = 0;
    public static final int DEBUGMODE_ON = 1;
    public static final int DEBUGMODE_INVALID = -1;
    public static final String COMMAND_INVALID = "!INVALID!";
    protected String _lastMsg = "!INVALID!";
    protected int _heapUsage = -1;
    protected int _xheapUsage = -1;
    protected String _currentScript = "!INVALID!";
    protected String _startupScript = "!INVALID!";
    protected int _debugMode = -1;
    protected String _command = "!INVALID!";
    protected UpdateCallback _valueCallbackMicroPython = null;
    protected YMicroPythonLogCallback _logCallback;
    protected boolean _isFirstCb;
    protected int _prevCbPos = 0;
    protected int _logPos = 0;
    protected String _prevPartialLog;
    private UpdateCallback yInternalEventCallback = new UpdateCallback(){

        @Override
        public void yNewValue(YMicroPython obj, String value) {
            try {
                obj._internalEventHandler(value);
            }
            catch (YAPI_Exception e) {
                e.printStackTrace();
            }
        }
    };

    protected YMicroPython(YAPIContext ctx, String func) {
        super(ctx, func);
        this._className = "MicroPython";
    }

    protected YMicroPython(String func) {
        this(YAPI.GetYCtx(true), func);
    }

    @Override
    protected void _parseAttr(YJSONObject json_val) throws Exception {
        if (json_val.has("lastMsg")) {
            this._lastMsg = json_val.getString("lastMsg");
        }
        if (json_val.has("heapUsage")) {
            this._heapUsage = json_val.getInt("heapUsage");
        }
        if (json_val.has("xheapUsage")) {
            this._xheapUsage = json_val.getInt("xheapUsage");
        }
        if (json_val.has("currentScript")) {
            this._currentScript = json_val.getString("currentScript");
        }
        if (json_val.has("startupScript")) {
            this._startupScript = json_val.getString("startupScript");
        }
        if (json_val.has("debugMode")) {
            int n = this._debugMode = json_val.getInt("debugMode") > 0 ? 1 : 0;
        }
        if (json_val.has("command")) {
            this._command = json_val.getString("command");
        }
        super._parseAttr(json_val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_lastMsg() throws YAPI_Exception {
        String res;
        YMicroPython yMicroPython = this;
        synchronized (yMicroPython) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._lastMsg;
        }
        return res;
    }

    public String getLastMsg() throws YAPI_Exception {
        return this.get_lastMsg();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_heapUsage() throws YAPI_Exception {
        int res;
        YMicroPython yMicroPython = this;
        synchronized (yMicroPython) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._heapUsage;
        }
        return res;
    }

    public int getHeapUsage() throws YAPI_Exception {
        return this.get_heapUsage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_xheapUsage() throws YAPI_Exception {
        int res;
        YMicroPython yMicroPython = this;
        synchronized (yMicroPython) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._xheapUsage;
        }
        return res;
    }

    public int getXheapUsage() throws YAPI_Exception {
        return this.get_xheapUsage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_currentScript() throws YAPI_Exception {
        String res;
        YMicroPython yMicroPython = this;
        synchronized (yMicroPython) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._currentScript;
        }
        return res;
    }

    public String getCurrentScript() throws YAPI_Exception {
        return this.get_currentScript();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_currentScript(String newval) throws YAPI_Exception {
        YMicroPython yMicroPython = this;
        synchronized (yMicroPython) {
            String rest_val = newval;
            this._setAttr("currentScript", rest_val);
        }
        return 0;
    }

    public int setCurrentScript(String newval) throws YAPI_Exception {
        return this.set_currentScript(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_startupScript() throws YAPI_Exception {
        String res;
        YMicroPython yMicroPython = this;
        synchronized (yMicroPython) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._startupScript;
        }
        return res;
    }

    public String getStartupScript() throws YAPI_Exception {
        return this.get_startupScript();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_startupScript(String newval) throws YAPI_Exception {
        YMicroPython yMicroPython = this;
        synchronized (yMicroPython) {
            String rest_val = newval;
            this._setAttr("startupScript", rest_val);
        }
        return 0;
    }

    public int setStartupScript(String newval) throws YAPI_Exception {
        return this.set_startupScript(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_debugMode() throws YAPI_Exception {
        int res;
        YMicroPython yMicroPython = this;
        synchronized (yMicroPython) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._debugMode;
        }
        return res;
    }

    public int getDebugMode() throws YAPI_Exception {
        return this.get_debugMode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_debugMode(int newval) throws YAPI_Exception {
        YMicroPython yMicroPython = this;
        synchronized (yMicroPython) {
            String rest_val = newval > 0 ? "1" : "0";
            this._setAttr("debugMode", rest_val);
        }
        return 0;
    }

    public int setDebugMode(int newval) throws YAPI_Exception {
        return this.set_debugMode(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_command() throws YAPI_Exception {
        String res;
        YMicroPython yMicroPython = this;
        synchronized (yMicroPython) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._command;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_command(String newval) throws YAPI_Exception {
        YMicroPython yMicroPython = this;
        synchronized (yMicroPython) {
            String rest_val = newval;
            this._setAttr("command", rest_val);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YMicroPython FindMicroPython(String func) {
        YMicroPython obj;
        YAPIContext ctx = YAPI.GetYCtx(true);
        Object object = ctx._functionCacheLock;
        synchronized (object) {
            obj = (YMicroPython)YFunction._FindFromCache("MicroPython", func);
            if (obj == null) {
                obj = new YMicroPython(func);
                YFunction._AddToCache("MicroPython", func, obj);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YMicroPython FindMicroPythonInContext(YAPIContext yctx, String func) {
        YMicroPython obj;
        Object object = yctx._functionCacheLock;
        synchronized (object) {
            obj = (YMicroPython)YFunction._FindFromCacheInContext(yctx, "MicroPython", func);
            if (obj == null) {
                obj = new YMicroPython(yctx, func);
                YFunction._AddToCache("MicroPython", func, obj);
            }
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackMicroPython = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackMicroPython != null) {
            this._valueCallbackMicroPython.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int eval(String codeName, String mpyCode) throws YAPI_Exception {
        String fullname = String.format(Locale.US, "mpy:%s", codeName);
        int res = this._upload(fullname, mpyCode.getBytes(this._yapi._deviceCharset));
        return res;
    }

    public int reset() throws YAPI_Exception {
        int res = this.set_command("Z");
        if (res != 0) {
            throw new YAPI_Exception(-8, "unable to trigger MicroPython reset");
        }
        String state = this.get_advertisedValue().substring(0, 1);
        while (!state.equals("z")) {
            YAPI.Sleep(50L);
            state = this.get_advertisedValue().substring(0, 1);
        }
        return 0;
    }

    public String get_lastLogs() throws YAPI_Exception {
        int bufflen;
        byte[] buff = new byte[]{};
        buff = this._download("mpy.txt");
        for (bufflen = buff.length - 1; bufflen > 0 && (buff[bufflen] & 0xFF) != 64; --bufflen) {
        }
        String res = new String(buff, this._yapi._deviceCharset).substring(0, bufflen);
        return res;
    }

    public int registerLogCallback(YMicroPythonLogCallback callback) throws YAPI_Exception {
        String serial = this.get_serialNumber();
        if (serial.equals("!INVALID!")) {
            return -4;
        }
        this._logCallback = callback;
        this._isFirstCb = true;
        if (callback != null) {
            this.registerValueCallback(this.yInternalEventCallback);
        } else {
            this.registerValueCallback((UpdateCallback)null);
        }
        return 0;
    }

    public YMicroPythonLogCallback get_logCallback() {
        return this._logCallback;
    }

    public int _internalEventHandler(String cbVal) throws YAPI_Exception {
        int endPos;
        String url;
        byte[] content = new byte[]{};
        ArrayList<Object> msgArr = new ArrayList();
        int cbPos = Integer.valueOf(cbVal.substring(1, 1 + cbVal.length() - 1), 16);
        int cbDPos = cbPos - this._prevCbPos & 0xFFFFF;
        this._prevCbPos = cbPos;
        if (cbDPos > 65536) {
            this._logPos = 0;
        }
        if (this._logCallback == null) {
            return 0;
        }
        if (this._isFirstCb) {
            this._logPos = 0;
            this._prevPartialLog = "";
            url = "mpy.txt";
        } else {
            url = String.format(Locale.US, "mpy.txt?pos=%d", this._logPos);
        }
        content = this._download(url);
        String contentStr = new String(content, this._yapi._deviceCharset);
        for (endPos = content.length - 1; endPos >= 0 && (content[endPos] & 0xFF) != 64; --endPos) {
        }
        if (endPos <= 0) {
            throw new YAPI_Exception(-8, "fail to download micropython logs");
        }
        String lenStr = contentStr.substring(endPos + 1, endPos + 1 + contentStr.length() - (endPos + 1));
        this._logPos = YAPIContext._atoi(lenStr);
        if (this._isFirstCb) {
            this._isFirstCb = false;
            return 0;
        }
        if ((content[--endPos] & 0xFF) != 10) {
            throw new YAPI_Exception(-8, "fail to download micropython logs");
        }
        msgArr = new ArrayList<String>(Arrays.asList((contentStr = contentStr.substring(0, endPos)).split("\n")));
        int arrLen = msgArr.size() - 1;
        if (arrLen > 0) {
            String logMsg = String.format(Locale.US, "%s%s", this._prevPartialLog, msgArr.get(0));
            if (this._logCallback != null) {
                this._logCallback.logCallback(this, logMsg);
            }
            this._prevPartialLog = "";
            for (int arrPos = 1; arrPos < arrLen; ++arrPos) {
                logMsg = (String)msgArr.get(arrPos);
                if (this._logCallback == null) continue;
                this._logCallback.logCallback(this, logMsg);
            }
        }
        this._prevPartialLog = String.format(Locale.US, "%s%s", this._prevPartialLog, msgArr.get(arrLen));
        return 0;
    }

    public YMicroPython nextMicroPython() {
        String next_hwid;
        try {
            String hwid = this._yapi._yHash.resolveHwID(this._className, this._func);
            next_hwid = this._yapi._yHash.getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YMicroPython.FindMicroPythonInContext(this._yapi, next_hwid);
    }

    public static YMicroPython FirstMicroPython() {
        YAPIContext yctx = YAPI.GetYCtx(false);
        if (yctx == null) {
            return null;
        }
        String next_hwid = yctx._yHash.getFirstHardwareId("MicroPython");
        if (next_hwid == null) {
            return null;
        }
        return YMicroPython.FindMicroPythonInContext(yctx, next_hwid);
    }

    public static YMicroPython FirstMicroPythonInContext(YAPIContext yctx) {
        String next_hwid = yctx._yHash.getFirstHardwareId("MicroPython");
        if (next_hwid == null) {
            return null;
        }
        return YMicroPython.FindMicroPythonInContext(yctx, next_hwid);
    }

    public static interface UpdateCallback {
        public void yNewValue(YMicroPython var1, String var2);
    }

    public static interface YMicroPythonLogCallback {
        public void logCallback(YMicroPython var1, String var2);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YMicroPython var1, YMeasure var2);
    }
}

