/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YJSONArray;
import com.yoctopuce.YoctoAPI.YJSONNumber;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YJSONString;

abstract class YJSONContent {
    final String _data;
    int _data_start;
    int _data_len;
    int _data_boundary;
    private final YJSONType _type;

    static YJSONContent ParseJson(String data, int start, int stop) throws Exception {
        int cur_pos = YJSONContent.SkipGarbage(data, start, stop);
        char c = data.charAt(cur_pos);
        YJSONContent res = c == '[' ? new YJSONArray(data, start, stop) : (c == '{' ? new YJSONObject(data, start, stop) : (c == '\"' ? new YJSONString(data, start, stop) : new YJSONNumber(data, start, stop)));
        ((YJSONContent)res).parse();
        return res;
    }

    YJSONContent(String data, int start, int stop, YJSONType type) {
        this._data = data;
        this._data_start = start;
        this._data_boundary = stop;
        this._type = type;
    }

    YJSONContent(YJSONType type) {
        this._data = null;
        this._type = type;
    }

    YJSONType getJSONType() {
        return this._type;
    }

    abstract int parse() throws Exception;

    static int SkipGarbage(String data, int start, int stop) {
        char sti;
        if (stop <= start) {
            return start;
        }
        while (start < stop && ((sti = data.charAt(start)) == ' ' || sti == '\n' || sti == '\r')) {
            ++start;
        }
        return start;
    }

    String formatError(String errmsg, int cur_pos) {
        int ststart = cur_pos - 10;
        int stend = cur_pos + 10;
        if (ststart < 0) {
            ststart = 0;
        }
        if (stend > this._data_boundary) {
            stend = this._data_boundary;
        }
        if (this._data != null) {
            return errmsg + " near " + this._data.substring(ststart, stend);
        }
        return errmsg;
    }

    abstract byte[] toJSON();

    static enum YJSONType {
        STRING,
        NUMBER,
        ARRAY,
        OBJECT;

    }

    static enum Tjstate {
        JSTART,
        JWAITFORNAME,
        JWAITFORENDOFNAME,
        JWAITFORCOLON,
        JWAITFORDATA,
        JWAITFORNEXTSTRUCTMEMBER,
        JWAITFORNEXTARRAYITEM,
        JWAITFORSTRINGVALUE,
        JWAITFORSTRINGVALUE_ESC,
        JWAITFORINTVALUE,
        JWAITFORBOOLVALUE;

    }
}

