/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YJSONContent;
import com.yoctopuce.YoctoAPI.YJSONNumber;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YJSONString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

class YJSONArray
extends YJSONContent {
    private ArrayList<YJSONContent> _arrayValue = new ArrayList();

    YJSONArray(String data, int start, int stop) {
        super(data, start, stop, YJSONContent.YJSONType.ARRAY);
    }

    YJSONArray(String data) {
        super(data, 0, data.length(), YJSONContent.YJSONType.ARRAY);
    }

    YJSONArray() {
        super(YJSONContent.YJSONType.ARRAY);
    }

    int length() {
        return this._arrayValue.size();
    }

    @Override
    int parse() throws Exception {
        int cur_pos = YJSONArray.SkipGarbage(this._data, this._data_start, this._data_boundary);
        if (cur_pos >= this._data_boundary || this._data.charAt(cur_pos) != '[') {
            throw new Exception(this.formatError("Opening braces was expected", cur_pos));
        }
        ++cur_pos;
        YJSONContent.Tjstate state = YJSONContent.Tjstate.JWAITFORDATA;
        block4: while (cur_pos < this._data_boundary) {
            char sti = this._data.charAt(cur_pos);
            switch (state) {
                case JWAITFORDATA: {
                    int len;
                    YJSONContent jobj;
                    if (sti == '{') {
                        jobj = new YJSONObject(this._data, cur_pos, this._data_boundary);
                        len = ((YJSONObject)jobj).parse();
                        cur_pos += len;
                        this._arrayValue.add(jobj);
                        state = YJSONContent.Tjstate.JWAITFORNEXTARRAYITEM;
                        continue block4;
                    }
                    if (sti == '[') {
                        jobj = new YJSONArray(this._data, cur_pos, this._data_boundary);
                        len = ((YJSONArray)jobj).parse();
                        cur_pos += len;
                        this._arrayValue.add(jobj);
                        state = YJSONContent.Tjstate.JWAITFORNEXTARRAYITEM;
                        continue block4;
                    }
                    if (sti == '\"') {
                        jobj = new YJSONString(this._data, cur_pos, this._data_boundary);
                        len = ((YJSONString)jobj).parse();
                        cur_pos += len;
                        this._arrayValue.add(jobj);
                        state = YJSONContent.Tjstate.JWAITFORNEXTARRAYITEM;
                        continue block4;
                    }
                    if (sti == '-' || sti >= '0' && sti <= '9') {
                        jobj = new YJSONNumber(this._data, cur_pos, this._data_boundary);
                        len = ((YJSONNumber)jobj).parse();
                        cur_pos += len;
                        this._arrayValue.add(jobj);
                        state = YJSONContent.Tjstate.JWAITFORNEXTARRAYITEM;
                        continue block4;
                    }
                    if (sti == ']') {
                        this._data_len = cur_pos + 1 - this._data_start;
                        return this._data_len;
                    }
                    if (sti == ' ' || sti == '\n' || sti == '\r') break;
                    throw new Exception(this.formatError("invalid char: was expecting  \",0..9,t or f", cur_pos));
                }
                case JWAITFORNEXTARRAYITEM: {
                    if (sti == ',') {
                        state = YJSONContent.Tjstate.JWAITFORDATA;
                        break;
                    }
                    if (sti == ']') {
                        this._data_len = cur_pos + 1 - this._data_start;
                        return this._data_len;
                    }
                    if (sti == ' ' || sti == '\n' || sti == '\r') break;
                    throw new Exception(this.formatError("invalid char: was expecting ,", cur_pos));
                }
                default: {
                    throw new Exception(this.formatError("invalid state for YJSONObject", cur_pos));
                }
            }
            ++cur_pos;
        }
        throw new Exception(this.formatError("unexpected end of data", cur_pos));
    }

    YJSONObject getYJSONObject(int i) {
        return (YJSONObject)this._arrayValue.get(i);
    }

    String getString(int i) {
        YJSONString ystr = (YJSONString)this._arrayValue.get(i);
        return ystr.getString();
    }

    YJSONContent get(int i) {
        return this._arrayValue.get(i);
    }

    YJSONArray getYJSONArray(int i) {
        return (YJSONArray)this._arrayValue.get(i);
    }

    int getInt(int i) {
        YJSONNumber ystr = (YJSONNumber)this._arrayValue.get(i);
        return ystr.getInt();
    }

    long getLong(int i) {
        YJSONNumber ystr = (YJSONNumber)this._arrayValue.get(i);
        return ystr.getLong();
    }

    double getDouble(int i) {
        YJSONNumber ystr = (YJSONNumber)this._arrayValue.get(i);
        return ystr.getDouble();
    }

    void put(String flatAttr) {
        YJSONString strobj = new YJSONString();
        strobj.setContent(flatAttr);
        this._arrayValue.add(strobj);
    }

    @Override
    byte[] toJSON() {
        ByteArrayOutputStream res = new ByteArrayOutputStream();
        try {
            res.write(91);
            String sep = "";
            for (YJSONContent yjsonContent : this._arrayValue) {
                byte[] subres = yjsonContent.toJSON();
                res.write(sep.getBytes("ISO-8859-1"));
                res.write(subres);
                sep = ",";
            }
            res.write(93);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return res.toByteArray();
    }

    public String toString() {
        StringBuilder res = new StringBuilder();
        res.append('[');
        String sep = "";
        for (YJSONContent yjsonContent : this._arrayValue) {
            String subres = yjsonContent.toString();
            res.append(sep);
            res.append(subres);
            sep = ",";
        }
        res.append(']');
        return res.toString();
    }
}

