/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YMessageBox;
import java.util.ArrayList;
import java.util.Locale;

public class YSms {
    protected YMessageBox _mbox;
    protected int _slot = 0;
    protected boolean _deliv;
    protected String _smsc = "";
    protected int _mref = 0;
    protected String _orig = "";
    protected String _dest = "";
    protected int _pid = 0;
    protected int _alphab = 0;
    protected int _mclass = 0;
    protected String _stamp = "";
    protected byte[] _udh = new byte[0];
    protected byte[] _udata = new byte[0];
    protected int _npdu = 0;
    protected byte[] _pdu = new byte[0];
    protected ArrayList<YSms> _parts = new ArrayList();
    protected String _aggSig = "";
    protected int _aggIdx = 0;
    protected int _aggCnt = 0;
    private final YAPIContext _yapi;

    protected YSms(YMessageBox mbox) {
        this._mbox = mbox;
        this._yapi = mbox._yapi;
    }

    public int get_slot() {
        return this._slot;
    }

    public String get_smsc() {
        return this._smsc;
    }

    public int get_msgRef() {
        return this._mref;
    }

    public String get_sender() {
        return this._orig;
    }

    public String get_recipient() {
        return this._dest;
    }

    public int get_protocolId() {
        return this._pid;
    }

    public boolean isReceived() {
        return this._deliv;
    }

    public int get_alphabet() {
        return this._alphab;
    }

    public int get_msgClass() {
        if ((this._mclass & 0x10) == 0) {
            return -1;
        }
        return this._mclass & 3;
    }

    public int get_dcs() {
        return this._mclass | this._alphab << 2;
    }

    public String get_timestamp() {
        return this._stamp;
    }

    public byte[] get_userDataHeader() {
        return this._udh;
    }

    public byte[] get_userData() {
        return this._udata;
    }

    public String get_textData() {
        byte[] isolatin = new byte[]{};
        if (this._alphab == 0) {
            return this._mbox.gsm2str(this._udata);
        }
        if (this._alphab == 2) {
            int isosize = this._udata.length >> 1;
            isolatin = new byte[isosize];
            for (int i = 0; i < isosize; ++i) {
                isolatin[i] = (byte)(this._udata[2 * i + 1] & 0xFF & 0xFF);
            }
            return new String(isolatin, this._yapi._deviceCharset);
        }
        return new String(this._udata, this._yapi._deviceCharset);
    }

    public ArrayList<Integer> get_unicodeData() {
        ArrayList<Integer> res = new ArrayList<Integer>();
        if (this._alphab == 0) {
            return this._mbox.gsm2unicode(this._udata);
        }
        if (this._alphab == 2) {
            int unisize = this._udata.length >> 1;
            res.clear();
            for (int i = 0; i < unisize; ++i) {
                int unival = 256 * (this._udata[2 * i] & 0xFF) + (this._udata[2 * i + 1] & 0xFF);
                res.add(unival);
            }
        } else {
            int unisize = this._udata.length;
            res.clear();
            for (int i = 0; i < unisize; ++i) {
                res.add((this._udata[i] & 0xFF) + 0);
            }
        }
        return res;
    }

    public int get_partCount() {
        if (this._npdu == 0) {
            this.generatePdu();
        }
        return this._npdu;
    }

    public byte[] get_pdu() {
        if (this._npdu == 0) {
            this.generatePdu();
        }
        return this._pdu;
    }

    public ArrayList<YSms> get_parts() {
        if (this._npdu == 0) {
            this.generatePdu();
        }
        return this._parts;
    }

    public String get_concatSignature() {
        if (this._npdu == 0) {
            this.generatePdu();
        }
        return this._aggSig;
    }

    public int get_concatIndex() {
        if (this._npdu == 0) {
            this.generatePdu();
        }
        return this._aggIdx;
    }

    public int get_concatCount() {
        if (this._npdu == 0) {
            this.generatePdu();
        }
        return this._aggCnt;
    }

    public int set_slot(int val) {
        this._slot = val;
        return 0;
    }

    public int set_received(boolean val) {
        this._deliv = val;
        return 0;
    }

    public int set_smsc(String val) {
        this._smsc = val;
        this._npdu = 0;
        return 0;
    }

    public int set_msgRef(int val) {
        this._mref = val;
        this._npdu = 0;
        return 0;
    }

    public int set_sender(String val) {
        this._orig = val;
        this._npdu = 0;
        return 0;
    }

    public int set_recipient(String val) {
        this._dest = val;
        this._npdu = 0;
        return 0;
    }

    public int set_protocolId(int val) {
        this._pid = val;
        this._npdu = 0;
        return 0;
    }

    public int set_alphabet(int val) {
        this._alphab = val;
        this._npdu = 0;
        return 0;
    }

    public int set_msgClass(int val) {
        this._mclass = val == -1 ? 0 : 16 + val;
        this._npdu = 0;
        return 0;
    }

    public int set_dcs(int val) {
        this._alphab = val >> 2 & 3;
        this._mclass = val & 0x13;
        this._npdu = 0;
        return 0;
    }

    public int set_timestamp(String val) {
        this._stamp = val;
        this._npdu = 0;
        return 0;
    }

    public int set_userDataHeader(byte[] val) {
        this._udh = val;
        this._npdu = 0;
        this.parseUserDataHeader();
        return 0;
    }

    public int set_userData(byte[] val) {
        this._udata = val;
        this._npdu = 0;
        return 0;
    }

    public int convertToUnicode() {
        ArrayList<Integer> ucs2 = new ArrayList();
        if (this._alphab == 2) {
            return 0;
        }
        if (this._alphab == 0) {
            ucs2 = this._mbox.gsm2unicode(this._udata);
        } else {
            int udatalen = this._udata.length;
            ucs2.clear();
            for (int i = 0; i < udatalen; ++i) {
                int uni = this._udata[i] & 0xFF;
                ucs2.add(uni);
            }
        }
        this._alphab = 2;
        this._udata = new byte[0];
        this.addUnicodeData(ucs2);
        return 0;
    }

    public int addText(String val) {
        int newdatalen;
        byte[] udata = new byte[]{};
        byte[] newdata = new byte[]{};
        if (val.length() == 0) {
            return 0;
        }
        if (this._alphab == 0) {
            newdata = this._mbox.str2gsm(val);
            newdatalen = newdata.length;
            if (newdatalen == 0) {
                this.convertToUnicode();
                newdata = val.getBytes(this._yapi._deviceCharset);
                newdatalen = newdata.length;
            }
        } else {
            newdata = val.getBytes(this._yapi._deviceCharset);
            newdatalen = newdata.length;
        }
        int udatalen = this._udata.length;
        if (this._alphab == 2) {
            int i;
            udata = new byte[udatalen + 2 * newdatalen];
            for (i = 0; i < udatalen; ++i) {
                udata[i] = (byte)(this._udata[i] & 0xFF & 0xFF);
            }
            for (i = 0; i < newdatalen; ++i) {
                udata[udatalen + 1] = (byte)(newdata[i] & 0xFF & 0xFF);
                udatalen += 2;
            }
        } else {
            int i;
            udata = new byte[udatalen + newdatalen];
            for (i = 0; i < udatalen; ++i) {
                udata[i] = (byte)(this._udata[i] & 0xFF & 0xFF);
            }
            for (i = 0; i < newdatalen; ++i) {
                udata[udatalen] = (byte)(newdata[i] & 0xFF & 0xFF);
                ++udatalen;
            }
        }
        return this.set_userData(udata);
    }

    public int addUnicodeData(ArrayList<Integer> val) {
        int uni;
        int i;
        int arrlen;
        byte[] udata = new byte[]{};
        if (this._alphab != 2) {
            this.convertToUnicode();
        }
        int newdatalen = arrlen = val.size();
        for (i = 0; i < arrlen; ++i) {
            uni = val.get(i);
            if (uni <= 65535) continue;
            ++newdatalen;
        }
        int udatalen = this._udata.length;
        udata = new byte[udatalen + 2 * newdatalen];
        for (i = 0; i < udatalen; ++i) {
            udata[i] = (byte)(this._udata[i] & 0xFF & 0xFF);
        }
        for (i = 0; i < arrlen; ++i) {
            uni = val.get(i);
            if (uni >= 65536) {
                int surrogate = uni - 65536;
                uni = (surrogate >> 10 & 0x3FF) + 55296;
                udata[udatalen] = (byte)(uni >> 8 & 0xFF);
                udata[udatalen + 1] = (byte)(uni & 0xFF & 0xFF);
                udatalen += 2;
                uni = (surrogate & 0x3FF) + 56320;
            }
            udata[udatalen] = (byte)(uni >> 8 & 0xFF);
            udata[udatalen + 1] = (byte)(uni & 0xFF & 0xFF);
            udatalen += 2;
        }
        return this.set_userData(udata);
    }

    public int set_pdu(byte[] pdu) {
        this._pdu = pdu;
        this._npdu = 1;
        return this.parsePdu(pdu);
    }

    public int set_parts(ArrayList<YSms> parts) {
        YSms subsms;
        int i;
        ArrayList<YSms> sorted = new ArrayList<YSms>();
        byte[] subdata = new byte[]{};
        byte[] res = new byte[]{};
        this._npdu = parts.size();
        if (this._npdu == 0) {
            return -2;
        }
        sorted.clear();
        int partno = 0;
        while (partno < this._npdu) {
            int initpartno = partno;
            for (i = 0; i < this._npdu; ++i) {
                subsms = parts.get(i);
                if (subsms.get_concatIndex() != partno) continue;
                sorted.add(subsms);
                ++partno;
            }
            if (initpartno != partno) continue;
            ++partno;
        }
        this._parts = sorted;
        subsms = this._parts.get(0);
        int retcode = this.parsePdu(subsms.get_pdu());
        if (retcode != 0) {
            return retcode;
        }
        this._npdu = sorted.size();
        int totsize = 0;
        for (partno = 0; partno < this._parts.size(); ++partno) {
            subsms = this._parts.get(partno);
            subdata = subsms.get_userData();
            totsize += subdata.length;
        }
        res = new byte[totsize];
        totsize = 0;
        for (partno = 0; partno < this._parts.size(); ++partno) {
            subsms = this._parts.get(partno);
            subdata = subsms.get_userData();
            for (i = 0; i < subdata.length; ++i) {
                res[totsize] = (byte)(subdata[i] & 0xFF & 0xFF);
                ++totsize;
            }
        }
        this._udata = res;
        return 0;
    }

    public byte[] encodeAddress(String addr) {
        int val;
        int i;
        byte[] bytes = new byte[]{};
        byte[] res = new byte[]{};
        bytes = addr.getBytes(this._yapi._deviceCharset);
        int srclen = bytes.length;
        int numlen = 0;
        for (i = 0; i < srclen; ++i) {
            val = bytes[i] & 0xFF;
            if (val < 48 || val >= 58) continue;
            ++numlen;
        }
        if (numlen == 0) {
            res = new byte[]{0};
            return res;
        }
        res = new byte[2 + (numlen + 1 >> 1)];
        res[0] = (byte)(numlen & 0xFF);
        res[1] = (bytes[0] & 0xFF) == 43 ? -111 : -127;
        numlen = 4;
        int digit = 0;
        for (i = 0; i < srclen; ++i) {
            val = bytes[i] & 0xFF;
            if (val < 48 || val >= 58) continue;
            if ((numlen & 1) == 0) {
                digit = val - 48;
            } else {
                res[numlen >> 1] = (byte)(digit + 16 * (val - 48) & 0xFF);
            }
            ++numlen;
        }
        if ((numlen & 1) != 0) {
            res[numlen >> 1] = (byte)(digit + 240 & 0xFF);
        }
        return res;
    }

    public String decodeAddress(byte[] addr, int ofs, int siz) {
        byte[] gsm7 = new byte[]{};
        if (siz == 0) {
            return "";
        }
        String res = "";
        int addrType = addr[ofs] & 0xFF & 0x70;
        if (addrType == 80) {
            siz = 4 * siz / 7;
            gsm7 = new byte[siz];
            int rpos = 1;
            int carry = 0;
            int nbits = 0;
            for (int i = 0; i < siz; ++i) {
                if (nbits == 7) {
                    gsm7[i] = (byte)(carry & 0xFF);
                    carry = 0;
                    nbits = 0;
                    continue;
                }
                int byt = addr[ofs + rpos] & 0xFF;
                ++rpos;
                gsm7[i] = (byte)((carry | byt << nbits & 0x7F) & 0xFF);
                carry = byt >> 7 - nbits;
                ++nbits;
            }
            return this._mbox.gsm2str(gsm7);
        }
        if (addrType == 16) {
            res = "+";
        }
        siz = siz + 1 >> 1;
        for (int i = 0; i < siz; ++i) {
            int byt = addr[ofs + i + 1] & 0xFF;
            res = String.format(Locale.US, "%s%x%x", res, byt & 0xF, byt >> 4);
        }
        if ((addr[ofs + siz] & 0xFF) >> 4 == 15) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    public byte[] encodeTimeStamp(String exp) {
        int v2;
        int v1;
        byte[] res = new byte[]{};
        byte[] expasc = new byte[]{};
        int explen = exp.length();
        if (explen == 0) {
            res = new byte[]{};
            return res;
        }
        if (exp.substring(0, 1).equals("+")) {
            int n = YAPIContext._atoi(exp.substring(1, 1 + explen - 1));
            res = new byte[1];
            if ((n = n > 2592000 ? 192 + (n + 518400) / 604800 : (n > 86400 ? 166 + (n + 86399) / 86400 : (n > 43200 ? 143 + (n - 43200 + 1799) / 1800 : -1 + (n + 299) / 300))) < 0) {
                n = 0;
            }
            res[0] = (byte)(n & 0xFF);
            return res;
        }
        if (exp.substring(4, 5).equals("-") || exp.substring(4, 5).equals("/")) {
            exp = exp.substring(2, 2 + explen - 2);
            explen = exp.length();
        }
        expasc = exp.getBytes(this._yapi._deviceCharset);
        res = new byte[7];
        int n = 0;
        int i = 0;
        while (i + 1 < explen && n < 7) {
            v1 = expasc[i] & 0xFF;
            if (v1 >= 48 && v1 < 58 && (v2 = expasc[i + 1] & 0xFF) >= 48 && v2 < 58) {
                res[n] = (byte)(((v2 -= 48) << 4) + (v1 -= 48) & 0xFF);
                ++n;
                ++i;
            }
            ++i;
        }
        while (n < 7) {
            res[n] = 0;
            ++n;
        }
        if (i + 2 < explen) {
            v1 = expasc[i - 3] & 0xFF;
            v2 = expasc[i] & 0xFF;
            if ((v1 == 43 || v1 == 45) && v2 == 58) {
                v1 = expasc[i + 1] & 0xFF;
                v2 = expasc[i + 2] & 0xFF;
                if (v1 >= 48 && v1 < 58 && v1 >= 48 && v1 < 58) {
                    v1 = (10 * (v1 - 48) + (v2 - 48)) / 15;
                    v2 = 4 * (res[--n] & 0xFF) + v1;
                    if ((expasc[i - 3] & 0xFF) == 45) {
                        v2 += 128;
                    }
                    res[n] = (byte)(v2 & 0xFF);
                }
            }
        }
        return res;
    }

    public String decodeTimeStamp(byte[] exp, int ofs, int siz) {
        int byt;
        int i;
        if (siz < 1) {
            return "";
        }
        if (siz == 1) {
            int n = exp[ofs] & 0xFF;
            n = n < 144 ? (n *= 300) : (n < 168 ? (n - 143) * 1800 : (n < 197 ? (n - 166) * 86400 : (n - 192) * 7 * 86400));
            return String.format(Locale.US, "+%d", n);
        }
        String res = "20";
        for (i = 0; i < siz && i < 6; ++i) {
            byt = exp[ofs + i] & 0xFF;
            res = String.format(Locale.US, "%s%x%x", res, byt & 0xF, byt >> 4);
            if (i < 3) {
                if (i < 2) {
                    res = String.format(Locale.US, "%s-", res);
                    continue;
                }
                res = String.format(Locale.US, "%s ", res);
                continue;
            }
            if (i >= 5) continue;
            res = String.format(Locale.US, "%s:", res);
        }
        if (siz == 7) {
            byt = exp[ofs + i] & 0xFF;
            String sign = "+";
            if ((byt & 8) != 0) {
                byt -= 8;
                sign = "-";
            }
            byt = 10 * (byt & 0xF) + (byt >> 4);
            String hh = String.format(Locale.US, "%d", byt >> 2);
            String ss = String.format(Locale.US, "%d", 15 * (byt & 3));
            if (hh.length() < 2) {
                hh = String.format(Locale.US, "0%s", hh);
            }
            if (ss.length() < 2) {
                ss = String.format(Locale.US, "0%s", ss);
            }
            res = String.format(Locale.US, "%s%s%s:%s", res, sign, hh, ss);
        }
        return res;
    }

    public int udataSize() {
        int udhsize = this._udh.length;
        int res = this._udata.length;
        if (this._alphab == 0) {
            if (udhsize > 0) {
                res += (8 + 8 * udhsize + 6) / 7;
            }
            res = (res * 7 + 7) / 8;
        } else if (udhsize > 0) {
            res = res + 1 + udhsize;
        }
        return res;
    }

    public byte[] encodeUserData() {
        int i;
        byte[] res = new byte[]{};
        int udsize = this.udataSize();
        int udhsize = this._udh.length;
        int udlen = this._udata.length;
        res = new byte[1 + udsize];
        int udhlen = 0;
        int nbits = 0;
        int carry = 0;
        if (this._alphab == 0) {
            if (udhsize > 0) {
                udhlen = (8 + 8 * udhsize + 6) / 7;
                nbits = 7 * udhlen - 8 - 8 * udhsize;
            }
            res[0] = (byte)(udhlen + udlen & 0xFF);
        } else {
            res[0] = (byte)(udsize & 0xFF);
        }
        int wpos = 1;
        if (udhsize > 0) {
            res[wpos] = (byte)(udhsize & 0xFF);
            ++wpos;
            for (i = 0; i < udhsize; ++i) {
                res[wpos] = (byte)(this._udh[i] & 0xFF & 0xFF);
                ++wpos;
            }
        }
        if (this._alphab == 0) {
            for (i = 0; i < udlen; ++i) {
                if (nbits == 0) {
                    carry = this._udata[i] & 0xFF;
                    nbits = 7;
                    continue;
                }
                int thi_b = this._udata[i] & 0xFF;
                res[wpos] = (byte)((carry | thi_b << nbits & 0xFF) & 0xFF);
                ++wpos;
                carry = thi_b >> 7 - --nbits;
            }
            if (nbits > 0) {
                res[wpos] = (byte)(carry & 0xFF);
            }
        } else {
            for (i = 0; i < udlen; ++i) {
                res[wpos] = (byte)(this._udata[i] & 0xFF & 0xFF);
                ++wpos;
            }
        }
        return res;
    }

    public int generateParts() {
        byte[] newud = new byte[]{};
        byte[] newudh = new byte[]{};
        int udhsize = this._udh.length;
        int udlen = this._udata.length;
        int mss = 134 - udhsize;
        if (this._alphab == 0) {
            mss = (mss * 8 - 6) / 7;
        }
        this._npdu = (udlen + mss - 1) / mss;
        this._parts.clear();
        int partno = 0;
        int wpos = 0;
        while (wpos < udlen) {
            int i;
            ++partno;
            newudh = new byte[5 + udhsize];
            newudh[0] = 0;
            newudh[1] = 3;
            newudh[2] = (byte)(this._mref & 0xFF);
            newudh[3] = (byte)(this._npdu & 0xFF);
            newudh[4] = (byte)(partno & 0xFF);
            for (i = 0; i < udhsize; ++i) {
                newudh[5 + i] = (byte)(this._udh[i] & 0xFF & 0xFF);
            }
            int partlen = wpos + mss < udlen ? mss : udlen - wpos;
            newud = new byte[partlen];
            for (i = 0; i < partlen; ++i) {
                newud[i] = (byte)(this._udata[wpos] & 0xFF & 0xFF);
                ++wpos;
            }
            YSms newpdu = new YSms(this._mbox);
            newpdu.set_received(this.isReceived());
            newpdu.set_smsc(this.get_smsc());
            newpdu.set_msgRef(this.get_msgRef());
            newpdu.set_sender(this.get_sender());
            newpdu.set_recipient(this.get_recipient());
            newpdu.set_protocolId(this.get_protocolId());
            newpdu.set_dcs(this.get_dcs());
            newpdu.set_timestamp(this.get_timestamp());
            newpdu.set_userDataHeader(newudh);
            newpdu.set_userData(newud);
            this._parts.add(newpdu);
        }
        return 0;
    }

    public int generatePdu() {
        int i;
        int pdutyp;
        byte[] sca = new byte[]{};
        byte[] hdr = new byte[]{};
        byte[] addr = new byte[]{};
        byte[] stamp = new byte[]{};
        byte[] udata = new byte[]{};
        this._parts.clear();
        if (this.udataSize() > 140) {
            this._pdu = new byte[0];
            return this.generateParts();
        }
        sca = this.encodeAddress(this._smsc);
        if (sca.length > 0) {
            sca[0] = (byte)(sca.length - 1 & 0xFF);
        }
        stamp = this.encodeTimeStamp(this._stamp);
        udata = this.encodeUserData();
        if (this._deliv) {
            addr = this.encodeAddress(this._orig);
            hdr = new byte[1];
            pdutyp = 0;
        } else {
            addr = this.encodeAddress(this._dest);
            this._mref = this._mbox.nextMsgRef();
            hdr = new byte[2];
            hdr[1] = (byte)(this._mref & 0xFF);
            pdutyp = 1;
            if (stamp.length > 0) {
                pdutyp += 16;
            }
            if (stamp.length == 7) {
                pdutyp += 8;
            }
        }
        if (this._udh.length > 0) {
            pdutyp += 64;
        }
        hdr[0] = (byte)(pdutyp & 0xFF);
        int pdulen = sca.length + hdr.length + addr.length + 2 + stamp.length + udata.length;
        this._pdu = new byte[pdulen];
        pdulen = 0;
        for (i = 0; i < sca.length; ++i) {
            this._pdu[pdulen] = (byte)(sca[i] & 0xFF & 0xFF);
            ++pdulen;
        }
        for (i = 0; i < hdr.length; ++i) {
            this._pdu[pdulen] = (byte)(hdr[i] & 0xFF & 0xFF);
            ++pdulen;
        }
        for (i = 0; i < addr.length; ++i) {
            this._pdu[pdulen] = (byte)(addr[i] & 0xFF & 0xFF);
            ++pdulen;
        }
        this._pdu[pdulen] = (byte)(this._pid & 0xFF);
        this._pdu[++pdulen] = (byte)(this.get_dcs() & 0xFF);
        ++pdulen;
        for (i = 0; i < stamp.length; ++i) {
            this._pdu[pdulen] = (byte)(stamp[i] & 0xFF & 0xFF);
            ++pdulen;
        }
        for (i = 0; i < udata.length; ++i) {
            this._pdu[pdulen] = (byte)(udata[i] & 0xFF & 0xFF);
            ++pdulen;
        }
        this._npdu = 1;
        return 0;
    }

    public int parseUserDataHeader() {
        this._aggSig = "";
        this._aggIdx = 0;
        this._aggCnt = 0;
        int udhlen = this._udh.length;
        int i = 0;
        while (i + 1 < udhlen) {
            int ielen;
            int iei = this._udh[i] & 0xFF;
            if ((i += 2) + (ielen = this._udh[i + 1] & 0xFF) <= udhlen) {
                String sig;
                if (iei == 0 && ielen == 3) {
                    this._aggSig = sig = String.format(Locale.US, "%s-%s-%02x-%02x", this._orig, this._dest, this._mref, this._udh[i] & 0xFF);
                    this._aggCnt = this._udh[i + 1] & 0xFF;
                    this._aggIdx = this._udh[i + 2] & 0xFF;
                }
                if (iei == 8 && ielen == 4) {
                    this._aggSig = sig = String.format(Locale.US, "%s-%s-%02x-%02x%02x", this._orig, this._dest, this._mref, this._udh[i] & 0xFF, this._udh[i + 1] & 0xFF);
                    this._aggCnt = this._udh[i + 2] & 0xFF;
                    this._aggIdx = this._udh[i + 3] & 0xFF;
                }
            }
            i += ielen;
        }
        return 0;
    }

    public int parsePdu(byte[] pdu) {
        int thi_b;
        int i;
        int udhsize;
        int tslen;
        int addrlen;
        this._pdu = pdu;
        this._npdu = 1;
        this._smsc = this.decodeAddress(pdu, 1, 2 * ((pdu[0] & 0xFF) - 1));
        int rpos = 1 + (pdu[0] & 0xFF);
        int pdutyp = pdu[rpos] & 0xFF;
        ++rpos;
        boolean bl = this._deliv = (pdutyp & 3) == 0;
        if (this._deliv) {
            addrlen = pdu[rpos] & 0xFF;
            this._orig = this.decodeAddress(pdu, ++rpos, addrlen);
            this._dest = "";
            tslen = 7;
        } else {
            this._mref = pdu[rpos] & 0xFF;
            addrlen = pdu[++rpos] & 0xFF;
            this._dest = this.decodeAddress(pdu, ++rpos, addrlen);
            this._orig = "";
            tslen = (pdutyp & 0x10) != 0 ? ((pdutyp & 8) != 0 ? 7 : 1) : 0;
        }
        this._pid = pdu[rpos += addrlen + 3 >> 1] & 0xFF;
        int dcs = pdu[++rpos] & 0xFF;
        this._alphab = dcs >> 2 & 3;
        this._mclass = dcs & 0x13;
        this._stamp = this.decodeTimeStamp(pdu, ++rpos, tslen);
        int nbits = 0;
        int carry = 0;
        int udlen = pdu[rpos += tslen] & 0xFF;
        ++rpos;
        if ((pdutyp & 0x40) != 0) {
            int udhlen;
            udhsize = pdu[rpos] & 0xFF;
            ++rpos;
            this._udh = new byte[udhsize];
            for (i = 0; i < udhsize; ++i) {
                this._udh[i] = (byte)(pdu[rpos] & 0xFF & 0xFF);
                ++rpos;
            }
            if (this._alphab == 0) {
                udhlen = (8 + 8 * udhsize + 6) / 7;
                nbits = 7 * udhlen - 8 - 8 * udhsize;
                if (nbits > 0) {
                    thi_b = pdu[rpos] & 0xFF;
                    ++rpos;
                    carry = thi_b >> nbits;
                    nbits = 8 - nbits;
                }
            } else {
                udhlen = 1 + udhsize;
            }
            udlen -= udhlen;
        } else {
            udhsize = 0;
            this._udh = new byte[0];
        }
        this._udata = new byte[udlen];
        if (this._alphab == 0) {
            for (i = 0; i < udlen; ++i) {
                if (nbits == 7) {
                    this._udata[i] = (byte)(carry & 0xFF);
                    carry = 0;
                    nbits = 0;
                    continue;
                }
                thi_b = pdu[rpos] & 0xFF;
                ++rpos;
                this._udata[i] = (byte)((carry | thi_b << nbits & 0x7F) & 0xFF);
                carry = thi_b >> 7 - nbits;
                ++nbits;
            }
        } else {
            for (i = 0; i < udlen; ++i) {
                this._udata[i] = (byte)(pdu[rpos] & 0xFF & 0xFF);
                ++rpos;
            }
        }
        this.parseUserDataHeader();
        return 0;
    }

    public int send() throws YAPI_Exception {
        if (this._npdu == 0) {
            this.generatePdu();
        }
        if (this._npdu == 1) {
            return this._mbox._upload("sendSMS", this._pdu);
        }
        int retcode = 0;
        for (int i = 0; i < this._npdu && retcode == 0; ++i) {
            YSms pdu = this._parts.get(i);
            retcode = pdu.send();
        }
        return retcode;
    }

    public int deleteFromSIM() throws YAPI_Exception {
        if (this._npdu < 2) {
            return this._mbox.clearSIMSlot(this._slot);
        }
        int retcode = 0;
        for (int i = 0; i < this._npdu && retcode == 0; ++i) {
            YSms pdu = this._parts.get(i);
            retcode = pdu.deleteFromSIM();
        }
        return retcode;
    }
}

