/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YRfidOptions;
import com.yoctopuce.YoctoAPI.YRfidStatus;
import com.yoctopuce.YoctoAPI.YRfidTagInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;

public class YRfidReader
extends YFunction {
    public static final int NTAGS_INVALID = -1;
    public static final int REFRESHRATE_INVALID = -1;
    protected int _nTags = -1;
    protected int _refreshRate = -1;
    protected UpdateCallback _valueCallbackRfidReader = null;
    protected YEventCallback _eventCallback;
    protected boolean _isFirstCb;
    protected int _prevCbPos = 0;
    protected int _eventPos = 0;
    protected int _eventStamp = 0;
    private UpdateCallback yInternalEventCallback = new UpdateCallback(){

        @Override
        public void yNewValue(YRfidReader obj, String value) {
            try {
                obj._internalEventHandler(value);
            }
            catch (YAPI_Exception e) {
                e.printStackTrace();
            }
        }
    };

    protected YRfidReader(YAPIContext ctx, String func) {
        super(ctx, func);
        this._className = "RfidReader";
    }

    protected YRfidReader(String func) {
        this(YAPI.GetYCtx(true), func);
    }

    @Override
    protected void _parseAttr(YJSONObject json_val) throws Exception {
        if (json_val.has("nTags")) {
            this._nTags = json_val.getInt("nTags");
        }
        if (json_val.has("refreshRate")) {
            this._refreshRate = json_val.getInt("refreshRate");
        }
        super._parseAttr(json_val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_nTags() throws YAPI_Exception {
        int res;
        YRfidReader yRfidReader = this;
        synchronized (yRfidReader) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._nTags;
        }
        return res;
    }

    public int getNTags() throws YAPI_Exception {
        return this.get_nTags();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_refreshRate() throws YAPI_Exception {
        int res;
        YRfidReader yRfidReader = this;
        synchronized (yRfidReader) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._refreshRate;
        }
        return res;
    }

    public int getRefreshRate() throws YAPI_Exception {
        return this.get_refreshRate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_refreshRate(int newval) throws YAPI_Exception {
        YRfidReader yRfidReader = this;
        synchronized (yRfidReader) {
            String rest_val = Integer.toString(newval);
            this._setAttr("refreshRate", rest_val);
        }
        return 0;
    }

    public int setRefreshRate(int newval) throws YAPI_Exception {
        return this.set_refreshRate(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YRfidReader FindRfidReader(String func) {
        YRfidReader obj;
        YAPIContext ctx = YAPI.GetYCtx(true);
        Object object = ctx._functionCacheLock;
        synchronized (object) {
            obj = (YRfidReader)YFunction._FindFromCache("RfidReader", func);
            if (obj == null) {
                obj = new YRfidReader(func);
                YFunction._AddToCache("RfidReader", func, obj);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YRfidReader FindRfidReaderInContext(YAPIContext yctx, String func) {
        YRfidReader obj;
        Object object = yctx._functionCacheLock;
        synchronized (object) {
            obj = (YRfidReader)YFunction._FindFromCacheInContext(yctx, "RfidReader", func);
            if (obj == null) {
                obj = new YRfidReader(yctx, func);
                YFunction._AddToCache("RfidReader", func, obj);
            }
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackRfidReader = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackRfidReader != null) {
            this._valueCallbackRfidReader.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int _chkerror(String tagId, byte[] json, YRfidStatus status) throws YAPI_Exception {
        int lab;
        int fab;
        int errBlk;
        int errCode;
        if (json.length == 0) {
            errCode = this.get_errorType();
            errBlk = -1;
            fab = -1;
            lab = -1;
        } else {
            String jsonStr = new String(json);
            errCode = YAPIContext._atoi(this._json_get_key(json, "err"));
            errBlk = YAPIContext._atoi(this._json_get_key(json, "errBlk")) - 1;
            if (jsonStr.indexOf("\"fab\":") >= 0) {
                fab = YAPIContext._atoi(this._json_get_key(json, "fab")) - 1;
                lab = YAPIContext._atoi(this._json_get_key(json, "lab")) - 1;
            } else {
                fab = -1;
                lab = -1;
            }
        }
        status.imm_init(tagId, errCode, errBlk, fab, lab);
        int retcode = status.get_yapiError();
        if (retcode != 0) {
            throw new YAPI_Exception(retcode, status.get_errorMessage());
        }
        return 0;
    }

    public int reset() throws YAPI_Exception {
        byte[] json = new byte[]{};
        YRfidStatus status = new YRfidStatus();
        json = this._download("rfid.json?a=reset");
        return this._chkerror("", json, status);
    }

    public ArrayList<String> get_tagIdList() throws YAPI_Exception {
        byte[] json = new byte[]{};
        ArrayList<Object> jsonList = new ArrayList();
        ArrayList<String> taglist = new ArrayList<String>();
        json = this._download("rfid.json?a=list");
        taglist.clear();
        if (json.length > 3) {
            jsonList = this._json_get_array(json);
            for (String string : jsonList) {
                taglist.add(this._json_get_string(string.getBytes()));
            }
        }
        return taglist;
    }

    public YRfidTagInfo get_tagInfo(String tagId, YRfidStatus status) throws YAPI_Exception {
        byte[] json = new byte[]{};
        String url = String.format(Locale.US, "rfid.json?a=info&t=%s", tagId);
        json = this._download(url);
        this._chkerror(tagId, json, status);
        int tagType = YAPIContext._atoi(this._json_get_key(json, "type"));
        int size = YAPIContext._atoi(this._json_get_key(json, "size"));
        int usable = YAPIContext._atoi(this._json_get_key(json, "usable"));
        int blksize = YAPIContext._atoi(this._json_get_key(json, "blksize"));
        int fblk = YAPIContext._atoi(this._json_get_key(json, "fblk"));
        int lblk = YAPIContext._atoi(this._json_get_key(json, "lblk"));
        YRfidTagInfo res = new YRfidTagInfo();
        res.imm_init(tagId, tagType, size, usable, blksize, fblk, lblk);
        return res;
    }

    public int tagLockBlocks(String tagId, int firstBlock, int nBlocks, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        byte[] json = new byte[]{};
        String optstr = options.imm_getParams();
        String url = String.format(Locale.US, "rfid.json?a=lock&t=%s&b=%d&n=%d%s", tagId, firstBlock, nBlocks, optstr);
        json = this._download(url);
        return this._chkerror(tagId, json, status);
    }

    public ArrayList<Boolean> get_tagLockState(String tagId, int firstBlock, int nBlocks, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        byte[] json = new byte[]{};
        byte[] binRes = new byte[]{};
        ArrayList<Boolean> res = new ArrayList<Boolean>();
        String optstr = options.imm_getParams();
        String url = String.format(Locale.US, "rfid.json?a=chkl&t=%s&b=%d&n=%d%s", tagId, firstBlock, nBlocks, optstr);
        json = this._download(url);
        this._chkerror(tagId, json, status);
        if (status.get_yapiError() != 0) {
            return res;
        }
        binRes = YAPIContext._hexStrToBin(this._json_get_key(json, "bitmap"));
        for (int idx = 0; idx < nBlocks; ++idx) {
            int val = binRes[idx >> 3] & 0xFF;
            boolean isLocked = (val & 1 << (idx & 7)) != 0;
            res.add(isLocked);
        }
        return res;
    }

    public ArrayList<Boolean> get_tagSpecialBlocks(String tagId, int firstBlock, int nBlocks, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        byte[] json = new byte[]{};
        byte[] binRes = new byte[]{};
        ArrayList<Boolean> res = new ArrayList<Boolean>();
        String optstr = options.imm_getParams();
        String url = String.format(Locale.US, "rfid.json?a=chks&t=%s&b=%d&n=%d%s", tagId, firstBlock, nBlocks, optstr);
        json = this._download(url);
        this._chkerror(tagId, json, status);
        if (status.get_yapiError() != 0) {
            return res;
        }
        binRes = YAPIContext._hexStrToBin(this._json_get_key(json, "bitmap"));
        for (int idx = 0; idx < nBlocks; ++idx) {
            int val = binRes[idx >> 3] & 0xFF;
            boolean isLocked = (val & 1 << (idx & 7)) != 0;
            res.add(isLocked);
        }
        return res;
    }

    public String tagReadHex(String tagId, int firstBlock, int nBytes, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        byte[] json = new byte[]{};
        String optstr = options.imm_getParams();
        String url = String.format(Locale.US, "rfid.json?a=read&t=%s&b=%d&n=%d%s", tagId, firstBlock, nBytes, optstr);
        json = this._download(url);
        this._chkerror(tagId, json, status);
        String hexbuf = status.get_yapiError() == 0 ? this._json_get_key(json, "res") : "";
        return hexbuf;
    }

    public byte[] tagReadBin(String tagId, int firstBlock, int nBytes, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        return YAPIContext._hexStrToBin(this.tagReadHex(tagId, firstBlock, nBytes, options, status));
    }

    public ArrayList<Integer> tagReadArray(String tagId, int firstBlock, int nBytes, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        byte[] blk = new byte[]{};
        ArrayList<Integer> res = new ArrayList<Integer>();
        blk = this.tagReadBin(tagId, firstBlock, nBytes, options, status);
        int endidx = blk.length;
        for (int idx = 0; idx < endidx; ++idx) {
            res.add(blk[idx] & 0xFF);
        }
        return res;
    }

    public String tagReadStr(String tagId, int firstBlock, int nChars, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        return new String(this.tagReadBin(tagId, firstBlock, nChars, options, status));
    }

    public int tagWriteBin(String tagId, int firstBlock, byte[] buff, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        byte[] json = new byte[]{};
        int buflen = buff.length;
        if (buflen <= 16) {
            String hexstr = YAPIContext._bytesToHexStr(buff, 0, buff.length);
            return this.tagWriteHex(tagId, firstBlock, hexstr, options, status);
        }
        String optstr = options.imm_getParams();
        String fname = String.format(Locale.US, "Rfid:t=%s&b=%d&n=%d%s", tagId, firstBlock, buflen, optstr);
        json = this._uploadEx(fname, buff);
        return this._chkerror(tagId, json, status);
    }

    public int tagWriteArray(String tagId, int firstBlock, ArrayList<Integer> byteList, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        byte[] buff = new byte[]{};
        int bufflen = byteList.size();
        buff = new byte[bufflen];
        for (int idx = 0; idx < bufflen; ++idx) {
            int hexb = byteList.get(idx);
            buff[idx] = (byte)(hexb & 0xFF);
        }
        return this.tagWriteBin(tagId, firstBlock, buff, options, status);
    }

    public int tagWriteHex(String tagId, int firstBlock, String hexString, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        byte[] json = new byte[]{};
        byte[] buff = new byte[]{};
        int bufflen = hexString.length();
        if ((bufflen >>= 1) <= 16) {
            String optstr = options.imm_getParams();
            String url = String.format(Locale.US, "rfid.json?a=writ&t=%s&b=%d&w=%s%s", tagId, firstBlock, hexString, optstr);
            json = this._download(url);
            return this._chkerror(tagId, json, status);
        }
        buff = new byte[bufflen];
        for (int idx = 0; idx < bufflen; ++idx) {
            int hexb = Integer.valueOf(hexString.substring(2 * idx, 2 * idx + 2), 16);
            buff[idx] = (byte)(hexb & 0xFF);
        }
        return this.tagWriteBin(tagId, firstBlock, buff, options, status);
    }

    public int tagWriteStr(String tagId, int firstBlock, String text, YRfidOptions options, YRfidStatus status) throws YAPI_Exception {
        byte[] buff = new byte[]{};
        buff = text.getBytes();
        return this.tagWriteBin(tagId, firstBlock, buff, options, status);
    }

    public String get_lastEvents() throws YAPI_Exception {
        byte[] content = new byte[]{};
        content = this._download("events.txt");
        return new String(content);
    }

    public int registerEventCallback(YEventCallback callback) throws YAPI_Exception {
        this._eventCallback = callback;
        this._isFirstCb = true;
        if (callback != null) {
            this.registerValueCallback(this.yInternalEventCallback);
        } else {
            this.registerValueCallback((UpdateCallback)null);
        }
        return 0;
    }

    public int _internalEventHandler(String cbVal) throws YAPI_Exception {
        int tagIdx;
        String evtData;
        String evtType;
        int dataPos;
        int typePos;
        String eventStr;
        int arrPos;
        byte[] content = new byte[]{};
        ArrayList<Object> currentTags = new ArrayList();
        ArrayList<Object> eventArr = new ArrayList();
        ArrayList<Integer> lastEvents = new ArrayList<Integer>();
        int cbPos = YAPIContext._atoi(cbVal);
        int cbNtags = cbPos % 1000;
        int cbDPos = (cbPos /= 1000) - this._prevCbPos & 0x7FFFF;
        this._prevCbPos = cbPos;
        if (cbDPos > 16384) {
            this._eventPos = 0;
        }
        if (this._eventCallback == null) {
            return 0;
        }
        String url = String.format(Locale.US, "events.txt?pos=%d", this._eventPos);
        content = this._download(url);
        String contentStr = new String(content);
        eventArr = new ArrayList<String>(Arrays.asList(contentStr.split("\n")));
        int arrLen = eventArr.size();
        if (arrLen <= 0) {
            throw new YAPI_Exception(-8, "fail to download events");
        }
        String lenStr = (String)eventArr.get(--arrLen);
        lenStr = lenStr.substring(1, 1 + lenStr.length() - 1);
        this._eventPos = YAPIContext._atoi(lenStr);
        if (this._isFirstCb) {
            this._isFirstCb = false;
            this._eventStamp = 0;
            if (cbNtags == 0) {
                return 0;
            }
            currentTags = this.get_tagIdList();
            int searchTags = cbNtags = currentTags.size();
            lastEvents.clear();
            for (arrPos = arrLen - 1; arrPos >= 0 && searchTags > 0; --arrPos) {
                eventStr = (String)eventArr.get(arrPos);
                typePos = eventStr.indexOf(":") + 1;
                if (typePos <= 8) continue;
                dataPos = eventStr.indexOf("=") + 1;
                evtType = eventStr.substring(typePos, typePos + 1);
                if (dataPos <= 10 || !evtType.equals("+")) continue;
                evtData = eventStr.substring(dataPos, dataPos + eventStr.length() - dataPos);
                for (tagIdx = searchTags - 1; tagIdx >= 0; --tagIdx) {
                    if (!evtData.equals(currentTags.get(tagIdx))) continue;
                    lastEvents.add(0 + arrPos);
                    currentTags.set(tagIdx, "");
                    while (searchTags > 0 && ((String)currentTags.get(searchTags - 1)).equals("")) {
                        --searchTags;
                    }
                    tagIdx = -1;
                }
            }
            for (tagIdx = 0; tagIdx < searchTags; ++tagIdx) {
                evtData = (String)currentTags.get(tagIdx);
                if (evtData.equals("")) continue;
                this._eventCallback.eventCallback(this, 0, "+", evtData);
            }
        } else {
            lastEvents.clear();
            for (arrPos = arrLen - 1; arrPos >= 0; --arrPos) {
                lastEvents.add(0 + arrPos);
            }
        }
        arrLen = lastEvents.size();
        for (arrPos = arrLen - 1; arrPos >= 0; --arrPos) {
            tagIdx = (Integer)lastEvents.get(arrPos);
            eventStr = (String)eventArr.get(tagIdx);
            int eventLen = eventStr.length();
            if (eventLen < 1) continue;
            String hexStamp = eventStr.substring(0, 8);
            int evtStamp = Integer.valueOf(hexStamp, 16);
            typePos = eventStr.indexOf(":") + 1;
            if (evtStamp < this._eventStamp || typePos <= 8) continue;
            this._eventStamp = evtStamp;
            dataPos = eventStr.indexOf("=") + 1;
            evtType = eventStr.substring(typePos, typePos + 1);
            evtData = "";
            if (dataPos > 10) {
                evtData = eventStr.substring(dataPos, dataPos + eventLen - dataPos);
            }
            this._eventCallback.eventCallback(this, evtStamp, evtType, evtData);
        }
        return 0;
    }

    public YRfidReader nextRfidReader() {
        String next_hwid;
        try {
            String hwid = this._yapi._yHash.resolveHwID(this._className, this._func);
            next_hwid = this._yapi._yHash.getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YRfidReader.FindRfidReaderInContext(this._yapi, next_hwid);
    }

    public static YRfidReader FirstRfidReader() {
        YAPIContext yctx = YAPI.GetYCtx(false);
        if (yctx == null) {
            return null;
        }
        String next_hwid = yctx._yHash.getFirstHardwareId("RfidReader");
        if (next_hwid == null) {
            return null;
        }
        return YRfidReader.FindRfidReaderInContext(yctx, next_hwid);
    }

    public static YRfidReader FirstRfidReaderInContext(YAPIContext yctx) {
        String next_hwid = yctx._yHash.getFirstHardwareId("RfidReader");
        if (next_hwid == null) {
            return null;
        }
        return YRfidReader.FindRfidReaderInContext(yctx, next_hwid);
    }

    public static interface YEventCallback {
        public void eventCallback(YRfidReader var1, int var2, String var3, String var4);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YRfidReader var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YRfidReader var1, String var2);
    }
}

