/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import java.util.ArrayList;
import java.util.Locale;

public class YInputCaptureData {
    protected YAPIContext _yapi;
    protected int _fmt = 0;
    protected int _var1size = 0;
    protected int _var2size = 0;
    protected int _var3size = 0;
    protected int _nVars = 0;
    protected int _recOfs = 0;
    protected int _nRecs = 0;
    protected int _samplesPerSec = 0;
    protected int _trigType = 0;
    protected double _trigVal = 0.0;
    protected int _trigPos = 0;
    protected double _trigUTC = 0.0;
    protected String _var1unit;
    protected String _var2unit;
    protected String _var3unit;
    protected ArrayList<Double> _var1samples = new ArrayList();
    protected ArrayList<Double> _var2samples = new ArrayList();
    protected ArrayList<Double> _var3samples = new ArrayList();

    YInputCaptureData(YFunction yfun, byte[] sdata) throws YAPI_Exception {
        this._yapi = yfun._yapi;
        this._decodeSnapBin(sdata);
    }

    public int _decodeU16(byte[] sdata, int ofs) {
        int v = sdata[ofs] & 0xFF;
        return v += 256 * (sdata[ofs + 1] & 0xFF);
    }

    public double _decodeU32(byte[] sdata, int ofs) {
        double v = this._decodeU16(sdata, ofs);
        return v += 65536.0 * (double)this._decodeU16(sdata, ofs + 2);
    }

    public double _decodeVal(byte[] sdata, int ofs, int len) {
        double v = this._decodeU16(sdata, ofs);
        double b = 65536.0;
        ofs += 2;
        len -= 2;
        while (len > 0) {
            v += b * (double)(sdata[ofs] & 0xFF);
            b *= 256.0;
            ++ofs;
            --len;
        }
        if (v > b / 2.0) {
            v -= b;
        }
        return v;
    }

    public int _decodeSnapBin(byte[] sdata) throws YAPI_Exception {
        double v;
        int buffSize = sdata.length;
        if (buffSize < 24) {
            throw new YAPI_Exception(-2, "Invalid snapshot data (too short)");
        }
        this._fmt = sdata[0] & 0xFF;
        this._var1size = (sdata[1] & 0xFF) - 48;
        this._var2size = (sdata[2] & 0xFF) - 48;
        this._var3size = (sdata[3] & 0xFF) - 48;
        if (this._fmt != 83) {
            throw new YAPI_Exception(-2, "Unsupported snapshot format");
        }
        if (this._var1size < 2 || this._var1size > 4) {
            throw new YAPI_Exception(-2, "Invalid sample size");
        }
        if (this._var2size < 0 || this._var1size > 4) {
            throw new YAPI_Exception(-2, "Invalid sample size");
        }
        if (this._var3size < 0 || this._var1size > 4) {
            throw new YAPI_Exception(-2, "Invalid sample size");
        }
        this._nVars = this._var2size == 0 ? 1 : (this._var3size == 0 ? 2 : 3);
        int recSize = this._var1size + this._var2size + this._var3size;
        this._recOfs = this._decodeU16(sdata, 4);
        this._nRecs = this._decodeU16(sdata, 6);
        this._samplesPerSec = this._decodeU16(sdata, 8);
        this._trigType = this._decodeU16(sdata, 10);
        this._trigVal = this._decodeVal(sdata, 12, 4) / 1000.0;
        this._trigPos = this._decodeU16(sdata, 16);
        int ms = this._decodeU16(sdata, 18);
        this._trigUTC = this._decodeVal(sdata, 20, 4);
        this._trigUTC += (double)ms / 1000.0;
        int recOfs = 24;
        while ((sdata[recOfs] & 0xFF) >= 32) {
            this._var1unit = String.format(Locale.US, "%s%c", this._var1unit, sdata[recOfs] & 0xFF);
            ++recOfs;
        }
        if (this._var2size > 0) {
            ++recOfs;
            while ((sdata[recOfs] & 0xFF) >= 32) {
                this._var2unit = String.format(Locale.US, "%s%c", this._var2unit, sdata[recOfs] & 0xFF);
                ++recOfs;
            }
        }
        if (this._var3size > 0) {
            ++recOfs;
            while ((sdata[recOfs] & 0xFF) >= 32) {
                this._var3unit = String.format(Locale.US, "%s%c", this._var3unit, sdata[recOfs] & 0xFF);
                ++recOfs;
            }
        }
        if ((recOfs & 1) == 1) {
            ++recOfs;
        }
        int mult1 = 1;
        int mult2 = 1;
        int mult3 = 1;
        if (recOfs < this._recOfs) {
            mult1 = this._decodeU16(sdata, this._recOfs);
            recOfs += 2;
            if (this._var2size > 0) {
                mult2 = this._decodeU16(sdata, this._recOfs);
                recOfs += 2;
            }
            if (this._var3size > 0) {
                mult3 = this._decodeU16(sdata, this._recOfs);
                recOfs += 2;
            }
        }
        recOfs = this._recOfs;
        int count = this._nRecs;
        while (count > 0 && recOfs + this._var1size <= buffSize) {
            v = this._decodeVal(sdata, recOfs, this._var1size) / 1000.0;
            this._var1samples.add(v * (double)mult1);
            recOfs += recSize;
        }
        if (this._var2size > 0) {
            recOfs = this._recOfs + this._var1size;
            count = this._nRecs;
            while (count > 0 && recOfs + this._var2size <= buffSize) {
                v = this._decodeVal(sdata, recOfs, this._var2size) / 1000.0;
                this._var2samples.add(v * (double)mult2);
                recOfs += recSize;
            }
        }
        if (this._var3size > 0) {
            recOfs = this._recOfs + this._var1size + this._var2size;
            count = this._nRecs;
            while (count > 0 && recOfs + this._var3size <= buffSize) {
                v = this._decodeVal(sdata, recOfs, this._var3size) / 1000.0;
                this._var3samples.add(v * (double)mult3);
                recOfs += recSize;
            }
        }
        return 0;
    }

    public int get_serieCount() {
        return this._nVars;
    }

    public int get_recordCount() {
        return this._nRecs;
    }

    public int get_samplingRate() {
        return this._samplesPerSec;
    }

    public int get_captureType() {
        return this._trigType;
    }

    public double get_triggerValue() {
        return this._trigVal;
    }

    public int get_triggerPosition() {
        return this._trigPos;
    }

    public double get_triggerRealTimeUTC() {
        return this._trigUTC;
    }

    public String get_serie1Unit() {
        return this._var1unit;
    }

    public String get_serie2Unit() throws YAPI_Exception {
        if (this._nVars < 2) {
            throw new YAPI_Exception(-2, "There is no serie 2 in this capture data");
        }
        return this._var2unit;
    }

    public String get_serie3Unit() throws YAPI_Exception {
        if (this._nVars < 3) {
            throw new YAPI_Exception(-2, "There is no serie 3 in this capture data");
        }
        return this._var3unit;
    }

    public ArrayList<Double> get_serie1Values() throws YAPI_Exception {
        return this._var1samples;
    }

    public ArrayList<Double> get_serie2Values() throws YAPI_Exception {
        if (this._nVars < 2) {
            throw new YAPI_Exception(-2, "There is no serie 2 in this capture data");
        }
        return this._var2samples;
    }

    public ArrayList<Double> get_serie3Values() throws YAPI_Exception {
        if (this._nVars < 3) {
            throw new YAPI_Exception(-2, "There is no serie 3 in this capture data");
        }
        return this._var3samples;
    }
}

