/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YSms;
import java.util.ArrayList;
import java.util.Locale;

public class YMessageBox
extends YFunction {
    public static final int SLOTSINUSE_INVALID = -1;
    public static final int SLOTSCOUNT_INVALID = -1;
    public static final String SLOTSBITMAP_INVALID = "!INVALID!";
    public static final int PDUSENT_INVALID = -1;
    public static final int PDURECEIVED_INVALID = -1;
    public static final String OBEY_INVALID = "!INVALID!";
    public static final String COMMAND_INVALID = "!INVALID!";
    protected int _slotsInUse = -1;
    protected int _slotsCount = -1;
    protected String _slotsBitmap = "!INVALID!";
    protected int _pduSent = -1;
    protected int _pduReceived = -1;
    protected String _obey = "!INVALID!";
    protected String _command = "!INVALID!";
    protected UpdateCallback _valueCallbackMessageBox = null;
    protected int _nextMsgRef = 0;
    protected String _prevBitmapStr = "";
    protected ArrayList<YSms> _pdus = new ArrayList();
    protected ArrayList<YSms> _messages = new ArrayList();
    protected boolean _gsm2unicodeReady;
    protected ArrayList<Integer> _gsm2unicode = new ArrayList();
    protected byte[] _iso2gsm = new byte[0];

    protected YMessageBox(YAPIContext ctx, String func) {
        super(ctx, func);
        this._className = "MessageBox";
    }

    protected YMessageBox(String func) {
        this(YAPI.GetYCtx(true), func);
    }

    @Override
    protected void _parseAttr(YJSONObject json_val) throws Exception {
        if (json_val.has("slotsInUse")) {
            this._slotsInUse = json_val.getInt("slotsInUse");
        }
        if (json_val.has("slotsCount")) {
            this._slotsCount = json_val.getInt("slotsCount");
        }
        if (json_val.has("slotsBitmap")) {
            this._slotsBitmap = json_val.getString("slotsBitmap");
        }
        if (json_val.has("pduSent")) {
            this._pduSent = json_val.getInt("pduSent");
        }
        if (json_val.has("pduReceived")) {
            this._pduReceived = json_val.getInt("pduReceived");
        }
        if (json_val.has("obey")) {
            this._obey = json_val.getString("obey");
        }
        if (json_val.has("command")) {
            this._command = json_val.getString("command");
        }
        super._parseAttr(json_val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_slotsInUse() throws YAPI_Exception {
        int res;
        YMessageBox yMessageBox = this;
        synchronized (yMessageBox) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._slotsInUse;
        }
        return res;
    }

    public int getSlotsInUse() throws YAPI_Exception {
        return this.get_slotsInUse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_slotsCount() throws YAPI_Exception {
        int res;
        YMessageBox yMessageBox = this;
        synchronized (yMessageBox) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._slotsCount;
        }
        return res;
    }

    public int getSlotsCount() throws YAPI_Exception {
        return this.get_slotsCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_slotsBitmap() throws YAPI_Exception {
        String res;
        YMessageBox yMessageBox = this;
        synchronized (yMessageBox) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._slotsBitmap;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_pduSent() throws YAPI_Exception {
        int res;
        YMessageBox yMessageBox = this;
        synchronized (yMessageBox) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._pduSent;
        }
        return res;
    }

    public int getPduSent() throws YAPI_Exception {
        return this.get_pduSent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_pduSent(int newval) throws YAPI_Exception {
        YMessageBox yMessageBox = this;
        synchronized (yMessageBox) {
            String rest_val = Integer.toString(newval);
            this._setAttr("pduSent", rest_val);
        }
        return 0;
    }

    public int setPduSent(int newval) throws YAPI_Exception {
        return this.set_pduSent(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_pduReceived() throws YAPI_Exception {
        int res;
        YMessageBox yMessageBox = this;
        synchronized (yMessageBox) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._pduReceived;
        }
        return res;
    }

    public int getPduReceived() throws YAPI_Exception {
        return this.get_pduReceived();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_pduReceived(int newval) throws YAPI_Exception {
        YMessageBox yMessageBox = this;
        synchronized (yMessageBox) {
            String rest_val = Integer.toString(newval);
            this._setAttr("pduReceived", rest_val);
        }
        return 0;
    }

    public int setPduReceived(int newval) throws YAPI_Exception {
        return this.set_pduReceived(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_obey() throws YAPI_Exception {
        String res;
        YMessageBox yMessageBox = this;
        synchronized (yMessageBox) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._obey;
        }
        return res;
    }

    public String getObey() throws YAPI_Exception {
        return this.get_obey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_obey(String newval) throws YAPI_Exception {
        YMessageBox yMessageBox = this;
        synchronized (yMessageBox) {
            String rest_val = newval;
            this._setAttr("obey", rest_val);
        }
        return 0;
    }

    public int setObey(String newval) throws YAPI_Exception {
        return this.set_obey(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_command() throws YAPI_Exception {
        String res;
        YMessageBox yMessageBox = this;
        synchronized (yMessageBox) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._command;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_command(String newval) throws YAPI_Exception {
        YMessageBox yMessageBox = this;
        synchronized (yMessageBox) {
            String rest_val = newval;
            this._setAttr("command", rest_val);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YMessageBox FindMessageBox(String func) {
        YMessageBox obj;
        YAPIContext ctx = YAPI.GetYCtx(true);
        Object object = ctx._functionCacheLock;
        synchronized (object) {
            obj = (YMessageBox)YFunction._FindFromCache("MessageBox", func);
            if (obj == null) {
                obj = new YMessageBox(func);
                YFunction._AddToCache("MessageBox", func, obj);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YMessageBox FindMessageBoxInContext(YAPIContext yctx, String func) {
        YMessageBox obj;
        Object object = yctx._functionCacheLock;
        synchronized (object) {
            obj = (YMessageBox)YFunction._FindFromCacheInContext(yctx, "MessageBox", func);
            if (obj == null) {
                obj = new YMessageBox(yctx, func);
                YFunction._AddToCache("MessageBox", func, obj);
            }
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackMessageBox = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackMessageBox != null) {
            this._valueCallbackMessageBox.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int nextMsgRef() {
        ++this._nextMsgRef;
        return this._nextMsgRef;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int clearSIMSlot(int slot) throws YAPI_Exception {
        byte[] newBitmap = new byte[]{};
        for (int retry = 5; retry > 0; --retry) {
            this.clearCache();
            String bitmapStr = this.get_slotsBitmap();
            newBitmap = YAPIContext._hexStrToBin(bitmapStr);
            int idx = slot >> 3;
            if (idx >= newBitmap.length) return -2;
            int bitVal = 1 << (slot & 7);
            if ((newBitmap[idx] & 0xFF & bitVal) == 0) return 0;
            this._prevBitmapStr = "";
            int int_res = this.set_command(String.format(Locale.US, "DS%d", slot));
            if (int_res < 0) {
                return int_res;
            }
            String res = this._AT("");
        }
        return -8;
    }

    public String _AT(String cmd) throws YAPI_Exception {
        byte[] buff = new byte[]{};
        int cmdLen = cmd.length();
        int chrPos = cmd.indexOf("#");
        while (chrPos >= 0) {
            cmd = String.format(Locale.US, "%s%c23%s", cmd.substring(0, chrPos), 37, cmd.substring(chrPos + 1, chrPos + 1 + cmdLen - chrPos - 1));
            cmdLen += 2;
            chrPos = cmd.indexOf("#");
        }
        chrPos = cmd.indexOf("+");
        while (chrPos >= 0) {
            cmd = String.format(Locale.US, "%s%c2B%s", cmd.substring(0, chrPos), 37, cmd.substring(chrPos + 1, chrPos + 1 + cmdLen - chrPos - 1));
            cmdLen += 2;
            chrPos = cmd.indexOf("+");
        }
        chrPos = cmd.indexOf("=");
        while (chrPos >= 0) {
            cmd = String.format(Locale.US, "%s%c3D%s", cmd.substring(0, chrPos), 37, cmd.substring(chrPos + 1, chrPos + 1 + cmdLen - chrPos - 1));
            cmdLen += 2;
            chrPos = cmd.indexOf("=");
        }
        cmd = String.format(Locale.US, "at.txt?cmd=%s", cmd);
        String res = "";
        int waitMore = 24;
        while (waitMore > 0) {
            int idx;
            buff = this._download(cmd);
            int bufflen = buff.length;
            String buffstr = new String(buff);
            int buffstrlen = buffstr.length();
            for (idx = bufflen - 1; idx > 0 && (buff[idx] & 0xFF) != 64 && (buff[idx] & 0xFF) != 10 && (buff[idx] & 0xFF) != 13; --idx) {
            }
            if ((buff[idx] & 0xFF) == 64) {
                int suffixlen = bufflen - idx;
                cmd = String.format(Locale.US, "at.txt?cmd=%s", buffstr.substring(buffstrlen - suffixlen, buffstrlen - suffixlen + suffixlen));
                buffstr = buffstr.substring(0, buffstrlen - suffixlen);
                --waitMore;
            } else {
                waitMore = 0;
            }
            res = String.format(Locale.US, "%s%s", res, buffstr);
        }
        return res;
    }

    public YSms fetchPdu(int slot) throws YAPI_Exception {
        byte[] binPdu = new byte[]{};
        ArrayList<Object> arrPdu = new ArrayList();
        binPdu = this._download(String.format(Locale.US, "sms.json?pos=%d&len=1", slot));
        arrPdu = this._json_get_array(binPdu);
        String hexPdu = this._decode_json_string((String)arrPdu.get(0));
        YSms sms = new YSms(this);
        sms.set_slot(slot);
        sms.parsePdu(YAPIContext._hexStrToBin(hexPdu));
        return sms;
    }

    public int initGsm2Unicode() {
        int i;
        this._gsm2unicode.clear();
        this._gsm2unicode.add(64);
        this._gsm2unicode.add(163);
        this._gsm2unicode.add(36);
        this._gsm2unicode.add(165);
        this._gsm2unicode.add(232);
        this._gsm2unicode.add(233);
        this._gsm2unicode.add(249);
        this._gsm2unicode.add(236);
        this._gsm2unicode.add(242);
        this._gsm2unicode.add(199);
        this._gsm2unicode.add(10);
        this._gsm2unicode.add(216);
        this._gsm2unicode.add(248);
        this._gsm2unicode.add(13);
        this._gsm2unicode.add(197);
        this._gsm2unicode.add(229);
        this._gsm2unicode.add(916);
        this._gsm2unicode.add(95);
        this._gsm2unicode.add(934);
        this._gsm2unicode.add(915);
        this._gsm2unicode.add(923);
        this._gsm2unicode.add(937);
        this._gsm2unicode.add(928);
        this._gsm2unicode.add(936);
        this._gsm2unicode.add(931);
        this._gsm2unicode.add(920);
        this._gsm2unicode.add(926);
        this._gsm2unicode.add(27);
        this._gsm2unicode.add(198);
        this._gsm2unicode.add(230);
        this._gsm2unicode.add(223);
        this._gsm2unicode.add(201);
        for (i = 32; i <= 122; ++i) {
            this._gsm2unicode.add(i);
        }
        this._gsm2unicode.set(36, 164);
        this._gsm2unicode.set(64, 161);
        this._gsm2unicode.set(91, 196);
        this._gsm2unicode.set(92, 214);
        this._gsm2unicode.set(93, 209);
        this._gsm2unicode.set(94, 220);
        this._gsm2unicode.set(95, 167);
        this._gsm2unicode.set(96, 191);
        this._gsm2unicode.add(228);
        this._gsm2unicode.add(246);
        this._gsm2unicode.add(241);
        this._gsm2unicode.add(252);
        this._gsm2unicode.add(224);
        this._iso2gsm = new byte[256];
        for (i = 0; i <= 127; ++i) {
            int uni = this._gsm2unicode.get(i);
            if (uni > 255) continue;
            this._iso2gsm[uni] = (byte)(i & 0xFF);
        }
        for (i = 0; i < 4; ++i) {
            this._iso2gsm[91 + i] = 27;
            this._iso2gsm[123 + i] = 27;
        }
        this._gsm2unicodeReady = true;
        return 0;
    }

    public ArrayList<Integer> gsm2unicode(byte[] gsm) {
        int i;
        int gsmlen;
        ArrayList<Integer> res = new ArrayList<Integer>();
        if (!this._gsm2unicodeReady) {
            this.initGsm2Unicode();
        }
        int reslen = gsmlen = gsm.length;
        for (i = 0; i < gsmlen; ++i) {
            if ((gsm[i] & 0xFF) != 27) continue;
            --reslen;
        }
        res.clear();
        for (i = 0; i < gsmlen; ++i) {
            int uni = this._gsm2unicode.get(gsm[i] & 0xFF);
            if (uni == 27 && i + 1 < gsmlen) {
                uni = (uni = gsm[++i] & 0xFF) < 60 ? (uni < 41 ? (uni == 20 ? 94 : (uni == 40 ? 123 : 0)) : (uni == 41 ? 125 : (uni == 47 ? 92 : 0))) : (uni < 62 ? (uni == 60 ? 91 : (uni == 61 ? 126 : 0)) : (uni == 62 ? 93 : (uni == 64 ? 124 : (uni == 101 ? 164 : 0))));
            }
            if (uni <= 0) continue;
            res.add(uni);
        }
        return res;
    }

    public String gsm2str(byte[] gsm) {
        int i;
        int gsmlen;
        byte[] resbin = new byte[]{};
        if (!this._gsm2unicodeReady) {
            this.initGsm2Unicode();
        }
        int reslen = gsmlen = gsm.length;
        for (i = 0; i < gsmlen; ++i) {
            if ((gsm[i] & 0xFF) != 27) continue;
            --reslen;
        }
        resbin = new byte[reslen];
        reslen = 0;
        for (i = 0; i < gsmlen; ++i) {
            int uni = this._gsm2unicode.get(gsm[i] & 0xFF);
            if (uni == 27 && i + 1 < gsmlen) {
                uni = (uni = gsm[++i] & 0xFF) < 60 ? (uni < 41 ? (uni == 20 ? 94 : (uni == 40 ? 123 : 0)) : (uni == 41 ? 125 : (uni == 47 ? 92 : 0))) : (uni < 62 ? (uni == 60 ? 91 : (uni == 61 ? 126 : 0)) : (uni == 62 ? 93 : (uni == 64 ? 124 : (uni == 101 ? 164 : 0))));
            }
            if (uni <= 0 || uni >= 256) continue;
            resbin[reslen] = (byte)(uni & 0xFF);
            ++reslen;
        }
        String resstr = new String(resbin);
        if (resstr.length() > reslen) {
            resstr = resstr.substring(0, reslen);
        }
        return resstr;
    }

    public byte[] str2gsm(String msg) {
        int gsm7;
        int ch;
        int i;
        byte[] asc = new byte[]{};
        byte[] res = new byte[]{};
        if (!this._gsm2unicodeReady) {
            this.initGsm2Unicode();
        }
        asc = msg.getBytes();
        int asclen = asc.length;
        int extra = 0;
        for (i = 0; i < asclen; ++i) {
            ch = asc[i] & 0xFF;
            gsm7 = this._iso2gsm[ch] & 0xFF;
            if (gsm7 == 27) {
                ++extra;
            }
            if (gsm7 != 0) continue;
            res = new byte[]{};
            return res;
        }
        res = new byte[asclen + extra];
        int wpos = 0;
        for (i = 0; i < asclen; ++i) {
            ch = asc[i] & 0xFF;
            gsm7 = this._iso2gsm[ch] & 0xFF;
            res[wpos] = (byte)(gsm7 & 0xFF);
            ++wpos;
            if (gsm7 != 27) continue;
            gsm7 = ch < 100 ? (ch < 93 ? (ch < 92 ? 60 : 47) : (ch < 94 ? 62 : 20)) : (ch < 125 ? (ch < 124 ? 40 : 64) : (ch < 126 ? 41 : 61));
            res[wpos] = (byte)(gsm7 & 0xFF);
            ++wpos;
        }
        return res;
    }

    public int checkNewMessages() throws YAPI_Exception {
        int i;
        String sig;
        int bitVal;
        int idx;
        int slot;
        YSms sms;
        int pduIdx;
        byte[] prevBitmap = new byte[]{};
        byte[] newBitmap = new byte[]{};
        ArrayList<YSms> newArr = new ArrayList<YSms>();
        ArrayList<YSms> newMsg = new ArrayList<YSms>();
        ArrayList<YSms> newAgg = new ArrayList<YSms>();
        ArrayList<String> signatures = new ArrayList<String>();
        String bitmapStr = this.get_slotsBitmap();
        if (bitmapStr.equals(this._prevBitmapStr)) {
            return 0;
        }
        prevBitmap = YAPIContext._hexStrToBin(this._prevBitmapStr);
        newBitmap = YAPIContext._hexStrToBin(bitmapStr);
        this._prevBitmapStr = bitmapStr;
        int nslots = 8 * newBitmap.length;
        newArr.clear();
        newMsg.clear();
        signatures.clear();
        int nsig = 0;
        for (pduIdx = 0; pduIdx < this._pdus.size(); ++pduIdx) {
            sms = this._pdus.get(pduIdx);
            slot = sms.get_slot();
            idx = slot >> 3;
            if (idx >= newBitmap.length || (newBitmap[idx] & 0xFF & (bitVal = 1 << (slot & 7))) == 0) continue;
            newArr.add(sms);
            if (sms.get_concatCount() == 0) {
                newMsg.add(sms);
                continue;
            }
            sig = sms.get_concatSignature();
            for (i = 0; i < nsig && sig.length() > 0; ++i) {
                if (!((String)signatures.get(i)).equals(sig)) continue;
                sig = "";
            }
            if (sig.length() <= 0) continue;
            signatures.add(sig);
            ++nsig;
        }
        for (slot = 0; slot < nslots; ++slot) {
            idx = slot >> 3;
            bitVal = 1 << (slot & 7);
            int prevBit = 0;
            if (idx < prevBitmap.length) {
                prevBit = prevBitmap[idx] & 0xFF & bitVal;
            }
            if ((newBitmap[idx] & 0xFF & bitVal) == 0 || prevBit != 0) continue;
            sms = this.fetchPdu(slot);
            newArr.add(sms);
            if (sms.get_concatCount() == 0) {
                newMsg.add(sms);
                continue;
            }
            sig = sms.get_concatSignature();
            for (i = 0; i < nsig && sig.length() > 0; ++i) {
                if (!((String)signatures.get(i)).equals(sig)) continue;
                sig = "";
            }
            if (sig.length() <= 0) continue;
            signatures.add(sig);
            ++nsig;
        }
        this._pdus = newArr;
        for (i = 0; i < nsig; ++i) {
            sig = (String)signatures.get(i);
            int cnt = 0;
            for (pduIdx = 0; pduIdx < this._pdus.size(); ++pduIdx) {
                sms = this._pdus.get(pduIdx);
                if (sms.get_concatCount() <= 0 || !sms.get_concatSignature().equals(sig)) continue;
                if (cnt == 0) {
                    cnt = sms.get_concatCount();
                    newAgg.clear();
                }
                newAgg.add(sms);
            }
            if (cnt <= 0 || newAgg.size() != cnt) continue;
            sms = new YSms(this);
            sms.set_parts(newAgg);
            newMsg.add(sms);
        }
        this._messages = newMsg;
        return 0;
    }

    public ArrayList<YSms> get_pdus() throws YAPI_Exception {
        this.checkNewMessages();
        return this._pdus;
    }

    public int clearPduCounters() throws YAPI_Exception {
        int retcode = this.set_pduReceived(0);
        if (retcode != 0) {
            return retcode;
        }
        retcode = this.set_pduSent(0);
        return retcode;
    }

    public int sendTextMessage(String recipient, String message) throws YAPI_Exception {
        YSms sms = new YSms(this);
        sms.set_recipient(recipient);
        sms.addText(message);
        return sms.send();
    }

    public int sendFlashMessage(String recipient, String message) throws YAPI_Exception {
        YSms sms = new YSms(this);
        sms.set_recipient(recipient);
        sms.set_msgClass(0);
        sms.addText(message);
        return sms.send();
    }

    public YSms newMessage(String recipient) throws YAPI_Exception {
        YSms sms = new YSms(this);
        sms.set_recipient(recipient);
        return sms;
    }

    public ArrayList<YSms> get_messages() throws YAPI_Exception {
        this.checkNewMessages();
        return this._messages;
    }

    public YMessageBox nextMessageBox() {
        String next_hwid;
        try {
            String hwid = this._yapi._yHash.resolveHwID(this._className, this._func);
            next_hwid = this._yapi._yHash.getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YMessageBox.FindMessageBoxInContext(this._yapi, next_hwid);
    }

    public static YMessageBox FirstMessageBox() {
        YAPIContext yctx = YAPI.GetYCtx(false);
        if (yctx == null) {
            return null;
        }
        String next_hwid = yctx._yHash.getFirstHardwareId("MessageBox");
        if (next_hwid == null) {
            return null;
        }
        return YMessageBox.FindMessageBoxInContext(yctx, next_hwid);
    }

    public static YMessageBox FirstMessageBoxInContext(YAPIContext yctx) {
        String next_hwid = yctx._yHash.getFirstHardwareId("MessageBox");
        if (next_hwid == null) {
            return null;
        }
        return YMessageBox.FindMessageBoxInContext(yctx, next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YMessageBox var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YMessageBox var1, String var2);
    }
}

