/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YJSONContent;

class YJSONString
extends YJSONContent {
    private String _stringValue;

    YJSONString(String data, int start, int stop) {
        super(data, start, stop, YJSONContent.YJSONType.STRING);
    }

    YJSONString(String data) {
        super(data, 0, data.length(), YJSONContent.YJSONType.STRING);
    }

    YJSONString() {
        super(YJSONContent.YJSONType.STRING);
    }

    @Override
    int parse() throws Exception {
        StringBuilder value = new StringBuilder();
        int cur_pos = YJSONString.SkipGarbage(this._data, this._data_start, this._data_boundary);
        if (cur_pos >= this._data_boundary || this._data.charAt(cur_pos) != '\"') {
            throw new Exception(this.formatError("double quote was expected", cur_pos));
        }
        int str_start = ++cur_pos;
        YJSONContent.Tjstate state = YJSONContent.Tjstate.JWAITFORSTRINGVALUE;
        while (cur_pos < this._data_boundary) {
            char sti = this._data.charAt(cur_pos);
            switch (state) {
                case JWAITFORSTRINGVALUE: {
                    if (sti == '\\') {
                        value.append(this._data.substring(str_start, cur_pos));
                        str_start = cur_pos;
                        state = YJSONContent.Tjstate.JWAITFORSTRINGVALUE_ESC;
                        break;
                    }
                    if (sti == '\"') {
                        value.append(this._data.substring(str_start, cur_pos));
                        this._stringValue = value.toString();
                        this._data_len = cur_pos + 1 - this._data_start;
                        return this._data_len;
                    }
                    if (sti >= ' ') break;
                    throw new Exception(this.formatError("invalid char: was expecting string value", cur_pos));
                }
                case JWAITFORSTRINGVALUE_ESC: {
                    value.append(sti);
                    state = YJSONContent.Tjstate.JWAITFORSTRINGVALUE;
                    str_start = cur_pos + 1;
                    break;
                }
                default: {
                    throw new Exception(this.formatError("invalid state for YJSONObject", cur_pos));
                }
            }
            ++cur_pos;
        }
        throw new Exception(this.formatError("unexpected end of data", cur_pos));
    }

    @Override
    String toJSON() {
        StringBuilder res = new StringBuilder(this._stringValue.length() * 2);
        res.append('\"');
        int len = this._stringValue.length();
        block10: for (int i = 0; i < len; ++i) {
            char c = this._stringValue.charAt(i);
            switch (c) {
                case '\"': {
                    res.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    res.append("\\\\");
                    continue block10;
                }
                case '/': {
                    res.append("\\/");
                    continue block10;
                }
                case '\b': {
                    res.append("\\b");
                    continue block10;
                }
                case '\f': {
                    res.append("\\f");
                    continue block10;
                }
                case '\n': {
                    res.append("\\n");
                    continue block10;
                }
                case '\r': {
                    res.append("\\r");
                    continue block10;
                }
                case '\t': {
                    res.append("\\t");
                    continue block10;
                }
                default: {
                    res.append(c);
                }
            }
        }
        res.append('\"');
        return res.toString();
    }

    String getString() {
        return this._stringValue;
    }

    public String toString() {
        return this._stringValue;
    }

    void setContent(String value) {
        this._stringValue = value;
    }
}

