/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFileRecord;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YMeasure;
import java.util.ArrayList;
import java.util.Locale;

public class YFiles
extends YFunction {
    public static final int FILESCOUNT_INVALID = -1;
    public static final int FREESPACE_INVALID = -1;
    protected int _filesCount = -1;
    protected int _freeSpace = -1;
    protected UpdateCallback _valueCallbackFiles = null;

    protected YFiles(YAPIContext yctx, String func) {
        super(yctx, func);
        this._className = "Files";
    }

    protected YFiles(String func) {
        this(YAPI.GetYCtx(true), func);
    }

    @Override
    protected void _parseAttr(YJSONObject json_val) throws Exception {
        if (json_val.has("filesCount")) {
            this._filesCount = json_val.getInt("filesCount");
        }
        if (json_val.has("freeSpace")) {
            this._freeSpace = json_val.getInt("freeSpace");
        }
        super._parseAttr(json_val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_filesCount() throws YAPI_Exception {
        int res;
        YFiles yFiles = this;
        synchronized (yFiles) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._filesCount;
        }
        return res;
    }

    public int getFilesCount() throws YAPI_Exception {
        return this.get_filesCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_freeSpace() throws YAPI_Exception {
        int res;
        YFiles yFiles = this;
        synchronized (yFiles) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._freeSpace;
        }
        return res;
    }

    public int getFreeSpace() throws YAPI_Exception {
        return this.get_freeSpace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YFiles FindFiles(String func) {
        YFiles obj;
        YAPIContext ctx = YAPI.GetYCtx(true);
        Object object = ctx._functionCacheLock;
        synchronized (object) {
            obj = (YFiles)YFunction._FindFromCache("Files", func);
            if (obj == null) {
                obj = new YFiles(func);
                YFunction._AddToCache("Files", func, obj);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YFiles FindFilesInContext(YAPIContext yctx, String func) {
        YFiles obj;
        Object object = yctx._functionCacheLock;
        synchronized (object) {
            obj = (YFiles)YFunction._FindFromCacheInContext(yctx, "Files", func);
            if (obj == null) {
                obj = new YFiles(yctx, func);
                YFunction._AddToCache("Files", func, obj);
            }
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackFiles = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackFiles != null) {
            this._valueCallbackFiles.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public byte[] sendCommand(String command) throws YAPI_Exception {
        String url = String.format(Locale.US, "files.json?a=%s", command);
        return this._download(url);
    }

    public int format_fs() throws YAPI_Exception {
        byte[] json = new byte[]{};
        json = this.sendCommand("format");
        String res = this._json_get_key(json, "res");
        if (!res.equals("ok")) {
            throw new YAPI_Exception(-8, "format failed");
        }
        return 0;
    }

    public ArrayList<YFileRecord> get_list(String pattern) throws YAPI_Exception {
        byte[] json = new byte[]{};
        ArrayList<Object> filelist = new ArrayList();
        ArrayList<YFileRecord> res = new ArrayList<YFileRecord>();
        json = this.sendCommand(String.format(Locale.US, "dir&f=%s", pattern));
        filelist = this._json_get_array(json);
        res.clear();
        for (String string : filelist) {
            res.add(new YFileRecord(string));
        }
        return res;
    }

    public boolean fileExist(String filename) throws YAPI_Exception {
        byte[] json = new byte[]{};
        ArrayList<Object> filelist = new ArrayList();
        if (filename.length() == 0) {
            return false;
        }
        json = this.sendCommand(String.format(Locale.US, "dir&f=%s", filename));
        filelist = this._json_get_array(json);
        return filelist.size() > 0;
    }

    public byte[] download(String pathname) throws YAPI_Exception {
        return this._download(pathname);
    }

    public int upload(String pathname, byte[] content) throws YAPI_Exception {
        return this._upload(pathname, content);
    }

    public int remove(String pathname) throws YAPI_Exception {
        byte[] json = new byte[]{};
        json = this.sendCommand(String.format(Locale.US, "del&f=%s", pathname));
        String res = this._json_get_key(json, "res");
        if (!res.equals("ok")) {
            throw new YAPI_Exception(-8, "unable to remove file");
        }
        return 0;
    }

    public YFiles nextFiles() {
        String next_hwid;
        try {
            String hwid = this._yapi._yHash.resolveHwID(this._className, this._func);
            next_hwid = this._yapi._yHash.getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YFiles.FindFilesInContext(this._yapi, next_hwid);
    }

    public static YFiles FirstFiles() {
        YAPIContext yctx = YAPI.GetYCtx(false);
        if (yctx == null) {
            return null;
        }
        String next_hwid = yctx._yHash.getFirstHardwareId("Files");
        if (next_hwid == null) {
            return null;
        }
        return YFiles.FindFilesInContext(yctx, next_hwid);
    }

    public static YFiles FirstFilesInContext(YAPIContext yctx) {
        String next_hwid = yctx._yHash.getFirstHardwareId("Files");
        if (next_hwid == null) {
            return null;
        }
        return YFiles.FindFilesInContext(yctx, next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YFiles var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YFiles var1, String var2);
    }
}

