/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YSensor;
import java.util.ArrayList;
import java.util.Locale;

public class YTemperature
extends YSensor {
    public static final int SENSORTYPE_DIGITAL = 0;
    public static final int SENSORTYPE_TYPE_K = 1;
    public static final int SENSORTYPE_TYPE_E = 2;
    public static final int SENSORTYPE_TYPE_J = 3;
    public static final int SENSORTYPE_TYPE_N = 4;
    public static final int SENSORTYPE_TYPE_R = 5;
    public static final int SENSORTYPE_TYPE_S = 6;
    public static final int SENSORTYPE_TYPE_T = 7;
    public static final int SENSORTYPE_PT100_4WIRES = 8;
    public static final int SENSORTYPE_PT100_3WIRES = 9;
    public static final int SENSORTYPE_PT100_2WIRES = 10;
    public static final int SENSORTYPE_RES_OHM = 11;
    public static final int SENSORTYPE_RES_NTC = 12;
    public static final int SENSORTYPE_RES_LINEAR = 13;
    public static final int SENSORTYPE_RES_INTERNAL = 14;
    public static final int SENSORTYPE_IR = 15;
    public static final int SENSORTYPE_RES_PT1000 = 16;
    public static final int SENSORTYPE_CHANNEL_OFF = 17;
    public static final int SENSORTYPE_INVALID = -1;
    public static final double SIGNALVALUE_INVALID = -1.79769313486231E308;
    public static final String SIGNALUNIT_INVALID = "!INVALID!";
    public static final String COMMAND_INVALID = "!INVALID!";
    protected int _sensorType = -1;
    protected double _signalValue = -1.79769313486231E308;
    protected String _signalUnit = "!INVALID!";
    protected String _command = "!INVALID!";
    protected UpdateCallback _valueCallbackTemperature = null;
    protected TimedReportCallback _timedReportCallbackTemperature = null;

    protected YTemperature(YAPIContext ctx, String func) {
        super(ctx, func);
        this._className = "Temperature";
    }

    protected YTemperature(String func) {
        this(YAPI.GetYCtx(true), func);
    }

    @Override
    protected void _parseAttr(YJSONObject json_val) throws Exception {
        if (json_val.has("sensorType")) {
            this._sensorType = json_val.getInt("sensorType");
        }
        if (json_val.has("signalValue")) {
            this._signalValue = (double)Math.round(json_val.getDouble("signalValue") / 65.536) / 1000.0;
        }
        if (json_val.has("signalUnit")) {
            this._signalUnit = json_val.getString("signalUnit");
        }
        if (json_val.has("command")) {
            this._command = json_val.getString("command");
        }
        super._parseAttr(json_val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_unit(String newval) throws YAPI_Exception {
        YTemperature yTemperature = this;
        synchronized (yTemperature) {
            String rest_val = newval;
            this._setAttr("unit", rest_val);
        }
        return 0;
    }

    public int setUnit(String newval) throws YAPI_Exception {
        return this.set_unit(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_sensorType() throws YAPI_Exception {
        int res;
        YTemperature yTemperature = this;
        synchronized (yTemperature) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1;
            }
            res = this._sensorType;
        }
        return res;
    }

    public int getSensorType() throws YAPI_Exception {
        return this.get_sensorType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_sensorType(int newval) throws YAPI_Exception {
        YTemperature yTemperature = this;
        synchronized (yTemperature) {
            String rest_val = Integer.toString(newval);
            this._setAttr("sensorType", rest_val);
        }
        return 0;
    }

    public int setSensorType(int newval) throws YAPI_Exception {
        return this.set_sensorType(newval);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double get_signalValue() throws YAPI_Exception {
        double res;
        YTemperature yTemperature = this;
        synchronized (yTemperature) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return -1.79769313486231E308;
            }
            res = (double)Math.round(this._signalValue * 1000.0) / 1000.0;
        }
        return res;
    }

    public double getSignalValue() throws YAPI_Exception {
        return this.get_signalValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_signalUnit() throws YAPI_Exception {
        String res;
        YTemperature yTemperature = this;
        synchronized (yTemperature) {
            if (this._cacheExpiration == 0L && this.load(this._yapi._defaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._signalUnit;
        }
        return res;
    }

    public String getSignalUnit() throws YAPI_Exception {
        return this.get_signalUnit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get_command() throws YAPI_Exception {
        String res;
        YTemperature yTemperature = this;
        synchronized (yTemperature) {
            if (this._cacheExpiration <= YAPIContext.GetTickCount() && this.load(this._yapi._defaultCacheValidity) != 0) {
                return "!INVALID!";
            }
            res = this._command;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int set_command(String newval) throws YAPI_Exception {
        YTemperature yTemperature = this;
        synchronized (yTemperature) {
            String rest_val = newval;
            this._setAttr("command", rest_val);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YTemperature FindTemperature(String func) {
        YTemperature obj;
        YAPIContext ctx = YAPI.GetYCtx(true);
        Object object = ctx._functionCacheLock;
        synchronized (object) {
            obj = (YTemperature)YFunction._FindFromCache("Temperature", func);
            if (obj == null) {
                obj = new YTemperature(func);
                YFunction._AddToCache("Temperature", func, obj);
            }
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static YTemperature FindTemperatureInContext(YAPIContext yctx, String func) {
        YTemperature obj;
        Object object = yctx._functionCacheLock;
        synchronized (object) {
            obj = (YTemperature)YFunction._FindFromCacheInContext(yctx, "Temperature", func);
            if (obj == null) {
                obj = new YTemperature(yctx, func);
                YFunction._AddToCache("Temperature", func, obj);
            }
        }
        return obj;
    }

    public int registerValueCallback(UpdateCallback callback) {
        String val;
        if (callback != null) {
            YFunction._UpdateValueCallbackList(this, true);
        } else {
            YFunction._UpdateValueCallbackList(this, false);
        }
        this._valueCallbackTemperature = callback;
        if (callback != null && this.isOnline() && !(val = this._advertisedValue).equals("")) {
            this._invokeValueCallback(val);
        }
        return 0;
    }

    @Override
    public int _invokeValueCallback(String value) {
        if (this._valueCallbackTemperature != null) {
            this._valueCallbackTemperature.yNewValue(this, value);
        } else {
            super._invokeValueCallback(value);
        }
        return 0;
    }

    public int registerTimedReportCallback(TimedReportCallback callback) {
        YTemperature sensor = this;
        if (callback != null) {
            YFunction._UpdateTimedReportCallbackList(sensor, true);
        } else {
            YFunction._UpdateTimedReportCallbackList(sensor, false);
        }
        this._timedReportCallbackTemperature = callback;
        return 0;
    }

    @Override
    public int _invokeTimedReportCallback(YMeasure value) {
        if (this._timedReportCallbackTemperature != null) {
            this._timedReportCallbackTemperature.timedReportCallback(this, value);
        } else {
            super._invokeTimedReportCallback(value);
        }
        return 0;
    }

    public int set_ntcParameters(double res25, double beta) throws YAPI_Exception {
        ArrayList<Double> tempValues = new ArrayList<Double>();
        ArrayList<Double> resValues = new ArrayList<Double>();
        double t0 = 298.15;
        double t1 = 373.15;
        double res100 = res25 * Math.exp(beta * (1.0 / t1 - 1.0 / t0));
        tempValues.clear();
        resValues.clear();
        tempValues.add(25.0);
        resValues.add(res25);
        tempValues.add(100.0);
        resValues.add(res100);
        return this.set_thermistorResponseTable(tempValues, resValues);
    }

    public int set_thermistorResponseTable(ArrayList<Double> tempValues, ArrayList<Double> resValues) throws YAPI_Exception {
        int siz = tempValues.size();
        if (siz < 2) {
            throw new YAPI_Exception(-2, "thermistor response table must have at least two points");
        }
        if (siz != resValues.size()) {
            throw new YAPI_Exception(-2, "table sizes mismatch");
        }
        int res = this.set_command("Z");
        if (res != 0) {
            throw new YAPI_Exception(-8, "unable to reset thermistor parameters");
        }
        int found = 1;
        double prev = 0.0;
        while (found > 0) {
            found = 0;
            double curr = 9.9999999E7;
            double currTemp = -999999.0;
            for (int idx = 0; idx < siz; ++idx) {
                double idxres = resValues.get(idx);
                if (!(idxres > prev) || !(idxres < curr)) continue;
                curr = idxres;
                currTemp = tempValues.get(idx);
                found = 1;
            }
            if (found <= 0) continue;
            res = this.set_command(String.format(Locale.US, "m%d:%d", (int)Math.round(1000.0 * curr), (int)Math.round(1000.0 * currTemp)));
            if (res != 0) {
                throw new YAPI_Exception(-8, "unable to reset thermistor parameters");
            }
            prev = curr;
        }
        return 0;
    }

    public int loadThermistorResponseTable(ArrayList<Double> tempValues, ArrayList<Double> resValues) throws YAPI_Exception {
        double temp;
        int idx;
        byte[] bin_json = new byte[]{};
        ArrayList<Object> paramlist = new ArrayList();
        ArrayList<Double> templist = new ArrayList<Double>();
        tempValues.clear();
        resValues.clear();
        String id = this.get_functionId();
        id = id.substring(11, 11 + id.length() - 11);
        if (id.equals("")) {
            id = "1";
        }
        bin_json = this._download(String.format(Locale.US, "extra.json?page=%s", id));
        paramlist = this._json_get_array(bin_json);
        int siz = paramlist.size() >> 1;
        templist.clear();
        for (idx = 0; idx < siz; ++idx) {
            temp = Double.valueOf((String)paramlist.get(2 * idx + 1)) / 1000.0;
            templist.add(temp);
        }
        tempValues.clear();
        resValues.clear();
        int found = 1;
        double prev = -999999.0;
        while (found > 0) {
            found = 0;
            double curr = 999999.0;
            double currRes = -999999.0;
            for (idx = 0; idx < siz; ++idx) {
                temp = (Double)templist.get(idx);
                if (!(temp > prev) || !(temp < curr)) continue;
                curr = temp;
                currRes = Double.valueOf((String)paramlist.get(2 * idx)) / 1000.0;
                found = 1;
            }
            if (found <= 0) continue;
            tempValues.add(curr);
            resValues.add(currRes);
            prev = curr;
        }
        return 0;
    }

    public YTemperature nextTemperature() {
        String next_hwid;
        try {
            String hwid = this._yapi._yHash.resolveHwID(this._className, this._func);
            next_hwid = this._yapi._yHash.getNextHardwareId(this._className, hwid);
        }
        catch (YAPI_Exception ignored) {
            next_hwid = null;
        }
        if (next_hwid == null) {
            return null;
        }
        return YTemperature.FindTemperatureInContext(this._yapi, next_hwid);
    }

    public static YTemperature FirstTemperature() {
        YAPIContext yctx = YAPI.GetYCtx(false);
        if (yctx == null) {
            return null;
        }
        String next_hwid = yctx._yHash.getFirstHardwareId("Temperature");
        if (next_hwid == null) {
            return null;
        }
        return YTemperature.FindTemperatureInContext(yctx, next_hwid);
    }

    public static YTemperature FirstTemperatureInContext(YAPIContext yctx) {
        String next_hwid = yctx._yHash.getFirstHardwareId("Temperature");
        if (next_hwid == null) {
            return null;
        }
        return YTemperature.FindTemperatureInContext(yctx, next_hwid);
    }

    public static interface TimedReportCallback {
        public void timedReportCallback(YTemperature var1, YMeasure var2);
    }

    public static interface UpdateCallback {
        public void yNewValue(YTemperature var1, String var2);
    }
}

