/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPI;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YGenericHub;
import com.yoctopuce.YoctoAPI.YHTTPHub;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Locale;

class yHTTPRequest
implements Runnable {
    public static final int MAX_REQUEST_MS = 5000;
    private static final int YIO_IDLE_TCP_TIMEOUT = 5000;
    private Object _context;
    private YGenericHub.RequestAsyncResult _resultCallback;
    private boolean _isChuckEncoded;
    private final YHTTPHub _hub;
    private Socket _socket = null;
    private boolean _reuse_socket = false;
    private OutputStream _out = null;
    private InputStream _in = null;
    private State _state = State.AVAIL;
    private boolean _eof;
    private String _firstLine;
    private byte[] _rest_of_request;
    private final String _dbglabel;
    private final StringBuilder _header = new StringBuilder(1024);
    private Boolean _header_found;
    private final ByteArrayOutputStream _result = new ByteArrayOutputStream(4096);
    private long _startRequestTime;
    private long _lastReceiveTime;
    private long _requestTimeout;

    public void kill() {
        this._requestStop();
    }

    yHTTPRequest(YHTTPHub hub, String dbglabel) {
        this._hub = hub;
        this._dbglabel = dbglabel;
    }

    synchronized void _requestReserve() throws YAPI_Exception {
        long timeout = YAPI.GetTickCount() + 5000L + 1000L;
        while (timeout > YAPI.GetTickCount() && this._state != State.AVAIL) {
            try {
                long toWait = timeout - YAPI.GetTickCount();
                this.wait(toWait);
            }
            catch (InterruptedException ie) {
                throw new YAPI_Exception(-7, "Last Http request did not finished");
            }
        }
        if (this._state != State.AVAIL) {
            throw new YAPI_Exception(-7, "Last Http request did not finished");
        }
        this._state = State.IN_REQUEST;
    }

    synchronized void _requestRelease() {
        this._state = State.AVAIL;
        this.notify();
    }

    void _requestStart(String firstLine, byte[] rest_of_request, long mstimeout, Object context, YGenericHub.RequestAsyncResult resultCallback) throws YAPI_Exception {
        boolean retry;
        byte[] full_request;
        this._firstLine = firstLine;
        this._rest_of_request = rest_of_request;
        this._context = context;
        this._startRequestTime = System.currentTimeMillis();
        this._requestTimeout = mstimeout;
        this._resultCallback = resultCallback;
        boolean persistent = "&.".equals(firstLine.substring(firstLine.length() - 2));
        String header = "";
        int cur = 0;
        int ofs = firstLine.indexOf(" ");
        header = header + firstLine.substring(0, ofs + 1);
        cur = ofs + 1;
        header = header + this._hub._http_params.getSubDomain();
        ofs = firstLine.indexOf(" ", cur);
        if (ofs < 0 && (ofs = firstLine.indexOf("\r", cur)) < 0) {
            ofs = firstLine.length();
        }
        header = header + firstLine.substring(cur, ofs);
        header = this._hub._usePureHTTP ? header + " HTTP/1.1\r\n" : header + " \r\n";
        header = header + this._hub.getAuthorization(header);
        if (this._hub._usePureHTTP) {
            header = header + "Host: " + this._hub.getHost() + "\r\n";
        }
        if (!persistent || this._hub._usePureHTTP) {
            header = header + "Connection: close\r\n";
        }
        if (rest_of_request == null) {
            header = header + "\r\n";
            full_request = header.getBytes();
        } else {
            int len = header.length();
            full_request = new byte[len + rest_of_request.length];
            System.arraycopy(header.getBytes(), 0, full_request, 0, len);
            System.arraycopy(rest_of_request, 0, full_request, len, rest_of_request.length);
        }
        do {
            retry = false;
            try {
                if (!this._reuse_socket) {
                    InetAddress addr = InetAddress.getByName(this._hub.getHost());
                    this._socket = this._hub.OpenConnectedSocket(addr, (int)mstimeout);
                    this._socket.setTcpNoDelay(true);
                    this._out = this._socket.getOutputStream();
                    this._in = this._socket.getInputStream();
                }
                this._result.reset();
                this._header.setLength(0);
                this._header_found = false;
                this._isChuckEncoded = false;
                this._eof = false;
            }
            catch (UnknownHostException e) {
                this._requestStop();
                throw new YAPI_Exception(-2, "Unknown host(" + this._hub.getHost() + ")");
            }
            catch (IOException e) {
                this._requestStop();
                throw new YAPI_Exception(-8, e.getLocalizedMessage());
            }
            try {
                this._out.write(full_request);
                this._out.flush();
                this._lastReceiveTime = -1L;
                if (this._reuse_socket) {
                    this._socket.setSoTimeout(1);
                    int b = this._in.read();
                    if (b < 0) {
                        retry = true;
                    } else {
                        this._header.append((char)b);
                    }
                }
            }
            catch (SocketTimeoutException b) {
            }
            catch (IOException e) {
                if (this._reuse_socket) {
                    retry = true;
                }
                this._requestStop();
                throw new YAPI_Exception(-8, e.getLocalizedMessage());
            }
            this._reuse_socket = false;
        } while (retry);
    }

    void _requestStop() {
        if (!this._reuse_socket) {
            if (this._out != null) {
                try {
                    this._out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this._out = null;
            }
            if (this._in != null) {
                try {
                    this._in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this._in = null;
            }
            if (this._socket != null) {
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this._socket = null;
            }
        }
    }

    private void _requestReset() throws YAPI_Exception {
        this._requestStop();
        this._requestStart(this._firstLine, this._rest_of_request, this._requestTimeout, this._context, this._resultCallback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int _requestProcesss() throws YAPI_Exception {
        boolean retry;
        int read = 0;
        if (this._eof) {
            return -1;
        }
        do {
            retry = false;
            byte[] buffer = new byte[1024];
            try {
                if (this._requestTimeout > 0L) {
                    long read_timeout = this._startRequestTime + this._requestTimeout - System.currentTimeMillis();
                    if (read_timeout < 0L) {
                        throw new YAPI_Exception(-7, String.format(Locale.US, "Hub did not send data during %dms", System.currentTimeMillis() - this._lastReceiveTime));
                    }
                    if (read_timeout > 5000L) {
                        read_timeout = 5000L;
                    }
                    this._socket.setSoTimeout((int)read_timeout);
                } else {
                    this._socket.setSoTimeout(5000);
                }
                read = this._in.read(buffer, 0, buffer.length);
            }
            catch (SocketTimeoutException e) {
                long nowTime = System.currentTimeMillis();
                if (this._lastReceiveTime < 0L || nowTime - this._lastReceiveTime < 5000L) {
                    retry = true;
                    continue;
                }
                long duration = nowTime - this._startRequestTime;
                if (duration > this._requestTimeout) {
                    throw new YAPI_Exception(-7, String.format(Locale.US, "TCP request on %s took too long (%dms)", this._hub.getHost(), duration));
                }
                if (duration > this._requestTimeout - this._requestTimeout / 4L) {
                    this._hub._yctx._Log(String.format(Locale.US, "Slow TCP request on %s (%dms)\n", this._hub.getHost(), duration));
                }
                retry = true;
                continue;
            }
            catch (IOException e) {
                throw new YAPI_Exception(-8, e.getLocalizedMessage());
            }
            if (read < 0) {
                this._reuse_socket = false;
                this._eof = true;
                continue;
            }
            if (read <= 0) continue;
            this._lastReceiveTime = System.currentTimeMillis();
            ByteArrayOutputStream byteArrayOutputStream = this._result;
            synchronized (byteArrayOutputStream) {
                if (!this._header_found.booleanValue()) {
                    String partial_head = new String(buffer, 0, read, this._hub._yctx._deviceCharset);
                    this._header.append(partial_head);
                    int pos = this._header.indexOf("\r\n\r\n");
                    if (pos > 0) {
                        pos += 4;
                        try {
                            this._result.write(this._header.substring(pos).getBytes(this._hub._yctx._deviceCharset));
                        }
                        catch (IOException ex) {
                            throw new YAPI_Exception(-8, ex.getLocalizedMessage());
                        }
                        this._header_found = true;
                        this._header.setLength(pos);
                        if (this._header.indexOf("0K\r\n") == 0) {
                            this._reuse_socket = true;
                        } else if (this._header.indexOf("OK\r\n") != 0) {
                            int lpos = this._header.indexOf("\r\n");
                            if (this._header.indexOf("HTTP/1.1 ") != 0) {
                                throw new YAPI_Exception(-8, "Invalid HTTP response header");
                            }
                            String[] parts = this._header.substring(9, lpos).split(" ");
                            if (parts[0].equals("401")) {
                                if (!this._hub.needRetryWithAuth()) {
                                    throw new YAPI_Exception(-12, "Authentication required");
                                }
                                this._hub.parseWWWAuthenticate(this._header.toString());
                                this._requestReset();
                                break;
                            }
                            if (!parts[0].equals("200") && !parts[0].equals("304")) {
                                throw new YAPI_Exception(-8, "Received HTTP status " + parts[0] + " (" + parts[1] + ")");
                            }
                            int t_ofs = this._header.indexOf("Transfer-Encoding");
                            if (t_ofs > 0) {
                                int t_endl = this._header.indexOf("\r\n", t_ofs += 17);
                                int t_chunk = this._header.indexOf("chunked", t_ofs);
                                if (t_chunk > 0 && t_chunk < t_endl) {
                                    this._isChuckEncoded = true;
                                }
                            }
                        }
                        this._hub.authSucceded();
                    }
                } else {
                    this._result.write(buffer, 0, read);
                }
                if (this._reuse_socket && this._result.toString().endsWith("\r\n")) {
                    this._eof = true;
                }
            }
        } while (retry);
        return read;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] getPartialResult() throws YAPI_Exception {
        byte[] res;
        ByteArrayOutputStream byteArrayOutputStream = this._result;
        synchronized (byteArrayOutputStream) {
            if (!this._header_found.booleanValue()) {
                return null;
            }
            if (this._result.size() == 0) {
                if (this._eof) {
                    throw new YAPI_Exception(-9, "end of file reached");
                }
                return null;
            }
            res = this._result.toByteArray();
            this._result.reset();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] RequestSync(String req_first_line, byte[] req_head_and_body, int mstimeout) throws YAPI_Exception {
        byte[] res;
        this._requestReserve();
        try {
            int read;
            this._requestStart(req_first_line, req_head_and_body, mstimeout, null, null);
            while ((read = this._requestProcesss()) >= 0) {
            }
            ByteArrayOutputStream byteArrayOutputStream = this._result;
            synchronized (byteArrayOutputStream) {
                res = this._result.toByteArray();
                this._result.reset();
                if (this._isChuckEncoded) {
                    res = this.unpackHTTPRequest(res);
                }
            }
        }
        catch (YAPI_Exception ex) {
            this._requestStop();
            this._requestRelease();
            throw ex;
        }
        this._requestStop();
        this._requestRelease();
        return res;
    }

    private byte[] unpackHTTPRequest(byte[] data) {
        ByteArrayOutputStream res = new ByteArrayOutputStream(data.length);
        int ofs = 0;
        do {
            int len;
            char c;
            StringBuilder hex_str = new StringBuilder();
            while (ofs < data.length && (c = (char)data[ofs]) != '\n') {
                if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') {
                    hex_str.append(c);
                }
                ++ofs;
            }
            if (ofs >= data.length) continue;
            try {
                len = Integer.parseInt(hex_str.toString(), 16);
            }
            catch (NumberFormatException ex) {
                len = 0;
            }
            if (ofs + 3 + len < data.length) {
                res.write(data, ++ofs, len);
                ofs += len + 2;
                continue;
            }
            ++ofs;
        } while (ofs < data.length);
        return res.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        byte[] res = null;
        int errorType = 0;
        String errmsg = null;
        try {
            int read;
            this._requestProcesss();
            while ((read = this._requestProcesss()) >= 0) {
            }
            ByteArrayOutputStream byteArrayOutputStream = this._result;
            synchronized (byteArrayOutputStream) {
                res = this._result.toByteArray();
                this._result.reset();
            }
        }
        catch (YAPI_Exception ex) {
            errorType = ex.errorType;
            errmsg = ex.getMessage();
            this._hub._yctx._Log("ASYNC request " + this._firstLine + "failed:" + errmsg + "\n");
        }
        this._requestStop();
        if (this._resultCallback != null) {
            this._resultCallback.RequestAsyncDone(this._context, res, errorType, errmsg);
        }
        this._requestRelease();
    }

    void RequestAsync(String req_first_line, byte[] req_head_and_body, YGenericHub.RequestAsyncResult callback, Object context) throws YAPI_Exception {
        this._requestReserve();
        try {
            this._requestStart(req_first_line, req_head_and_body, this._hub._yctx._networkTimeoutMs, context, callback);
            Thread t = new Thread(this);
            t.setName(this._dbglabel);
            t.start();
        }
        catch (YAPI_Exception ex) {
            this._requestRelease();
            throw ex;
        }
    }

    synchronized void WaitRequestEnd(long mstimeout) throws InterruptedException {
        long timeout = YAPI.GetTickCount() + mstimeout;
        while (timeout > YAPI.GetTickCount() && this._state == State.IN_REQUEST) {
            long toWait = timeout - YAPI.GetTickCount();
            this.wait(toWait);
        }
        if (this._state == State.IN_REQUEST) {
            this._hub._yctx._Log("WARNING: Last Http request did not finished");
        }
        this._reuse_socket = false;
        this._requestStop();
        this._state = State.STOPPED;
    }

    private static enum State {
        AVAIL,
        IN_REQUEST,
        STOPPED;

    }
}

