/*
 * Decompiled with CFR 0.152.
 */
package com.yoctopuce.YoctoAPI;

import com.yoctopuce.YoctoAPI.YAPIContext;
import com.yoctopuce.YoctoAPI.YAPI_Exception;
import com.yoctopuce.YoctoAPI.YDataStream;
import com.yoctopuce.YoctoAPI.YFunction;
import com.yoctopuce.YoctoAPI.YJSONArray;
import com.yoctopuce.YoctoAPI.YJSONObject;
import com.yoctopuce.YoctoAPI.YMeasure;
import com.yoctopuce.YoctoAPI.YModule;
import java.util.ArrayList;
import java.util.Locale;

public class YDataSet {
    protected YFunction _parent;
    protected String _hardwareId;
    protected String _functionId;
    protected String _unit;
    protected int _bulkLoad = 0;
    protected double _startTimeMs = 0.0;
    protected double _endTimeMs = 0.0;
    protected int _progress = 0;
    protected ArrayList<Integer> _calib = new ArrayList();
    protected ArrayList<YDataStream> _streams = new ArrayList();
    protected YMeasure _summary;
    protected ArrayList<YMeasure> _preview = new ArrayList();
    protected ArrayList<YMeasure> _measures = new ArrayList();
    protected double _summaryMinVal = 0.0;
    protected double _summaryMaxVal = 0.0;
    protected double _summaryTotalAvg = 0.0;
    protected double _summaryTotalTime = 0.0;

    YDataSet(YFunction parent, String functionId, String unit, double startTime, double endTime) {
        this._parent = parent;
        this._functionId = functionId;
        this._unit = unit;
        this._startTimeMs = startTime * 1000.0;
        this._endTimeMs = endTime * 1000.0;
        this._progress = -1;
        this._hardwareId = "";
        this._summary = new YMeasure();
    }

    public YDataSet(YFunction parent) {
        this._parent = parent;
        this._startTimeMs = 0.0;
        this._endTimeMs = 0.0;
        this._hardwareId = "";
        this._summary = new YMeasure();
    }

    protected int _parse(String json_str) throws YAPI_Exception {
        try {
            YJSONObject json = new YJSONObject(json_str);
            json.parse();
            this._functionId = json.getString("id");
            this._unit = json.getString("unit");
            if (json.has("bulk")) {
                this._bulkLoad = YAPIContext._atoi(json.getString("bulk"));
            }
            if (json.has("calib")) {
                this._calib = YAPIContext._decodeFloats(json.getString("calib"));
                this._calib.set(0, this._calib.get(0) / 1000);
            } else {
                this._calib = YAPIContext._decodeWords(json.getString("cal"));
            }
            this._streams = new ArrayList();
            this._preview = new ArrayList();
            this._measures = new ArrayList();
            YJSONArray jstreams = json.getYJSONArray("streams");
            for (int i = 0; i < jstreams.length(); ++i) {
                YDataStream stream = this._parent._findDataStream(this, jstreams.getString(i));
                double streamStartTime = Math.round(stream.get_realStartTimeUTC() * 1000.0);
                double streamEndTime = Math.round(streamStartTime + stream.get_realDuration() * 1000.0);
                if (this._startTimeMs > 0.0 && streamEndTime <= this._startTimeMs || this._endTimeMs > 0.0 && streamStartTime >= this._endTimeMs) continue;
                this._streams.add(stream);
            }
        }
        catch (Exception e) {
            throw new YAPI_Exception(-8, "invalid json structure for YDataSet: " + e.getMessage());
        }
        this._progress = 0;
        return this.get_progress();
    }

    public ArrayList<Integer> _get_calibration() {
        return this._calib;
    }

    public int loadSummary(byte[] data) throws YAPI_Exception {
        ArrayList<Object> dataRows = new ArrayList();
        ArrayList measure_data = new ArrayList();
        if (this._progress < 0) {
            String strdata = new String(data);
            if (strdata.equals("{}")) {
                this._parent._throw(-5, "device firmware is too old");
                return -5;
            }
            int res = this._parse(strdata);
            if (res < 0) {
                return res;
            }
        }
        double summaryTotalTime = 0.0;
        double summaryTotalAvg = 0.0;
        double summaryMinVal = Double.MAX_VALUE;
        double summaryMaxVal = Double.MIN_VALUE;
        double summaryStartMs = Double.MAX_VALUE;
        double summaryStopMs = Double.MIN_VALUE;
        for (YDataStream ii : this._streams) {
            double previewDuration;
            double previewStopMs;
            double previewStartMs;
            double previewMaxVal;
            double previewAvgVal;
            double previewMinVal;
            double streamStartTimeMs = Math.round(ii.get_realStartTimeUTC() * 1000.0);
            double streamDuration = ii.get_realDuration();
            double streamEndTimeMs = streamStartTimeMs + (double)Math.round(streamDuration * 1000.0);
            if (streamStartTimeMs >= this._startTimeMs && (this._endTimeMs == 0.0 || streamEndTimeMs <= this._endTimeMs)) {
                previewMinVal = ii.get_minValue();
                previewAvgVal = ii.get_averageValue();
                previewMaxVal = ii.get_maxValue();
                previewStartMs = streamStartTimeMs;
                previewStopMs = streamEndTimeMs;
                previewDuration = streamDuration;
            } else {
                if (!ii._wasLoaded()) {
                    String url = ii._get_url();
                    data = this._parent._download(url);
                    ii._parseStream(data);
                }
                if ((dataRows = ii.get_dataRows()).size() == 0) {
                    return this.get_progress();
                }
                double tim = streamStartTimeMs;
                double fitv = Math.round(ii.get_firstDataSamplesInterval() * 1000.0);
                double itv = Math.round(ii.get_dataSamplesInterval() * 1000.0);
                int nCols = ((ArrayList)dataRows.get(0)).size();
                int minCol = 0;
                int avgCol = nCols > 2 ? 1 : 0;
                int maxCol = nCols > 2 ? 2 : 0;
                double previewTotalTime = 0.0;
                double previewTotalAvg = 0.0;
                previewStartMs = streamEndTimeMs;
                previewStopMs = streamStartTimeMs;
                previewMinVal = Double.MAX_VALUE;
                previewMaxVal = Double.MIN_VALUE;
                for (int m_pos = 0; m_pos < dataRows.size(); ++m_pos) {
                    measure_data = (ArrayList)dataRows.get(m_pos);
                    double mitv = m_pos == 0 ? fitv : itv;
                    double end_ = tim + mitv;
                    if (end_ > this._startTimeMs && (this._endTimeMs == 0.0 || tim < this._endTimeMs)) {
                        double minVal = (Double)measure_data.get(minCol);
                        double avgVal = (Double)measure_data.get(avgCol);
                        double maxVal = (Double)measure_data.get(maxCol);
                        if (previewStartMs > tim) {
                            previewStartMs = tim;
                        }
                        if (previewStopMs < end_) {
                            previewStopMs = end_;
                        }
                        if (previewMinVal > minVal) {
                            previewMinVal = minVal;
                        }
                        if (previewMaxVal < maxVal) {
                            previewMaxVal = maxVal;
                        }
                        if (!Double.isNaN(avgVal)) {
                            previewTotalAvg += avgVal * mitv;
                            previewTotalTime += mitv;
                        }
                    }
                    tim = end_;
                }
                if (previewTotalTime > 0.0) {
                    previewAvgVal = previewTotalAvg / previewTotalTime;
                    previewDuration = (previewStopMs - previewStartMs) / 1000.0;
                } else {
                    previewAvgVal = 0.0;
                    previewDuration = 0.0;
                }
            }
            this._preview.add(new YMeasure(previewStartMs / 1000.0, previewStopMs / 1000.0, previewMinVal, previewAvgVal, previewMaxVal));
            if (summaryMinVal > previewMinVal) {
                summaryMinVal = previewMinVal;
            }
            if (summaryMaxVal < previewMaxVal) {
                summaryMaxVal = previewMaxVal;
            }
            if (summaryStartMs > previewStartMs) {
                summaryStartMs = previewStartMs;
            }
            if (summaryStopMs < previewStopMs) {
                summaryStopMs = previewStopMs;
            }
            summaryTotalAvg += previewAvgVal * previewDuration;
            summaryTotalTime += previewDuration;
        }
        if (this._startTimeMs == 0.0 || this._startTimeMs > summaryStartMs) {
            this._startTimeMs = summaryStartMs;
        }
        if (this._endTimeMs == 0.0 || this._endTimeMs < summaryStopMs) {
            this._endTimeMs = summaryStopMs;
        }
        this._summary = summaryTotalTime > 0.0 ? new YMeasure(summaryStartMs / 1000.0, summaryStopMs / 1000.0, summaryMinVal, summaryTotalAvg / summaryTotalTime, summaryMaxVal) : new YMeasure(0.0, 0.0, -1.79769313486231E308, -1.79769313486231E308, -1.79769313486231E308);
        return this.get_progress();
    }

    public int processMore(int progress, byte[] data) throws YAPI_Exception {
        ArrayList<Object> dataRows = new ArrayList();
        ArrayList<String> suffixes = new ArrayList<String>();
        byte[] bulkFile = new byte[]{};
        ArrayList<Object> streamStr = new ArrayList();
        byte[] streamBin = new byte[]{};
        if (progress != this._progress) {
            return this._progress;
        }
        if (this._progress < 0) {
            return this.loadSummary(data);
        }
        YDataStream stream = this._streams.get(this._progress);
        if (!stream._wasLoaded()) {
            stream._parseStream(data);
        }
        dataRows = stream.get_dataRows();
        ++this._progress;
        if (dataRows.size() == 0) {
            return this.get_progress();
        }
        double tim = Math.round(stream.get_realStartTimeUTC() * 1000.0);
        double fitv = Math.round(stream.get_firstDataSamplesInterval() * 1000.0);
        double itv = Math.round(stream.get_dataSamplesInterval() * 1000.0);
        if (fitv == 0.0) {
            fitv = itv;
        }
        if (tim < itv) {
            tim = itv;
        }
        int nCols = ((ArrayList)dataRows.get(0)).size();
        int minCol = 0;
        int avgCol = nCols > 2 ? 1 : 0;
        int maxCol = nCols > 2 ? 2 : 0;
        boolean firstMeasure = true;
        for (ArrayList arrayList : dataRows) {
            double end_;
            if (firstMeasure) {
                end_ = tim + fitv;
                firstMeasure = false;
            } else {
                end_ = tim + itv;
            }
            double avgv = (Double)arrayList.get(avgCol);
            if (end_ > this._startTimeMs && (this._endTimeMs == 0.0 || tim < this._endTimeMs) && !Double.isNaN(avgv)) {
                this._measures.add(new YMeasure(tim / 1000.0, end_ / 1000.0, (Double)arrayList.get(minCol), avgv, (Double)arrayList.get(maxCol)));
            }
            tim = end_;
        }
        if (this._bulkLoad > 0 && this._progress < this._streams.size()) {
            int idx;
            stream = this._streams.get(this._progress);
            if (stream._wasLoaded()) {
                return this.get_progress();
            }
            String baseurl = stream._get_baseurl();
            String url = stream._get_url();
            String suffix = stream._get_urlsuffix();
            suffixes.add(suffix);
            for (idx = this._progress + 1; idx < this._streams.size() && suffixes.size() < this._bulkLoad; ++idx) {
                stream = this._streams.get(idx);
                if (stream._wasLoaded() || !stream._get_baseurl().equals(baseurl)) continue;
                suffix = stream._get_urlsuffix();
                suffixes.add(suffix);
                url = url + "," + suffix;
            }
            bulkFile = this._parent._download(url);
            streamStr = this._parent._json_get_array(bulkFile);
            int urlIdx = 0;
            for (idx = this._progress; idx < this._streams.size() && urlIdx < suffixes.size() && urlIdx < streamStr.size(); ++idx) {
                stream = this._streams.get(idx);
                if (!stream._get_baseurl().equals(baseurl) || !stream._get_urlsuffix().equals(suffixes.get(urlIdx))) continue;
                streamBin = ((String)streamStr.get(urlIdx)).getBytes();
                stream._parseStream(streamBin);
                ++urlIdx;
            }
        }
        return this.get_progress();
    }

    public ArrayList<YDataStream> get_privateDataStreams() {
        return this._streams;
    }

    public String get_hardwareId() throws YAPI_Exception {
        if (!this._hardwareId.equals("")) {
            return this._hardwareId;
        }
        YModule mo = this._parent.get_module();
        this._hardwareId = String.format(Locale.US, "%s.%s", mo.get_serialNumber(), this.get_functionId());
        return this._hardwareId;
    }

    public String get_functionId() {
        return this._functionId;
    }

    public String get_unit() throws YAPI_Exception {
        return this._unit;
    }

    public long get_startTimeUTC() {
        return this.imm_get_startTimeUTC();
    }

    public long imm_get_startTimeUTC() {
        return (long)(this._startTimeMs / 1000.0);
    }

    public long get_endTimeUTC() {
        return this.imm_get_endTimeUTC();
    }

    public long imm_get_endTimeUTC() {
        return (long)((double)Math.round(this._endTimeMs / 1000.0));
    }

    public int get_progress() {
        if (this._progress < 0) {
            return 0;
        }
        if (this._progress >= this._streams.size()) {
            return 100;
        }
        return (1 + (1 + this._progress) * 98) / (1 + this._streams.size());
    }

    public int loadMore() throws YAPI_Exception {
        String url;
        if (this._progress < 0) {
            url = String.format(Locale.US, "logger.json?id=%s", this._functionId);
            if (this._startTimeMs != 0.0) {
                url = String.format(Locale.US, "%s&from=%d", url, this.imm_get_startTimeUTC());
            }
            if (this._endTimeMs != 0.0) {
                url = String.format(Locale.US, "%s&to=%d", url, this.imm_get_endTimeUTC() + 1L);
            }
        } else {
            if (this._progress >= this._streams.size()) {
                return 100;
            }
            YDataStream stream = this._streams.get(this._progress);
            if (stream._wasLoaded()) {
                return this.processMore(this._progress, "".getBytes());
            }
            url = stream._get_url();
        }
        try {
            return this.processMore(this._progress, this._parent._download(url));
        }
        catch (Exception ex) {
            return this.processMore(this._progress, this._parent._download(url));
        }
    }

    public YMeasure get_summary() {
        return this._summary;
    }

    public ArrayList<YMeasure> get_preview() throws YAPI_Exception {
        return this._preview;
    }

    public ArrayList<YMeasure> get_measuresAt(YMeasure measure) throws YAPI_Exception {
        double itv;
        ArrayList<Object> dataRows = new ArrayList();
        ArrayList<YMeasure> measures = new ArrayList<YMeasure>();
        double startUtcMs = measure.get_startTimeUTC() * 1000.0;
        YDataStream stream = null;
        for (YDataStream yDataStream : this._streams) {
            if ((double)Math.round(yDataStream.get_realStartTimeUTC() * 1000.0) != startUtcMs) continue;
            stream = yDataStream;
        }
        if (stream == null) {
            return measures;
        }
        dataRows = stream.get_dataRows();
        if (dataRows.size() == 0) {
            return measures;
        }
        double tim = Math.round(stream.get_realStartTimeUTC() * 1000.0);
        if (tim < (itv = (double)Math.round(stream.get_dataSamplesInterval() * 1000.0))) {
            tim = itv;
        }
        int nCols = ((ArrayList)dataRows.get(0)).size();
        int minCol = 0;
        int avgCol = nCols > 2 ? 1 : 0;
        int maxCol = nCols > 2 ? 2 : 0;
        for (ArrayList arrayList : dataRows) {
            double end_ = tim + itv;
            if (end_ > this._startTimeMs && (this._endTimeMs == 0.0 || tim < this._endTimeMs)) {
                measures.add(new YMeasure(tim / 1000.0, end_ / 1000.0, (Double)arrayList.get(minCol), (Double)arrayList.get(avgCol), (Double)arrayList.get(maxCol)));
            }
            tim = end_;
        }
        return measures;
    }

    public ArrayList<YMeasure> get_measures() throws YAPI_Exception {
        return this._measures;
    }
}

